/* Ruari Diff, a program to compare a Packages file and /var/lib/dpkg/status */
/* Copyright (C) 1997, James Troup <jjtroup@comp.brad.ac.uk> */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"
#include "error.h"
#include "xmalloc.h"
#include "utils.h"

void get_blah (const char *buffer, int *counter, char *output, char *input, 
	       const int length, const char *package_name, const int input_length)
{

  int line_counter = 0;
  int temp = *counter;

  output[0] = '\0'; 

  while (*counter < length && line_counter < GET_BLAH_LINES_TO_SEARCH)
    {
      if (buffer[*counter] == input[0])
	{
	  read_line (buffer, counter, output);

	  /* If we encounter a blank line, we've overun the package
             description; give up */
	  if (output[0] == '\n')
	    {
	      output[0] = '\0';
	      break;
	    }

	  /* If we have a match stop searching, if not blank the
             output string */
	  if (!(strncmp (input, output, input_length))) 
	    break;
	  else
	    output[0] = '\0';
	}
      else
	skip_line(buffer, counter);
      line_counter++;
    }

  if (output[0] == '\0' && warn_missing_lines)
    fprintf (stderr, "Warning: no %s found for %s!\n", input, package_name);
    
  *counter = temp;  /* Restore counter */

}

void skip_line (const char *buffer, int *counter)
{
  
  while (buffer[*counter] != '\n')
    (*counter)++;

  (*counter)++;          /* Skip the newline */

}


void read_line (const char *buffer, int *counter, char *string)
{

  int i = 0;

  while (buffer[*counter] != '\n')
    string[i++] = buffer[(*counter)++];
  
  (*counter)++;           /* Skip the newline */
  string[i] = '\0';       /* Terminate the string */

}

void open_file (char *filename, FILE *fp, char **buffer_p, long *file_length)
{

  int n_read;                   

  fp = fopen (filename, "r");
  if (fp == NULL)
    error (FATAL | SYSERR, "%s: couldn't open file \"%s\"",
	   program_name, filename);
  if ((fseek (fp, 0, SEEK_END)) != 0)
    error (FATAL | SYSERR, "%s: couldn't seek to the end of file \"%s\"",
	   program_name, filename);
  *file_length = ftell (fp);
  rewind (fp);

  if (*file_length == 0)
    error (FATAL, "%s: \"%s\" is zero-length", program_name, filename);

  /* We don't do any memory management, we just ask for a chunk of
   * memory the size of the file */

  *buffer_p = (char *) xmalloc (*file_length);

  /* RUARI QUINN this is ignoring the possibility that ftell could be long */

  n_read = fread (*buffer_p, sizeof (char), *file_length, fp);
  if (n_read == 0)
    error (FATAL | SYSERR, "%s: couldn't read file \"%s\" into buffer",
	   program_name, filename);
  else if (n_read < *file_length)
    error (FATAL, "%s: short read (found %d, expected %d) in file \"%s\"",
	   program_name, n_read, *file_length, filename);
}
