
/*
 * Copyright 1986 by Larry Campbell, 73 Concord Street, Maynard MA 01754 USA
 * (maynard!campbell).  You may freely copy, use, and distribute this software
 * subject to the following restrictions:
 *
 *  1)	You may not charge money for it.
 *  2)	You may not remove or alter this copyright notice.
 *  3)	You may not claim you wrote it.
 *  4)	If you make improvements (or other changes), you are requested
 *	to send them to me, so there's a focal point for distributing
 *	improved versions.
 *
 * John Chmielewski (tesla!jlc until 9/1/86, then rogue!jlc) assisted
 * by doing the System V port and adding some nice features.  Thanks!
 */

#include <stdio.h>
#include "x10.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/resource.h>
#include <errno.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>
#include <limits.h>

#ifdef __GLIBC__
/* msf - added for glibc/rh 5.0 */
#include <pty.h>
#endif


void exit();
char *make_lock_name();
unsigned long lockpid();

char x10_tty[50];
extern int verbose;

int tty = -1;		/* Real tty */
int sptty = -1;	/* Spool */


#ifndef SYSV
#include <sgtty.h>
struct sgttyb oldsb, newsb;
#else
#ifndef POSIX
#include <termio.h>
struct termio oldsb, newsb;
#else
#include <termios.h>
struct termios oldsb, newsb;
#endif

#endif

setup_tty(lockflag)
int lockflag;
{
    char RCSID[]= "@(#) $Id: tty.c,v 1.11 1998/05/08 01:50:08 dbs Exp dbs $\n";

    if (!x10_tty[0])
    	error("no TTY specified in configfile");

    if( lockflag )
	if( ttylock(x10_tty) < 1 )
	{
	    syslog(LOG_ERR, "Other proccess using real tty port.");
	    error("Other process is using tty port");
	}

    tty = open(x10_tty, 2);
    if (tty < 0)
    {
        syslog(LOG_ERR, "Can't open tty line.");
	error("Can't open tty line");
    }

#ifndef SYSV
    (void) ioctl(tty, TIOCFLUSH, (struct sgttyb *) NULL);
    (void) ioctl(tty, TIOCGETP, &oldsb);
    newsb = oldsb;
    newsb.sg_flags |= RAW;
    newsb.sg_flags &= ~(ECHO | EVENP | ODDP);
    hangup();
    newsb.sg_ispeed = newsb.sg_ospeed = B4800;	/* raise DTR & set speed */
    (void) ioctl(tty, TIOCSETN, &newsb);
#else
#ifndef POSIX
    if (ioctl(tty, TCGETA, &oldsb) < 0) {
    	perror("ioctl get");
	exit(1);
    }
    newsb = oldsb;
    newsb.c_lflag = 0;
    newsb.c_oflag = 0;
    newsb.c_iflag = IGNBRK | IGNPAR;
    newsb.c_cflag = (CLOCAL | B4800 | CS8 | CREAD);
    newsb.c_cc[VMIN] = 1;
    newsb.c_cc[VTIME] = 0;
    newsb.c_cc[VINTR] = 0;
    newsb.c_cc[VQUIT] = 0;
#ifdef VSWTCH
    newsb.c_cc[VSWTCH] = 0;
#endif
    newsb.c_cc[VTIME] = 0;
    if (ioctl(tty, TCSETAF, &newsb) < 0) {
    	perror("ioctl set");
	exit(1);
    }
#else
    {
	int s;
	s = tcgetattr(tty, &oldsb);
	if (s < 0) {
		perror("ttopen tcgetattr");
		exit(1);
	}

	newsb = oldsb;

	/* newsb.c_iflag = BRKINT|(oldsb.c_iflag & (IXON|IXANY|IXOFF)); */
	newsb.c_iflag = IGNBRK | IGNPAR;
	newsb.c_oflag = 0;
	newsb.c_lflag = ISIG;
	newsb.c_cflag = (CLOCAL | B4800 | CS8 | CREAD);
	for (s = 0; s < NCC; s++)
		newsb.c_cc[s] = 0;
	newsb.c_cc[VMIN] = 1;
	newsb.c_cc[VTIME] = 0;
#ifdef BEFORE
#ifdef	VSWTCH
	newsb.c_cc[VSWTCH] = 0;
#endif
	newsb.c_cc[VSUSP] = 0;
	newsb.c_cc[VSTART] = 0;
	newsb.c_cc[VSTOP] = 0;
#endif

	tcsetattr(tty, TCSADRAIN, &newsb);
    }
#endif
#endif
}

restore_tty()
{
#ifndef SYSV
    hangup();
    (void) ioctl(tty, TIOCSETN, &oldsb);
#else
#ifndef POSIX
    (void) ioctl(tty, TCSETAF, &oldsb);
#else
    tcsetattr(tty, TCSADRAIN, &oldsb);
#endif
#endif
}

#ifndef SYSV
hangup()
{
    newsb.sg_ispeed = newsb.sg_ospeed = B0;	/* drop DTR */
    (void) ioctl(tty, TIOCSETN, &newsb);
    sleep(SMALLPAUSE);
}

#endif

quit()
{
    if (tty == -1)
	exit(1);
    restore_tty();
    exit(1);
}

/* ttylock locks the tty device in a UUCP compatible style.
 * If the process is not valid, it's ok to remove the lock
 * The ttydev arguement should be the device (tty2) or a fully qualified
 * path name (/dev/tty2).
 * It's OK to sleep a moment when we get see a valid lock, just in case it
 * will go away quickly
 *
 */

ttylock(ttydev)
char * ttydev;
{
    char *devstr;
    static int reenter = 0;

    devstr = make_lock_name(ttydev);

    if( verbose )
        printf("Trying to lock (%s)\n", devstr);
    if( lockpid(ttydev) == 0 )
	lock_device(devstr);

return(1);
}


/* munlock should be called when it's time to close the TTY.
 * The ttydev param should be a fully qualified pathname for the lock file
 */
munlock(ttydev)
char * ttydev;
{
    char *devstr;
    
    devstr = make_lock_name(ttydev);

return( unlink(devstr) );
}

/* This function writes the pid into the lock file.  It uses the ASCII mode.
 * It will overwrite the existing file.
 */
int lock_device(ttydev)
char * ttydev;
{
    FILE *f;

    if( (f = fopen(ttydev, "w")) != NULL)
    {
        fprintf(f, "    %ld\n", getpid() );
	chmod(ttydev, 0777);
    }
    else
    {
	if ( verbose )
	    perror("Unable to create the lock file:");
	fclose(f);
	syslog(LOG_DAEMON | LOG_ERR, "Unable to create the lock file.\n");
        error("Unable to create the lock file.");
    }
    fclose(f);
return(0);
}

/* set up the real and spool psuedo tty file descriptor.
 */
int setup_sp_tty()
{
    extern char spoolfile[PATH_MAX];

    setup_tty(0);
    if (tty < 0)
    {
	error("Can't open tty line");
	syslog(LOG_DAEMON | LOG_ERR, "Can't open tty line\n");
    }

    sptty = open(spoolfile, O_RDWR|O_APPEND);		/* open the spool file */
    if (sptty < 0)
    {
	error("Can't open spool tty line");
	syslog(LOG_DAEMON | LOG_ERR, "Can't open spool tty line\n");

    }
    lseek(sptty, 0, SEEK_END);			/* seek to end of file */

}

/* concatenate the lock directory path with the name to be locked. 
 * Start with a device or other string.  Example: /dev/tty2
 * End result is a string such as "/usr/spool/uucp/LCK..tty2"
 */
char *make_lock_name(ttydev)
char *ttydev;
{
    char *devstr;
    char *ptr;
    struct stat stat_buf;
    char err_string[200];

    /* strip the leading path name */
    ptr = rindex(ttydev, '/');

    if( (devstr = (char *)calloc(sizeof(char), PATH_MAX)) == NULL )
    {
        perror("Could not allocate array 'devstr':");
	syslog(LOG_DAEMON | LOG_ERR, "Could not allocate array 'devstr'.\n");
	quit();
    }
    if( ptr == (char *) NULL)
    {
        ptr = ttydev;
    }
    else
        ptr++; 		/* move past the slash */

    /* Check to see that the Lock Directory is valid */
    strcat(devstr, LOCKDIR);
    if (devstr[strlen(devstr) - 1] != '/')
        strcat(devstr, "/");

    sprintf(err_string, "Unable to access the lock directory %s\n", LOCKDIR);
    if( (stat(devstr, &stat_buf) != 0 ) || ((stat_buf.st_mode & S_IFDIR) == 0) )
    {
        perror(err_string);
	syslog(LOG_DAEMON | LOG_ERR, err_string);
	quit();
    }
    strcat(devstr, "LCK..");
    strcat(devstr, ptr);

return(devstr);
}



/* lockpid returns 0 if the file is not locked or PID is invalid,
 *         returns the PID if the file is locked
 *         returns -1 on error
 */
unsigned long lockpid(ttydev)
char *ttydev;
{
    FILE *input;
    char bufr[PATH_MAX];
    char *devstr;
    struct stat lockstat;
    int infd;
    long pid_no;

    devstr = make_lock_name(ttydev);

    if( stat(devstr, &lockstat) >= 0 )  
    {				/* a lock file exists */

	input = fopen(devstr, "r");
	if( input == NULL )
	{
	   perror("Problem opening the lock file:");
	   syslog(LOG_DAEMON | LOG_ERR, "Problem opening the lock file.\n");
	   quit();
	}
	fgets(bufr,80,input);	/* read the pid info from the file */
	if( strncmp("    ", bufr, 4) == 0 )
	{  			/* Oh! ascii info */
	    sscanf(bufr, " %ld", &pid_no);
	    fclose(input);
	}
	else
	{			/* Ahhh.  Binary */
	   fclose(input);
	   infd=open(devstr, O_RDONLY);
	   if( infd < 0  )
	   {
	       perror("Problem opening the lock file:");
	       syslog(LOG_DAEMON | LOG_ERR, "Problem opening the lock file.\n");
	       quit();
	   }
	   read(infd,&pid_no,4);
	   close(infd);
	}
	/* does the process exist? */
        
        errno = 0;
        getpriority(PRIO_PROCESS, pid_no);	/* a harmless check for a pid */
        if( errno == ESRCH)
            return(0);			/* no pid exists */
        else
        {
	           /*  locked by other process.  Please try again. */
	    return(pid_no);
        }
    }
    else 			/* could not stat the file.  Why? */
    {
        if( errno == ENOENT )   /* Cool!  no lock file. */
        {
            return(0);
        }
	else
        {
	    perror("Lock file not accessable:");
	    syslog(LOG_DAEMON | LOG_ERR, "Lock file not accessable.\n");
	    quit(); 
	}
    }

return(0);
}
