/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: rload.c,v 6.1 96/11/24 00:26:03 nevin Rel $
 *
 *	Function:	- loads file onto remote node
 *	Accepts:	- source node of file 
 *			- destination node 
 *			- flat tag
 *			- filename
 */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <events.h>
#include <ksignal.h>
#include <lreq.h>
#include <net.h>
#include <portable.h>
#include <terror.h>
#include <typical.h>

/*
 * external functions
 */
extern char		*_path_env_find();	/* find name in path vector */

int
rload(src_node, dest_node, tag, filename)

int4			src_node;
int4			dest_node;
int4			tag;
CONST char		*filename;

{
	struct lreply	*reply;			/* loadd reply */
	struct lreq	*req;			/* loadd request */
	struct nmsg	nhead;			/* network header */
	char		*fullpath;
	int		mask;
	int		bmalloc;		/* malloc'd filename */
/*
 * If the source node is the local node, get a full path for the
 * file in the client, not loadd.
 */
	if ((src_node == LOCAL) || (src_node == getnodeid())) {
		fullpath = _path_env_find(filename, R_OK | X_OK);
		if (fullpath == 0) return(LAMERROR);
		bmalloc = TRUE;
		nhead.nh_length = strlen(fullpath) + 1;
	} else {
		bmalloc = FALSE;
		nhead.nh_length = strlen(filename) + 1;
	}
/*
 * Check name length.
 */
	if (nhead.nh_length > FNAMELEN) {

		if (bmalloc) {
			free(fullpath);
		}

		errno = ENAMETOOLONG;
		return(LAMERROR);
	}

	req = (struct lreq *) nhead.nh_data;
	reply = (struct lreply *) nhead.nh_data;
/*
 * Complete request information structure.
 */
	req->lq_req = LQLOAD;
	req->lq_src_node = (src_node == LOCAL) ? src_node : getnodeid();
	req->lq_src_event = -getpid();
	req->lq_dest_node = dest_node;
	req->lq_tag = tag;

	nhead.nh_node = src_node;
	nhead.nh_event = EVLOADD;
	nhead.nh_type = 0;	  
	nhead.nh_flags = 0;
	nhead.nh_msg = bmalloc ? fullpath : (char *) filename;
	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));
/*
 * Send loadd request.
 */
	if (nsend(&nhead)) {

		if (bmalloc) {
			free(fullpath);
		}

		ksigsetmask(mask);
		return(LAMERROR);
	}

	if (bmalloc) {
		free(fullpath);
	}

	nhead.nh_event = -getpid();
/*
 * Receive reply.
 */
	if (nrecv(&nhead)) {
		ksigsetmask(mask);
		return(LAMERROR);
	}

	ksigsetmask(mask);
/*
 * Set local errno with returned errno value.
 */
	if (reply->lr_reply) {
		errno = reply->lr_reply;
		return(LAMERROR);
	} else {
		return(0);
	}
}
