/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: tsize.c,v 6.1 96/11/23 22:54:45 nevin Rel $
 *
 *	Function:	- return size of datatype
 *	Accepts:	- datatype
 *			- ptr to size (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Type_size(dtype, psize)

MPI_Datatype		dtype;
int			*psize;

{
	lam_initerr();
	lam_setfunc(BLKMPITSIZE);

	if (dtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITSIZE, lam_mkerr(MPI_ERR_TYPE, 0)));
	}
	else if (psize == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITSIZE, lam_mkerr(MPI_ERR_ARG, 0)));
	}
	else {
		*psize = dtype->dt_size;
	}

	lam_resetfunc(BLKMPITSIZE);
	return(MPI_SUCCESS);
}
