/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: nameunpub.c,v 6.1 96/11/22 13:35:05 nevin Rel $
 *
 *	Function:	- unpublish a port/service pair
 *	Accepts:	- port name
 *			- service name
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <errno.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>
#include <trreq.h>


int
MPI_Name_unpublish(port_name, service_name)

char			*port_name;
char			*service_name;

{
	lam_initerr();
	lam_setfunc(BLKMPINAMEUNPUB);
/*
 * Check arguments.
 */
	if (service_name == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPINAMEUNPUB,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * We do not allow multiple ports for the same service name and hence
 * ignore the port name argument.
 */
	if (lam_rtrnamedel(0, service_name)) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPINAMEUNPUB,
				lam_mkerr(MPI_ERR_SERVICE, errno))); 
	}

        lam_resetfunc(BLKMPINAMEUNPUB);
	return(MPI_SUCCESS);
}
