/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	NJN
 *
 *	$Id: namepub_f.c,v 6.1 96/11/22 13:44:37 nevin Rel $
 *
 *	Function:	- MPI_Name_publish F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

void
mpi_name_publish_(p, i,	s, ierr, np, ns)

char			*p, *s;
int			*i, *ierr;
int			np, ns;

{
	char		*port;
	char		*service;

	port = lam_F2C_string(p, np);
	service	= lam_F2C_string(s, ns);

	if (port == 0 || service == 0) {
		lam_setfunc(BLKMPINAMEPUB);
		*ierr =	lam_errfunc(MPI_COMM_WORLD, BLKMPINAMEPUB,
					lam_mkerr(MPI_ERR_OTHER, errno));
		return;
	}

	*ierr =	MPI_Name_publish(port, GETHDL(*i), service);

	free(port);
	free(service);
}
