/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	RBD/NJN
 *
 *	$Id: keycreate_f.c,v 6.1 96/11/22 13:44:37 nevin Rel $
 *
 *	Function:	- MPI_Keyval_create F77	wrapper
 */

#include <lam_config.h>

#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

void 
mpi_keyval_create_(cf, df, k, es, ierr)

void	(*cf) ();
void	(*df) ();
int	*k, *es, *ierr;

{
	MPI_Copy_function *cf_C;
	MPI_Delete_function *df_C;
	
	cf_C =  (*cf == mpi_null_copy_fn_) ?
			MPI_NULL_COPY_FN : (MPI_Copy_function *) cf;
	df_C = (*df == mpi_null_delete_fn_) ?
			MPI_NULL_DELETE_FN : (MPI_Delete_function *) df;
	
	*ierr =	MPI_Keyval_create(cf_C, df_C, k, (void *) *es);
}
