/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: bsendinit.c,v 6.1 96/11/23 22:50:59 nevin Rel $
 *
 *	Function:	- create a buffered send request
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- destination
 *			- tag
 *			- communicator
 *			- request (returned)
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

/*
 * external functions
 */
extern int		lam_errfunc();
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern int		_mpi_req_build();


int
MPI_Bsend_init(buf, count, dtype, dest, tag, comm, req)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			dest;
int			tag;
MPI_Comm		comm;
MPI_Request		*req;

{
	int		err;			/* error code */

	lam_initerr();
	lam_setfunc(BLKMPIBSINIT);
/*
 * Create the fake user request.
 */
	*req = MPI_REQUEST_NULL;
	err = _mpi_req_build(buf, count, dtype, dest, tag, comm,
				LAM_RQIFAKE, req);

	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIBSINIT, err));
	}

	(*req)->rq_marks |= LAM_RQFPERSIST;
	(*req)->rq_status.MPI_ERROR = MPI_SUCCESS;
	(*req)->rq_status.MPI_SOURCE = MPI_PROC_NULL;

	lam_resetfunc(BLKMPIBSINIT);
	return(MPI_SUCCESS);
}
