/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	few.c,v $
 * Revision 6.1  96/11/23  19:57:56  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:46:31  gdburns
 * Ohio Release
 * 
 *	Function:	- forks, execs and waits for a subordinate program
 *	Accepts:	- argument vector, argv[0] is program
 *	Returns:	- status code or ERROR
 */

#include <errno.h>
#include <sys/wait.h>
#include <unistd.h>

int
_lam_few(argv)

char			*argv[];

{
	int		status;		/* exit status */
	int		pid;		/* whoami? */

	if ((pid = fork()) < 0) {
		return(pid);
    	}

	else if (pid == 0) {		/* child */
		execvp(argv[0], argv);
		exit(errno);
    	}

	else {				/* parent */

		while ((waitpid(pid, &status, 0) != 0) &&
				(! WIFEXITED(status)));
	}

	return(WEXITSTATUS(status));
}
