/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	filed.h,v $
 * Revision 6.1  96/11/23  19:54:55  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:30:54  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/02/01  21:08:02  gdburns
 * Remove cubix support into a separate library.
 * 
 * Revision 5.2  94/08/22  13:47:49  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:42:02  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:26:35  gdburns
 * Ohio Release
 *
 *	Function:	- general templates and contants used by filed
 */

#ifndef _FILED
#define _FILED

#include <portable.h>

/*
 * Trollius file descriptor
 */
struct fdesc {
	int4		f_tfd;		/* Trollius file descriptor */
	int4		f_fd;		/* Unix file descriptor */
	int4		f_ptr;		/* current pointer within file */
	int4		f_tflags;	/* Trollius peculiar flags */
	int4		f_flags;	/* Unix flags */
	int4		f_flow;		/* total data flow */
	int4		f_count;	/* open count O_REUSE */
	int4		f_src_node;	/* last client's node */
	int4		f_src_event;	/* last client's event */
	char		*f_name;	/* file name */
	struct fdesc	*f_next;	/* next entry in file desc. list */
	struct fdesc	*f_prev;	/* previous entry in file desc. list */
};

/*
 * nulls
 */
#define FDNULL		((struct fdesc *) 0)

/*
 * limits
 */
#define ACTIVEMAX	10		/* filed's open descriptors */

/*
 * codes
 */
#define FMT		'f'		/* formatted F77 file */
#define UFMT		'u'		/* unformatted F77 file */

#endif
