/* snarf, the Simple Non-interactive All-purpose Resource Fetcher
** Copyright (C) 1995 Zachary Beane
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public LIcense as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is dsitributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILIY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** The author of this program may be reached via email at
** xach@phoenix.umeres.maine.edu or via USPS at 17 Talmadge Rd., Waite,
** ME 04492, USA.
*/
#include <stdio.h>
#include <ctype.h>

struct alias {
  char a_alias[50];
  char a_url[256];
};

int aliastourl(char *config_file, char *key, char *url)
{
  FILE *fp;
  char line[256];
  struct alias a;
  int nl = 0;

  if((fp = fopen(config_file, "r")) == NULL){
    return 0;
  }
  
  while(getline(fp, line)){
    nl++;
    if(iscomment(line)){
        continue;
    }
    get_alias(&a, line);
  
    if(strcmp(a.a_alias, key) == 0){
      strcpy(url, a.a_url);
      return 1;
    }
    
  }
  return 0;
}

int getline(FILE *fp, char *line)
{
  int lp = 0;
  char c;

  while((c = fgetc(fp)) != EOF){
    if(c == '\n'){
      line[lp] = '\0';
      return 1;
    }
    line[lp++] = c;
  }
  return 0;

}

int iscomment(char *line)
{
  char c;
  int lp = 0;
  
  while(line[lp] != '\0'){
    if(isspace(line[lp])){
      lp++;
      continue;
    }    
    if(line[lp] == '#')
      return(1);
    else
      return(0);
  }
}

int get_alias(struct alias *a, char *line)
{
  int lp = 0;
  int ap = 0;
  
  while(isspace(line[lp]))
    lp++;
  
  while(!isspace(line[lp]))
    a->a_alias[ap++] = line[lp++];

  a->a_alias[ap] = '\0';

  while(isspace(line[lp]))
    lp++;

  ap = 0;

  while(!isspace(line[lp]))
    a->a_url[ap++] = line[lp++];

  a->a_url[ap] = '\0';

  return 1;
}

