/* # skkinput (Simple Kana-Kanji Input)
 * draw.h
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef draw_h
#define draw_h

#include "FontMgr.h"

enum {
  MODELINE_NOTHING = 0, MODELINE_HANKAKU, MODELINE_ZENKAKU,
  MODELINE_KATAKANA, MODELINE_KANA,
} ;

#define NUMBER_OF_MODELINE	(4)
#define NUMBER_OF_MODELINE_JISYO	(2)
#define NUMBER_OF_MODELINE_OVERTHESPOT	(2)

/*
 * $B%W%m%H%?%$%W@k8@!#(B
 */
int skkwin_jputchar
( Display *disp, Window win, struct skkinputManagedFont **fontset,
  GC gc, int x, int y, int chara, int flag ) ;
void skkwin_jerase
( Display *disp, Window win, GC gc, int x, int y,
  int font_ascent, int width, int height ) ;
int skkwin_jputMyChar
( Display *disp, Window win, struct skkinputManagedFont **fontset,
  GC gc, GC rgc, int x, int y, struct myChar chara, 
  int font_height, int font_ascent, int flag ) ;
int skkwin_jputstring
( Display *disp, Window win, struct skkinputManagedFont **fontset,
  GC gc, int x, int y, struct myChar *text ) ;
void skkwin_jdiffputstring
( Display *disp, Window win, struct skkinputManagedFont **fontset,
  GC gc, GC rgc, int x, int y, int width,
  struct myChar *text, struct myChar *ptext,
  int font_height, int font_ascent ) ;
void skkinputDrawCursor
( Display *disp, Window win, GC roman_ngc, GC roman_rgc, 
  int x, int y, int font_ascent, int width, int height, int is_focus ) ;
void OTSW_CalcTopPositionOfBuffer
( struct skkinputManagedFont **fontset,
  struct myChar *linetop, int linetop_pos, int cur_pos,
  int client_width, struct myChar **ret_toptext, int *ret_toppos ) ;
void OTSW_FullDrawTopBufferTopLine
( Display *disp, Window win, struct skkinputManagedFont **fontset,
  GC gc, GC rgc, struct myChar *text, int text_pos,
  int font_ascent, int font_height, int width, int bsflag, 
  int cursor_width, int cur_pos, int cur_exist, int is_focus ) ;
int skkinput_GetLineNum
( struct skkinputManagedFont **fontset, struct myChar *text,
  unsigned int width,  int cursor_width, int cur_pos, int *cur_line ) ;
int skkinput_FindStartLine
( struct skkinputManagedFont **fontset, struct myChar *text, 
  int startline, unsigned int width ) ;
void XChangeWMNormalHints
( Display *disp, Window win, XSizeHints *hints ) ;
void XGetRectangleOfWindow
( Display *disp, Window win, XRectangle *area ) ;
int skkinput_GetModelineNumber
( struct SKKInputNode *node ) ;
int skkwin_jputCharString
( Display *disp, Window win, struct skkinputManagedFont **fontset,
  GC gc, int x, int y, unsigned char *text ) ;
int skkwin_charTextWidth
( struct skkinputManagedFont **fontset, unsigned char *string, int num ) ;
int myCharTextWidth
( struct skkinputManagedFont **fontset, struct myChar *wstring, int num ) ;
int getWidthOfModeLine
( struct skkinputManagedFont **fontset, struct SKKInputNode *node,
  int jisyo_dirty, int overthespot_like_input ) ;
void fullDrawModeLine
( Display *disp, Window win, struct skkinputManagedFont **fontset,
  GC gc, struct SKKInputNode *node, int x, int y,
  int jisyo_dirty, int overthespot_like_input ) ;
int getMaxLengthOfModeline
( struct skkinputManagedFont **fontset ) ;

#endif
