//  wminterface.cc for bbtools.
//
//  Copyright (c) 1998-1999 by John Kennis, jkennis@chello.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// (See the included file COPYING / GPL-2.0)
//
#ifndef __WMINTERFACE_HH
#define __WMINTERFACE_HH

#include "Image.hh"
#include "bbpager.hh"

class BImageControl;
class Resource;
class ToolWindow;

struct WindowList;

class WMInterface {

public:
  WMInterface(ToolWindow *);
  ~WMInterface(void);

  void moduleInit(void);

  void windowChange(Window);
  void removeSticky(Window,int);
  void addSticky(WindowList *);
  void sendWindowToDesktop(Window,int);
  int getWinOnDesktop(Window);
  int isIcon(Window);
  int isSticky(Window);

  int getNumberOfDesktops();
  int getCurrentDesktop();
  void changeDesktop(int);

  void processClientEvents(XEvent Event);

  Atom getKWMModuleDesktopChange(void) { return kwm_module_desktop_change; }
  Atom getKWMModuleDesktopNumberChange(void) {
                return kwm_module_desktop_number_change; }
  Atom getKWMModuleInit(void) { return kwm_module_init; }
  Atom getKWMModuleWinAdd(void) { return kwm_module_win_add; }
  Atom getKWMModuleWinRemove(void) { return kwm_module_win_remove; }
  Atom getKWMModuleWinChange(void) { return kwm_module_win_change; }
  Atom getKWMModuleWinActivate(void) { return kwm_module_win_activate; }
  Atom getKWMModuleWinRaise(void) { return kwm_module_win_raise; }
  Atom getKWMModuleWinLower(void) { return kwm_module_win_lower; }



private:
  void sendClientMessage(Atom, XID);

  ToolWindow *bbtool;

  Atom kwm_module_init;
  Atom kwm_module_win_add;
  Atom kwm_module_win_remove;
  Atom kwm_module_win_change;
  Atom kwm_module_win_activate;
  Atom kwm_module_win_iconfied;
  Atom kwm_module_win_raise;
  Atom kwm_module_win_lower;
  Atom kwm_module_desktop_change;
  Atom kwm_module_desktop_number_change;


};

#endif /* __WMINTERFACE_HH */
