; -*- coding: iso-2022-7bit  -*-
;;; ugb2312.el --- tables between UCS and GB2312-80

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, JIS X 0208

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; This file is converted from GB2312.TXT of Unicode consortium
;;; by Miyashita Hisashi <himi@bird.scphys.kyoto-u.ac.jp>.

(put 'chinese-gb2312 'unicode 'gb2312-80-vs-unicode-assoc)

(defvar
  gb2312-80-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?$A!!(B . ?\x3000) ;; IDEOGRAPHIC SPACE
     (?$A!"(B . ?\x3001) ;; IDEOGRAPHIC COMMA
     (?$A!#(B . ?\x3002) ;; IDEOGRAPHIC FULL STOP
     (?$A!$(B . ?\x30FB) ;; KATAKANA MIDDLE DOT
     (?$A!%(B . ?\x02C9) ;; MODIFIER LETTER MACRON (Mandarin Chinese first tone)
     (?$A!&(B . ?\x02C7) ;; CARON (Mandarin Chinese third tone)
     (?$A!'(B . ?\x00A8) ;; DIAERESIS
     (?$A!((B . ?\x3003) ;; DITTO MARK
     (?$A!)(B . ?\x3005) ;; IDEOGRAPHIC ITERATION MARK
     (?$A!*(B . ?\x2015) ;; HORIZONTAL BAR
     (?$A!+(B . ?\xFF5E) ;; FULLWIDTH TILDE
     (?$A!,(B . ?\x2225) ;; PARALLEL TO
     (?$A!-(B . ?\x2026) ;; HORIZONTAL ELLIPSIS
     (?$A!.(B . ?\x2018) ;; LEFT SINGLE QUOTATION MARK
     (?$A!/(B . ?\x2019) ;; RIGHT SINGLE QUOTATION MARK
     (?$A!0(B . ?\x201C) ;; LEFT DOUBLE QUOTATION MARK
     (?$A!1(B . ?\x201D) ;; RIGHT DOUBLE QUOTATION MARK
     (?$A!2(B . ?\x3014) ;; LEFT TORTOISE SHELL BRACKET
     (?$A!3(B . ?\x3015) ;; RIGHT TORTOISE SHELL BRACKET
     (?$A!4(B . ?\x3008) ;; LEFT ANGLE BRACKET
     (?$A!5(B . ?\x3009) ;; RIGHT ANGLE BRACKET
     (?$A!6(B . ?\x300A) ;; LEFT DOUBLE ANGLE BRACKET
     (?$A!7(B . ?\x300B) ;; RIGHT DOUBLE ANGLE BRACKET
     (?$A!8(B . ?\x300C) ;; LEFT CORNER BRACKET
     (?$A!9(B . ?\x300D) ;; RIGHT CORNER BRACKET
     (?$A!:(B . ?\x300E) ;; LEFT WHITE CORNER BRACKET
     (?$A!;(B . ?\x300F) ;; RIGHT WHITE CORNER BRACKET
     (?$A!<(B . ?\x3016) ;; LEFT WHITE LENTICULAR BRACKET
     (?$A!=(B . ?\x3017) ;; RIGHT WHITE LENTICULAR BRACKET
     (?$A!>(B . ?\x3010) ;; LEFT BLACK LENTICULAR BRACKET
     (?$A!?(B . ?\x3011) ;; RIGHT BLACK LENTICULAR BRACKET
     (?$A!@(B . ?\x00B1) ;; PLUS-MINUS SIGN
     (?$A!A(B . ?\x00D7) ;; MULTIPLICATION SIGN
     (?$A!B(B . ?\x00F7) ;; DIVISION SIGN
     (?$A!C(B . ?\x2236) ;; RATIO
     (?$A!D(B . ?\x2227) ;; LOGICAL AND
     (?$A!E(B . ?\x2228) ;; LOGICAL OR
     (?$A!F(B . ?\x2211) ;; N-ARY SUMMATION
     (?$A!G(B . ?\x220F) ;; N-ARY PRODUCT
     (?$A!H(B . ?\x222A) ;; UNION
     (?$A!I(B . ?\x2229) ;; INTERSECTION
     (?$A!J(B . ?\x2208) ;; ELEMENT OF
     (?$A!K(B . ?\x2237) ;; PROPORTION
     (?$A!L(B . ?\x221A) ;; SQUARE ROOT
     (?$A!M(B . ?\x22A5) ;; UP TACK
     (?$A!N(B . ?\x2225) ;; PARALLEL TO
     (?$A!O(B . ?\x2220) ;; ANGLE
     (?$A!P(B . ?\x2312) ;; ARC
     (?$A!Q(B . ?\x2299) ;; CIRCLED DOT OPERATOR
     (?$A!R(B . ?\x222B) ;; INTEGRAL
     (?$A!S(B . ?\x222E) ;; CONTOUR INTEGRAL
     (?$A!T(B . ?\x2261) ;; IDENTICAL TO
     (?$A!U(B . ?\x224C) ;; ALL EQUAL TO
     (?$A!V(B . ?\x2248) ;; ALMOST EQUAL TO
     (?$A!W(B . ?\x223D) ;; REVERSED TILDE
     (?$A!X(B . ?\x221D) ;; PROPORTIONAL TO
     (?$A!Y(B . ?\x2260) ;; NOT EQUAL TO
     (?$A!Z(B . ?\x226E) ;; NOT LESS-THAN
     (?$A![(B . ?\x226F) ;; NOT GREATER-THAN
     (?$A!\(B . ?\x2264) ;; LESS-THAN OR EQUAL TO
     (?$A!](B . ?\x2265) ;; GREATER-THAN OR EQUAL TO
     (?$A!^(B . ?\x221E) ;; INFINITY
     (?$A!_(B . ?\x2235) ;; BECAUSE
     (?$A!`(B . ?\x2234) ;; THEREFORE
     (?$A!a(B . ?\x2642) ;; MALE SIGN
     (?$A!b(B . ?\x2640) ;; FEMALE SIGN
     (?$A!c(B . ?\x00B0) ;; DEGREE SIGN
     (?$A!d(B . ?\x2032) ;; PRIME
     (?$A!e(B . ?\x2033) ;; DOUBLE PRIME
     (?$A!f(B . ?\x2103) ;; DEGREE CELSIUS
     (?$A!g(B . ?\xFF04) ;; FULLWIDTH DOLLAR SIGN
     (?$A!h(B . ?\x00A4) ;; CURRENCY SIGN
     (?$A!i(B . ?\xFFE0) ;; FULLWIDTH CENT SIGN
     (?$A!j(B . ?\xFFE1) ;; FULLWIDTH POUND SIGN
     (?$A!k(B . ?\x2030) ;; PER MILLE SIGN
     (?$A!l(B . ?\x00A7) ;; SECTION SIGN
     (?$A!m(B . ?\x2116) ;; NUMERO SIGN
     (?$A!n(B . ?\x2606) ;; WHITE STAR
     (?$A!o(B . ?\x2605) ;; BLACK STAR
     (?$A!p(B . ?\x25CB) ;; WHITE CIRCLE
     (?$A!q(B . ?\x25CF) ;; BLACK CIRCLE
     (?$A!r(B . ?\x25CE) ;; BULLSEYE
     (?$A!s(B . ?\x25C7) ;; WHITE DIAMOND
     (?$A!t(B . ?\x25C6) ;; BLACK DIAMOND
     (?$A!u(B . ?\x25A1) ;; WHITE SQUARE
     (?$A!v(B . ?\x25A0) ;; BLACK SQUARE
     (?$A!w(B . ?\x25B3) ;; WHITE UP-POINTING TRIANGLE
     (?$A!x(B . ?\x25B2) ;; BLACK UP-POINTING TRIANGLE
     (?$A!y(B . ?\x203B) ;; REFERENCE MARK
     (?$A!z(B . ?\x2192) ;; RIGHTWARDS ARROW
     (?$A!{(B . ?\x2190) ;; LEFTWARDS ARROW
     (?$A!|(B . ?\x2191) ;; UPWARDS ARROW
     (?$A!}(B . ?\x2193) ;; DOWNWARDS ARROW
     (?$A!~(B . ?\x3013) ;; GETA MARK
     (?$A"1(B . ?\x2488) ;; DIGIT ONE FULL STOP
     (?$A"2(B . ?\x2489) ;; DIGIT TWO FULL STOP
     (?$A"3(B . ?\x248A) ;; DIGIT THREE FULL STOP
     (?$A"4(B . ?\x248B) ;; DIGIT FOUR FULL STOP
     (?$A"5(B . ?\x248C) ;; DIGIT FIVE FULL STOP
     (?$A"6(B . ?\x248D) ;; DIGIT SIX FULL STOP
     (?$A"7(B . ?\x248E) ;; DIGIT SEVEN FULL STOP
     (?$A"8(B . ?\x248F) ;; DIGIT EIGHT FULL STOP
     (?$A"9(B . ?\x2490) ;; DIGIT NINE FULL STOP
     (?$A":(B . ?\x2491) ;; NUMBER TEN FULL STOP
     (?$A";(B . ?\x2492) ;; NUMBER ELEVEN FULL STOP
     (?$A"<(B . ?\x2493) ;; NUMBER TWELVE FULL STOP
     (?$A"=(B . ?\x2494) ;; NUMBER THIRTEEN FULL STOP
     (?$A">(B . ?\x2495) ;; NUMBER FOURTEEN FULL STOP
     (?$A"?(B . ?\x2496) ;; NUMBER FIFTEEN FULL STOP
     (?$A"@(B . ?\x2497) ;; NUMBER SIXTEEN FULL STOP
     (?$A"A(B . ?\x2498) ;; NUMBER SEVENTEEN FULL STOP
     (?$A"B(B . ?\x2499) ;; NUMBER EIGHTEEN FULL STOP
     (?$A"C(B . ?\x249A) ;; NUMBER NINETEEN FULL STOP
     (?$A"D(B . ?\x249B) ;; NUMBER TWENTY FULL STOP
     (?$A"E(B . ?\x2474) ;; PARENTHESIZED DIGIT ONE
     (?$A"F(B . ?\x2475) ;; PARENTHESIZED DIGIT TWO
     (?$A"G(B . ?\x2476) ;; PARENTHESIZED DIGIT THREE
     (?$A"H(B . ?\x2477) ;; PARENTHESIZED DIGIT FOUR
     (?$A"I(B . ?\x2478) ;; PARENTHESIZED DIGIT FIVE
     (?$A"J(B . ?\x2479) ;; PARENTHESIZED DIGIT SIX
     (?$A"K(B . ?\x247A) ;; PARENTHESIZED DIGIT SEVEN
     (?$A"L(B . ?\x247B) ;; PARENTHESIZED DIGIT EIGHT
     (?$A"M(B . ?\x247C) ;; PARENTHESIZED DIGIT NINE
     (?$A"N(B . ?\x247D) ;; PARENTHESIZED NUMBER TEN
     (?$A"O(B . ?\x247E) ;; PARENTHESIZED NUMBER ELEVEN
     (?$A"P(B . ?\x247F) ;; PARENTHESIZED NUMBER TWELVE
     (?$A"Q(B . ?\x2480) ;; PARENTHESIZED NUMBER THIRTEEN
     (?$A"R(B . ?\x2481) ;; PARENTHESIZED NUMBER FOURTEEN
     (?$A"S(B . ?\x2482) ;; PARENTHESIZED NUMBER FIFTEEN
     (?$A"T(B . ?\x2483) ;; PARENTHESIZED NUMBER SIXTEEN
     (?$A"U(B . ?\x2484) ;; PARENTHESIZED NUMBER SEVENTEEN
     (?$A"V(B . ?\x2485) ;; PARENTHESIZED NUMBER EIGHTEEN
     (?$A"W(B . ?\x2486) ;; PARENTHESIZED NUMBER NINETEEN
     (?$A"X(B . ?\x2487) ;; PARENTHESIZED NUMBER TWENTY
     (?$A"Y(B . ?\x2460) ;; CIRCLED DIGIT ONE
     (?$A"Z(B . ?\x2461) ;; CIRCLED DIGIT TWO
     (?$A"[(B . ?\x2462) ;; CIRCLED DIGIT THREE
     (?$A"\(B . ?\x2463) ;; CIRCLED DIGIT FOUR
     (?$A"](B . ?\x2464) ;; CIRCLED DIGIT FIVE
     (?$A"^(B . ?\x2465) ;; CIRCLED DIGIT SIX
     (?$A"_(B . ?\x2466) ;; CIRCLED DIGIT SEVEN
     (?$A"`(B . ?\x2467) ;; CIRCLED DIGIT EIGHT
     (?$A"a(B . ?\x2468) ;; CIRCLED DIGIT NINE
     (?$A"b(B . ?\x2469) ;; CIRCLED NUMBER TEN
     (?$A"e(B . ?\x3220) ;; PARENTHESIZED IDEOGRAPH ONE
     (?$A"f(B . ?\x3221) ;; PARENTHESIZED IDEOGRAPH TWO
     (?$A"g(B . ?\x3222) ;; PARENTHESIZED IDEOGRAPH THREE
     (?$A"h(B . ?\x3223) ;; PARENTHESIZED IDEOGRAPH FOUR
     (?$A"i(B . ?\x3224) ;; PARENTHESIZED IDEOGRAPH FIVE
     (?$A"j(B . ?\x3225) ;; PARENTHESIZED IDEOGRAPH SIX
     (?$A"k(B . ?\x3226) ;; PARENTHESIZED IDEOGRAPH SEVEN
     (?$A"l(B . ?\x3227) ;; PARENTHESIZED IDEOGRAPH EIGHT
     (?$A"m(B . ?\x3228) ;; PARENTHESIZED IDEOGRAPH NINE
     (?$A"n(B . ?\x3229) ;; PARENTHESIZED IDEOGRAPH TEN
     (?$A"q(B . ?\x2160) ;; ROMAN NUMERAL ONE
     (?$A"r(B . ?\x2161) ;; ROMAN NUMERAL TWO
     (?$A"s(B . ?\x2162) ;; ROMAN NUMERAL THREE
     (?$A"t(B . ?\x2163) ;; ROMAN NUMERAL FOUR
     (?$A"u(B . ?\x2164) ;; ROMAN NUMERAL FIVE
     (?$A"v(B . ?\x2165) ;; ROMAN NUMERAL SIX
     (?$A"w(B . ?\x2166) ;; ROMAN NUMERAL SEVEN
     (?$A"x(B . ?\x2167) ;; ROMAN NUMERAL EIGHT
     (?$A"y(B . ?\x2168) ;; ROMAN NUMERAL NINE
     (?$A"z(B . ?\x2169) ;; ROMAN NUMERAL TEN
     (?$A"{(B . ?\x216A) ;; ROMAN NUMERAL ELEVEN
     (?$A"|(B . ?\x216B) ;; ROMAN NUMERAL TWELVE
     (?$A#!(B . ?\xFF01) ;; FULLWIDTH EXCLAMATION MARK
     (?$A#"(B . ?\xFF02) ;; FULLWIDTH QUOTATION MARK
     (?$A##(B . ?\xFF03) ;; FULLWIDTH NUMBER SIGN
     (?$A#$(B . ?\xFFE5) ;; FULLWIDTH YEN SIGN
     (?$A#%(B . ?\xFF05) ;; FULLWIDTH PERCENT SIGN
     (?$A#&(B . ?\xFF06) ;; FULLWIDTH AMPERSAND
     (?$A#'(B . ?\xFF07) ;; FULLWIDTH APOSTROPHE
     (?$A#((B . ?\xFF08) ;; FULLWIDTH LEFT PARENTHESIS
     (?$A#)(B . ?\xFF09) ;; FULLWIDTH RIGHT PARENTHESIS
     (?$A#*(B . ?\xFF0A) ;; FULLWIDTH ASTERISK
     (?$A#+(B . ?\xFF0B) ;; FULLWIDTH PLUS SIGN
     (?$A#,(B . ?\xFF0C) ;; FULLWIDTH COMMA
     (?$A#-(B . ?\xFF0D) ;; FULLWIDTH HYPHEN-MINUS
     (?$A#.(B . ?\xFF0E) ;; FULLWIDTH FULL STOP
     (?$A#/(B . ?\xFF0F) ;; FULLWIDTH SOLIDUS
     (?$A#0(B . ?\xFF10) ;; FULLWIDTH DIGIT ZERO
     (?$A#1(B . ?\xFF11) ;; FULLWIDTH DIGIT ONE
     (?$A#2(B . ?\xFF12) ;; FULLWIDTH DIGIT TWO
     (?$A#3(B . ?\xFF13) ;; FULLWIDTH DIGIT THREE
     (?$A#4(B . ?\xFF14) ;; FULLWIDTH DIGIT FOUR
     (?$A#5(B . ?\xFF15) ;; FULLWIDTH DIGIT FIVE
     (?$A#6(B . ?\xFF16) ;; FULLWIDTH DIGIT SIX
     (?$A#7(B . ?\xFF17) ;; FULLWIDTH DIGIT SEVEN
     (?$A#8(B . ?\xFF18) ;; FULLWIDTH DIGIT EIGHT
     (?$A#9(B . ?\xFF19) ;; FULLWIDTH DIGIT NINE
     (?$A#:(B . ?\xFF1A) ;; FULLWIDTH COLON
     (?$A#;(B . ?\xFF1B) ;; FULLWIDTH SEMICOLON
     (?$A#<(B . ?\xFF1C) ;; FULLWIDTH LESS-THAN SIGN
     (?$A#=(B . ?\xFF1D) ;; FULLWIDTH EQUALS SIGN
     (?$A#>(B . ?\xFF1E) ;; FULLWIDTH GREATER-THAN SIGN
     (?$A#?(B . ?\xFF1F) ;; FULLWIDTH QUESTION MARK
     (?$A#@(B . ?\xFF20) ;; FULLWIDTH COMMERCIAL AT
     (?$A#A(B . ?\xFF21) ;; FULLWIDTH LATIN CAPITAL LETTER A
     (?$A#B(B . ?\xFF22) ;; FULLWIDTH LATIN CAPITAL LETTER B
     (?$A#C(B . ?\xFF23) ;; FULLWIDTH LATIN CAPITAL LETTER C
     (?$A#D(B . ?\xFF24) ;; FULLWIDTH LATIN CAPITAL LETTER D
     (?$A#E(B . ?\xFF25) ;; FULLWIDTH LATIN CAPITAL LETTER E
     (?$A#F(B . ?\xFF26) ;; FULLWIDTH LATIN CAPITAL LETTER F
     (?$A#G(B . ?\xFF27) ;; FULLWIDTH LATIN CAPITAL LETTER G
     (?$A#H(B . ?\xFF28) ;; FULLWIDTH LATIN CAPITAL LETTER H
     (?$A#I(B . ?\xFF29) ;; FULLWIDTH LATIN CAPITAL LETTER I
     (?$A#J(B . ?\xFF2A) ;; FULLWIDTH LATIN CAPITAL LETTER J
     (?$A#K(B . ?\xFF2B) ;; FULLWIDTH LATIN CAPITAL LETTER K
     (?$A#L(B . ?\xFF2C) ;; FULLWIDTH LATIN CAPITAL LETTER L
     (?$A#M(B . ?\xFF2D) ;; FULLWIDTH LATIN CAPITAL LETTER M
     (?$A#N(B . ?\xFF2E) ;; FULLWIDTH LATIN CAPITAL LETTER N
     (?$A#O(B . ?\xFF2F) ;; FULLWIDTH LATIN CAPITAL LETTER O
     (?$A#P(B . ?\xFF30) ;; FULLWIDTH LATIN CAPITAL LETTER P
     (?$A#Q(B . ?\xFF31) ;; FULLWIDTH LATIN CAPITAL LETTER Q
     (?$A#R(B . ?\xFF32) ;; FULLWIDTH LATIN CAPITAL LETTER R
     (?$A#S(B . ?\xFF33) ;; FULLWIDTH LATIN CAPITAL LETTER S
     (?$A#T(B . ?\xFF34) ;; FULLWIDTH LATIN CAPITAL LETTER T
     (?$A#U(B . ?\xFF35) ;; FULLWIDTH LATIN CAPITAL LETTER U
     (?$A#V(B . ?\xFF36) ;; FULLWIDTH LATIN CAPITAL LETTER V
     (?$A#W(B . ?\xFF37) ;; FULLWIDTH LATIN CAPITAL LETTER W
     (?$A#X(B . ?\xFF38) ;; FULLWIDTH LATIN CAPITAL LETTER X
     (?$A#Y(B . ?\xFF39) ;; FULLWIDTH LATIN CAPITAL LETTER Y
     (?$A#Z(B . ?\xFF3A) ;; FULLWIDTH LATIN CAPITAL LETTER Z
     (?$A#[(B . ?\xFF3B) ;; FULLWIDTH LEFT SQUARE BRACKET
     (?$A#\(B . ?\xFF3C) ;; FULLWIDTH REVERSE SOLIDUS
     (?$A#](B . ?\xFF3D) ;; FULLWIDTH RIGHT SQUARE BRACKET
     (?$A#^(B . ?\xFF3E) ;; FULLWIDTH CIRCUMFLEX ACCENT
     (?$A#_(B . ?\xFF3F) ;; FULLWIDTH LOW LINE
     (?$A#`(B . ?\xFF40) ;; FULLWIDTH GRAVE ACCENT
     (?$A#a(B . ?\xFF41) ;; FULLWIDTH LATIN SMALL LETTER A
     (?$A#b(B . ?\xFF42) ;; FULLWIDTH LATIN SMALL LETTER B
     (?$A#c(B . ?\xFF43) ;; FULLWIDTH LATIN SMALL LETTER C
     (?$A#d(B . ?\xFF44) ;; FULLWIDTH LATIN SMALL LETTER D
     (?$A#e(B . ?\xFF45) ;; FULLWIDTH LATIN SMALL LETTER E
     (?$A#f(B . ?\xFF46) ;; FULLWIDTH LATIN SMALL LETTER F
     (?$A#g(B . ?\xFF47) ;; FULLWIDTH LATIN SMALL LETTER G
     (?$A#h(B . ?\xFF48) ;; FULLWIDTH LATIN SMALL LETTER H
     (?$A#i(B . ?\xFF49) ;; FULLWIDTH LATIN SMALL LETTER I
     (?$A#j(B . ?\xFF4A) ;; FULLWIDTH LATIN SMALL LETTER J
     (?$A#k(B . ?\xFF4B) ;; FULLWIDTH LATIN SMALL LETTER K
     (?$A#l(B . ?\xFF4C) ;; FULLWIDTH LATIN SMALL LETTER L
     (?$A#m(B . ?\xFF4D) ;; FULLWIDTH LATIN SMALL LETTER M
     (?$A#n(B . ?\xFF4E) ;; FULLWIDTH LATIN SMALL LETTER N
     (?$A#o(B . ?\xFF4F) ;; FULLWIDTH LATIN SMALL LETTER O
     (?$A#p(B . ?\xFF50) ;; FULLWIDTH LATIN SMALL LETTER P
     (?$A#q(B . ?\xFF51) ;; FULLWIDTH LATIN SMALL LETTER Q
     (?$A#r(B . ?\xFF52) ;; FULLWIDTH LATIN SMALL LETTER R
     (?$A#s(B . ?\xFF53) ;; FULLWIDTH LATIN SMALL LETTER S
     (?$A#t(B . ?\xFF54) ;; FULLWIDTH LATIN SMALL LETTER T
     (?$A#u(B . ?\xFF55) ;; FULLWIDTH LATIN SMALL LETTER U
     (?$A#v(B . ?\xFF56) ;; FULLWIDTH LATIN SMALL LETTER V
     (?$A#w(B . ?\xFF57) ;; FULLWIDTH LATIN SMALL LETTER W
     (?$A#x(B . ?\xFF58) ;; FULLWIDTH LATIN SMALL LETTER X
     (?$A#y(B . ?\xFF59) ;; FULLWIDTH LATIN SMALL LETTER Y
     (?$A#z(B . ?\xFF5A) ;; FULLWIDTH LATIN SMALL LETTER Z
     (?$A#{(B . ?\xFF5B) ;; FULLWIDTH LEFT CURLY BRACKET
     (?$A#|(B . ?\xFF5C) ;; FULLWIDTH VERTICAL LINE
     (?$A#}(B . ?\xFF5D) ;; FULLWIDTH RIGHT CURLY BRACKET
     (?$A#~(B . ?\xFFE3) ;; FULLWIDTH MACRON
     (?$A$!(B . ?\x3041) ;; HIRAGANA LETTER SMALL A
     (?$A$"(B . ?\x3042) ;; HIRAGANA LETTER A
     (?$A$#(B . ?\x3043) ;; HIRAGANA LETTER SMALL I
     (?$A$$(B . ?\x3044) ;; HIRAGANA LETTER I
     (?$A$%(B . ?\x3045) ;; HIRAGANA LETTER SMALL U
     (?$A$&(B . ?\x3046) ;; HIRAGANA LETTER U
     (?$A$'(B . ?\x3047) ;; HIRAGANA LETTER SMALL E
     (?$A$((B . ?\x3048) ;; HIRAGANA LETTER E
     (?$A$)(B . ?\x3049) ;; HIRAGANA LETTER SMALL O
     (?$A$*(B . ?\x304A) ;; HIRAGANA LETTER O
     (?$A$+(B . ?\x304B) ;; HIRAGANA LETTER KA
     (?$A$,(B . ?\x304C) ;; HIRAGANA LETTER GA
     (?$A$-(B . ?\x304D) ;; HIRAGANA LETTER KI
     (?$A$.(B . ?\x304E) ;; HIRAGANA LETTER GI
     (?$A$/(B . ?\x304F) ;; HIRAGANA LETTER KU
     (?$A$0(B . ?\x3050) ;; HIRAGANA LETTER GU
     (?$A$1(B . ?\x3051) ;; HIRAGANA LETTER KE
     (?$A$2(B . ?\x3052) ;; HIRAGANA LETTER GE
     (?$A$3(B . ?\x3053) ;; HIRAGANA LETTER KO
     (?$A$4(B . ?\x3054) ;; HIRAGANA LETTER GO
     (?$A$5(B . ?\x3055) ;; HIRAGANA LETTER SA
     (?$A$6(B . ?\x3056) ;; HIRAGANA LETTER ZA
     (?$A$7(B . ?\x3057) ;; HIRAGANA LETTER SI
     (?$A$8(B . ?\x3058) ;; HIRAGANA LETTER ZI
     (?$A$9(B . ?\x3059) ;; HIRAGANA LETTER SU
     (?$A$:(B . ?\x305A) ;; HIRAGANA LETTER ZU
     (?$A$;(B . ?\x305B) ;; HIRAGANA LETTER SE
     (?$A$<(B . ?\x305C) ;; HIRAGANA LETTER ZE
     (?$A$=(B . ?\x305D) ;; HIRAGANA LETTER SO
     (?$A$>(B . ?\x305E) ;; HIRAGANA LETTER ZO
     (?$A$?(B . ?\x305F) ;; HIRAGANA LETTER TA
     (?$A$@(B . ?\x3060) ;; HIRAGANA LETTER DA
     (?$A$A(B . ?\x3061) ;; HIRAGANA LETTER TI
     (?$A$B(B . ?\x3062) ;; HIRAGANA LETTER DI
     (?$A$C(B . ?\x3063) ;; HIRAGANA LETTER SMALL TU
     (?$A$D(B . ?\x3064) ;; HIRAGANA LETTER TU
     (?$A$E(B . ?\x3065) ;; HIRAGANA LETTER DU
     (?$A$F(B . ?\x3066) ;; HIRAGANA LETTER TE
     (?$A$G(B . ?\x3067) ;; HIRAGANA LETTER DE
     (?$A$H(B . ?\x3068) ;; HIRAGANA LETTER TO
     (?$A$I(B . ?\x3069) ;; HIRAGANA LETTER DO
     (?$A$J(B . ?\x306A) ;; HIRAGANA LETTER NA
     (?$A$K(B . ?\x306B) ;; HIRAGANA LETTER NI
     (?$A$L(B . ?\x306C) ;; HIRAGANA LETTER NU
     (?$A$M(B . ?\x306D) ;; HIRAGANA LETTER NE
     (?$A$N(B . ?\x306E) ;; HIRAGANA LETTER NO
     (?$A$O(B . ?\x306F) ;; HIRAGANA LETTER HA
     (?$A$P(B . ?\x3070) ;; HIRAGANA LETTER BA
     (?$A$Q(B . ?\x3071) ;; HIRAGANA LETTER PA
     (?$A$R(B . ?\x3072) ;; HIRAGANA LETTER HI
     (?$A$S(B . ?\x3073) ;; HIRAGANA LETTER BI
     (?$A$T(B . ?\x3074) ;; HIRAGANA LETTER PI
     (?$A$U(B . ?\x3075) ;; HIRAGANA LETTER HU
     (?$A$V(B . ?\x3076) ;; HIRAGANA LETTER BU
     (?$A$W(B . ?\x3077) ;; HIRAGANA LETTER PU
     (?$A$X(B . ?\x3078) ;; HIRAGANA LETTER HE
     (?$A$Y(B . ?\x3079) ;; HIRAGANA LETTER BE
     (?$A$Z(B . ?\x307A) ;; HIRAGANA LETTER PE
     (?$A$[(B . ?\x307B) ;; HIRAGANA LETTER HO
     (?$A$\(B . ?\x307C) ;; HIRAGANA LETTER BO
     (?$A$](B . ?\x307D) ;; HIRAGANA LETTER PO
     (?$A$^(B . ?\x307E) ;; HIRAGANA LETTER MA
     (?$A$_(B . ?\x307F) ;; HIRAGANA LETTER MI
     (?$A$`(B . ?\x3080) ;; HIRAGANA LETTER MU
     (?$A$a(B . ?\x3081) ;; HIRAGANA LETTER ME
     (?$A$b(B . ?\x3082) ;; HIRAGANA LETTER MO
     (?$A$c(B . ?\x3083) ;; HIRAGANA LETTER SMALL YA
     (?$A$d(B . ?\x3084) ;; HIRAGANA LETTER YA
     (?$A$e(B . ?\x3085) ;; HIRAGANA LETTER SMALL YU
     (?$A$f(B . ?\x3086) ;; HIRAGANA LETTER YU
     (?$A$g(B . ?\x3087) ;; HIRAGANA LETTER SMALL YO
     (?$A$h(B . ?\x3088) ;; HIRAGANA LETTER YO
     (?$A$i(B . ?\x3089) ;; HIRAGANA LETTER RA
     (?$A$j(B . ?\x308A) ;; HIRAGANA LETTER RI
     (?$A$k(B . ?\x308B) ;; HIRAGANA LETTER RU
     (?$A$l(B . ?\x308C) ;; HIRAGANA LETTER RE
     (?$A$m(B . ?\x308D) ;; HIRAGANA LETTER RO
     (?$A$n(B . ?\x308E) ;; HIRAGANA LETTER SMALL WA
     (?$A$o(B . ?\x308F) ;; HIRAGANA LETTER WA
     (?$A$p(B . ?\x3090) ;; HIRAGANA LETTER WI
     (?$A$q(B . ?\x3091) ;; HIRAGANA LETTER WE
     (?$A$r(B . ?\x3092) ;; HIRAGANA LETTER WO
     (?$A$s(B . ?\x3093) ;; HIRAGANA LETTER N
     (?$A%!(B . ?\x30A1) ;; KATAKANA LETTER SMALL A
     (?$A%"(B . ?\x30A2) ;; KATAKANA LETTER A
     (?$A%#(B . ?\x30A3) ;; KATAKANA LETTER SMALL I
     (?$A%$(B . ?\x30A4) ;; KATAKANA LETTER I
     (?$A%%(B . ?\x30A5) ;; KATAKANA LETTER SMALL U
     (?$A%&(B . ?\x30A6) ;; KATAKANA LETTER U
     (?$A%'(B . ?\x30A7) ;; KATAKANA LETTER SMALL E
     (?$A%((B . ?\x30A8) ;; KATAKANA LETTER E
     (?$A%)(B . ?\x30A9) ;; KATAKANA LETTER SMALL O
     (?$A%*(B . ?\x30AA) ;; KATAKANA LETTER O
     (?$A%+(B . ?\x30AB) ;; KATAKANA LETTER KA
     (?$A%,(B . ?\x30AC) ;; KATAKANA LETTER GA
     (?$A%-(B . ?\x30AD) ;; KATAKANA LETTER KI
     (?$A%.(B . ?\x30AE) ;; KATAKANA LETTER GI
     (?$A%/(B . ?\x30AF) ;; KATAKANA LETTER KU
     (?$A%0(B . ?\x30B0) ;; KATAKANA LETTER GU
     (?$A%1(B . ?\x30B1) ;; KATAKANA LETTER KE
     (?$A%2(B . ?\x30B2) ;; KATAKANA LETTER GE
     (?$A%3(B . ?\x30B3) ;; KATAKANA LETTER KO
     (?$A%4(B . ?\x30B4) ;; KATAKANA LETTER GO
     (?$A%5(B . ?\x30B5) ;; KATAKANA LETTER SA
     (?$A%6(B . ?\x30B6) ;; KATAKANA LETTER ZA
     (?$A%7(B . ?\x30B7) ;; KATAKANA LETTER SI
     (?$A%8(B . ?\x30B8) ;; KATAKANA LETTER ZI
     (?$A%9(B . ?\x30B9) ;; KATAKANA LETTER SU
     (?$A%:(B . ?\x30BA) ;; KATAKANA LETTER ZU
     (?$A%;(B . ?\x30BB) ;; KATAKANA LETTER SE
     (?$A%<(B . ?\x30BC) ;; KATAKANA LETTER ZE
     (?$A%=(B . ?\x30BD) ;; KATAKANA LETTER SO
     (?$A%>(B . ?\x30BE) ;; KATAKANA LETTER ZO
     (?$A%?(B . ?\x30BF) ;; KATAKANA LETTER TA
     (?$A%@(B . ?\x30C0) ;; KATAKANA LETTER DA
     (?$A%A(B . ?\x30C1) ;; KATAKANA LETTER TI
     (?$A%B(B . ?\x30C2) ;; KATAKANA LETTER DI
     (?$A%C(B . ?\x30C3) ;; KATAKANA LETTER SMALL TU
     (?$A%D(B . ?\x30C4) ;; KATAKANA LETTER TU
     (?$A%E(B . ?\x30C5) ;; KATAKANA LETTER DU
     (?$A%F(B . ?\x30C6) ;; KATAKANA LETTER TE
     (?$A%G(B . ?\x30C7) ;; KATAKANA LETTER DE
     (?$A%H(B . ?\x30C8) ;; KATAKANA LETTER TO
     (?$A%I(B . ?\x30C9) ;; KATAKANA LETTER DO
     (?$A%J(B . ?\x30CA) ;; KATAKANA LETTER NA
     (?$A%K(B . ?\x30CB) ;; KATAKANA LETTER NI
     (?$A%L(B . ?\x30CC) ;; KATAKANA LETTER NU
     (?$A%M(B . ?\x30CD) ;; KATAKANA LETTER NE
     (?$A%N(B . ?\x30CE) ;; KATAKANA LETTER NO
     (?$A%O(B . ?\x30CF) ;; KATAKANA LETTER HA
     (?$A%P(B . ?\x30D0) ;; KATAKANA LETTER BA
     (?$A%Q(B . ?\x30D1) ;; KATAKANA LETTER PA
     (?$A%R(B . ?\x30D2) ;; KATAKANA LETTER HI
     (?$A%S(B . ?\x30D3) ;; KATAKANA LETTER BI
     (?$A%T(B . ?\x30D4) ;; KATAKANA LETTER PI
     (?$A%U(B . ?\x30D5) ;; KATAKANA LETTER HU
     (?$A%V(B . ?\x30D6) ;; KATAKANA LETTER BU
     (?$A%W(B . ?\x30D7) ;; KATAKANA LETTER PU
     (?$A%X(B . ?\x30D8) ;; KATAKANA LETTER HE
     (?$A%Y(B . ?\x30D9) ;; KATAKANA LETTER BE
     (?$A%Z(B . ?\x30DA) ;; KATAKANA LETTER PE
     (?$A%[(B . ?\x30DB) ;; KATAKANA LETTER HO
     (?$A%\(B . ?\x30DC) ;; KATAKANA LETTER BO
     (?$A%](B . ?\x30DD) ;; KATAKANA LETTER PO
     (?$A%^(B . ?\x30DE) ;; KATAKANA LETTER MA
     (?$A%_(B . ?\x30DF) ;; KATAKANA LETTER MI
     (?$A%`(B . ?\x30E0) ;; KATAKANA LETTER MU
     (?$A%a(B . ?\x30E1) ;; KATAKANA LETTER ME
     (?$A%b(B . ?\x30E2) ;; KATAKANA LETTER MO
     (?$A%c(B . ?\x30E3) ;; KATAKANA LETTER SMALL YA
     (?$A%d(B . ?\x30E4) ;; KATAKANA LETTER YA
     (?$A%e(B . ?\x30E5) ;; KATAKANA LETTER SMALL YU
     (?$A%f(B . ?\x30E6) ;; KATAKANA LETTER YU
     (?$A%g(B . ?\x30E7) ;; KATAKANA LETTER SMALL YO
     (?$A%h(B . ?\x30E8) ;; KATAKANA LETTER YO
     (?$A%i(B . ?\x30E9) ;; KATAKANA LETTER RA
     (?$A%j(B . ?\x30EA) ;; KATAKANA LETTER RI
     (?$A%k(B . ?\x30EB) ;; KATAKANA LETTER RU
     (?$A%l(B . ?\x30EC) ;; KATAKANA LETTER RE
     (?$A%m(B . ?\x30ED) ;; KATAKANA LETTER RO
     (?$A%n(B . ?\x30EE) ;; KATAKANA LETTER SMALL WA
     (?$A%o(B . ?\x30EF) ;; KATAKANA LETTER WA
     (?$A%p(B . ?\x30F0) ;; KATAKANA LETTER WI
     (?$A%q(B . ?\x30F1) ;; KATAKANA LETTER WE
     (?$A%r(B . ?\x30F2) ;; KATAKANA LETTER WO
     (?$A%s(B . ?\x30F3) ;; KATAKANA LETTER N
     (?$A%t(B . ?\x30F4) ;; KATAKANA LETTER VU
     (?$A%u(B . ?\x30F5) ;; KATAKANA LETTER SMALL KA
     (?$A%v(B . ?\x30F6) ;; KATAKANA LETTER SMALL KE
     (?$A&!(B . ?\x0391) ;; GREEK CAPITAL LETTER ALPHA
     (?$A&"(B . ?\x0392) ;; GREEK CAPITAL LETTER BETA
     (?$A&#(B . ?\x0393) ;; GREEK CAPITAL LETTER GAMMA
     (?$A&$(B . ?\x0394) ;; GREEK CAPITAL LETTER DELTA
     (?$A&%(B . ?\x0395) ;; GREEK CAPITAL LETTER EPSILON
     (?$A&&(B . ?\x0396) ;; GREEK CAPITAL LETTER ZETA
     (?$A&'(B . ?\x0397) ;; GREEK CAPITAL LETTER ETA
     (?$A&((B . ?\x0398) ;; GREEK CAPITAL LETTER THETA
     (?$A&)(B . ?\x0399) ;; GREEK CAPITAL LETTER IOTA
     (?$A&*(B . ?\x039A) ;; GREEK CAPITAL LETTER KAPPA
     (?$A&+(B . ?\x039B) ;; GREEK CAPITAL LETTER LAMDA
     (?$A&,(B . ?\x039C) ;; GREEK CAPITAL LETTER MU
     (?$A&-(B . ?\x039D) ;; GREEK CAPITAL LETTER NU
     (?$A&.(B . ?\x039E) ;; GREEK CAPITAL LETTER XI
     (?$A&/(B . ?\x039F) ;; GREEK CAPITAL LETTER OMICRON
     (?$A&0(B . ?\x03A0) ;; GREEK CAPITAL LETTER PI
     (?$A&1(B . ?\x03A1) ;; GREEK CAPITAL LETTER RHO
     (?$A&2(B . ?\x03A3) ;; GREEK CAPITAL LETTER SIGMA
     (?$A&3(B . ?\x03A4) ;; GREEK CAPITAL LETTER TAU
     (?$A&4(B . ?\x03A5) ;; GREEK CAPITAL LETTER UPSILON
     (?$A&5(B . ?\x03A6) ;; GREEK CAPITAL LETTER PHI
     (?$A&6(B . ?\x03A7) ;; GREEK CAPITAL LETTER CHI
     (?$A&7(B . ?\x03A8) ;; GREEK CAPITAL LETTER PSI
     (?$A&8(B . ?\x03A9) ;; GREEK CAPITAL LETTER OMEGA
     (?$A&A(B . ?\x03B1) ;; GREEK SMALL LETTER ALPHA
     (?$A&B(B . ?\x03B2) ;; GREEK SMALL LETTER BETA
     (?$A&C(B . ?\x03B3) ;; GREEK SMALL LETTER GAMMA
     (?$A&D(B . ?\x03B4) ;; GREEK SMALL LETTER DELTA
     (?$A&E(B . ?\x03B5) ;; GREEK SMALL LETTER EPSILON
     (?$A&F(B . ?\x03B6) ;; GREEK SMALL LETTER ZETA
     (?$A&G(B . ?\x03B7) ;; GREEK SMALL LETTER ETA
     (?$A&H(B . ?\x03B8) ;; GREEK SMALL LETTER THETA
     (?$A&I(B . ?\x03B9) ;; GREEK SMALL LETTER IOTA
     (?$A&J(B . ?\x03BA) ;; GREEK SMALL LETTER KAPPA
     (?$A&K(B . ?\x03BB) ;; GREEK SMALL LETTER LAMDA
     (?$A&L(B . ?\x03BC) ;; GREEK SMALL LETTER MU
     (?$A&M(B . ?\x03BD) ;; GREEK SMALL LETTER NU
     (?$A&N(B . ?\x03BE) ;; GREEK SMALL LETTER XI
     (?$A&O(B . ?\x03BF) ;; GREEK SMALL LETTER OMICRON
     (?$A&P(B . ?\x03C0) ;; GREEK SMALL LETTER PI
     (?$A&Q(B . ?\x03C1) ;; GREEK SMALL LETTER RHO
     (?$A&R(B . ?\x03C3) ;; GREEK SMALL LETTER SIGMA
     (?$A&S(B . ?\x03C4) ;; GREEK SMALL LETTER TAU
     (?$A&T(B . ?\x03C5) ;; GREEK SMALL LETTER UPSILON
     (?$A&U(B . ?\x03C6) ;; GREEK SMALL LETTER PHI
     (?$A&V(B . ?\x03C7) ;; GREEK SMALL LETTER CHI
     (?$A&W(B . ?\x03C8) ;; GREEK SMALL LETTER PSI
     (?$A&X(B . ?\x03C9) ;; GREEK SMALL LETTER OMEGA
     (?$A'!(B . ?\x0410) ;; CYRILLIC CAPITAL LETTER A
     (?$A'"(B . ?\x0411) ;; CYRILLIC CAPITAL LETTER BE
     (?$A'#(B . ?\x0412) ;; CYRILLIC CAPITAL LETTER VE
     (?$A'$(B . ?\x0413) ;; CYRILLIC CAPITAL LETTER GHE
     (?$A'%(B . ?\x0414) ;; CYRILLIC CAPITAL LETTER DE
     (?$A'&(B . ?\x0415) ;; CYRILLIC CAPITAL LETTER IE
     (?$A''(B . ?\x0401) ;; CYRILLIC CAPITAL LETTER IO
     (?$A'((B . ?\x0416) ;; CYRILLIC CAPITAL LETTER ZHE
     (?$A')(B . ?\x0417) ;; CYRILLIC CAPITAL LETTER ZE
     (?$A'*(B . ?\x0418) ;; CYRILLIC CAPITAL LETTER I
     (?$A'+(B . ?\x0419) ;; CYRILLIC CAPITAL LETTER SHORT I
     (?$A',(B . ?\x041A) ;; CYRILLIC CAPITAL LETTER KA
     (?$A'-(B . ?\x041B) ;; CYRILLIC CAPITAL LETTER EL
     (?$A'.(B . ?\x041C) ;; CYRILLIC CAPITAL LETTER EM
     (?$A'/(B . ?\x041D) ;; CYRILLIC CAPITAL LETTER EN
     (?$A'0(B . ?\x041E) ;; CYRILLIC CAPITAL LETTER O
     (?$A'1(B . ?\x041F) ;; CYRILLIC CAPITAL LETTER PE
     (?$A'2(B . ?\x0420) ;; CYRILLIC CAPITAL LETTER ER
     (?$A'3(B . ?\x0421) ;; CYRILLIC CAPITAL LETTER ES
     (?$A'4(B . ?\x0422) ;; CYRILLIC CAPITAL LETTER TE
     (?$A'5(B . ?\x0423) ;; CYRILLIC CAPITAL LETTER U
     (?$A'6(B . ?\x0424) ;; CYRILLIC CAPITAL LETTER EF
     (?$A'7(B . ?\x0425) ;; CYRILLIC CAPITAL LETTER HA
     (?$A'8(B . ?\x0426) ;; CYRILLIC CAPITAL LETTER TSE
     (?$A'9(B . ?\x0427) ;; CYRILLIC CAPITAL LETTER CHE
     (?$A':(B . ?\x0428) ;; CYRILLIC CAPITAL LETTER SHA
     (?$A';(B . ?\x0429) ;; CYRILLIC CAPITAL LETTER SHCHA
     (?$A'<(B . ?\x042A) ;; CYRILLIC CAPITAL LETTER HARD SIGN
     (?$A'=(B . ?\x042B) ;; CYRILLIC CAPITAL LETTER YERU
     (?$A'>(B . ?\x042C) ;; CYRILLIC CAPITAL LETTER SOFT SIGN
     (?$A'?(B . ?\x042D) ;; CYRILLIC CAPITAL LETTER E
     (?$A'@(B . ?\x042E) ;; CYRILLIC CAPITAL LETTER YU
     (?$A'A(B . ?\x042F) ;; CYRILLIC CAPITAL LETTER YA
     (?$A'Q(B . ?\x0430) ;; CYRILLIC SMALL LETTER A
     (?$A'R(B . ?\x0431) ;; CYRILLIC SMALL LETTER BE
     (?$A'S(B . ?\x0432) ;; CYRILLIC SMALL LETTER VE
     (?$A'T(B . ?\x0433) ;; CYRILLIC SMALL LETTER GHE
     (?$A'U(B . ?\x0434) ;; CYRILLIC SMALL LETTER DE
     (?$A'V(B . ?\x0435) ;; CYRILLIC SMALL LETTER IE
     (?$A'W(B . ?\x0451) ;; CYRILLIC SMALL LETTER IO
     (?$A'X(B . ?\x0436) ;; CYRILLIC SMALL LETTER ZHE
     (?$A'Y(B . ?\x0437) ;; CYRILLIC SMALL LETTER ZE
     (?$A'Z(B . ?\x0438) ;; CYRILLIC SMALL LETTER I
     (?$A'[(B . ?\x0439) ;; CYRILLIC SMALL LETTER SHORT I
     (?$A'\(B . ?\x043A) ;; CYRILLIC SMALL LETTER KA
     (?$A'](B . ?\x043B) ;; CYRILLIC SMALL LETTER EL
     (?$A'^(B . ?\x043C) ;; CYRILLIC SMALL LETTER EM
     (?$A'_(B . ?\x043D) ;; CYRILLIC SMALL LETTER EN
     (?$A'`(B . ?\x043E) ;; CYRILLIC SMALL LETTER O
     (?$A'a(B . ?\x043F) ;; CYRILLIC SMALL LETTER PE
     (?$A'b(B . ?\x0440) ;; CYRILLIC SMALL LETTER ER
     (?$A'c(B . ?\x0441) ;; CYRILLIC SMALL LETTER ES
     (?$A'd(B . ?\x0442) ;; CYRILLIC SMALL LETTER TE
     (?$A'e(B . ?\x0443) ;; CYRILLIC SMALL LETTER U
     (?$A'f(B . ?\x0444) ;; CYRILLIC SMALL LETTER EF
     (?$A'g(B . ?\x0445) ;; CYRILLIC SMALL LETTER HA
     (?$A'h(B . ?\x0446) ;; CYRILLIC SMALL LETTER TSE
     (?$A'i(B . ?\x0447) ;; CYRILLIC SMALL LETTER CHE
     (?$A'j(B . ?\x0448) ;; CYRILLIC SMALL LETTER SHA
     (?$A'k(B . ?\x0449) ;; CYRILLIC SMALL LETTER SHCHA
     (?$A'l(B . ?\x044A) ;; CYRILLIC SMALL LETTER HARD SIGN
     (?$A'm(B . ?\x044B) ;; CYRILLIC SMALL LETTER YERU
     (?$A'n(B . ?\x044C) ;; CYRILLIC SMALL LETTER SOFT SIGN
     (?$A'o(B . ?\x044D) ;; CYRILLIC SMALL LETTER E
     (?$A'p(B . ?\x044E) ;; CYRILLIC SMALL LETTER YU
     (?$A'q(B . ?\x044F) ;; CYRILLIC SMALL LETTER YA
     (?$A(!(B . ?\x0101) ;; LATIN SMALL LETTER A WITH MACRON
     (?$A("(B . ?\x00E1) ;; LATIN SMALL LETTER A WITH ACUTE
     (?$A(#(B . ?\x01CE) ;; LATIN SMALL LETTER A WITH CARON
     (?$A($(B . ?\x00E0) ;; LATIN SMALL LETTER A WITH GRAVE
     (?$A(%(B . ?\x0113) ;; LATIN SMALL LETTER E WITH MACRON
     (?$A(&(B . ?\x00E9) ;; LATIN SMALL LETTER E WITH ACUTE
     (?$A('(B . ?\x011B) ;; LATIN SMALL LETTER E WITH CARON
     (?$A(((B . ?\x00E8) ;; LATIN SMALL LETTER E WITH GRAVE
     (?$A()(B . ?\x012B) ;; LATIN SMALL LETTER I WITH MACRON
     (?$A(*(B . ?\x00ED) ;; LATIN SMALL LETTER I WITH ACUTE
     (?$A(+(B . ?\x01D0) ;; LATIN SMALL LETTER I WITH CARON
     (?$A(,(B . ?\x00EC) ;; LATIN SMALL LETTER I WITH GRAVE
     (?$A(-(B . ?\x014D) ;; LATIN SMALL LETTER O WITH MACRON
     (?$A(.(B . ?\x00F3) ;; LATIN SMALL LETTER O WITH ACUTE
     (?$A(/(B . ?\x01D2) ;; LATIN SMALL LETTER O WITH CARON
     (?$A(0(B . ?\x00F2) ;; LATIN SMALL LETTER O WITH GRAVE
     (?$A(1(B . ?\x016B) ;; LATIN SMALL LETTER U WITH MACRON
     (?$A(2(B . ?\x00FA) ;; LATIN SMALL LETTER U WITH ACUTE
     (?$A(3(B . ?\x01D4) ;; LATIN SMALL LETTER U WITH CARON
     (?$A(4(B . ?\x00F9) ;; LATIN SMALL LETTER U WITH GRAVE
     (?$A(5(B . ?\x01D6) ;; LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
     (?$A(6(B . ?\x01D8) ;; LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
     (?$A(7(B . ?\x01DA) ;; LATIN SMALL LETTER U WITH DIAERESIS AND CARON
     (?$A(8(B . ?\x01DC) ;; LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
     (?$A(9(B . ?\x00FC) ;; LATIN SMALL LETTER U WITH DIAERESIS
     (?$A(:(B . ?\x00EA) ;; LATIN SMALL LETTER E WITH CIRCUMFLEX
     (?$A(E(B . ?\x3105) ;; BOPOMOFO LETTER B
     (?$A(F(B . ?\x3106) ;; BOPOMOFO LETTER P
     (?$A(G(B . ?\x3107) ;; BOPOMOFO LETTER M
     (?$A(H(B . ?\x3108) ;; BOPOMOFO LETTER F
     (?$A(I(B . ?\x3109) ;; BOPOMOFO LETTER D
     (?$A(J(B . ?\x310A) ;; BOPOMOFO LETTER T
     (?$A(K(B . ?\x310B) ;; BOPOMOFO LETTER N
     (?$A(L(B . ?\x310C) ;; BOPOMOFO LETTER L
     (?$A(M(B . ?\x310D) ;; BOPOMOFO LETTER G
     (?$A(N(B . ?\x310E) ;; BOPOMOFO LETTER K
     (?$A(O(B . ?\x310F) ;; BOPOMOFO LETTER H
     (?$A(P(B . ?\x3110) ;; BOPOMOFO LETTER J
     (?$A(Q(B . ?\x3111) ;; BOPOMOFO LETTER Q
     (?$A(R(B . ?\x3112) ;; BOPOMOFO LETTER X
     (?$A(S(B . ?\x3113) ;; BOPOMOFO LETTER ZH
     (?$A(T(B . ?\x3114) ;; BOPOMOFO LETTER CH
     (?$A(U(B . ?\x3115) ;; BOPOMOFO LETTER SH
     (?$A(V(B . ?\x3116) ;; BOPOMOFO LETTER R
     (?$A(W(B . ?\x3117) ;; BOPOMOFO LETTER Z
     (?$A(X(B . ?\x3118) ;; BOPOMOFO LETTER C
     (?$A(Y(B . ?\x3119) ;; BOPOMOFO LETTER S
     (?$A(Z(B . ?\x311A) ;; BOPOMOFO LETTER A
     (?$A([(B . ?\x311B) ;; BOPOMOFO LETTER O
     (?$A(\(B . ?\x311C) ;; BOPOMOFO LETTER E
     (?$A(](B . ?\x311D) ;; BOPOMOFO LETTER EH
     (?$A(^(B . ?\x311E) ;; BOPOMOFO LETTER AI
     (?$A(_(B . ?\x311F) ;; BOPOMOFO LETTER EI
     (?$A(`(B . ?\x3120) ;; BOPOMOFO LETTER AU
     (?$A(a(B . ?\x3121) ;; BOPOMOFO LETTER OU
     (?$A(b(B . ?\x3122) ;; BOPOMOFO LETTER AN
     (?$A(c(B . ?\x3123) ;; BOPOMOFO LETTER EN
     (?$A(d(B . ?\x3124) ;; BOPOMOFO LETTER ANG
     (?$A(e(B . ?\x3125) ;; BOPOMOFO LETTER ENG
     (?$A(f(B . ?\x3126) ;; BOPOMOFO LETTER ER
     (?$A(g(B . ?\x3127) ;; BOPOMOFO LETTER I
     (?$A(h(B . ?\x3128) ;; BOPOMOFO LETTER U
     (?$A(i(B . ?\x3129) ;; BOPOMOFO LETTER IU
     (?$A)$(B . ?\x2500) ;; BOX DRAWINGS LIGHT HORIZONTAL
     (?$A)%(B . ?\x2501) ;; BOX DRAWINGS HEAVY HORIZONTAL
     (?$A)&(B . ?\x2502) ;; BOX DRAWINGS LIGHT VERTICAL
     (?$A)'(B . ?\x2503) ;; BOX DRAWINGS HEAVY VERTICAL
     (?$A)((B . ?\x2504) ;; BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL
     (?$A))(B . ?\x2505) ;; BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL
     (?$A)*(B . ?\x2506) ;; BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL
     (?$A)+(B . ?\x2507) ;; BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL
     (?$A),(B . ?\x2508) ;; BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL
     (?$A)-(B . ?\x2509) ;; BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL
     (?$A).(B . ?\x250A) ;; BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL
     (?$A)/(B . ?\x250B) ;; BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL
     (?$A)0(B . ?\x250C) ;; BOX DRAWINGS LIGHT DOWN AND RIGHT
     (?$A)1(B . ?\x250D) ;; BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY
     (?$A)2(B . ?\x250E) ;; BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT
     (?$A)3(B . ?\x250F) ;; BOX DRAWINGS HEAVY DOWN AND RIGHT
     (?$A)4(B . ?\x2510) ;; BOX DRAWINGS LIGHT DOWN AND LEFT
     (?$A)5(B . ?\x2511) ;; BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY
     (?$A)6(B . ?\x2512) ;; BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT
     (?$A)7(B . ?\x2513) ;; BOX DRAWINGS HEAVY DOWN AND LEFT
     (?$A)8(B . ?\x2514) ;; BOX DRAWINGS LIGHT UP AND RIGHT
     (?$A)9(B . ?\x2515) ;; BOX DRAWINGS UP LIGHT AND RIGHT HEAVY
     (?$A):(B . ?\x2516) ;; BOX DRAWINGS UP HEAVY AND RIGHT LIGHT
     (?$A);(B . ?\x2517) ;; BOX DRAWINGS HEAVY UP AND RIGHT
     (?$A)<(B . ?\x2518) ;; BOX DRAWINGS LIGHT UP AND LEFT
     (?$A)=(B . ?\x2519) ;; BOX DRAWINGS UP LIGHT AND LEFT HEAVY
     (?$A)>(B . ?\x251A) ;; BOX DRAWINGS UP HEAVY AND LEFT LIGHT
     (?$A)?(B . ?\x251B) ;; BOX DRAWINGS HEAVY UP AND LEFT
     (?$A)@(B . ?\x251C) ;; BOX DRAWINGS LIGHT VERTICAL AND RIGHT
     (?$A)A(B . ?\x251D) ;; BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
     (?$A)B(B . ?\x251E) ;; BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT
     (?$A)C(B . ?\x251F) ;; BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT
     (?$A)D(B . ?\x2520) ;; BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
     (?$A)E(B . ?\x2521) ;; BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY
     (?$A)F(B . ?\x2522) ;; BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY
     (?$A)G(B . ?\x2523) ;; BOX DRAWINGS HEAVY VERTICAL AND RIGHT
     (?$A)H(B . ?\x2524) ;; BOX DRAWINGS LIGHT VERTICAL AND LEFT
     (?$A)I(B . ?\x2525) ;; BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
     (?$A)J(B . ?\x2526) ;; BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT
     (?$A)K(B . ?\x2527) ;; BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT
     (?$A)L(B . ?\x2528) ;; BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
     (?$A)M(B . ?\x2529) ;; BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY
     (?$A)N(B . ?\x252A) ;; BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY
     (?$A)O(B . ?\x252B) ;; BOX DRAWINGS HEAVY VERTICAL AND LEFT
     (?$A)P(B . ?\x252C) ;; BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
     (?$A)Q(B . ?\x252D) ;; BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT
     (?$A)R(B . ?\x252E) ;; BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT
     (?$A)S(B . ?\x252F) ;; BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
     (?$A)T(B . ?\x2530) ;; BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
     (?$A)U(B . ?\x2531) ;; BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY
     (?$A)V(B . ?\x2532) ;; BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY
     (?$A)W(B . ?\x2533) ;; BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
     (?$A)X(B . ?\x2534) ;; BOX DRAWINGS LIGHT UP AND HORIZONTAL
     (?$A)Y(B . ?\x2535) ;; BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT
     (?$A)Z(B . ?\x2536) ;; BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT
     (?$A)[(B . ?\x2537) ;; BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
     (?$A)\(B . ?\x2538) ;; BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
     (?$A)](B . ?\x2539) ;; BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY
     (?$A)^(B . ?\x253A) ;; BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY
     (?$A)_(B . ?\x253B) ;; BOX DRAWINGS HEAVY UP AND HORIZONTAL
     (?$A)`(B . ?\x253C) ;; BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
     (?$A)a(B . ?\x253D) ;; BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT
     (?$A)b(B . ?\x253E) ;; BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT
     (?$A)c(B . ?\x253F) ;; BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
     (?$A)d(B . ?\x2540) ;; BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT
     (?$A)e(B . ?\x2541) ;; BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT
     (?$A)f(B . ?\x2542) ;; BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
     (?$A)g(B . ?\x2543) ;; BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT
     (?$A)h(B . ?\x2544) ;; BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT
     (?$A)i(B . ?\x2545) ;; BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT
     (?$A)j(B . ?\x2546) ;; BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT
     (?$A)k(B . ?\x2547) ;; BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY
     (?$A)l(B . ?\x2548) ;; BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY
     (?$A)m(B . ?\x2549) ;; BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY
     (?$A)n(B . ?\x254A) ;; BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY
     (?$A)o(B . ?\x254B) ;; BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
     (?$A0!(B . ?\x554A) ;; <CJK>
     (?$A0"(B . ?\x963F) ;; <CJK>
     (?$A0#(B . ?\x57C3) ;; <CJK>
     (?$A0$(B . ?\x6328) ;; <CJK>
     (?$A0%(B . ?\x54CE) ;; <CJK>
     (?$A0&(B . ?\x5509) ;; <CJK>
     (?$A0'(B . ?\x54C0) ;; <CJK>
     (?$A0((B . ?\x7691) ;; <CJK>
     (?$A0)(B . ?\x764C) ;; <CJK>
     (?$A0*(B . ?\x853C) ;; <CJK>
     (?$A0+(B . ?\x77EE) ;; <CJK>
     (?$A0,(B . ?\x827E) ;; <CJK>
     (?$A0-(B . ?\x788D) ;; <CJK>
     (?$A0.(B . ?\x7231) ;; <CJK>
     (?$A0/(B . ?\x9698) ;; <CJK>
     (?$A00(B . ?\x978D) ;; <CJK>
     (?$A01(B . ?\x6C28) ;; <CJK>
     (?$A02(B . ?\x5B89) ;; <CJK>
     (?$A03(B . ?\x4FFA) ;; <CJK>
     (?$A04(B . ?\x6309) ;; <CJK>
     (?$A05(B . ?\x6697) ;; <CJK>
     (?$A06(B . ?\x5CB8) ;; <CJK>
     (?$A07(B . ?\x80FA) ;; <CJK>
     (?$A08(B . ?\x6848) ;; <CJK>
     (?$A09(B . ?\x80AE) ;; <CJK>
     (?$A0:(B . ?\x6602) ;; <CJK>
     (?$A0;(B . ?\x76CE) ;; <CJK>
     (?$A0<(B . ?\x51F9) ;; <CJK>
     (?$A0=(B . ?\x6556) ;; <CJK>
     (?$A0>(B . ?\x71AC) ;; <CJK>
     (?$A0?(B . ?\x7FF1) ;; <CJK>
     (?$A0@(B . ?\x8884) ;; <CJK>
     (?$A0A(B . ?\x50B2) ;; <CJK>
     (?$A0B(B . ?\x5965) ;; <CJK>
     (?$A0C(B . ?\x61CA) ;; <CJK>
     (?$A0D(B . ?\x6FB3) ;; <CJK>
     (?$A0E(B . ?\x82AD) ;; <CJK>
     (?$A0F(B . ?\x634C) ;; <CJK>
     (?$A0G(B . ?\x6252) ;; <CJK>
     (?$A0H(B . ?\x53ED) ;; <CJK>
     (?$A0I(B . ?\x5427) ;; <CJK>
     (?$A0J(B . ?\x7B06) ;; <CJK>
     (?$A0K(B . ?\x516B) ;; <CJK>
     (?$A0L(B . ?\x75A4) ;; <CJK>
     (?$A0M(B . ?\x5DF4) ;; <CJK>
     (?$A0N(B . ?\x62D4) ;; <CJK>
     (?$A0O(B . ?\x8DCB) ;; <CJK>
     (?$A0P(B . ?\x9776) ;; <CJK>
     (?$A0Q(B . ?\x628A) ;; <CJK>
     (?$A0R(B . ?\x8019) ;; <CJK>
     (?$A0S(B . ?\x575D) ;; <CJK>
     (?$A0T(B . ?\x9738) ;; <CJK>
     (?$A0U(B . ?\x7F62) ;; <CJK>
     (?$A0V(B . ?\x7238) ;; <CJK>
     (?$A0W(B . ?\x767D) ;; <CJK>
     (?$A0X(B . ?\x67CF) ;; <CJK>
     (?$A0Y(B . ?\x767E) ;; <CJK>
     (?$A0Z(B . ?\x6446) ;; <CJK>
     (?$A0[(B . ?\x4F70) ;; <CJK>
     (?$A0\(B . ?\x8D25) ;; <CJK>
     (?$A0](B . ?\x62DC) ;; <CJK>
     (?$A0^(B . ?\x7A17) ;; <CJK>
     (?$A0_(B . ?\x6591) ;; <CJK>
     (?$A0`(B . ?\x73ED) ;; <CJK>
     (?$A0a(B . ?\x642C) ;; <CJK>
     (?$A0b(B . ?\x6273) ;; <CJK>
     (?$A0c(B . ?\x822C) ;; <CJK>
     (?$A0d(B . ?\x9881) ;; <CJK>
     (?$A0e(B . ?\x677F) ;; <CJK>
     (?$A0f(B . ?\x7248) ;; <CJK>
     (?$A0g(B . ?\x626E) ;; <CJK>
     (?$A0h(B . ?\x62CC) ;; <CJK>
     (?$A0i(B . ?\x4F34) ;; <CJK>
     (?$A0j(B . ?\x74E3) ;; <CJK>
     (?$A0k(B . ?\x534A) ;; <CJK>
     (?$A0l(B . ?\x529E) ;; <CJK>
     (?$A0m(B . ?\x7ECA) ;; <CJK>
     (?$A0n(B . ?\x90A6) ;; <CJK>
     (?$A0o(B . ?\x5E2E) ;; <CJK>
     (?$A0p(B . ?\x6886) ;; <CJK>
     (?$A0q(B . ?\x699C) ;; <CJK>
     (?$A0r(B . ?\x8180) ;; <CJK>
     (?$A0s(B . ?\x7ED1) ;; <CJK>
     (?$A0t(B . ?\x68D2) ;; <CJK>
     (?$A0u(B . ?\x78C5) ;; <CJK>
     (?$A0v(B . ?\x868C) ;; <CJK>
     (?$A0w(B . ?\x9551) ;; <CJK>
     (?$A0x(B . ?\x508D) ;; <CJK>
     (?$A0y(B . ?\x8C24) ;; <CJK>
     (?$A0z(B . ?\x82DE) ;; <CJK>
     (?$A0{(B . ?\x80DE) ;; <CJK>
     (?$A0|(B . ?\x5305) ;; <CJK>
     (?$A0}(B . ?\x8912) ;; <CJK>
     (?$A0~(B . ?\x5265) ;; <CJK>
     (?$A1!(B . ?\x8584) ;; <CJK>
     (?$A1"(B . ?\x96F9) ;; <CJK>
     (?$A1#(B . ?\x4FDD) ;; <CJK>
     (?$A1$(B . ?\x5821) ;; <CJK>
     (?$A1%(B . ?\x9971) ;; <CJK>
     (?$A1&(B . ?\x5B9D) ;; <CJK>
     (?$A1'(B . ?\x62B1) ;; <CJK>
     (?$A1((B . ?\x62A5) ;; <CJK>
     (?$A1)(B . ?\x66B4) ;; <CJK>
     (?$A1*(B . ?\x8C79) ;; <CJK>
     (?$A1+(B . ?\x9C8D) ;; <CJK>
     (?$A1,(B . ?\x7206) ;; <CJK>
     (?$A1-(B . ?\x676F) ;; <CJK>
     (?$A1.(B . ?\x7891) ;; <CJK>
     (?$A1/(B . ?\x60B2) ;; <CJK>
     (?$A10(B . ?\x5351) ;; <CJK>
     (?$A11(B . ?\x5317) ;; <CJK>
     (?$A12(B . ?\x8F88) ;; <CJK>
     (?$A13(B . ?\x80CC) ;; <CJK>
     (?$A14(B . ?\x8D1D) ;; <CJK>
     (?$A15(B . ?\x94A1) ;; <CJK>
     (?$A16(B . ?\x500D) ;; <CJK>
     (?$A17(B . ?\x72C8) ;; <CJK>
     (?$A18(B . ?\x5907) ;; <CJK>
     (?$A19(B . ?\x60EB) ;; <CJK>
     (?$A1:(B . ?\x7119) ;; <CJK>
     (?$A1;(B . ?\x88AB) ;; <CJK>
     (?$A1<(B . ?\x5954) ;; <CJK>
     (?$A1=(B . ?\x82EF) ;; <CJK>
     (?$A1>(B . ?\x672C) ;; <CJK>
     (?$A1?(B . ?\x7B28) ;; <CJK>
     (?$A1@(B . ?\x5D29) ;; <CJK>
     (?$A1A(B . ?\x7EF7) ;; <CJK>
     (?$A1B(B . ?\x752D) ;; <CJK>
     (?$A1C(B . ?\x6CF5) ;; <CJK>
     (?$A1D(B . ?\x8E66) ;; <CJK>
     (?$A1E(B . ?\x8FF8) ;; <CJK>
     (?$A1F(B . ?\x903C) ;; <CJK>
     (?$A1G(B . ?\x9F3B) ;; <CJK>
     (?$A1H(B . ?\x6BD4) ;; <CJK>
     (?$A1I(B . ?\x9119) ;; <CJK>
     (?$A1J(B . ?\x7B14) ;; <CJK>
     (?$A1K(B . ?\x5F7C) ;; <CJK>
     (?$A1L(B . ?\x78A7) ;; <CJK>
     (?$A1M(B . ?\x84D6) ;; <CJK>
     (?$A1N(B . ?\x853D) ;; <CJK>
     (?$A1O(B . ?\x6BD5) ;; <CJK>
     (?$A1P(B . ?\x6BD9) ;; <CJK>
     (?$A1Q(B . ?\x6BD6) ;; <CJK>
     (?$A1R(B . ?\x5E01) ;; <CJK>
     (?$A1S(B . ?\x5E87) ;; <CJK>
     (?$A1T(B . ?\x75F9) ;; <CJK>
     (?$A1U(B . ?\x95ED) ;; <CJK>
     (?$A1V(B . ?\x655D) ;; <CJK>
     (?$A1W(B . ?\x5F0A) ;; <CJK>
     (?$A1X(B . ?\x5FC5) ;; <CJK>
     (?$A1Y(B . ?\x8F9F) ;; <CJK>
     (?$A1Z(B . ?\x58C1) ;; <CJK>
     (?$A1[(B . ?\x81C2) ;; <CJK>
     (?$A1\(B . ?\x907F) ;; <CJK>
     (?$A1](B . ?\x965B) ;; <CJK>
     (?$A1^(B . ?\x97AD) ;; <CJK>
     (?$A1_(B . ?\x8FB9) ;; <CJK>
     (?$A1`(B . ?\x7F16) ;; <CJK>
     (?$A1a(B . ?\x8D2C) ;; <CJK>
     (?$A1b(B . ?\x6241) ;; <CJK>
     (?$A1c(B . ?\x4FBF) ;; <CJK>
     (?$A1d(B . ?\x53D8) ;; <CJK>
     (?$A1e(B . ?\x535E) ;; <CJK>
     (?$A1f(B . ?\x8FA8) ;; <CJK>
     (?$A1g(B . ?\x8FA9) ;; <CJK>
     (?$A1h(B . ?\x8FAB) ;; <CJK>
     (?$A1i(B . ?\x904D) ;; <CJK>
     (?$A1j(B . ?\x6807) ;; <CJK>
     (?$A1k(B . ?\x5F6A) ;; <CJK>
     (?$A1l(B . ?\x8198) ;; <CJK>
     (?$A1m(B . ?\x8868) ;; <CJK>
     (?$A1n(B . ?\x9CD6) ;; <CJK>
     (?$A1o(B . ?\x618B) ;; <CJK>
     (?$A1p(B . ?\x522B) ;; <CJK>
     (?$A1q(B . ?\x762A) ;; <CJK>
     (?$A1r(B . ?\x5F6C) ;; <CJK>
     (?$A1s(B . ?\x658C) ;; <CJK>
     (?$A1t(B . ?\x6FD2) ;; <CJK>
     (?$A1u(B . ?\x6EE8) ;; <CJK>
     (?$A1v(B . ?\x5BBE) ;; <CJK>
     (?$A1w(B . ?\x6448) ;; <CJK>
     (?$A1x(B . ?\x5175) ;; <CJK>
     (?$A1y(B . ?\x51B0) ;; <CJK>
     (?$A1z(B . ?\x67C4) ;; <CJK>
     (?$A1{(B . ?\x4E19) ;; <CJK>
     (?$A1|(B . ?\x79C9) ;; <CJK>
     (?$A1}(B . ?\x997C) ;; <CJK>
     (?$A1~(B . ?\x70B3) ;; <CJK>
     (?$A2!(B . ?\x75C5) ;; <CJK>
     (?$A2"(B . ?\x5E76) ;; <CJK>
     (?$A2#(B . ?\x73BB) ;; <CJK>
     (?$A2$(B . ?\x83E0) ;; <CJK>
     (?$A2%(B . ?\x64AD) ;; <CJK>
     (?$A2&(B . ?\x62E8) ;; <CJK>
     (?$A2'(B . ?\x94B5) ;; <CJK>
     (?$A2((B . ?\x6CE2) ;; <CJK>
     (?$A2)(B . ?\x535A) ;; <CJK>
     (?$A2*(B . ?\x52C3) ;; <CJK>
     (?$A2+(B . ?\x640F) ;; <CJK>
     (?$A2,(B . ?\x94C2) ;; <CJK>
     (?$A2-(B . ?\x7B94) ;; <CJK>
     (?$A2.(B . ?\x4F2F) ;; <CJK>
     (?$A2/(B . ?\x5E1B) ;; <CJK>
     (?$A20(B . ?\x8236) ;; <CJK>
     (?$A21(B . ?\x8116) ;; <CJK>
     (?$A22(B . ?\x818A) ;; <CJK>
     (?$A23(B . ?\x6E24) ;; <CJK>
     (?$A24(B . ?\x6CCA) ;; <CJK>
     (?$A25(B . ?\x9A73) ;; <CJK>
     (?$A26(B . ?\x6355) ;; <CJK>
     (?$A27(B . ?\x535C) ;; <CJK>
     (?$A28(B . ?\x54FA) ;; <CJK>
     (?$A29(B . ?\x8865) ;; <CJK>
     (?$A2:(B . ?\x57E0) ;; <CJK>
     (?$A2;(B . ?\x4E0D) ;; <CJK>
     (?$A2<(B . ?\x5E03) ;; <CJK>
     (?$A2=(B . ?\x6B65) ;; <CJK>
     (?$A2>(B . ?\x7C3F) ;; <CJK>
     (?$A2?(B . ?\x90E8) ;; <CJK>
     (?$A2@(B . ?\x6016) ;; <CJK>
     (?$A2A(B . ?\x64E6) ;; <CJK>
     (?$A2B(B . ?\x731C) ;; <CJK>
     (?$A2C(B . ?\x88C1) ;; <CJK>
     (?$A2D(B . ?\x6750) ;; <CJK>
     (?$A2E(B . ?\x624D) ;; <CJK>
     (?$A2F(B . ?\x8D22) ;; <CJK>
     (?$A2G(B . ?\x776C) ;; <CJK>
     (?$A2H(B . ?\x8E29) ;; <CJK>
     (?$A2I(B . ?\x91C7) ;; <CJK>
     (?$A2J(B . ?\x5F69) ;; <CJK>
     (?$A2K(B . ?\x83DC) ;; <CJK>
     (?$A2L(B . ?\x8521) ;; <CJK>
     (?$A2M(B . ?\x9910) ;; <CJK>
     (?$A2N(B . ?\x53C2) ;; <CJK>
     (?$A2O(B . ?\x8695) ;; <CJK>
     (?$A2P(B . ?\x6B8B) ;; <CJK>
     (?$A2Q(B . ?\x60ED) ;; <CJK>
     (?$A2R(B . ?\x60E8) ;; <CJK>
     (?$A2S(B . ?\x707F) ;; <CJK>
     (?$A2T(B . ?\x82CD) ;; <CJK>
     (?$A2U(B . ?\x8231) ;; <CJK>
     (?$A2V(B . ?\x4ED3) ;; <CJK>
     (?$A2W(B . ?\x6CA7) ;; <CJK>
     (?$A2X(B . ?\x85CF) ;; <CJK>
     (?$A2Y(B . ?\x64CD) ;; <CJK>
     (?$A2Z(B . ?\x7CD9) ;; <CJK>
     (?$A2[(B . ?\x69FD) ;; <CJK>
     (?$A2\(B . ?\x66F9) ;; <CJK>
     (?$A2](B . ?\x8349) ;; <CJK>
     (?$A2^(B . ?\x5395) ;; <CJK>
     (?$A2_(B . ?\x7B56) ;; <CJK>
     (?$A2`(B . ?\x4FA7) ;; <CJK>
     (?$A2a(B . ?\x518C) ;; <CJK>
     (?$A2b(B . ?\x6D4B) ;; <CJK>
     (?$A2c(B . ?\x5C42) ;; <CJK>
     (?$A2d(B . ?\x8E6D) ;; <CJK>
     (?$A2e(B . ?\x63D2) ;; <CJK>
     (?$A2f(B . ?\x53C9) ;; <CJK>
     (?$A2g(B . ?\x832C) ;; <CJK>
     (?$A2h(B . ?\x8336) ;; <CJK>
     (?$A2i(B . ?\x67E5) ;; <CJK>
     (?$A2j(B . ?\x78B4) ;; <CJK>
     (?$A2k(B . ?\x643D) ;; <CJK>
     (?$A2l(B . ?\x5BDF) ;; <CJK>
     (?$A2m(B . ?\x5C94) ;; <CJK>
     (?$A2n(B . ?\x5DEE) ;; <CJK>
     (?$A2o(B . ?\x8BE7) ;; <CJK>
     (?$A2p(B . ?\x62C6) ;; <CJK>
     (?$A2q(B . ?\x67F4) ;; <CJK>
     (?$A2r(B . ?\x8C7A) ;; <CJK>
     (?$A2s(B . ?\x6400) ;; <CJK>
     (?$A2t(B . ?\x63BA) ;; <CJK>
     (?$A2u(B . ?\x8749) ;; <CJK>
     (?$A2v(B . ?\x998B) ;; <CJK>
     (?$A2w(B . ?\x8C17) ;; <CJK>
     (?$A2x(B . ?\x7F20) ;; <CJK>
     (?$A2y(B . ?\x94F2) ;; <CJK>
     (?$A2z(B . ?\x4EA7) ;; <CJK>
     (?$A2{(B . ?\x9610) ;; <CJK>
     (?$A2|(B . ?\x98A4) ;; <CJK>
     (?$A2}(B . ?\x660C) ;; <CJK>
     (?$A2~(B . ?\x7316) ;; <CJK>
     (?$A3!(B . ?\x573A) ;; <CJK>
     (?$A3"(B . ?\x5C1D) ;; <CJK>
     (?$A3#(B . ?\x5E38) ;; <CJK>
     (?$A3$(B . ?\x957F) ;; <CJK>
     (?$A3%(B . ?\x507F) ;; <CJK>
     (?$A3&(B . ?\x80A0) ;; <CJK>
     (?$A3'(B . ?\x5382) ;; <CJK>
     (?$A3((B . ?\x655E) ;; <CJK>
     (?$A3)(B . ?\x7545) ;; <CJK>
     (?$A3*(B . ?\x5531) ;; <CJK>
     (?$A3+(B . ?\x5021) ;; <CJK>
     (?$A3,(B . ?\x8D85) ;; <CJK>
     (?$A3-(B . ?\x6284) ;; <CJK>
     (?$A3.(B . ?\x949E) ;; <CJK>
     (?$A3/(B . ?\x671D) ;; <CJK>
     (?$A30(B . ?\x5632) ;; <CJK>
     (?$A31(B . ?\x6F6E) ;; <CJK>
     (?$A32(B . ?\x5DE2) ;; <CJK>
     (?$A33(B . ?\x5435) ;; <CJK>
     (?$A34(B . ?\x7092) ;; <CJK>
     (?$A35(B . ?\x8F66) ;; <CJK>
     (?$A36(B . ?\x626F) ;; <CJK>
     (?$A37(B . ?\x64A4) ;; <CJK>
     (?$A38(B . ?\x63A3) ;; <CJK>
     (?$A39(B . ?\x5F7B) ;; <CJK>
     (?$A3:(B . ?\x6F88) ;; <CJK>
     (?$A3;(B . ?\x90F4) ;; <CJK>
     (?$A3<(B . ?\x81E3) ;; <CJK>
     (?$A3=(B . ?\x8FB0) ;; <CJK>
     (?$A3>(B . ?\x5C18) ;; <CJK>
     (?$A3?(B . ?\x6668) ;; <CJK>
     (?$A3@(B . ?\x5FF1) ;; <CJK>
     (?$A3A(B . ?\x6C89) ;; <CJK>
     (?$A3B(B . ?\x9648) ;; <CJK>
     (?$A3C(B . ?\x8D81) ;; <CJK>
     (?$A3D(B . ?\x886C) ;; <CJK>
     (?$A3E(B . ?\x6491) ;; <CJK>
     (?$A3F(B . ?\x79F0) ;; <CJK>
     (?$A3G(B . ?\x57CE) ;; <CJK>
     (?$A3H(B . ?\x6A59) ;; <CJK>
     (?$A3I(B . ?\x6210) ;; <CJK>
     (?$A3J(B . ?\x5448) ;; <CJK>
     (?$A3K(B . ?\x4E58) ;; <CJK>
     (?$A3L(B . ?\x7A0B) ;; <CJK>
     (?$A3M(B . ?\x60E9) ;; <CJK>
     (?$A3N(B . ?\x6F84) ;; <CJK>
     (?$A3O(B . ?\x8BDA) ;; <CJK>
     (?$A3P(B . ?\x627F) ;; <CJK>
     (?$A3Q(B . ?\x901E) ;; <CJK>
     (?$A3R(B . ?\x9A8B) ;; <CJK>
     (?$A3S(B . ?\x79E4) ;; <CJK>
     (?$A3T(B . ?\x5403) ;; <CJK>
     (?$A3U(B . ?\x75F4) ;; <CJK>
     (?$A3V(B . ?\x6301) ;; <CJK>
     (?$A3W(B . ?\x5319) ;; <CJK>
     (?$A3X(B . ?\x6C60) ;; <CJK>
     (?$A3Y(B . ?\x8FDF) ;; <CJK>
     (?$A3Z(B . ?\x5F1B) ;; <CJK>
     (?$A3[(B . ?\x9A70) ;; <CJK>
     (?$A3\(B . ?\x803B) ;; <CJK>
     (?$A3](B . ?\x9F7F) ;; <CJK>
     (?$A3^(B . ?\x4F88) ;; <CJK>
     (?$A3_(B . ?\x5C3A) ;; <CJK>
     (?$A3`(B . ?\x8D64) ;; <CJK>
     (?$A3a(B . ?\x7FC5) ;; <CJK>
     (?$A3b(B . ?\x65A5) ;; <CJK>
     (?$A3c(B . ?\x70BD) ;; <CJK>
     (?$A3d(B . ?\x5145) ;; <CJK>
     (?$A3e(B . ?\x51B2) ;; <CJK>
     (?$A3f(B . ?\x866B) ;; <CJK>
     (?$A3g(B . ?\x5D07) ;; <CJK>
     (?$A3h(B . ?\x5BA0) ;; <CJK>
     (?$A3i(B . ?\x62BD) ;; <CJK>
     (?$A3j(B . ?\x916C) ;; <CJK>
     (?$A3k(B . ?\x7574) ;; <CJK>
     (?$A3l(B . ?\x8E0C) ;; <CJK>
     (?$A3m(B . ?\x7A20) ;; <CJK>
     (?$A3n(B . ?\x6101) ;; <CJK>
     (?$A3o(B . ?\x7B79) ;; <CJK>
     (?$A3p(B . ?\x4EC7) ;; <CJK>
     (?$A3q(B . ?\x7EF8) ;; <CJK>
     (?$A3r(B . ?\x7785) ;; <CJK>
     (?$A3s(B . ?\x4E11) ;; <CJK>
     (?$A3t(B . ?\x81ED) ;; <CJK>
     (?$A3u(B . ?\x521D) ;; <CJK>
     (?$A3v(B . ?\x51FA) ;; <CJK>
     (?$A3w(B . ?\x6A71) ;; <CJK>
     (?$A3x(B . ?\x53A8) ;; <CJK>
     (?$A3y(B . ?\x8E87) ;; <CJK>
     (?$A3z(B . ?\x9504) ;; <CJK>
     (?$A3{(B . ?\x96CF) ;; <CJK>
     (?$A3|(B . ?\x6EC1) ;; <CJK>
     (?$A3}(B . ?\x9664) ;; <CJK>
     (?$A3~(B . ?\x695A) ;; <CJK>
     (?$A4!(B . ?\x7840) ;; <CJK>
     (?$A4"(B . ?\x50A8) ;; <CJK>
     (?$A4#(B . ?\x77D7) ;; <CJK>
     (?$A4$(B . ?\x6410) ;; <CJK>
     (?$A4%(B . ?\x89E6) ;; <CJK>
     (?$A4&(B . ?\x5904) ;; <CJK>
     (?$A4'(B . ?\x63E3) ;; <CJK>
     (?$A4((B . ?\x5DDD) ;; <CJK>
     (?$A4)(B . ?\x7A7F) ;; <CJK>
     (?$A4*(B . ?\x693D) ;; <CJK>
     (?$A4+(B . ?\x4F20) ;; <CJK>
     (?$A4,(B . ?\x8239) ;; <CJK>
     (?$A4-(B . ?\x5598) ;; <CJK>
     (?$A4.(B . ?\x4E32) ;; <CJK>
     (?$A4/(B . ?\x75AE) ;; <CJK>
     (?$A40(B . ?\x7A97) ;; <CJK>
     (?$A41(B . ?\x5E62) ;; <CJK>
     (?$A42(B . ?\x5E8A) ;; <CJK>
     (?$A43(B . ?\x95EF) ;; <CJK>
     (?$A44(B . ?\x521B) ;; <CJK>
     (?$A45(B . ?\x5439) ;; <CJK>
     (?$A46(B . ?\x708A) ;; <CJK>
     (?$A47(B . ?\x6376) ;; <CJK>
     (?$A48(B . ?\x9524) ;; <CJK>
     (?$A49(B . ?\x5782) ;; <CJK>
     (?$A4:(B . ?\x6625) ;; <CJK>
     (?$A4;(B . ?\x693F) ;; <CJK>
     (?$A4<(B . ?\x9187) ;; <CJK>
     (?$A4=(B . ?\x5507) ;; <CJK>
     (?$A4>(B . ?\x6DF3) ;; <CJK>
     (?$A4?(B . ?\x7EAF) ;; <CJK>
     (?$A4@(B . ?\x8822) ;; <CJK>
     (?$A4A(B . ?\x6233) ;; <CJK>
     (?$A4B(B . ?\x7EF0) ;; <CJK>
     (?$A4C(B . ?\x75B5) ;; <CJK>
     (?$A4D(B . ?\x8328) ;; <CJK>
     (?$A4E(B . ?\x78C1) ;; <CJK>
     (?$A4F(B . ?\x96CC) ;; <CJK>
     (?$A4G(B . ?\x8F9E) ;; <CJK>
     (?$A4H(B . ?\x6148) ;; <CJK>
     (?$A4I(B . ?\x74F7) ;; <CJK>
     (?$A4J(B . ?\x8BCD) ;; <CJK>
     (?$A4K(B . ?\x6B64) ;; <CJK>
     (?$A4L(B . ?\x523A) ;; <CJK>
     (?$A4M(B . ?\x8D50) ;; <CJK>
     (?$A4N(B . ?\x6B21) ;; <CJK>
     (?$A4O(B . ?\x806A) ;; <CJK>
     (?$A4P(B . ?\x8471) ;; <CJK>
     (?$A4Q(B . ?\x56F1) ;; <CJK>
     (?$A4R(B . ?\x5306) ;; <CJK>
     (?$A4S(B . ?\x4ECE) ;; <CJK>
     (?$A4T(B . ?\x4E1B) ;; <CJK>
     (?$A4U(B . ?\x51D1) ;; <CJK>
     (?$A4V(B . ?\x7C97) ;; <CJK>
     (?$A4W(B . ?\x918B) ;; <CJK>
     (?$A4X(B . ?\x7C07) ;; <CJK>
     (?$A4Y(B . ?\x4FC3) ;; <CJK>
     (?$A4Z(B . ?\x8E7F) ;; <CJK>
     (?$A4[(B . ?\x7BE1) ;; <CJK>
     (?$A4\(B . ?\x7A9C) ;; <CJK>
     (?$A4](B . ?\x6467) ;; <CJK>
     (?$A4^(B . ?\x5D14) ;; <CJK>
     (?$A4_(B . ?\x50AC) ;; <CJK>
     (?$A4`(B . ?\x8106) ;; <CJK>
     (?$A4a(B . ?\x7601) ;; <CJK>
     (?$A4b(B . ?\x7CB9) ;; <CJK>
     (?$A4c(B . ?\x6DEC) ;; <CJK>
     (?$A4d(B . ?\x7FE0) ;; <CJK>
     (?$A4e(B . ?\x6751) ;; <CJK>
     (?$A4f(B . ?\x5B58) ;; <CJK>
     (?$A4g(B . ?\x5BF8) ;; <CJK>
     (?$A4h(B . ?\x78CB) ;; <CJK>
     (?$A4i(B . ?\x64AE) ;; <CJK>
     (?$A4j(B . ?\x6413) ;; <CJK>
     (?$A4k(B . ?\x63AA) ;; <CJK>
     (?$A4l(B . ?\x632B) ;; <CJK>
     (?$A4m(B . ?\x9519) ;; <CJK>
     (?$A4n(B . ?\x642D) ;; <CJK>
     (?$A4o(B . ?\x8FBE) ;; <CJK>
     (?$A4p(B . ?\x7B54) ;; <CJK>
     (?$A4q(B . ?\x7629) ;; <CJK>
     (?$A4r(B . ?\x6253) ;; <CJK>
     (?$A4s(B . ?\x5927) ;; <CJK>
     (?$A4t(B . ?\x5446) ;; <CJK>
     (?$A4u(B . ?\x6B79) ;; <CJK>
     (?$A4v(B . ?\x50A3) ;; <CJK>
     (?$A4w(B . ?\x6234) ;; <CJK>
     (?$A4x(B . ?\x5E26) ;; <CJK>
     (?$A4y(B . ?\x6B86) ;; <CJK>
     (?$A4z(B . ?\x4EE3) ;; <CJK>
     (?$A4{(B . ?\x8D37) ;; <CJK>
     (?$A4|(B . ?\x888B) ;; <CJK>
     (?$A4}(B . ?\x5F85) ;; <CJK>
     (?$A4~(B . ?\x902E) ;; <CJK>
     (?$A5!(B . ?\x6020) ;; <CJK>
     (?$A5"(B . ?\x803D) ;; <CJK>
     (?$A5#(B . ?\x62C5) ;; <CJK>
     (?$A5$(B . ?\x4E39) ;; <CJK>
     (?$A5%(B . ?\x5355) ;; <CJK>
     (?$A5&(B . ?\x90F8) ;; <CJK>
     (?$A5'(B . ?\x63B8) ;; <CJK>
     (?$A5((B . ?\x80C6) ;; <CJK>
     (?$A5)(B . ?\x65E6) ;; <CJK>
     (?$A5*(B . ?\x6C2E) ;; <CJK>
     (?$A5+(B . ?\x4F46) ;; <CJK>
     (?$A5,(B . ?\x60EE) ;; <CJK>
     (?$A5-(B . ?\x6DE1) ;; <CJK>
     (?$A5.(B . ?\x8BDE) ;; <CJK>
     (?$A5/(B . ?\x5F39) ;; <CJK>
     (?$A50(B . ?\x86CB) ;; <CJK>
     (?$A51(B . ?\x5F53) ;; <CJK>
     (?$A52(B . ?\x6321) ;; <CJK>
     (?$A53(B . ?\x515A) ;; <CJK>
     (?$A54(B . ?\x8361) ;; <CJK>
     (?$A55(B . ?\x6863) ;; <CJK>
     (?$A56(B . ?\x5200) ;; <CJK>
     (?$A57(B . ?\x6363) ;; <CJK>
     (?$A58(B . ?\x8E48) ;; <CJK>
     (?$A59(B . ?\x5012) ;; <CJK>
     (?$A5:(B . ?\x5C9B) ;; <CJK>
     (?$A5;(B . ?\x7977) ;; <CJK>
     (?$A5<(B . ?\x5BFC) ;; <CJK>
     (?$A5=(B . ?\x5230) ;; <CJK>
     (?$A5>(B . ?\x7A3B) ;; <CJK>
     (?$A5?(B . ?\x60BC) ;; <CJK>
     (?$A5@(B . ?\x9053) ;; <CJK>
     (?$A5A(B . ?\x76D7) ;; <CJK>
     (?$A5B(B . ?\x5FB7) ;; <CJK>
     (?$A5C(B . ?\x5F97) ;; <CJK>
     (?$A5D(B . ?\x7684) ;; <CJK>
     (?$A5E(B . ?\x8E6C) ;; <CJK>
     (?$A5F(B . ?\x706F) ;; <CJK>
     (?$A5G(B . ?\x767B) ;; <CJK>
     (?$A5H(B . ?\x7B49) ;; <CJK>
     (?$A5I(B . ?\x77AA) ;; <CJK>
     (?$A5J(B . ?\x51F3) ;; <CJK>
     (?$A5K(B . ?\x9093) ;; <CJK>
     (?$A5L(B . ?\x5824) ;; <CJK>
     (?$A5M(B . ?\x4F4E) ;; <CJK>
     (?$A5N(B . ?\x6EF4) ;; <CJK>
     (?$A5O(B . ?\x8FEA) ;; <CJK>
     (?$A5P(B . ?\x654C) ;; <CJK>
     (?$A5Q(B . ?\x7B1B) ;; <CJK>
     (?$A5R(B . ?\x72C4) ;; <CJK>
     (?$A5S(B . ?\x6DA4) ;; <CJK>
     (?$A5T(B . ?\x7FDF) ;; <CJK>
     (?$A5U(B . ?\x5AE1) ;; <CJK>
     (?$A5V(B . ?\x62B5) ;; <CJK>
     (?$A5W(B . ?\x5E95) ;; <CJK>
     (?$A5X(B . ?\x5730) ;; <CJK>
     (?$A5Y(B . ?\x8482) ;; <CJK>
     (?$A5Z(B . ?\x7B2C) ;; <CJK>
     (?$A5[(B . ?\x5E1D) ;; <CJK>
     (?$A5\(B . ?\x5F1F) ;; <CJK>
     (?$A5](B . ?\x9012) ;; <CJK>
     (?$A5^(B . ?\x7F14) ;; <CJK>
     (?$A5_(B . ?\x98A0) ;; <CJK>
     (?$A5`(B . ?\x6382) ;; <CJK>
     (?$A5a(B . ?\x6EC7) ;; <CJK>
     (?$A5b(B . ?\x7898) ;; <CJK>
     (?$A5c(B . ?\x70B9) ;; <CJK>
     (?$A5d(B . ?\x5178) ;; <CJK>
     (?$A5e(B . ?\x975B) ;; <CJK>
     (?$A5f(B . ?\x57AB) ;; <CJK>
     (?$A5g(B . ?\x7535) ;; <CJK>
     (?$A5h(B . ?\x4F43) ;; <CJK>
     (?$A5i(B . ?\x7538) ;; <CJK>
     (?$A5j(B . ?\x5E97) ;; <CJK>
     (?$A5k(B . ?\x60E6) ;; <CJK>
     (?$A5l(B . ?\x5960) ;; <CJK>
     (?$A5m(B . ?\x6DC0) ;; <CJK>
     (?$A5n(B . ?\x6BBF) ;; <CJK>
     (?$A5o(B . ?\x7889) ;; <CJK>
     (?$A5p(B . ?\x53FC) ;; <CJK>
     (?$A5q(B . ?\x96D5) ;; <CJK>
     (?$A5r(B . ?\x51CB) ;; <CJK>
     (?$A5s(B . ?\x5201) ;; <CJK>
     (?$A5t(B . ?\x6389) ;; <CJK>
     (?$A5u(B . ?\x540A) ;; <CJK>
     (?$A5v(B . ?\x9493) ;; <CJK>
     (?$A5w(B . ?\x8C03) ;; <CJK>
     (?$A5x(B . ?\x8DCC) ;; <CJK>
     (?$A5y(B . ?\x7239) ;; <CJK>
     (?$A5z(B . ?\x789F) ;; <CJK>
     (?$A5{(B . ?\x8776) ;; <CJK>
     (?$A5|(B . ?\x8FED) ;; <CJK>
     (?$A5}(B . ?\x8C0D) ;; <CJK>
     (?$A5~(B . ?\x53E0) ;; <CJK>
     (?$A6!(B . ?\x4E01) ;; <CJK>
     (?$A6"(B . ?\x76EF) ;; <CJK>
     (?$A6#(B . ?\x53EE) ;; <CJK>
     (?$A6$(B . ?\x9489) ;; <CJK>
     (?$A6%(B . ?\x9876) ;; <CJK>
     (?$A6&(B . ?\x9F0E) ;; <CJK>
     (?$A6'(B . ?\x952D) ;; <CJK>
     (?$A6((B . ?\x5B9A) ;; <CJK>
     (?$A6)(B . ?\x8BA2) ;; <CJK>
     (?$A6*(B . ?\x4E22) ;; <CJK>
     (?$A6+(B . ?\x4E1C) ;; <CJK>
     (?$A6,(B . ?\x51AC) ;; <CJK>
     (?$A6-(B . ?\x8463) ;; <CJK>
     (?$A6.(B . ?\x61C2) ;; <CJK>
     (?$A6/(B . ?\x52A8) ;; <CJK>
     (?$A60(B . ?\x680B) ;; <CJK>
     (?$A61(B . ?\x4F97) ;; <CJK>
     (?$A62(B . ?\x606B) ;; <CJK>
     (?$A63(B . ?\x51BB) ;; <CJK>
     (?$A64(B . ?\x6D1E) ;; <CJK>
     (?$A65(B . ?\x515C) ;; <CJK>
     (?$A66(B . ?\x6296) ;; <CJK>
     (?$A67(B . ?\x6597) ;; <CJK>
     (?$A68(B . ?\x9661) ;; <CJK>
     (?$A69(B . ?\x8C46) ;; <CJK>
     (?$A6:(B . ?\x9017) ;; <CJK>
     (?$A6;(B . ?\x75D8) ;; <CJK>
     (?$A6<(B . ?\x90FD) ;; <CJK>
     (?$A6=(B . ?\x7763) ;; <CJK>
     (?$A6>(B . ?\x6BD2) ;; <CJK>
     (?$A6?(B . ?\x728A) ;; <CJK>
     (?$A6@(B . ?\x72EC) ;; <CJK>
     (?$A6A(B . ?\x8BFB) ;; <CJK>
     (?$A6B(B . ?\x5835) ;; <CJK>
     (?$A6C(B . ?\x7779) ;; <CJK>
     (?$A6D(B . ?\x8D4C) ;; <CJK>
     (?$A6E(B . ?\x675C) ;; <CJK>
     (?$A6F(B . ?\x9540) ;; <CJK>
     (?$A6G(B . ?\x809A) ;; <CJK>
     (?$A6H(B . ?\x5EA6) ;; <CJK>
     (?$A6I(B . ?\x6E21) ;; <CJK>
     (?$A6J(B . ?\x5992) ;; <CJK>
     (?$A6K(B . ?\x7AEF) ;; <CJK>
     (?$A6L(B . ?\x77ED) ;; <CJK>
     (?$A6M(B . ?\x953B) ;; <CJK>
     (?$A6N(B . ?\x6BB5) ;; <CJK>
     (?$A6O(B . ?\x65AD) ;; <CJK>
     (?$A6P(B . ?\x7F0E) ;; <CJK>
     (?$A6Q(B . ?\x5806) ;; <CJK>
     (?$A6R(B . ?\x5151) ;; <CJK>
     (?$A6S(B . ?\x961F) ;; <CJK>
     (?$A6T(B . ?\x5BF9) ;; <CJK>
     (?$A6U(B . ?\x58A9) ;; <CJK>
     (?$A6V(B . ?\x5428) ;; <CJK>
     (?$A6W(B . ?\x8E72) ;; <CJK>
     (?$A6X(B . ?\x6566) ;; <CJK>
     (?$A6Y(B . ?\x987F) ;; <CJK>
     (?$A6Z(B . ?\x56E4) ;; <CJK>
     (?$A6[(B . ?\x949D) ;; <CJK>
     (?$A6\(B . ?\x76FE) ;; <CJK>
     (?$A6](B . ?\x9041) ;; <CJK>
     (?$A6^(B . ?\x6387) ;; <CJK>
     (?$A6_(B . ?\x54C6) ;; <CJK>
     (?$A6`(B . ?\x591A) ;; <CJK>
     (?$A6a(B . ?\x593A) ;; <CJK>
     (?$A6b(B . ?\x579B) ;; <CJK>
     (?$A6c(B . ?\x8EB2) ;; <CJK>
     (?$A6d(B . ?\x6735) ;; <CJK>
     (?$A6e(B . ?\x8DFA) ;; <CJK>
     (?$A6f(B . ?\x8235) ;; <CJK>
     (?$A6g(B . ?\x5241) ;; <CJK>
     (?$A6h(B . ?\x60F0) ;; <CJK>
     (?$A6i(B . ?\x5815) ;; <CJK>
     (?$A6j(B . ?\x86FE) ;; <CJK>
     (?$A6k(B . ?\x5CE8) ;; <CJK>
     (?$A6l(B . ?\x9E45) ;; <CJK>
     (?$A6m(B . ?\x4FC4) ;; <CJK>
     (?$A6n(B . ?\x989D) ;; <CJK>
     (?$A6o(B . ?\x8BB9) ;; <CJK>
     (?$A6p(B . ?\x5A25) ;; <CJK>
     (?$A6q(B . ?\x6076) ;; <CJK>
     (?$A6r(B . ?\x5384) ;; <CJK>
     (?$A6s(B . ?\x627C) ;; <CJK>
     (?$A6t(B . ?\x904F) ;; <CJK>
     (?$A6u(B . ?\x9102) ;; <CJK>
     (?$A6v(B . ?\x997F) ;; <CJK>
     (?$A6w(B . ?\x6069) ;; <CJK>
     (?$A6x(B . ?\x800C) ;; <CJK>
     (?$A6y(B . ?\x513F) ;; <CJK>
     (?$A6z(B . ?\x8033) ;; <CJK>
     (?$A6{(B . ?\x5C14) ;; <CJK>
     (?$A6|(B . ?\x9975) ;; <CJK>
     (?$A6}(B . ?\x6D31) ;; <CJK>
     (?$A6~(B . ?\x4E8C) ;; <CJK>
     (?$A7!(B . ?\x8D30) ;; <CJK>
     (?$A7"(B . ?\x53D1) ;; <CJK>
     (?$A7#(B . ?\x7F5A) ;; <CJK>
     (?$A7$(B . ?\x7B4F) ;; <CJK>
     (?$A7%(B . ?\x4F10) ;; <CJK>
     (?$A7&(B . ?\x4E4F) ;; <CJK>
     (?$A7'(B . ?\x9600) ;; <CJK>
     (?$A7((B . ?\x6CD5) ;; <CJK>
     (?$A7)(B . ?\x73D0) ;; <CJK>
     (?$A7*(B . ?\x85E9) ;; <CJK>
     (?$A7+(B . ?\x5E06) ;; <CJK>
     (?$A7,(B . ?\x756A) ;; <CJK>
     (?$A7-(B . ?\x7FFB) ;; <CJK>
     (?$A7.(B . ?\x6A0A) ;; <CJK>
     (?$A7/(B . ?\x77FE) ;; <CJK>
     (?$A70(B . ?\x9492) ;; <CJK>
     (?$A71(B . ?\x7E41) ;; <CJK>
     (?$A72(B . ?\x51E1) ;; <CJK>
     (?$A73(B . ?\x70E6) ;; <CJK>
     (?$A74(B . ?\x53CD) ;; <CJK>
     (?$A75(B . ?\x8FD4) ;; <CJK>
     (?$A76(B . ?\x8303) ;; <CJK>
     (?$A77(B . ?\x8D29) ;; <CJK>
     (?$A78(B . ?\x72AF) ;; <CJK>
     (?$A79(B . ?\x996D) ;; <CJK>
     (?$A7:(B . ?\x6CDB) ;; <CJK>
     (?$A7;(B . ?\x574A) ;; <CJK>
     (?$A7<(B . ?\x82B3) ;; <CJK>
     (?$A7=(B . ?\x65B9) ;; <CJK>
     (?$A7>(B . ?\x80AA) ;; <CJK>
     (?$A7?(B . ?\x623F) ;; <CJK>
     (?$A7@(B . ?\x9632) ;; <CJK>
     (?$A7A(B . ?\x59A8) ;; <CJK>
     (?$A7B(B . ?\x4EFF) ;; <CJK>
     (?$A7C(B . ?\x8BBF) ;; <CJK>
     (?$A7D(B . ?\x7EBA) ;; <CJK>
     (?$A7E(B . ?\x653E) ;; <CJK>
     (?$A7F(B . ?\x83F2) ;; <CJK>
     (?$A7G(B . ?\x975E) ;; <CJK>
     (?$A7H(B . ?\x5561) ;; <CJK>
     (?$A7I(B . ?\x98DE) ;; <CJK>
     (?$A7J(B . ?\x80A5) ;; <CJK>
     (?$A7K(B . ?\x532A) ;; <CJK>
     (?$A7L(B . ?\x8BFD) ;; <CJK>
     (?$A7M(B . ?\x5420) ;; <CJK>
     (?$A7N(B . ?\x80BA) ;; <CJK>
     (?$A7O(B . ?\x5E9F) ;; <CJK>
     (?$A7P(B . ?\x6CB8) ;; <CJK>
     (?$A7Q(B . ?\x8D39) ;; <CJK>
     (?$A7R(B . ?\x82AC) ;; <CJK>
     (?$A7S(B . ?\x915A) ;; <CJK>
     (?$A7T(B . ?\x5429) ;; <CJK>
     (?$A7U(B . ?\x6C1B) ;; <CJK>
     (?$A7V(B . ?\x5206) ;; <CJK>
     (?$A7W(B . ?\x7EB7) ;; <CJK>
     (?$A7X(B . ?\x575F) ;; <CJK>
     (?$A7Y(B . ?\x711A) ;; <CJK>
     (?$A7Z(B . ?\x6C7E) ;; <CJK>
     (?$A7[(B . ?\x7C89) ;; <CJK>
     (?$A7\(B . ?\x594B) ;; <CJK>
     (?$A7](B . ?\x4EFD) ;; <CJK>
     (?$A7^(B . ?\x5FFF) ;; <CJK>
     (?$A7_(B . ?\x6124) ;; <CJK>
     (?$A7`(B . ?\x7CAA) ;; <CJK>
     (?$A7a(B . ?\x4E30) ;; <CJK>
     (?$A7b(B . ?\x5C01) ;; <CJK>
     (?$A7c(B . ?\x67AB) ;; <CJK>
     (?$A7d(B . ?\x8702) ;; <CJK>
     (?$A7e(B . ?\x5CF0) ;; <CJK>
     (?$A7f(B . ?\x950B) ;; <CJK>
     (?$A7g(B . ?\x98CE) ;; <CJK>
     (?$A7h(B . ?\x75AF) ;; <CJK>
     (?$A7i(B . ?\x70FD) ;; <CJK>
     (?$A7j(B . ?\x9022) ;; <CJK>
     (?$A7k(B . ?\x51AF) ;; <CJK>
     (?$A7l(B . ?\x7F1D) ;; <CJK>
     (?$A7m(B . ?\x8BBD) ;; <CJK>
     (?$A7n(B . ?\x5949) ;; <CJK>
     (?$A7o(B . ?\x51E4) ;; <CJK>
     (?$A7p(B . ?\x4F5B) ;; <CJK>
     (?$A7q(B . ?\x5426) ;; <CJK>
     (?$A7r(B . ?\x592B) ;; <CJK>
     (?$A7s(B . ?\x6577) ;; <CJK>
     (?$A7t(B . ?\x80A4) ;; <CJK>
     (?$A7u(B . ?\x5B75) ;; <CJK>
     (?$A7v(B . ?\x6276) ;; <CJK>
     (?$A7w(B . ?\x62C2) ;; <CJK>
     (?$A7x(B . ?\x8F90) ;; <CJK>
     (?$A7y(B . ?\x5E45) ;; <CJK>
     (?$A7z(B . ?\x6C1F) ;; <CJK>
     (?$A7{(B . ?\x7B26) ;; <CJK>
     (?$A7|(B . ?\x4F0F) ;; <CJK>
     (?$A7}(B . ?\x4FD8) ;; <CJK>
     (?$A7~(B . ?\x670D) ;; <CJK>
     (?$A8!(B . ?\x6D6E) ;; <CJK>
     (?$A8"(B . ?\x6DAA) ;; <CJK>
     (?$A8#(B . ?\x798F) ;; <CJK>
     (?$A8$(B . ?\x88B1) ;; <CJK>
     (?$A8%(B . ?\x5F17) ;; <CJK>
     (?$A8&(B . ?\x752B) ;; <CJK>
     (?$A8'(B . ?\x629A) ;; <CJK>
     (?$A8((B . ?\x8F85) ;; <CJK>
     (?$A8)(B . ?\x4FEF) ;; <CJK>
     (?$A8*(B . ?\x91DC) ;; <CJK>
     (?$A8+(B . ?\x65A7) ;; <CJK>
     (?$A8,(B . ?\x812F) ;; <CJK>
     (?$A8-(B . ?\x8151) ;; <CJK>
     (?$A8.(B . ?\x5E9C) ;; <CJK>
     (?$A8/(B . ?\x8150) ;; <CJK>
     (?$A80(B . ?\x8D74) ;; <CJK>
     (?$A81(B . ?\x526F) ;; <CJK>
     (?$A82(B . ?\x8986) ;; <CJK>
     (?$A83(B . ?\x8D4B) ;; <CJK>
     (?$A84(B . ?\x590D) ;; <CJK>
     (?$A85(B . ?\x5085) ;; <CJK>
     (?$A86(B . ?\x4ED8) ;; <CJK>
     (?$A87(B . ?\x961C) ;; <CJK>
     (?$A88(B . ?\x7236) ;; <CJK>
     (?$A89(B . ?\x8179) ;; <CJK>
     (?$A8:(B . ?\x8D1F) ;; <CJK>
     (?$A8;(B . ?\x5BCC) ;; <CJK>
     (?$A8<(B . ?\x8BA3) ;; <CJK>
     (?$A8=(B . ?\x9644) ;; <CJK>
     (?$A8>(B . ?\x5987) ;; <CJK>
     (?$A8?(B . ?\x7F1A) ;; <CJK>
     (?$A8@(B . ?\x5490) ;; <CJK>
     (?$A8A(B . ?\x5676) ;; <CJK>
     (?$A8B(B . ?\x560E) ;; <CJK>
     (?$A8C(B . ?\x8BE5) ;; <CJK>
     (?$A8D(B . ?\x6539) ;; <CJK>
     (?$A8E(B . ?\x6982) ;; <CJK>
     (?$A8F(B . ?\x9499) ;; <CJK>
     (?$A8G(B . ?\x76D6) ;; <CJK>
     (?$A8H(B . ?\x6E89) ;; <CJK>
     (?$A8I(B . ?\x5E72) ;; <CJK>
     (?$A8J(B . ?\x7518) ;; <CJK>
     (?$A8K(B . ?\x6746) ;; <CJK>
     (?$A8L(B . ?\x67D1) ;; <CJK>
     (?$A8M(B . ?\x7AFF) ;; <CJK>
     (?$A8N(B . ?\x809D) ;; <CJK>
     (?$A8O(B . ?\x8D76) ;; <CJK>
     (?$A8P(B . ?\x611F) ;; <CJK>
     (?$A8Q(B . ?\x79C6) ;; <CJK>
     (?$A8R(B . ?\x6562) ;; <CJK>
     (?$A8S(B . ?\x8D63) ;; <CJK>
     (?$A8T(B . ?\x5188) ;; <CJK>
     (?$A8U(B . ?\x521A) ;; <CJK>
     (?$A8V(B . ?\x94A2) ;; <CJK>
     (?$A8W(B . ?\x7F38) ;; <CJK>
     (?$A8X(B . ?\x809B) ;; <CJK>
     (?$A8Y(B . ?\x7EB2) ;; <CJK>
     (?$A8Z(B . ?\x5C97) ;; <CJK>
     (?$A8[(B . ?\x6E2F) ;; <CJK>
     (?$A8\(B . ?\x6760) ;; <CJK>
     (?$A8](B . ?\x7BD9) ;; <CJK>
     (?$A8^(B . ?\x768B) ;; <CJK>
     (?$A8_(B . ?\x9AD8) ;; <CJK>
     (?$A8`(B . ?\x818F) ;; <CJK>
     (?$A8a(B . ?\x7F94) ;; <CJK>
     (?$A8b(B . ?\x7CD5) ;; <CJK>
     (?$A8c(B . ?\x641E) ;; <CJK>
     (?$A8d(B . ?\x9550) ;; <CJK>
     (?$A8e(B . ?\x7A3F) ;; <CJK>
     (?$A8f(B . ?\x544A) ;; <CJK>
     (?$A8g(B . ?\x54E5) ;; <CJK>
     (?$A8h(B . ?\x6B4C) ;; <CJK>
     (?$A8i(B . ?\x6401) ;; <CJK>
     (?$A8j(B . ?\x6208) ;; <CJK>
     (?$A8k(B . ?\x9E3D) ;; <CJK>
     (?$A8l(B . ?\x80F3) ;; <CJK>
     (?$A8m(B . ?\x7599) ;; <CJK>
     (?$A8n(B . ?\x5272) ;; <CJK>
     (?$A8o(B . ?\x9769) ;; <CJK>
     (?$A8p(B . ?\x845B) ;; <CJK>
     (?$A8q(B . ?\x683C) ;; <CJK>
     (?$A8r(B . ?\x86E4) ;; <CJK>
     (?$A8s(B . ?\x9601) ;; <CJK>
     (?$A8t(B . ?\x9694) ;; <CJK>
     (?$A8u(B . ?\x94EC) ;; <CJK>
     (?$A8v(B . ?\x4E2A) ;; <CJK>
     (?$A8w(B . ?\x5404) ;; <CJK>
     (?$A8x(B . ?\x7ED9) ;; <CJK>
     (?$A8y(B . ?\x6839) ;; <CJK>
     (?$A8z(B . ?\x8DDF) ;; <CJK>
     (?$A8{(B . ?\x8015) ;; <CJK>
     (?$A8|(B . ?\x66F4) ;; <CJK>
     (?$A8}(B . ?\x5E9A) ;; <CJK>
     (?$A8~(B . ?\x7FB9) ;; <CJK>
     (?$A9!(B . ?\x57C2) ;; <CJK>
     (?$A9"(B . ?\x803F) ;; <CJK>
     (?$A9#(B . ?\x6897) ;; <CJK>
     (?$A9$(B . ?\x5DE5) ;; <CJK>
     (?$A9%(B . ?\x653B) ;; <CJK>
     (?$A9&(B . ?\x529F) ;; <CJK>
     (?$A9'(B . ?\x606D) ;; <CJK>
     (?$A9((B . ?\x9F9A) ;; <CJK>
     (?$A9)(B . ?\x4F9B) ;; <CJK>
     (?$A9*(B . ?\x8EAC) ;; <CJK>
     (?$A9+(B . ?\x516C) ;; <CJK>
     (?$A9,(B . ?\x5BAB) ;; <CJK>
     (?$A9-(B . ?\x5F13) ;; <CJK>
     (?$A9.(B . ?\x5DE9) ;; <CJK>
     (?$A9/(B . ?\x6C5E) ;; <CJK>
     (?$A90(B . ?\x62F1) ;; <CJK>
     (?$A91(B . ?\x8D21) ;; <CJK>
     (?$A92(B . ?\x5171) ;; <CJK>
     (?$A93(B . ?\x94A9) ;; <CJK>
     (?$A94(B . ?\x52FE) ;; <CJK>
     (?$A95(B . ?\x6C9F) ;; <CJK>
     (?$A96(B . ?\x82DF) ;; <CJK>
     (?$A97(B . ?\x72D7) ;; <CJK>
     (?$A98(B . ?\x57A2) ;; <CJK>
     (?$A99(B . ?\x6784) ;; <CJK>
     (?$A9:(B . ?\x8D2D) ;; <CJK>
     (?$A9;(B . ?\x591F) ;; <CJK>
     (?$A9<(B . ?\x8F9C) ;; <CJK>
     (?$A9=(B . ?\x83C7) ;; <CJK>
     (?$A9>(B . ?\x5495) ;; <CJK>
     (?$A9?(B . ?\x7B8D) ;; <CJK>
     (?$A9@(B . ?\x4F30) ;; <CJK>
     (?$A9A(B . ?\x6CBD) ;; <CJK>
     (?$A9B(B . ?\x5B64) ;; <CJK>
     (?$A9C(B . ?\x59D1) ;; <CJK>
     (?$A9D(B . ?\x9F13) ;; <CJK>
     (?$A9E(B . ?\x53E4) ;; <CJK>
     (?$A9F(B . ?\x86CA) ;; <CJK>
     (?$A9G(B . ?\x9AA8) ;; <CJK>
     (?$A9H(B . ?\x8C37) ;; <CJK>
     (?$A9I(B . ?\x80A1) ;; <CJK>
     (?$A9J(B . ?\x6545) ;; <CJK>
     (?$A9K(B . ?\x987E) ;; <CJK>
     (?$A9L(B . ?\x56FA) ;; <CJK>
     (?$A9M(B . ?\x96C7) ;; <CJK>
     (?$A9N(B . ?\x522E) ;; <CJK>
     (?$A9O(B . ?\x74DC) ;; <CJK>
     (?$A9P(B . ?\x5250) ;; <CJK>
     (?$A9Q(B . ?\x5BE1) ;; <CJK>
     (?$A9R(B . ?\x6302) ;; <CJK>
     (?$A9S(B . ?\x8902) ;; <CJK>
     (?$A9T(B . ?\x4E56) ;; <CJK>
     (?$A9U(B . ?\x62D0) ;; <CJK>
     (?$A9V(B . ?\x602A) ;; <CJK>
     (?$A9W(B . ?\x68FA) ;; <CJK>
     (?$A9X(B . ?\x5173) ;; <CJK>
     (?$A9Y(B . ?\x5B98) ;; <CJK>
     (?$A9Z(B . ?\x51A0) ;; <CJK>
     (?$A9[(B . ?\x89C2) ;; <CJK>
     (?$A9\(B . ?\x7BA1) ;; <CJK>
     (?$A9](B . ?\x9986) ;; <CJK>
     (?$A9^(B . ?\x7F50) ;; <CJK>
     (?$A9_(B . ?\x60EF) ;; <CJK>
     (?$A9`(B . ?\x704C) ;; <CJK>
     (?$A9a(B . ?\x8D2F) ;; <CJK>
     (?$A9b(B . ?\x5149) ;; <CJK>
     (?$A9c(B . ?\x5E7F) ;; <CJK>
     (?$A9d(B . ?\x901B) ;; <CJK>
     (?$A9e(B . ?\x7470) ;; <CJK>
     (?$A9f(B . ?\x89C4) ;; <CJK>
     (?$A9g(B . ?\x572D) ;; <CJK>
     (?$A9h(B . ?\x7845) ;; <CJK>
     (?$A9i(B . ?\x5F52) ;; <CJK>
     (?$A9j(B . ?\x9F9F) ;; <CJK>
     (?$A9k(B . ?\x95FA) ;; <CJK>
     (?$A9l(B . ?\x8F68) ;; <CJK>
     (?$A9m(B . ?\x9B3C) ;; <CJK>
     (?$A9n(B . ?\x8BE1) ;; <CJK>
     (?$A9o(B . ?\x7678) ;; <CJK>
     (?$A9p(B . ?\x6842) ;; <CJK>
     (?$A9q(B . ?\x67DC) ;; <CJK>
     (?$A9r(B . ?\x8DEA) ;; <CJK>
     (?$A9s(B . ?\x8D35) ;; <CJK>
     (?$A9t(B . ?\x523D) ;; <CJK>
     (?$A9u(B . ?\x8F8A) ;; <CJK>
     (?$A9v(B . ?\x6EDA) ;; <CJK>
     (?$A9w(B . ?\x68CD) ;; <CJK>
     (?$A9x(B . ?\x9505) ;; <CJK>
     (?$A9y(B . ?\x90ED) ;; <CJK>
     (?$A9z(B . ?\x56FD) ;; <CJK>
     (?$A9{(B . ?\x679C) ;; <CJK>
     (?$A9|(B . ?\x88F9) ;; <CJK>
     (?$A9}(B . ?\x8FC7) ;; <CJK>
     (?$A9~(B . ?\x54C8) ;; <CJK>
     (?$A:!(B . ?\x9AB8) ;; <CJK>
     (?$A:"(B . ?\x5B69) ;; <CJK>
     (?$A:#(B . ?\x6D77) ;; <CJK>
     (?$A:$(B . ?\x6C26) ;; <CJK>
     (?$A:%(B . ?\x4EA5) ;; <CJK>
     (?$A:&(B . ?\x5BB3) ;; <CJK>
     (?$A:'(B . ?\x9A87) ;; <CJK>
     (?$A:((B . ?\x9163) ;; <CJK>
     (?$A:)(B . ?\x61A8) ;; <CJK>
     (?$A:*(B . ?\x90AF) ;; <CJK>
     (?$A:+(B . ?\x97E9) ;; <CJK>
     (?$A:,(B . ?\x542B) ;; <CJK>
     (?$A:-(B . ?\x6DB5) ;; <CJK>
     (?$A:.(B . ?\x5BD2) ;; <CJK>
     (?$A:/(B . ?\x51FD) ;; <CJK>
     (?$A:0(B . ?\x558A) ;; <CJK>
     (?$A:1(B . ?\x7F55) ;; <CJK>
     (?$A:2(B . ?\x7FF0) ;; <CJK>
     (?$A:3(B . ?\x64BC) ;; <CJK>
     (?$A:4(B . ?\x634D) ;; <CJK>
     (?$A:5(B . ?\x65F1) ;; <CJK>
     (?$A:6(B . ?\x61BE) ;; <CJK>
     (?$A:7(B . ?\x608D) ;; <CJK>
     (?$A:8(B . ?\x710A) ;; <CJK>
     (?$A:9(B . ?\x6C57) ;; <CJK>
     (?$A::(B . ?\x6C49) ;; <CJK>
     (?$A:;(B . ?\x592F) ;; <CJK>
     (?$A:<(B . ?\x676D) ;; <CJK>
     (?$A:=(B . ?\x822A) ;; <CJK>
     (?$A:>(B . ?\x58D5) ;; <CJK>
     (?$A:?(B . ?\x568E) ;; <CJK>
     (?$A:@(B . ?\x8C6A) ;; <CJK>
     (?$A:A(B . ?\x6BEB) ;; <CJK>
     (?$A:B(B . ?\x90DD) ;; <CJK>
     (?$A:C(B . ?\x597D) ;; <CJK>
     (?$A:D(B . ?\x8017) ;; <CJK>
     (?$A:E(B . ?\x53F7) ;; <CJK>
     (?$A:F(B . ?\x6D69) ;; <CJK>
     (?$A:G(B . ?\x5475) ;; <CJK>
     (?$A:H(B . ?\x559D) ;; <CJK>
     (?$A:I(B . ?\x8377) ;; <CJK>
     (?$A:J(B . ?\x83CF) ;; <CJK>
     (?$A:K(B . ?\x6838) ;; <CJK>
     (?$A:L(B . ?\x79BE) ;; <CJK>
     (?$A:M(B . ?\x548C) ;; <CJK>
     (?$A:N(B . ?\x4F55) ;; <CJK>
     (?$A:O(B . ?\x5408) ;; <CJK>
     (?$A:P(B . ?\x76D2) ;; <CJK>
     (?$A:Q(B . ?\x8C89) ;; <CJK>
     (?$A:R(B . ?\x9602) ;; <CJK>
     (?$A:S(B . ?\x6CB3) ;; <CJK>
     (?$A:T(B . ?\x6DB8) ;; <CJK>
     (?$A:U(B . ?\x8D6B) ;; <CJK>
     (?$A:V(B . ?\x8910) ;; <CJK>
     (?$A:W(B . ?\x9E64) ;; <CJK>
     (?$A:X(B . ?\x8D3A) ;; <CJK>
     (?$A:Y(B . ?\x563F) ;; <CJK>
     (?$A:Z(B . ?\x9ED1) ;; <CJK>
     (?$A:[(B . ?\x75D5) ;; <CJK>
     (?$A:\(B . ?\x5F88) ;; <CJK>
     (?$A:](B . ?\x72E0) ;; <CJK>
     (?$A:^(B . ?\x6068) ;; <CJK>
     (?$A:_(B . ?\x54FC) ;; <CJK>
     (?$A:`(B . ?\x4EA8) ;; <CJK>
     (?$A:a(B . ?\x6A2A) ;; <CJK>
     (?$A:b(B . ?\x8861) ;; <CJK>
     (?$A:c(B . ?\x6052) ;; <CJK>
     (?$A:d(B . ?\x8F70) ;; <CJK>
     (?$A:e(B . ?\x54C4) ;; <CJK>
     (?$A:f(B . ?\x70D8) ;; <CJK>
     (?$A:g(B . ?\x8679) ;; <CJK>
     (?$A:h(B . ?\x9E3F) ;; <CJK>
     (?$A:i(B . ?\x6D2A) ;; <CJK>
     (?$A:j(B . ?\x5B8F) ;; <CJK>
     (?$A:k(B . ?\x5F18) ;; <CJK>
     (?$A:l(B . ?\x7EA2) ;; <CJK>
     (?$A:m(B . ?\x5589) ;; <CJK>
     (?$A:n(B . ?\x4FAF) ;; <CJK>
     (?$A:o(B . ?\x7334) ;; <CJK>
     (?$A:p(B . ?\x543C) ;; <CJK>
     (?$A:q(B . ?\x539A) ;; <CJK>
     (?$A:r(B . ?\x5019) ;; <CJK>
     (?$A:s(B . ?\x540E) ;; <CJK>
     (?$A:t(B . ?\x547C) ;; <CJK>
     (?$A:u(B . ?\x4E4E) ;; <CJK>
     (?$A:v(B . ?\x5FFD) ;; <CJK>
     (?$A:w(B . ?\x745A) ;; <CJK>
     (?$A:x(B . ?\x58F6) ;; <CJK>
     (?$A:y(B . ?\x846B) ;; <CJK>
     (?$A:z(B . ?\x80E1) ;; <CJK>
     (?$A:{(B . ?\x8774) ;; <CJK>
     (?$A:|(B . ?\x72D0) ;; <CJK>
     (?$A:}(B . ?\x7CCA) ;; <CJK>
     (?$A:~(B . ?\x6E56) ;; <CJK>
     (?$A;!(B . ?\x5F27) ;; <CJK>
     (?$A;"(B . ?\x864E) ;; <CJK>
     (?$A;#(B . ?\x552C) ;; <CJK>
     (?$A;$(B . ?\x62A4) ;; <CJK>
     (?$A;%(B . ?\x4E92) ;; <CJK>
     (?$A;&(B . ?\x6CAA) ;; <CJK>
     (?$A;'(B . ?\x6237) ;; <CJK>
     (?$A;((B . ?\x82B1) ;; <CJK>
     (?$A;)(B . ?\x54D7) ;; <CJK>
     (?$A;*(B . ?\x534E) ;; <CJK>
     (?$A;+(B . ?\x733E) ;; <CJK>
     (?$A;,(B . ?\x6ED1) ;; <CJK>
     (?$A;-(B . ?\x753B) ;; <CJK>
     (?$A;.(B . ?\x5212) ;; <CJK>
     (?$A;/(B . ?\x5316) ;; <CJK>
     (?$A;0(B . ?\x8BDD) ;; <CJK>
     (?$A;1(B . ?\x69D0) ;; <CJK>
     (?$A;2(B . ?\x5F8A) ;; <CJK>
     (?$A;3(B . ?\x6000) ;; <CJK>
     (?$A;4(B . ?\x6DEE) ;; <CJK>
     (?$A;5(B . ?\x574F) ;; <CJK>
     (?$A;6(B . ?\x6B22) ;; <CJK>
     (?$A;7(B . ?\x73AF) ;; <CJK>
     (?$A;8(B . ?\x6853) ;; <CJK>
     (?$A;9(B . ?\x8FD8) ;; <CJK>
     (?$A;:(B . ?\x7F13) ;; <CJK>
     (?$A;;(B . ?\x6362) ;; <CJK>
     (?$A;<(B . ?\x60A3) ;; <CJK>
     (?$A;=(B . ?\x5524) ;; <CJK>
     (?$A;>(B . ?\x75EA) ;; <CJK>
     (?$A;?(B . ?\x8C62) ;; <CJK>
     (?$A;@(B . ?\x7115) ;; <CJK>
     (?$A;A(B . ?\x6DA3) ;; <CJK>
     (?$A;B(B . ?\x5BA6) ;; <CJK>
     (?$A;C(B . ?\x5E7B) ;; <CJK>
     (?$A;D(B . ?\x8352) ;; <CJK>
     (?$A;E(B . ?\x614C) ;; <CJK>
     (?$A;F(B . ?\x9EC4) ;; <CJK>
     (?$A;G(B . ?\x78FA) ;; <CJK>
     (?$A;H(B . ?\x8757) ;; <CJK>
     (?$A;I(B . ?\x7C27) ;; <CJK>
     (?$A;J(B . ?\x7687) ;; <CJK>
     (?$A;K(B . ?\x51F0) ;; <CJK>
     (?$A;L(B . ?\x60F6) ;; <CJK>
     (?$A;M(B . ?\x714C) ;; <CJK>
     (?$A;N(B . ?\x6643) ;; <CJK>
     (?$A;O(B . ?\x5E4C) ;; <CJK>
     (?$A;P(B . ?\x604D) ;; <CJK>
     (?$A;Q(B . ?\x8C0E) ;; <CJK>
     (?$A;R(B . ?\x7070) ;; <CJK>
     (?$A;S(B . ?\x6325) ;; <CJK>
     (?$A;T(B . ?\x8F89) ;; <CJK>
     (?$A;U(B . ?\x5FBD) ;; <CJK>
     (?$A;V(B . ?\x6062) ;; <CJK>
     (?$A;W(B . ?\x86D4) ;; <CJK>
     (?$A;X(B . ?\x56DE) ;; <CJK>
     (?$A;Y(B . ?\x6BC1) ;; <CJK>
     (?$A;Z(B . ?\x6094) ;; <CJK>
     (?$A;[(B . ?\x6167) ;; <CJK>
     (?$A;\(B . ?\x5349) ;; <CJK>
     (?$A;](B . ?\x60E0) ;; <CJK>
     (?$A;^(B . ?\x6666) ;; <CJK>
     (?$A;_(B . ?\x8D3F) ;; <CJK>
     (?$A;`(B . ?\x79FD) ;; <CJK>
     (?$A;a(B . ?\x4F1A) ;; <CJK>
     (?$A;b(B . ?\x70E9) ;; <CJK>
     (?$A;c(B . ?\x6C47) ;; <CJK>
     (?$A;d(B . ?\x8BB3) ;; <CJK>
     (?$A;e(B . ?\x8BF2) ;; <CJK>
     (?$A;f(B . ?\x7ED8) ;; <CJK>
     (?$A;g(B . ?\x8364) ;; <CJK>
     (?$A;h(B . ?\x660F) ;; <CJK>
     (?$A;i(B . ?\x5A5A) ;; <CJK>
     (?$A;j(B . ?\x9B42) ;; <CJK>
     (?$A;k(B . ?\x6D51) ;; <CJK>
     (?$A;l(B . ?\x6DF7) ;; <CJK>
     (?$A;m(B . ?\x8C41) ;; <CJK>
     (?$A;n(B . ?\x6D3B) ;; <CJK>
     (?$A;o(B . ?\x4F19) ;; <CJK>
     (?$A;p(B . ?\x706B) ;; <CJK>
     (?$A;q(B . ?\x83B7) ;; <CJK>
     (?$A;r(B . ?\x6216) ;; <CJK>
     (?$A;s(B . ?\x60D1) ;; <CJK>
     (?$A;t(B . ?\x970D) ;; <CJK>
     (?$A;u(B . ?\x8D27) ;; <CJK>
     (?$A;v(B . ?\x7978) ;; <CJK>
     (?$A;w(B . ?\x51FB) ;; <CJK>
     (?$A;x(B . ?\x573E) ;; <CJK>
     (?$A;y(B . ?\x57FA) ;; <CJK>
     (?$A;z(B . ?\x673A) ;; <CJK>
     (?$A;{(B . ?\x7578) ;; <CJK>
     (?$A;|(B . ?\x7A3D) ;; <CJK>
     (?$A;}(B . ?\x79EF) ;; <CJK>
     (?$A;~(B . ?\x7B95) ;; <CJK>
     (?$A<!(B . ?\x808C) ;; <CJK>
     (?$A<"(B . ?\x9965) ;; <CJK>
     (?$A<#(B . ?\x8FF9) ;; <CJK>
     (?$A<$(B . ?\x6FC0) ;; <CJK>
     (?$A<%(B . ?\x8BA5) ;; <CJK>
     (?$A<&(B . ?\x9E21) ;; <CJK>
     (?$A<'(B . ?\x59EC) ;; <CJK>
     (?$A<((B . ?\x7EE9) ;; <CJK>
     (?$A<)(B . ?\x7F09) ;; <CJK>
     (?$A<*(B . ?\x5409) ;; <CJK>
     (?$A<+(B . ?\x6781) ;; <CJK>
     (?$A<,(B . ?\x68D8) ;; <CJK>
     (?$A<-(B . ?\x8F91) ;; <CJK>
     (?$A<.(B . ?\x7C4D) ;; <CJK>
     (?$A</(B . ?\x96C6) ;; <CJK>
     (?$A<0(B . ?\x53CA) ;; <CJK>
     (?$A<1(B . ?\x6025) ;; <CJK>
     (?$A<2(B . ?\x75BE) ;; <CJK>
     (?$A<3(B . ?\x6C72) ;; <CJK>
     (?$A<4(B . ?\x5373) ;; <CJK>
     (?$A<5(B . ?\x5AC9) ;; <CJK>
     (?$A<6(B . ?\x7EA7) ;; <CJK>
     (?$A<7(B . ?\x6324) ;; <CJK>
     (?$A<8(B . ?\x51E0) ;; <CJK>
     (?$A<9(B . ?\x810A) ;; <CJK>
     (?$A<:(B . ?\x5DF1) ;; <CJK>
     (?$A<;(B . ?\x84DF) ;; <CJK>
     (?$A<<(B . ?\x6280) ;; <CJK>
     (?$A<=(B . ?\x5180) ;; <CJK>
     (?$A<>(B . ?\x5B63) ;; <CJK>
     (?$A<?(B . ?\x4F0E) ;; <CJK>
     (?$A<@(B . ?\x796D) ;; <CJK>
     (?$A<A(B . ?\x5242) ;; <CJK>
     (?$A<B(B . ?\x60B8) ;; <CJK>
     (?$A<C(B . ?\x6D4E) ;; <CJK>
     (?$A<D(B . ?\x5BC4) ;; <CJK>
     (?$A<E(B . ?\x5BC2) ;; <CJK>
     (?$A<F(B . ?\x8BA1) ;; <CJK>
     (?$A<G(B . ?\x8BB0) ;; <CJK>
     (?$A<H(B . ?\x65E2) ;; <CJK>
     (?$A<I(B . ?\x5FCC) ;; <CJK>
     (?$A<J(B . ?\x9645) ;; <CJK>
     (?$A<K(B . ?\x5993) ;; <CJK>
     (?$A<L(B . ?\x7EE7) ;; <CJK>
     (?$A<M(B . ?\x7EAA) ;; <CJK>
     (?$A<N(B . ?\x5609) ;; <CJK>
     (?$A<O(B . ?\x67B7) ;; <CJK>
     (?$A<P(B . ?\x5939) ;; <CJK>
     (?$A<Q(B . ?\x4F73) ;; <CJK>
     (?$A<R(B . ?\x5BB6) ;; <CJK>
     (?$A<S(B . ?\x52A0) ;; <CJK>
     (?$A<T(B . ?\x835A) ;; <CJK>
     (?$A<U(B . ?\x988A) ;; <CJK>
     (?$A<V(B . ?\x8D3E) ;; <CJK>
     (?$A<W(B . ?\x7532) ;; <CJK>
     (?$A<X(B . ?\x94BE) ;; <CJK>
     (?$A<Y(B . ?\x5047) ;; <CJK>
     (?$A<Z(B . ?\x7A3C) ;; <CJK>
     (?$A<[(B . ?\x4EF7) ;; <CJK>
     (?$A<\(B . ?\x67B6) ;; <CJK>
     (?$A<](B . ?\x9A7E) ;; <CJK>
     (?$A<^(B . ?\x5AC1) ;; <CJK>
     (?$A<_(B . ?\x6B7C) ;; <CJK>
     (?$A<`(B . ?\x76D1) ;; <CJK>
     (?$A<a(B . ?\x575A) ;; <CJK>
     (?$A<b(B . ?\x5C16) ;; <CJK>
     (?$A<c(B . ?\x7B3A) ;; <CJK>
     (?$A<d(B . ?\x95F4) ;; <CJK>
     (?$A<e(B . ?\x714E) ;; <CJK>
     (?$A<f(B . ?\x517C) ;; <CJK>
     (?$A<g(B . ?\x80A9) ;; <CJK>
     (?$A<h(B . ?\x8270) ;; <CJK>
     (?$A<i(B . ?\x5978) ;; <CJK>
     (?$A<j(B . ?\x7F04) ;; <CJK>
     (?$A<k(B . ?\x8327) ;; <CJK>
     (?$A<l(B . ?\x68C0) ;; <CJK>
     (?$A<m(B . ?\x67EC) ;; <CJK>
     (?$A<n(B . ?\x78B1) ;; <CJK>
     (?$A<o(B . ?\x7877) ;; <CJK>
     (?$A<p(B . ?\x62E3) ;; <CJK>
     (?$A<q(B . ?\x6361) ;; <CJK>
     (?$A<r(B . ?\x7B80) ;; <CJK>
     (?$A<s(B . ?\x4FED) ;; <CJK>
     (?$A<t(B . ?\x526A) ;; <CJK>
     (?$A<u(B . ?\x51CF) ;; <CJK>
     (?$A<v(B . ?\x8350) ;; <CJK>
     (?$A<w(B . ?\x69DB) ;; <CJK>
     (?$A<x(B . ?\x9274) ;; <CJK>
     (?$A<y(B . ?\x8DF5) ;; <CJK>
     (?$A<z(B . ?\x8D31) ;; <CJK>
     (?$A<{(B . ?\x89C1) ;; <CJK>
     (?$A<|(B . ?\x952E) ;; <CJK>
     (?$A<}(B . ?\x7BAD) ;; <CJK>
     (?$A<~(B . ?\x4EF6) ;; <CJK>
     (?$A=!(B . ?\x5065) ;; <CJK>
     (?$A="(B . ?\x8230) ;; <CJK>
     (?$A=#(B . ?\x5251) ;; <CJK>
     (?$A=$(B . ?\x996F) ;; <CJK>
     (?$A=%(B . ?\x6E10) ;; <CJK>
     (?$A=&(B . ?\x6E85) ;; <CJK>
     (?$A='(B . ?\x6DA7) ;; <CJK>
     (?$A=((B . ?\x5EFA) ;; <CJK>
     (?$A=)(B . ?\x50F5) ;; <CJK>
     (?$A=*(B . ?\x59DC) ;; <CJK>
     (?$A=+(B . ?\x5C06) ;; <CJK>
     (?$A=,(B . ?\x6D46) ;; <CJK>
     (?$A=-(B . ?\x6C5F) ;; <CJK>
     (?$A=.(B . ?\x7586) ;; <CJK>
     (?$A=/(B . ?\x848B) ;; <CJK>
     (?$A=0(B . ?\x6868) ;; <CJK>
     (?$A=1(B . ?\x5956) ;; <CJK>
     (?$A=2(B . ?\x8BB2) ;; <CJK>
     (?$A=3(B . ?\x5320) ;; <CJK>
     (?$A=4(B . ?\x9171) ;; <CJK>
     (?$A=5(B . ?\x964D) ;; <CJK>
     (?$A=6(B . ?\x8549) ;; <CJK>
     (?$A=7(B . ?\x6912) ;; <CJK>
     (?$A=8(B . ?\x7901) ;; <CJK>
     (?$A=9(B . ?\x7126) ;; <CJK>
     (?$A=:(B . ?\x80F6) ;; <CJK>
     (?$A=;(B . ?\x4EA4) ;; <CJK>
     (?$A=<(B . ?\x90CA) ;; <CJK>
     (?$A==(B . ?\x6D47) ;; <CJK>
     (?$A=>(B . ?\x9A84) ;; <CJK>
     (?$A=?(B . ?\x5A07) ;; <CJK>
     (?$A=@(B . ?\x56BC) ;; <CJK>
     (?$A=A(B . ?\x6405) ;; <CJK>
     (?$A=B(B . ?\x94F0) ;; <CJK>
     (?$A=C(B . ?\x77EB) ;; <CJK>
     (?$A=D(B . ?\x4FA5) ;; <CJK>
     (?$A=E(B . ?\x811A) ;; <CJK>
     (?$A=F(B . ?\x72E1) ;; <CJK>
     (?$A=G(B . ?\x89D2) ;; <CJK>
     (?$A=H(B . ?\x997A) ;; <CJK>
     (?$A=I(B . ?\x7F34) ;; <CJK>
     (?$A=J(B . ?\x7EDE) ;; <CJK>
     (?$A=K(B . ?\x527F) ;; <CJK>
     (?$A=L(B . ?\x6559) ;; <CJK>
     (?$A=M(B . ?\x9175) ;; <CJK>
     (?$A=N(B . ?\x8F7F) ;; <CJK>
     (?$A=O(B . ?\x8F83) ;; <CJK>
     (?$A=P(B . ?\x53EB) ;; <CJK>
     (?$A=Q(B . ?\x7A96) ;; <CJK>
     (?$A=R(B . ?\x63ED) ;; <CJK>
     (?$A=S(B . ?\x63A5) ;; <CJK>
     (?$A=T(B . ?\x7686) ;; <CJK>
     (?$A=U(B . ?\x79F8) ;; <CJK>
     (?$A=V(B . ?\x8857) ;; <CJK>
     (?$A=W(B . ?\x9636) ;; <CJK>
     (?$A=X(B . ?\x622A) ;; <CJK>
     (?$A=Y(B . ?\x52AB) ;; <CJK>
     (?$A=Z(B . ?\x8282) ;; <CJK>
     (?$A=[(B . ?\x6854) ;; <CJK>
     (?$A=\(B . ?\x6770) ;; <CJK>
     (?$A=](B . ?\x6377) ;; <CJK>
     (?$A=^(B . ?\x776B) ;; <CJK>
     (?$A=_(B . ?\x7AED) ;; <CJK>
     (?$A=`(B . ?\x6D01) ;; <CJK>
     (?$A=a(B . ?\x7ED3) ;; <CJK>
     (?$A=b(B . ?\x89E3) ;; <CJK>
     (?$A=c(B . ?\x59D0) ;; <CJK>
     (?$A=d(B . ?\x6212) ;; <CJK>
     (?$A=e(B . ?\x85C9) ;; <CJK>
     (?$A=f(B . ?\x82A5) ;; <CJK>
     (?$A=g(B . ?\x754C) ;; <CJK>
     (?$A=h(B . ?\x501F) ;; <CJK>
     (?$A=i(B . ?\x4ECB) ;; <CJK>
     (?$A=j(B . ?\x75A5) ;; <CJK>
     (?$A=k(B . ?\x8BEB) ;; <CJK>
     (?$A=l(B . ?\x5C4A) ;; <CJK>
     (?$A=m(B . ?\x5DFE) ;; <CJK>
     (?$A=n(B . ?\x7B4B) ;; <CJK>
     (?$A=o(B . ?\x65A4) ;; <CJK>
     (?$A=p(B . ?\x91D1) ;; <CJK>
     (?$A=q(B . ?\x4ECA) ;; <CJK>
     (?$A=r(B . ?\x6D25) ;; <CJK>
     (?$A=s(B . ?\x895F) ;; <CJK>
     (?$A=t(B . ?\x7D27) ;; <CJK>
     (?$A=u(B . ?\x9526) ;; <CJK>
     (?$A=v(B . ?\x4EC5) ;; <CJK>
     (?$A=w(B . ?\x8C28) ;; <CJK>
     (?$A=x(B . ?\x8FDB) ;; <CJK>
     (?$A=y(B . ?\x9773) ;; <CJK>
     (?$A=z(B . ?\x664B) ;; <CJK>
     (?$A={(B . ?\x7981) ;; <CJK>
     (?$A=|(B . ?\x8FD1) ;; <CJK>
     (?$A=}(B . ?\x70EC) ;; <CJK>
     (?$A=~(B . ?\x6D78) ;; <CJK>
     (?$A>!(B . ?\x5C3D) ;; <CJK>
     (?$A>"(B . ?\x52B2) ;; <CJK>
     (?$A>#(B . ?\x8346) ;; <CJK>
     (?$A>$(B . ?\x5162) ;; <CJK>
     (?$A>%(B . ?\x830E) ;; <CJK>
     (?$A>&(B . ?\x775B) ;; <CJK>
     (?$A>'(B . ?\x6676) ;; <CJK>
     (?$A>((B . ?\x9CB8) ;; <CJK>
     (?$A>)(B . ?\x4EAC) ;; <CJK>
     (?$A>*(B . ?\x60CA) ;; <CJK>
     (?$A>+(B . ?\x7CBE) ;; <CJK>
     (?$A>,(B . ?\x7CB3) ;; <CJK>
     (?$A>-(B . ?\x7ECF) ;; <CJK>
     (?$A>.(B . ?\x4E95) ;; <CJK>
     (?$A>/(B . ?\x8B66) ;; <CJK>
     (?$A>0(B . ?\x666F) ;; <CJK>
     (?$A>1(B . ?\x9888) ;; <CJK>
     (?$A>2(B . ?\x9759) ;; <CJK>
     (?$A>3(B . ?\x5883) ;; <CJK>
     (?$A>4(B . ?\x656C) ;; <CJK>
     (?$A>5(B . ?\x955C) ;; <CJK>
     (?$A>6(B . ?\x5F84) ;; <CJK>
     (?$A>7(B . ?\x75C9) ;; <CJK>
     (?$A>8(B . ?\x9756) ;; <CJK>
     (?$A>9(B . ?\x7ADF) ;; <CJK>
     (?$A>:(B . ?\x7ADE) ;; <CJK>
     (?$A>;(B . ?\x51C0) ;; <CJK>
     (?$A><(B . ?\x70AF) ;; <CJK>
     (?$A>=(B . ?\x7A98) ;; <CJK>
     (?$A>>(B . ?\x63EA) ;; <CJK>
     (?$A>?(B . ?\x7A76) ;; <CJK>
     (?$A>@(B . ?\x7EA0) ;; <CJK>
     (?$A>A(B . ?\x7396) ;; <CJK>
     (?$A>B(B . ?\x97ED) ;; <CJK>
     (?$A>C(B . ?\x4E45) ;; <CJK>
     (?$A>D(B . ?\x7078) ;; <CJK>
     (?$A>E(B . ?\x4E5D) ;; <CJK>
     (?$A>F(B . ?\x9152) ;; <CJK>
     (?$A>G(B . ?\x53A9) ;; <CJK>
     (?$A>H(B . ?\x6551) ;; <CJK>
     (?$A>I(B . ?\x65E7) ;; <CJK>
     (?$A>J(B . ?\x81FC) ;; <CJK>
     (?$A>K(B . ?\x8205) ;; <CJK>
     (?$A>L(B . ?\x548E) ;; <CJK>
     (?$A>M(B . ?\x5C31) ;; <CJK>
     (?$A>N(B . ?\x759A) ;; <CJK>
     (?$A>O(B . ?\x97A0) ;; <CJK>
     (?$A>P(B . ?\x62D8) ;; <CJK>
     (?$A>Q(B . ?\x72D9) ;; <CJK>
     (?$A>R(B . ?\x75BD) ;; <CJK>
     (?$A>S(B . ?\x5C45) ;; <CJK>
     (?$A>T(B . ?\x9A79) ;; <CJK>
     (?$A>U(B . ?\x83CA) ;; <CJK>
     (?$A>V(B . ?\x5C40) ;; <CJK>
     (?$A>W(B . ?\x5480) ;; <CJK>
     (?$A>X(B . ?\x77E9) ;; <CJK>
     (?$A>Y(B . ?\x4E3E) ;; <CJK>
     (?$A>Z(B . ?\x6CAE) ;; <CJK>
     (?$A>[(B . ?\x805A) ;; <CJK>
     (?$A>\(B . ?\x62D2) ;; <CJK>
     (?$A>](B . ?\x636E) ;; <CJK>
     (?$A>^(B . ?\x5DE8) ;; <CJK>
     (?$A>_(B . ?\x5177) ;; <CJK>
     (?$A>`(B . ?\x8DDD) ;; <CJK>
     (?$A>a(B . ?\x8E1E) ;; <CJK>
     (?$A>b(B . ?\x952F) ;; <CJK>
     (?$A>c(B . ?\x4FF1) ;; <CJK>
     (?$A>d(B . ?\x53E5) ;; <CJK>
     (?$A>e(B . ?\x60E7) ;; <CJK>
     (?$A>f(B . ?\x70AC) ;; <CJK>
     (?$A>g(B . ?\x5267) ;; <CJK>
     (?$A>h(B . ?\x6350) ;; <CJK>
     (?$A>i(B . ?\x9E43) ;; <CJK>
     (?$A>j(B . ?\x5A1F) ;; <CJK>
     (?$A>k(B . ?\x5026) ;; <CJK>
     (?$A>l(B . ?\x7737) ;; <CJK>
     (?$A>m(B . ?\x5377) ;; <CJK>
     (?$A>n(B . ?\x7EE2) ;; <CJK>
     (?$A>o(B . ?\x6485) ;; <CJK>
     (?$A>p(B . ?\x652B) ;; <CJK>
     (?$A>q(B . ?\x6289) ;; <CJK>
     (?$A>r(B . ?\x6398) ;; <CJK>
     (?$A>s(B . ?\x5014) ;; <CJK>
     (?$A>t(B . ?\x7235) ;; <CJK>
     (?$A>u(B . ?\x89C9) ;; <CJK>
     (?$A>v(B . ?\x51B3) ;; <CJK>
     (?$A>w(B . ?\x8BC0) ;; <CJK>
     (?$A>x(B . ?\x7EDD) ;; <CJK>
     (?$A>y(B . ?\x5747) ;; <CJK>
     (?$A>z(B . ?\x83CC) ;; <CJK>
     (?$A>{(B . ?\x94A7) ;; <CJK>
     (?$A>|(B . ?\x519B) ;; <CJK>
     (?$A>}(B . ?\x541B) ;; <CJK>
     (?$A>~(B . ?\x5CFB) ;; <CJK>
     (?$A?!(B . ?\x4FCA) ;; <CJK>
     (?$A?"(B . ?\x7AE3) ;; <CJK>
     (?$A?#(B . ?\x6D5A) ;; <CJK>
     (?$A?$(B . ?\x90E1) ;; <CJK>
     (?$A?%(B . ?\x9A8F) ;; <CJK>
     (?$A?&(B . ?\x5580) ;; <CJK>
     (?$A?'(B . ?\x5496) ;; <CJK>
     (?$A?((B . ?\x5361) ;; <CJK>
     (?$A?)(B . ?\x54AF) ;; <CJK>
     (?$A?*(B . ?\x5F00) ;; <CJK>
     (?$A?+(B . ?\x63E9) ;; <CJK>
     (?$A?,(B . ?\x6977) ;; <CJK>
     (?$A?-(B . ?\x51EF) ;; <CJK>
     (?$A?.(B . ?\x6168) ;; <CJK>
     (?$A?/(B . ?\x520A) ;; <CJK>
     (?$A?0(B . ?\x582A) ;; <CJK>
     (?$A?1(B . ?\x52D8) ;; <CJK>
     (?$A?2(B . ?\x574E) ;; <CJK>
     (?$A?3(B . ?\x780D) ;; <CJK>
     (?$A?4(B . ?\x770B) ;; <CJK>
     (?$A?5(B . ?\x5EB7) ;; <CJK>
     (?$A?6(B . ?\x6177) ;; <CJK>
     (?$A?7(B . ?\x7CE0) ;; <CJK>
     (?$A?8(B . ?\x625B) ;; <CJK>
     (?$A?9(B . ?\x6297) ;; <CJK>
     (?$A?:(B . ?\x4EA2) ;; <CJK>
     (?$A?;(B . ?\x7095) ;; <CJK>
     (?$A?<(B . ?\x8003) ;; <CJK>
     (?$A?=(B . ?\x62F7) ;; <CJK>
     (?$A?>(B . ?\x70E4) ;; <CJK>
     (?$A??(B . ?\x9760) ;; <CJK>
     (?$A?@(B . ?\x5777) ;; <CJK>
     (?$A?A(B . ?\x82DB) ;; <CJK>
     (?$A?B(B . ?\x67EF) ;; <CJK>
     (?$A?C(B . ?\x68F5) ;; <CJK>
     (?$A?D(B . ?\x78D5) ;; <CJK>
     (?$A?E(B . ?\x9897) ;; <CJK>
     (?$A?F(B . ?\x79D1) ;; <CJK>
     (?$A?G(B . ?\x58F3) ;; <CJK>
     (?$A?H(B . ?\x54B3) ;; <CJK>
     (?$A?I(B . ?\x53EF) ;; <CJK>
     (?$A?J(B . ?\x6E34) ;; <CJK>
     (?$A?K(B . ?\x514B) ;; <CJK>
     (?$A?L(B . ?\x523B) ;; <CJK>
     (?$A?M(B . ?\x5BA2) ;; <CJK>
     (?$A?N(B . ?\x8BFE) ;; <CJK>
     (?$A?O(B . ?\x80AF) ;; <CJK>
     (?$A?P(B . ?\x5543) ;; <CJK>
     (?$A?Q(B . ?\x57A6) ;; <CJK>
     (?$A?R(B . ?\x6073) ;; <CJK>
     (?$A?S(B . ?\x5751) ;; <CJK>
     (?$A?T(B . ?\x542D) ;; <CJK>
     (?$A?U(B . ?\x7A7A) ;; <CJK>
     (?$A?V(B . ?\x6050) ;; <CJK>
     (?$A?W(B . ?\x5B54) ;; <CJK>
     (?$A?X(B . ?\x63A7) ;; <CJK>
     (?$A?Y(B . ?\x62A0) ;; <CJK>
     (?$A?Z(B . ?\x53E3) ;; <CJK>
     (?$A?[(B . ?\x6263) ;; <CJK>
     (?$A?\(B . ?\x5BC7) ;; <CJK>
     (?$A?](B . ?\x67AF) ;; <CJK>
     (?$A?^(B . ?\x54ED) ;; <CJK>
     (?$A?_(B . ?\x7A9F) ;; <CJK>
     (?$A?`(B . ?\x82E6) ;; <CJK>
     (?$A?a(B . ?\x9177) ;; <CJK>
     (?$A?b(B . ?\x5E93) ;; <CJK>
     (?$A?c(B . ?\x88E4) ;; <CJK>
     (?$A?d(B . ?\x5938) ;; <CJK>
     (?$A?e(B . ?\x57AE) ;; <CJK>
     (?$A?f(B . ?\x630E) ;; <CJK>
     (?$A?g(B . ?\x8DE8) ;; <CJK>
     (?$A?h(B . ?\x80EF) ;; <CJK>
     (?$A?i(B . ?\x5757) ;; <CJK>
     (?$A?j(B . ?\x7B77) ;; <CJK>
     (?$A?k(B . ?\x4FA9) ;; <CJK>
     (?$A?l(B . ?\x5FEB) ;; <CJK>
     (?$A?m(B . ?\x5BBD) ;; <CJK>
     (?$A?n(B . ?\x6B3E) ;; <CJK>
     (?$A?o(B . ?\x5321) ;; <CJK>
     (?$A?p(B . ?\x7B50) ;; <CJK>
     (?$A?q(B . ?\x72C2) ;; <CJK>
     (?$A?r(B . ?\x6846) ;; <CJK>
     (?$A?s(B . ?\x77FF) ;; <CJK>
     (?$A?t(B . ?\x7736) ;; <CJK>
     (?$A?u(B . ?\x65F7) ;; <CJK>
     (?$A?v(B . ?\x51B5) ;; <CJK>
     (?$A?w(B . ?\x4E8F) ;; <CJK>
     (?$A?x(B . ?\x76D4) ;; <CJK>
     (?$A?y(B . ?\x5CBF) ;; <CJK>
     (?$A?z(B . ?\x7AA5) ;; <CJK>
     (?$A?{(B . ?\x8475) ;; <CJK>
     (?$A?|(B . ?\x594E) ;; <CJK>
     (?$A?}(B . ?\x9B41) ;; <CJK>
     (?$A?~(B . ?\x5080) ;; <CJK>
     (?$A@!(B . ?\x9988) ;; <CJK>
     (?$A@"(B . ?\x6127) ;; <CJK>
     (?$A@#(B . ?\x6E83) ;; <CJK>
     (?$A@$(B . ?\x5764) ;; <CJK>
     (?$A@%(B . ?\x6606) ;; <CJK>
     (?$A@&(B . ?\x6346) ;; <CJK>
     (?$A@'(B . ?\x56F0) ;; <CJK>
     (?$A@((B . ?\x62EC) ;; <CJK>
     (?$A@)(B . ?\x6269) ;; <CJK>
     (?$A@*(B . ?\x5ED3) ;; <CJK>
     (?$A@+(B . ?\x9614) ;; <CJK>
     (?$A@,(B . ?\x5783) ;; <CJK>
     (?$A@-(B . ?\x62C9) ;; <CJK>
     (?$A@.(B . ?\x5587) ;; <CJK>
     (?$A@/(B . ?\x8721) ;; <CJK>
     (?$A@0(B . ?\x814A) ;; <CJK>
     (?$A@1(B . ?\x8FA3) ;; <CJK>
     (?$A@2(B . ?\x5566) ;; <CJK>
     (?$A@3(B . ?\x83B1) ;; <CJK>
     (?$A@4(B . ?\x6765) ;; <CJK>
     (?$A@5(B . ?\x8D56) ;; <CJK>
     (?$A@6(B . ?\x84DD) ;; <CJK>
     (?$A@7(B . ?\x5A6A) ;; <CJK>
     (?$A@8(B . ?\x680F) ;; <CJK>
     (?$A@9(B . ?\x62E6) ;; <CJK>
     (?$A@:(B . ?\x7BEE) ;; <CJK>
     (?$A@;(B . ?\x9611) ;; <CJK>
     (?$A@<(B . ?\x5170) ;; <CJK>
     (?$A@=(B . ?\x6F9C) ;; <CJK>
     (?$A@>(B . ?\x8C30) ;; <CJK>
     (?$A@?(B . ?\x63FD) ;; <CJK>
     (?$A@@(B . ?\x89C8) ;; <CJK>
     (?$A@A(B . ?\x61D2) ;; <CJK>
     (?$A@B(B . ?\x7F06) ;; <CJK>
     (?$A@C(B . ?\x70C2) ;; <CJK>
     (?$A@D(B . ?\x6EE5) ;; <CJK>
     (?$A@E(B . ?\x7405) ;; <CJK>
     (?$A@F(B . ?\x6994) ;; <CJK>
     (?$A@G(B . ?\x72FC) ;; <CJK>
     (?$A@H(B . ?\x5ECA) ;; <CJK>
     (?$A@I(B . ?\x90CE) ;; <CJK>
     (?$A@J(B . ?\x6717) ;; <CJK>
     (?$A@K(B . ?\x6D6A) ;; <CJK>
     (?$A@L(B . ?\x635E) ;; <CJK>
     (?$A@M(B . ?\x52B3) ;; <CJK>
     (?$A@N(B . ?\x7262) ;; <CJK>
     (?$A@O(B . ?\x8001) ;; <CJK>
     (?$A@P(B . ?\x4F6C) ;; <CJK>
     (?$A@Q(B . ?\x59E5) ;; <CJK>
     (?$A@R(B . ?\x916A) ;; <CJK>
     (?$A@S(B . ?\x70D9) ;; <CJK>
     (?$A@T(B . ?\x6D9D) ;; <CJK>
     (?$A@U(B . ?\x52D2) ;; <CJK>
     (?$A@V(B . ?\x4E50) ;; <CJK>
     (?$A@W(B . ?\x96F7) ;; <CJK>
     (?$A@X(B . ?\x956D) ;; <CJK>
     (?$A@Y(B . ?\x857E) ;; <CJK>
     (?$A@Z(B . ?\x78CA) ;; <CJK>
     (?$A@[(B . ?\x7D2F) ;; <CJK>
     (?$A@\(B . ?\x5121) ;; <CJK>
     (?$A@](B . ?\x5792) ;; <CJK>
     (?$A@^(B . ?\x64C2) ;; <CJK>
     (?$A@_(B . ?\x808B) ;; <CJK>
     (?$A@`(B . ?\x7C7B) ;; <CJK>
     (?$A@a(B . ?\x6CEA) ;; <CJK>
     (?$A@b(B . ?\x68F1) ;; <CJK>
     (?$A@c(B . ?\x695E) ;; <CJK>
     (?$A@d(B . ?\x51B7) ;; <CJK>
     (?$A@e(B . ?\x5398) ;; <CJK>
     (?$A@f(B . ?\x68A8) ;; <CJK>
     (?$A@g(B . ?\x7281) ;; <CJK>
     (?$A@h(B . ?\x9ECE) ;; <CJK>
     (?$A@i(B . ?\x7BF1) ;; <CJK>
     (?$A@j(B . ?\x72F8) ;; <CJK>
     (?$A@k(B . ?\x79BB) ;; <CJK>
     (?$A@l(B . ?\x6F13) ;; <CJK>
     (?$A@m(B . ?\x7406) ;; <CJK>
     (?$A@n(B . ?\x674E) ;; <CJK>
     (?$A@o(B . ?\x91CC) ;; <CJK>
     (?$A@p(B . ?\x9CA4) ;; <CJK>
     (?$A@q(B . ?\x793C) ;; <CJK>
     (?$A@r(B . ?\x8389) ;; <CJK>
     (?$A@s(B . ?\x8354) ;; <CJK>
     (?$A@t(B . ?\x540F) ;; <CJK>
     (?$A@u(B . ?\x6817) ;; <CJK>
     (?$A@v(B . ?\x4E3D) ;; <CJK>
     (?$A@w(B . ?\x5389) ;; <CJK>
     (?$A@x(B . ?\x52B1) ;; <CJK>
     (?$A@y(B . ?\x783E) ;; <CJK>
     (?$A@z(B . ?\x5386) ;; <CJK>
     (?$A@{(B . ?\x5229) ;; <CJK>
     (?$A@|(B . ?\x5088) ;; <CJK>
     (?$A@}(B . ?\x4F8B) ;; <CJK>
     (?$A@~(B . ?\x4FD0) ;; <CJK>
     (?$AA!(B . ?\x75E2) ;; <CJK>
     (?$AA"(B . ?\x7ACB) ;; <CJK>
     (?$AA#(B . ?\x7C92) ;; <CJK>
     (?$AA$(B . ?\x6CA5) ;; <CJK>
     (?$AA%(B . ?\x96B6) ;; <CJK>
     (?$AA&(B . ?\x529B) ;; <CJK>
     (?$AA'(B . ?\x7483) ;; <CJK>
     (?$AA((B . ?\x54E9) ;; <CJK>
     (?$AA)(B . ?\x4FE9) ;; <CJK>
     (?$AA*(B . ?\x8054) ;; <CJK>
     (?$AA+(B . ?\x83B2) ;; <CJK>
     (?$AA,(B . ?\x8FDE) ;; <CJK>
     (?$AA-(B . ?\x9570) ;; <CJK>
     (?$AA.(B . ?\x5EC9) ;; <CJK>
     (?$AA/(B . ?\x601C) ;; <CJK>
     (?$AA0(B . ?\x6D9F) ;; <CJK>
     (?$AA1(B . ?\x5E18) ;; <CJK>
     (?$AA2(B . ?\x655B) ;; <CJK>
     (?$AA3(B . ?\x8138) ;; <CJK>
     (?$AA4(B . ?\x94FE) ;; <CJK>
     (?$AA5(B . ?\x604B) ;; <CJK>
     (?$AA6(B . ?\x70BC) ;; <CJK>
     (?$AA7(B . ?\x7EC3) ;; <CJK>
     (?$AA8(B . ?\x7CAE) ;; <CJK>
     (?$AA9(B . ?\x51C9) ;; <CJK>
     (?$AA:(B . ?\x6881) ;; <CJK>
     (?$AA;(B . ?\x7CB1) ;; <CJK>
     (?$AA<(B . ?\x826F) ;; <CJK>
     (?$AA=(B . ?\x4E24) ;; <CJK>
     (?$AA>(B . ?\x8F86) ;; <CJK>
     (?$AA?(B . ?\x91CF) ;; <CJK>
     (?$AA@(B . ?\x667E) ;; <CJK>
     (?$AAA(B . ?\x4EAE) ;; <CJK>
     (?$AAB(B . ?\x8C05) ;; <CJK>
     (?$AAC(B . ?\x64A9) ;; <CJK>
     (?$AAD(B . ?\x804A) ;; <CJK>
     (?$AAE(B . ?\x50DA) ;; <CJK>
     (?$AAF(B . ?\x7597) ;; <CJK>
     (?$AAG(B . ?\x71CE) ;; <CJK>
     (?$AAH(B . ?\x5BE5) ;; <CJK>
     (?$AAI(B . ?\x8FBD) ;; <CJK>
     (?$AAJ(B . ?\x6F66) ;; <CJK>
     (?$AAK(B . ?\x4E86) ;; <CJK>
     (?$AAL(B . ?\x6482) ;; <CJK>
     (?$AAM(B . ?\x9563) ;; <CJK>
     (?$AAN(B . ?\x5ED6) ;; <CJK>
     (?$AAO(B . ?\x6599) ;; <CJK>
     (?$AAP(B . ?\x5217) ;; <CJK>
     (?$AAQ(B . ?\x88C2) ;; <CJK>
     (?$AAR(B . ?\x70C8) ;; <CJK>
     (?$AAS(B . ?\x52A3) ;; <CJK>
     (?$AAT(B . ?\x730E) ;; <CJK>
     (?$AAU(B . ?\x7433) ;; <CJK>
     (?$AAV(B . ?\x6797) ;; <CJK>
     (?$AAW(B . ?\x78F7) ;; <CJK>
     (?$AAX(B . ?\x9716) ;; <CJK>
     (?$AAY(B . ?\x4E34) ;; <CJK>
     (?$AAZ(B . ?\x90BB) ;; <CJK>
     (?$AA[(B . ?\x9CDE) ;; <CJK>
     (?$AA\(B . ?\x6DCB) ;; <CJK>
     (?$AA](B . ?\x51DB) ;; <CJK>
     (?$AA^(B . ?\x8D41) ;; <CJK>
     (?$AA_(B . ?\x541D) ;; <CJK>
     (?$AA`(B . ?\x62CE) ;; <CJK>
     (?$AAa(B . ?\x73B2) ;; <CJK>
     (?$AAb(B . ?\x83F1) ;; <CJK>
     (?$AAc(B . ?\x96F6) ;; <CJK>
     (?$AAd(B . ?\x9F84) ;; <CJK>
     (?$AAe(B . ?\x94C3) ;; <CJK>
     (?$AAf(B . ?\x4F36) ;; <CJK>
     (?$AAg(B . ?\x7F9A) ;; <CJK>
     (?$AAh(B . ?\x51CC) ;; <CJK>
     (?$AAi(B . ?\x7075) ;; <CJK>
     (?$AAj(B . ?\x9675) ;; <CJK>
     (?$AAk(B . ?\x5CAD) ;; <CJK>
     (?$AAl(B . ?\x9886) ;; <CJK>
     (?$AAm(B . ?\x53E6) ;; <CJK>
     (?$AAn(B . ?\x4EE4) ;; <CJK>
     (?$AAo(B . ?\x6E9C) ;; <CJK>
     (?$AAp(B . ?\x7409) ;; <CJK>
     (?$AAq(B . ?\x69B4) ;; <CJK>
     (?$AAr(B . ?\x786B) ;; <CJK>
     (?$AAs(B . ?\x998F) ;; <CJK>
     (?$AAt(B . ?\x7559) ;; <CJK>
     (?$AAu(B . ?\x5218) ;; <CJK>
     (?$AAv(B . ?\x7624) ;; <CJK>
     (?$AAw(B . ?\x6D41) ;; <CJK>
     (?$AAx(B . ?\x67F3) ;; <CJK>
     (?$AAy(B . ?\x516D) ;; <CJK>
     (?$AAz(B . ?\x9F99) ;; <CJK>
     (?$AA{(B . ?\x804B) ;; <CJK>
     (?$AA|(B . ?\x5499) ;; <CJK>
     (?$AA}(B . ?\x7B3C) ;; <CJK>
     (?$AA~(B . ?\x7ABF) ;; <CJK>
     (?$AB!(B . ?\x9686) ;; <CJK>
     (?$AB"(B . ?\x5784) ;; <CJK>
     (?$AB#(B . ?\x62E2) ;; <CJK>
     (?$AB$(B . ?\x9647) ;; <CJK>
     (?$AB%(B . ?\x697C) ;; <CJK>
     (?$AB&(B . ?\x5A04) ;; <CJK>
     (?$AB'(B . ?\x6402) ;; <CJK>
     (?$AB((B . ?\x7BD3) ;; <CJK>
     (?$AB)(B . ?\x6F0F) ;; <CJK>
     (?$AB*(B . ?\x964B) ;; <CJK>
     (?$AB+(B . ?\x82A6) ;; <CJK>
     (?$AB,(B . ?\x5362) ;; <CJK>
     (?$AB-(B . ?\x9885) ;; <CJK>
     (?$AB.(B . ?\x5E90) ;; <CJK>
     (?$AB/(B . ?\x7089) ;; <CJK>
     (?$AB0(B . ?\x63B3) ;; <CJK>
     (?$AB1(B . ?\x5364) ;; <CJK>
     (?$AB2(B . ?\x864F) ;; <CJK>
     (?$AB3(B . ?\x9C81) ;; <CJK>
     (?$AB4(B . ?\x9E93) ;; <CJK>
     (?$AB5(B . ?\x788C) ;; <CJK>
     (?$AB6(B . ?\x9732) ;; <CJK>
     (?$AB7(B . ?\x8DEF) ;; <CJK>
     (?$AB8(B . ?\x8D42) ;; <CJK>
     (?$AB9(B . ?\x9E7F) ;; <CJK>
     (?$AB:(B . ?\x6F5E) ;; <CJK>
     (?$AB;(B . ?\x7984) ;; <CJK>
     (?$AB<(B . ?\x5F55) ;; <CJK>
     (?$AB=(B . ?\x9646) ;; <CJK>
     (?$AB>(B . ?\x622E) ;; <CJK>
     (?$AB?(B . ?\x9A74) ;; <CJK>
     (?$AB@(B . ?\x5415) ;; <CJK>
     (?$ABA(B . ?\x94DD) ;; <CJK>
     (?$ABB(B . ?\x4FA3) ;; <CJK>
     (?$ABC(B . ?\x65C5) ;; <CJK>
     (?$ABD(B . ?\x5C65) ;; <CJK>
     (?$ABE(B . ?\x5C61) ;; <CJK>
     (?$ABF(B . ?\x7F15) ;; <CJK>
     (?$ABG(B . ?\x8651) ;; <CJK>
     (?$ABH(B . ?\x6C2F) ;; <CJK>
     (?$ABI(B . ?\x5F8B) ;; <CJK>
     (?$ABJ(B . ?\x7387) ;; <CJK>
     (?$ABK(B . ?\x6EE4) ;; <CJK>
     (?$ABL(B . ?\x7EFF) ;; <CJK>
     (?$ABM(B . ?\x5CE6) ;; <CJK>
     (?$ABN(B . ?\x631B) ;; <CJK>
     (?$ABO(B . ?\x5B6A) ;; <CJK>
     (?$ABP(B . ?\x6EE6) ;; <CJK>
     (?$ABQ(B . ?\x5375) ;; <CJK>
     (?$ABR(B . ?\x4E71) ;; <CJK>
     (?$ABS(B . ?\x63A0) ;; <CJK>
     (?$ABT(B . ?\x7565) ;; <CJK>
     (?$ABU(B . ?\x62A1) ;; <CJK>
     (?$ABV(B . ?\x8F6E) ;; <CJK>
     (?$ABW(B . ?\x4F26) ;; <CJK>
     (?$ABX(B . ?\x4ED1) ;; <CJK>
     (?$ABY(B . ?\x6CA6) ;; <CJK>
     (?$ABZ(B . ?\x7EB6) ;; <CJK>
     (?$AB[(B . ?\x8BBA) ;; <CJK>
     (?$AB\(B . ?\x841D) ;; <CJK>
     (?$AB](B . ?\x87BA) ;; <CJK>
     (?$AB^(B . ?\x7F57) ;; <CJK>
     (?$AB_(B . ?\x903B) ;; <CJK>
     (?$AB`(B . ?\x9523) ;; <CJK>
     (?$ABa(B . ?\x7BA9) ;; <CJK>
     (?$ABb(B . ?\x9AA1) ;; <CJK>
     (?$ABc(B . ?\x88F8) ;; <CJK>
     (?$ABd(B . ?\x843D) ;; <CJK>
     (?$ABe(B . ?\x6D1B) ;; <CJK>
     (?$ABf(B . ?\x9A86) ;; <CJK>
     (?$ABg(B . ?\x7EDC) ;; <CJK>
     (?$ABh(B . ?\x5988) ;; <CJK>
     (?$ABi(B . ?\x9EBB) ;; <CJK>
     (?$ABj(B . ?\x739B) ;; <CJK>
     (?$ABk(B . ?\x7801) ;; <CJK>
     (?$ABl(B . ?\x8682) ;; <CJK>
     (?$ABm(B . ?\x9A6C) ;; <CJK>
     (?$ABn(B . ?\x9A82) ;; <CJK>
     (?$ABo(B . ?\x561B) ;; <CJK>
     (?$ABp(B . ?\x5417) ;; <CJK>
     (?$ABq(B . ?\x57CB) ;; <CJK>
     (?$ABr(B . ?\x4E70) ;; <CJK>
     (?$ABs(B . ?\x9EA6) ;; <CJK>
     (?$ABt(B . ?\x5356) ;; <CJK>
     (?$ABu(B . ?\x8FC8) ;; <CJK>
     (?$ABv(B . ?\x8109) ;; <CJK>
     (?$ABw(B . ?\x7792) ;; <CJK>
     (?$ABx(B . ?\x9992) ;; <CJK>
     (?$ABy(B . ?\x86EE) ;; <CJK>
     (?$ABz(B . ?\x6EE1) ;; <CJK>
     (?$AB{(B . ?\x8513) ;; <CJK>
     (?$AB|(B . ?\x66FC) ;; <CJK>
     (?$AB}(B . ?\x6162) ;; <CJK>
     (?$AB~(B . ?\x6F2B) ;; <CJK>
     (?$AC!(B . ?\x8C29) ;; <CJK>
     (?$AC"(B . ?\x8292) ;; <CJK>
     (?$AC#(B . ?\x832B) ;; <CJK>
     (?$AC$(B . ?\x76F2) ;; <CJK>
     (?$AC%(B . ?\x6C13) ;; <CJK>
     (?$AC&(B . ?\x5FD9) ;; <CJK>
     (?$AC'(B . ?\x83BD) ;; <CJK>
     (?$AC((B . ?\x732B) ;; <CJK>
     (?$AC)(B . ?\x8305) ;; <CJK>
     (?$AC*(B . ?\x951A) ;; <CJK>
     (?$AC+(B . ?\x6BDB) ;; <CJK>
     (?$AC,(B . ?\x77DB) ;; <CJK>
     (?$AC-(B . ?\x94C6) ;; <CJK>
     (?$AC.(B . ?\x536F) ;; <CJK>
     (?$AC/(B . ?\x8302) ;; <CJK>
     (?$AC0(B . ?\x5192) ;; <CJK>
     (?$AC1(B . ?\x5E3D) ;; <CJK>
     (?$AC2(B . ?\x8C8C) ;; <CJK>
     (?$AC3(B . ?\x8D38) ;; <CJK>
     (?$AC4(B . ?\x4E48) ;; <CJK>
     (?$AC5(B . ?\x73AB) ;; <CJK>
     (?$AC6(B . ?\x679A) ;; <CJK>
     (?$AC7(B . ?\x6885) ;; <CJK>
     (?$AC8(B . ?\x9176) ;; <CJK>
     (?$AC9(B . ?\x9709) ;; <CJK>
     (?$AC:(B . ?\x7164) ;; <CJK>
     (?$AC;(B . ?\x6CA1) ;; <CJK>
     (?$AC<(B . ?\x7709) ;; <CJK>
     (?$AC=(B . ?\x5A92) ;; <CJK>
     (?$AC>(B . ?\x9541) ;; <CJK>
     (?$AC?(B . ?\x6BCF) ;; <CJK>
     (?$AC@(B . ?\x7F8E) ;; <CJK>
     (?$ACA(B . ?\x6627) ;; <CJK>
     (?$ACB(B . ?\x5BD0) ;; <CJK>
     (?$ACC(B . ?\x59B9) ;; <CJK>
     (?$ACD(B . ?\x5A9A) ;; <CJK>
     (?$ACE(B . ?\x95E8) ;; <CJK>
     (?$ACF(B . ?\x95F7) ;; <CJK>
     (?$ACG(B . ?\x4EEC) ;; <CJK>
     (?$ACH(B . ?\x840C) ;; <CJK>
     (?$ACI(B . ?\x8499) ;; <CJK>
     (?$ACJ(B . ?\x6AAC) ;; <CJK>
     (?$ACK(B . ?\x76DF) ;; <CJK>
     (?$ACL(B . ?\x9530) ;; <CJK>
     (?$ACM(B . ?\x731B) ;; <CJK>
     (?$ACN(B . ?\x68A6) ;; <CJK>
     (?$ACO(B . ?\x5B5F) ;; <CJK>
     (?$ACP(B . ?\x772F) ;; <CJK>
     (?$ACQ(B . ?\x919A) ;; <CJK>
     (?$ACR(B . ?\x9761) ;; <CJK>
     (?$ACS(B . ?\x7CDC) ;; <CJK>
     (?$ACT(B . ?\x8FF7) ;; <CJK>
     (?$ACU(B . ?\x8C1C) ;; <CJK>
     (?$ACV(B . ?\x5F25) ;; <CJK>
     (?$ACW(B . ?\x7C73) ;; <CJK>
     (?$ACX(B . ?\x79D8) ;; <CJK>
     (?$ACY(B . ?\x89C5) ;; <CJK>
     (?$ACZ(B . ?\x6CCC) ;; <CJK>
     (?$AC[(B . ?\x871C) ;; <CJK>
     (?$AC\(B . ?\x5BC6) ;; <CJK>
     (?$AC](B . ?\x5E42) ;; <CJK>
     (?$AC^(B . ?\x68C9) ;; <CJK>
     (?$AC_(B . ?\x7720) ;; <CJK>
     (?$AC`(B . ?\x7EF5) ;; <CJK>
     (?$ACa(B . ?\x5195) ;; <CJK>
     (?$ACb(B . ?\x514D) ;; <CJK>
     (?$ACc(B . ?\x52C9) ;; <CJK>
     (?$ACd(B . ?\x5A29) ;; <CJK>
     (?$ACe(B . ?\x7F05) ;; <CJK>
     (?$ACf(B . ?\x9762) ;; <CJK>
     (?$ACg(B . ?\x82D7) ;; <CJK>
     (?$ACh(B . ?\x63CF) ;; <CJK>
     (?$ACi(B . ?\x7784) ;; <CJK>
     (?$ACj(B . ?\x85D0) ;; <CJK>
     (?$ACk(B . ?\x79D2) ;; <CJK>
     (?$ACl(B . ?\x6E3A) ;; <CJK>
     (?$ACm(B . ?\x5E99) ;; <CJK>
     (?$ACn(B . ?\x5999) ;; <CJK>
     (?$ACo(B . ?\x8511) ;; <CJK>
     (?$ACp(B . ?\x706D) ;; <CJK>
     (?$ACq(B . ?\x6C11) ;; <CJK>
     (?$ACr(B . ?\x62BF) ;; <CJK>
     (?$ACs(B . ?\x76BF) ;; <CJK>
     (?$ACt(B . ?\x654F) ;; <CJK>
     (?$ACu(B . ?\x60AF) ;; <CJK>
     (?$ACv(B . ?\x95FD) ;; <CJK>
     (?$ACw(B . ?\x660E) ;; <CJK>
     (?$ACx(B . ?\x879F) ;; <CJK>
     (?$ACy(B . ?\x9E23) ;; <CJK>
     (?$ACz(B . ?\x94ED) ;; <CJK>
     (?$AC{(B . ?\x540D) ;; <CJK>
     (?$AC|(B . ?\x547D) ;; <CJK>
     (?$AC}(B . ?\x8C2C) ;; <CJK>
     (?$AC~(B . ?\x6478) ;; <CJK>
     (?$AD!(B . ?\x6479) ;; <CJK>
     (?$AD"(B . ?\x8611) ;; <CJK>
     (?$AD#(B . ?\x6A21) ;; <CJK>
     (?$AD$(B . ?\x819C) ;; <CJK>
     (?$AD%(B . ?\x78E8) ;; <CJK>
     (?$AD&(B . ?\x6469) ;; <CJK>
     (?$AD'(B . ?\x9B54) ;; <CJK>
     (?$AD((B . ?\x62B9) ;; <CJK>
     (?$AD)(B . ?\x672B) ;; <CJK>
     (?$AD*(B . ?\x83AB) ;; <CJK>
     (?$AD+(B . ?\x58A8) ;; <CJK>
     (?$AD,(B . ?\x9ED8) ;; <CJK>
     (?$AD-(B . ?\x6CAB) ;; <CJK>
     (?$AD.(B . ?\x6F20) ;; <CJK>
     (?$AD/(B . ?\x5BDE) ;; <CJK>
     (?$AD0(B . ?\x964C) ;; <CJK>
     (?$AD1(B . ?\x8C0B) ;; <CJK>
     (?$AD2(B . ?\x725F) ;; <CJK>
     (?$AD3(B . ?\x67D0) ;; <CJK>
     (?$AD4(B . ?\x62C7) ;; <CJK>
     (?$AD5(B . ?\x7261) ;; <CJK>
     (?$AD6(B . ?\x4EA9) ;; <CJK>
     (?$AD7(B . ?\x59C6) ;; <CJK>
     (?$AD8(B . ?\x6BCD) ;; <CJK>
     (?$AD9(B . ?\x5893) ;; <CJK>
     (?$AD:(B . ?\x66AE) ;; <CJK>
     (?$AD;(B . ?\x5E55) ;; <CJK>
     (?$AD<(B . ?\x52DF) ;; <CJK>
     (?$AD=(B . ?\x6155) ;; <CJK>
     (?$AD>(B . ?\x6728) ;; <CJK>
     (?$AD?(B . ?\x76EE) ;; <CJK>
     (?$AD@(B . ?\x7766) ;; <CJK>
     (?$ADA(B . ?\x7267) ;; <CJK>
     (?$ADB(B . ?\x7A46) ;; <CJK>
     (?$ADC(B . ?\x62FF) ;; <CJK>
     (?$ADD(B . ?\x54EA) ;; <CJK>
     (?$ADE(B . ?\x5450) ;; <CJK>
     (?$ADF(B . ?\x94A0) ;; <CJK>
     (?$ADG(B . ?\x90A3) ;; <CJK>
     (?$ADH(B . ?\x5A1C) ;; <CJK>
     (?$ADI(B . ?\x7EB3) ;; <CJK>
     (?$ADJ(B . ?\x6C16) ;; <CJK>
     (?$ADK(B . ?\x4E43) ;; <CJK>
     (?$ADL(B . ?\x5976) ;; <CJK>
     (?$ADM(B . ?\x8010) ;; <CJK>
     (?$ADN(B . ?\x5948) ;; <CJK>
     (?$ADO(B . ?\x5357) ;; <CJK>
     (?$ADP(B . ?\x7537) ;; <CJK>
     (?$ADQ(B . ?\x96BE) ;; <CJK>
     (?$ADR(B . ?\x56CA) ;; <CJK>
     (?$ADS(B . ?\x6320) ;; <CJK>
     (?$ADT(B . ?\x8111) ;; <CJK>
     (?$ADU(B . ?\x607C) ;; <CJK>
     (?$ADV(B . ?\x95F9) ;; <CJK>
     (?$ADW(B . ?\x6DD6) ;; <CJK>
     (?$ADX(B . ?\x5462) ;; <CJK>
     (?$ADY(B . ?\x9981) ;; <CJK>
     (?$ADZ(B . ?\x5185) ;; <CJK>
     (?$AD[(B . ?\x5AE9) ;; <CJK>
     (?$AD\(B . ?\x80FD) ;; <CJK>
     (?$AD](B . ?\x59AE) ;; <CJK>
     (?$AD^(B . ?\x9713) ;; <CJK>
     (?$AD_(B . ?\x502A) ;; <CJK>
     (?$AD`(B . ?\x6CE5) ;; <CJK>
     (?$ADa(B . ?\x5C3C) ;; <CJK>
     (?$ADb(B . ?\x62DF) ;; <CJK>
     (?$ADc(B . ?\x4F60) ;; <CJK>
     (?$ADd(B . ?\x533F) ;; <CJK>
     (?$ADe(B . ?\x817B) ;; <CJK>
     (?$ADf(B . ?\x9006) ;; <CJK>
     (?$ADg(B . ?\x6EBA) ;; <CJK>
     (?$ADh(B . ?\x852B) ;; <CJK>
     (?$ADi(B . ?\x62C8) ;; <CJK>
     (?$ADj(B . ?\x5E74) ;; <CJK>
     (?$ADk(B . ?\x78BE) ;; <CJK>
     (?$ADl(B . ?\x64B5) ;; <CJK>
     (?$ADm(B . ?\x637B) ;; <CJK>
     (?$ADn(B . ?\x5FF5) ;; <CJK>
     (?$ADo(B . ?\x5A18) ;; <CJK>
     (?$ADp(B . ?\x917F) ;; <CJK>
     (?$ADq(B . ?\x9E1F) ;; <CJK>
     (?$ADr(B . ?\x5C3F) ;; <CJK>
     (?$ADs(B . ?\x634F) ;; <CJK>
     (?$ADt(B . ?\x8042) ;; <CJK>
     (?$ADu(B . ?\x5B7D) ;; <CJK>
     (?$ADv(B . ?\x556E) ;; <CJK>
     (?$ADw(B . ?\x954A) ;; <CJK>
     (?$ADx(B . ?\x954D) ;; <CJK>
     (?$ADy(B . ?\x6D85) ;; <CJK>
     (?$ADz(B . ?\x60A8) ;; <CJK>
     (?$AD{(B . ?\x67E0) ;; <CJK>
     (?$AD|(B . ?\x72DE) ;; <CJK>
     (?$AD}(B . ?\x51DD) ;; <CJK>
     (?$AD~(B . ?\x5B81) ;; <CJK>
     (?$AE!(B . ?\x62E7) ;; <CJK>
     (?$AE"(B . ?\x6CDE) ;; <CJK>
     (?$AE#(B . ?\x725B) ;; <CJK>
     (?$AE$(B . ?\x626D) ;; <CJK>
     (?$AE%(B . ?\x94AE) ;; <CJK>
     (?$AE&(B . ?\x7EBD) ;; <CJK>
     (?$AE'(B . ?\x8113) ;; <CJK>
     (?$AE((B . ?\x6D53) ;; <CJK>
     (?$AE)(B . ?\x519C) ;; <CJK>
     (?$AE*(B . ?\x5F04) ;; <CJK>
     (?$AE+(B . ?\x5974) ;; <CJK>
     (?$AE,(B . ?\x52AA) ;; <CJK>
     (?$AE-(B . ?\x6012) ;; <CJK>
     (?$AE.(B . ?\x5973) ;; <CJK>
     (?$AE/(B . ?\x6696) ;; <CJK>
     (?$AE0(B . ?\x8650) ;; <CJK>
     (?$AE1(B . ?\x759F) ;; <CJK>
     (?$AE2(B . ?\x632A) ;; <CJK>
     (?$AE3(B . ?\x61E6) ;; <CJK>
     (?$AE4(B . ?\x7CEF) ;; <CJK>
     (?$AE5(B . ?\x8BFA) ;; <CJK>
     (?$AE6(B . ?\x54E6) ;; <CJK>
     (?$AE7(B . ?\x6B27) ;; <CJK>
     (?$AE8(B . ?\x9E25) ;; <CJK>
     (?$AE9(B . ?\x6BB4) ;; <CJK>
     (?$AE:(B . ?\x85D5) ;; <CJK>
     (?$AE;(B . ?\x5455) ;; <CJK>
     (?$AE<(B . ?\x5076) ;; <CJK>
     (?$AE=(B . ?\x6CA4) ;; <CJK>
     (?$AE>(B . ?\x556A) ;; <CJK>
     (?$AE?(B . ?\x8DB4) ;; <CJK>
     (?$AE@(B . ?\x722C) ;; <CJK>
     (?$AEA(B . ?\x5E15) ;; <CJK>
     (?$AEB(B . ?\x6015) ;; <CJK>
     (?$AEC(B . ?\x7436) ;; <CJK>
     (?$AED(B . ?\x62CD) ;; <CJK>
     (?$AEE(B . ?\x6392) ;; <CJK>
     (?$AEF(B . ?\x724C) ;; <CJK>
     (?$AEG(B . ?\x5F98) ;; <CJK>
     (?$AEH(B . ?\x6E43) ;; <CJK>
     (?$AEI(B . ?\x6D3E) ;; <CJK>
     (?$AEJ(B . ?\x6500) ;; <CJK>
     (?$AEK(B . ?\x6F58) ;; <CJK>
     (?$AEL(B . ?\x76D8) ;; <CJK>
     (?$AEM(B . ?\x78D0) ;; <CJK>
     (?$AEN(B . ?\x76FC) ;; <CJK>
     (?$AEO(B . ?\x7554) ;; <CJK>
     (?$AEP(B . ?\x5224) ;; <CJK>
     (?$AEQ(B . ?\x53DB) ;; <CJK>
     (?$AER(B . ?\x4E53) ;; <CJK>
     (?$AES(B . ?\x5E9E) ;; <CJK>
     (?$AET(B . ?\x65C1) ;; <CJK>
     (?$AEU(B . ?\x802A) ;; <CJK>
     (?$AEV(B . ?\x80D6) ;; <CJK>
     (?$AEW(B . ?\x629B) ;; <CJK>
     (?$AEX(B . ?\x5486) ;; <CJK>
     (?$AEY(B . ?\x5228) ;; <CJK>
     (?$AEZ(B . ?\x70AE) ;; <CJK>
     (?$AE[(B . ?\x888D) ;; <CJK>
     (?$AE\(B . ?\x8DD1) ;; <CJK>
     (?$AE](B . ?\x6CE1) ;; <CJK>
     (?$AE^(B . ?\x5478) ;; <CJK>
     (?$AE_(B . ?\x80DA) ;; <CJK>
     (?$AE`(B . ?\x57F9) ;; <CJK>
     (?$AEa(B . ?\x88F4) ;; <CJK>
     (?$AEb(B . ?\x8D54) ;; <CJK>
     (?$AEc(B . ?\x966A) ;; <CJK>
     (?$AEd(B . ?\x914D) ;; <CJK>
     (?$AEe(B . ?\x4F69) ;; <CJK>
     (?$AEf(B . ?\x6C9B) ;; <CJK>
     (?$AEg(B . ?\x55B7) ;; <CJK>
     (?$AEh(B . ?\x76C6) ;; <CJK>
     (?$AEi(B . ?\x7830) ;; <CJK>
     (?$AEj(B . ?\x62A8) ;; <CJK>
     (?$AEk(B . ?\x70F9) ;; <CJK>
     (?$AEl(B . ?\x6F8E) ;; <CJK>
     (?$AEm(B . ?\x5F6D) ;; <CJK>
     (?$AEn(B . ?\x84EC) ;; <CJK>
     (?$AEo(B . ?\x68DA) ;; <CJK>
     (?$AEp(B . ?\x787C) ;; <CJK>
     (?$AEq(B . ?\x7BF7) ;; <CJK>
     (?$AEr(B . ?\x81A8) ;; <CJK>
     (?$AEs(B . ?\x670B) ;; <CJK>
     (?$AEt(B . ?\x9E4F) ;; <CJK>
     (?$AEu(B . ?\x6367) ;; <CJK>
     (?$AEv(B . ?\x78B0) ;; <CJK>
     (?$AEw(B . ?\x576F) ;; <CJK>
     (?$AEx(B . ?\x7812) ;; <CJK>
     (?$AEy(B . ?\x9739) ;; <CJK>
     (?$AEz(B . ?\x6279) ;; <CJK>
     (?$AE{(B . ?\x62AB) ;; <CJK>
     (?$AE|(B . ?\x5288) ;; <CJK>
     (?$AE}(B . ?\x7435) ;; <CJK>
     (?$AE~(B . ?\x6BD7) ;; <CJK>
     (?$AF!(B . ?\x5564) ;; <CJK>
     (?$AF"(B . ?\x813E) ;; <CJK>
     (?$AF#(B . ?\x75B2) ;; <CJK>
     (?$AF$(B . ?\x76AE) ;; <CJK>
     (?$AF%(B . ?\x5339) ;; <CJK>
     (?$AF&(B . ?\x75DE) ;; <CJK>
     (?$AF'(B . ?\x50FB) ;; <CJK>
     (?$AF((B . ?\x5C41) ;; <CJK>
     (?$AF)(B . ?\x8B6C) ;; <CJK>
     (?$AF*(B . ?\x7BC7) ;; <CJK>
     (?$AF+(B . ?\x504F) ;; <CJK>
     (?$AF,(B . ?\x7247) ;; <CJK>
     (?$AF-(B . ?\x9A97) ;; <CJK>
     (?$AF.(B . ?\x98D8) ;; <CJK>
     (?$AF/(B . ?\x6F02) ;; <CJK>
     (?$AF0(B . ?\x74E2) ;; <CJK>
     (?$AF1(B . ?\x7968) ;; <CJK>
     (?$AF2(B . ?\x6487) ;; <CJK>
     (?$AF3(B . ?\x77A5) ;; <CJK>
     (?$AF4(B . ?\x62FC) ;; <CJK>
     (?$AF5(B . ?\x9891) ;; <CJK>
     (?$AF6(B . ?\x8D2B) ;; <CJK>
     (?$AF7(B . ?\x54C1) ;; <CJK>
     (?$AF8(B . ?\x8058) ;; <CJK>
     (?$AF9(B . ?\x4E52) ;; <CJK>
     (?$AF:(B . ?\x576A) ;; <CJK>
     (?$AF;(B . ?\x82F9) ;; <CJK>
     (?$AF<(B . ?\x840D) ;; <CJK>
     (?$AF=(B . ?\x5E73) ;; <CJK>
     (?$AF>(B . ?\x51ED) ;; <CJK>
     (?$AF?(B . ?\x74F6) ;; <CJK>
     (?$AF@(B . ?\x8BC4) ;; <CJK>
     (?$AFA(B . ?\x5C4F) ;; <CJK>
     (?$AFB(B . ?\x5761) ;; <CJK>
     (?$AFC(B . ?\x6CFC) ;; <CJK>
     (?$AFD(B . ?\x9887) ;; <CJK>
     (?$AFE(B . ?\x5A46) ;; <CJK>
     (?$AFF(B . ?\x7834) ;; <CJK>
     (?$AFG(B . ?\x9B44) ;; <CJK>
     (?$AFH(B . ?\x8FEB) ;; <CJK>
     (?$AFI(B . ?\x7C95) ;; <CJK>
     (?$AFJ(B . ?\x5256) ;; <CJK>
     (?$AFK(B . ?\x6251) ;; <CJK>
     (?$AFL(B . ?\x94FA) ;; <CJK>
     (?$AFM(B . ?\x4EC6) ;; <CJK>
     (?$AFN(B . ?\x8386) ;; <CJK>
     (?$AFO(B . ?\x8461) ;; <CJK>
     (?$AFP(B . ?\x83E9) ;; <CJK>
     (?$AFQ(B . ?\x84B2) ;; <CJK>
     (?$AFR(B . ?\x57D4) ;; <CJK>
     (?$AFS(B . ?\x6734) ;; <CJK>
     (?$AFT(B . ?\x5703) ;; <CJK>
     (?$AFU(B . ?\x666E) ;; <CJK>
     (?$AFV(B . ?\x6D66) ;; <CJK>
     (?$AFW(B . ?\x8C31) ;; <CJK>
     (?$AFX(B . ?\x66DD) ;; <CJK>
     (?$AFY(B . ?\x7011) ;; <CJK>
     (?$AFZ(B . ?\x671F) ;; <CJK>
     (?$AF[(B . ?\x6B3A) ;; <CJK>
     (?$AF\(B . ?\x6816) ;; <CJK>
     (?$AF](B . ?\x621A) ;; <CJK>
     (?$AF^(B . ?\x59BB) ;; <CJK>
     (?$AF_(B . ?\x4E03) ;; <CJK>
     (?$AF`(B . ?\x51C4) ;; <CJK>
     (?$AFa(B . ?\x6F06) ;; <CJK>
     (?$AFb(B . ?\x67D2) ;; <CJK>
     (?$AFc(B . ?\x6C8F) ;; <CJK>
     (?$AFd(B . ?\x5176) ;; <CJK>
     (?$AFe(B . ?\x68CB) ;; <CJK>
     (?$AFf(B . ?\x5947) ;; <CJK>
     (?$AFg(B . ?\x6B67) ;; <CJK>
     (?$AFh(B . ?\x7566) ;; <CJK>
     (?$AFi(B . ?\x5D0E) ;; <CJK>
     (?$AFj(B . ?\x8110) ;; <CJK>
     (?$AFk(B . ?\x9F50) ;; <CJK>
     (?$AFl(B . ?\x65D7) ;; <CJK>
     (?$AFm(B . ?\x7948) ;; <CJK>
     (?$AFn(B . ?\x7941) ;; <CJK>
     (?$AFo(B . ?\x9A91) ;; <CJK>
     (?$AFp(B . ?\x8D77) ;; <CJK>
     (?$AFq(B . ?\x5C82) ;; <CJK>
     (?$AFr(B . ?\x4E5E) ;; <CJK>
     (?$AFs(B . ?\x4F01) ;; <CJK>
     (?$AFt(B . ?\x542F) ;; <CJK>
     (?$AFu(B . ?\x5951) ;; <CJK>
     (?$AFv(B . ?\x780C) ;; <CJK>
     (?$AFw(B . ?\x5668) ;; <CJK>
     (?$AFx(B . ?\x6C14) ;; <CJK>
     (?$AFy(B . ?\x8FC4) ;; <CJK>
     (?$AFz(B . ?\x5F03) ;; <CJK>
     (?$AF{(B . ?\x6C7D) ;; <CJK>
     (?$AF|(B . ?\x6CE3) ;; <CJK>
     (?$AF}(B . ?\x8BAB) ;; <CJK>
     (?$AF~(B . ?\x6390) ;; <CJK>
     (?$AG!(B . ?\x6070) ;; <CJK>
     (?$AG"(B . ?\x6D3D) ;; <CJK>
     (?$AG#(B . ?\x7275) ;; <CJK>
     (?$AG$(B . ?\x6266) ;; <CJK>
     (?$AG%(B . ?\x948E) ;; <CJK>
     (?$AG&(B . ?\x94C5) ;; <CJK>
     (?$AG'(B . ?\x5343) ;; <CJK>
     (?$AG((B . ?\x8FC1) ;; <CJK>
     (?$AG)(B . ?\x7B7E) ;; <CJK>
     (?$AG*(B . ?\x4EDF) ;; <CJK>
     (?$AG+(B . ?\x8C26) ;; <CJK>
     (?$AG,(B . ?\x4E7E) ;; <CJK>
     (?$AG-(B . ?\x9ED4) ;; <CJK>
     (?$AG.(B . ?\x94B1) ;; <CJK>
     (?$AG/(B . ?\x94B3) ;; <CJK>
     (?$AG0(B . ?\x524D) ;; <CJK>
     (?$AG1(B . ?\x6F5C) ;; <CJK>
     (?$AG2(B . ?\x9063) ;; <CJK>
     (?$AG3(B . ?\x6D45) ;; <CJK>
     (?$AG4(B . ?\x8C34) ;; <CJK>
     (?$AG5(B . ?\x5811) ;; <CJK>
     (?$AG6(B . ?\x5D4C) ;; <CJK>
     (?$AG7(B . ?\x6B20) ;; <CJK>
     (?$AG8(B . ?\x6B49) ;; <CJK>
     (?$AG9(B . ?\x67AA) ;; <CJK>
     (?$AG:(B . ?\x545B) ;; <CJK>
     (?$AG;(B . ?\x8154) ;; <CJK>
     (?$AG<(B . ?\x7F8C) ;; <CJK>
     (?$AG=(B . ?\x5899) ;; <CJK>
     (?$AG>(B . ?\x8537) ;; <CJK>
     (?$AG?(B . ?\x5F3A) ;; <CJK>
     (?$AG@(B . ?\x62A2) ;; <CJK>
     (?$AGA(B . ?\x6A47) ;; <CJK>
     (?$AGB(B . ?\x9539) ;; <CJK>
     (?$AGC(B . ?\x6572) ;; <CJK>
     (?$AGD(B . ?\x6084) ;; <CJK>
     (?$AGE(B . ?\x6865) ;; <CJK>
     (?$AGF(B . ?\x77A7) ;; <CJK>
     (?$AGG(B . ?\x4E54) ;; <CJK>
     (?$AGH(B . ?\x4FA8) ;; <CJK>
     (?$AGI(B . ?\x5DE7) ;; <CJK>
     (?$AGJ(B . ?\x9798) ;; <CJK>
     (?$AGK(B . ?\x64AC) ;; <CJK>
     (?$AGL(B . ?\x7FD8) ;; <CJK>
     (?$AGM(B . ?\x5CED) ;; <CJK>
     (?$AGN(B . ?\x4FCF) ;; <CJK>
     (?$AGO(B . ?\x7A8D) ;; <CJK>
     (?$AGP(B . ?\x5207) ;; <CJK>
     (?$AGQ(B . ?\x8304) ;; <CJK>
     (?$AGR(B . ?\x4E14) ;; <CJK>
     (?$AGS(B . ?\x602F) ;; <CJK>
     (?$AGT(B . ?\x7A83) ;; <CJK>
     (?$AGU(B . ?\x94A6) ;; <CJK>
     (?$AGV(B . ?\x4FB5) ;; <CJK>
     (?$AGW(B . ?\x4EB2) ;; <CJK>
     (?$AGX(B . ?\x79E6) ;; <CJK>
     (?$AGY(B . ?\x7434) ;; <CJK>
     (?$AGZ(B . ?\x52E4) ;; <CJK>
     (?$AG[(B . ?\x82B9) ;; <CJK>
     (?$AG\(B . ?\x64D2) ;; <CJK>
     (?$AG](B . ?\x79BD) ;; <CJK>
     (?$AG^(B . ?\x5BDD) ;; <CJK>
     (?$AG_(B . ?\x6C81) ;; <CJK>
     (?$AG`(B . ?\x9752) ;; <CJK>
     (?$AGa(B . ?\x8F7B) ;; <CJK>
     (?$AGb(B . ?\x6C22) ;; <CJK>
     (?$AGc(B . ?\x503E) ;; <CJK>
     (?$AGd(B . ?\x537F) ;; <CJK>
     (?$AGe(B . ?\x6E05) ;; <CJK>
     (?$AGf(B . ?\x64CE) ;; <CJK>
     (?$AGg(B . ?\x6674) ;; <CJK>
     (?$AGh(B . ?\x6C30) ;; <CJK>
     (?$AGi(B . ?\x60C5) ;; <CJK>
     (?$AGj(B . ?\x9877) ;; <CJK>
     (?$AGk(B . ?\x8BF7) ;; <CJK>
     (?$AGl(B . ?\x5E86) ;; <CJK>
     (?$AGm(B . ?\x743C) ;; <CJK>
     (?$AGn(B . ?\x7A77) ;; <CJK>
     (?$AGo(B . ?\x79CB) ;; <CJK>
     (?$AGp(B . ?\x4E18) ;; <CJK>
     (?$AGq(B . ?\x90B1) ;; <CJK>
     (?$AGr(B . ?\x7403) ;; <CJK>
     (?$AGs(B . ?\x6C42) ;; <CJK>
     (?$AGt(B . ?\x56DA) ;; <CJK>
     (?$AGu(B . ?\x914B) ;; <CJK>
     (?$AGv(B . ?\x6CC5) ;; <CJK>
     (?$AGw(B . ?\x8D8B) ;; <CJK>
     (?$AGx(B . ?\x533A) ;; <CJK>
     (?$AGy(B . ?\x86C6) ;; <CJK>
     (?$AGz(B . ?\x66F2) ;; <CJK>
     (?$AG{(B . ?\x8EAF) ;; <CJK>
     (?$AG|(B . ?\x5C48) ;; <CJK>
     (?$AG}(B . ?\x9A71) ;; <CJK>
     (?$AG~(B . ?\x6E20) ;; <CJK>
     (?$AH!(B . ?\x53D6) ;; <CJK>
     (?$AH"(B . ?\x5A36) ;; <CJK>
     (?$AH#(B . ?\x9F8B) ;; <CJK>
     (?$AH$(B . ?\x8DA3) ;; <CJK>
     (?$AH%(B . ?\x53BB) ;; <CJK>
     (?$AH&(B . ?\x5708) ;; <CJK>
     (?$AH'(B . ?\x98A7) ;; <CJK>
     (?$AH((B . ?\x6743) ;; <CJK>
     (?$AH)(B . ?\x919B) ;; <CJK>
     (?$AH*(B . ?\x6CC9) ;; <CJK>
     (?$AH+(B . ?\x5168) ;; <CJK>
     (?$AH,(B . ?\x75CA) ;; <CJK>
     (?$AH-(B . ?\x62F3) ;; <CJK>
     (?$AH.(B . ?\x72AC) ;; <CJK>
     (?$AH/(B . ?\x5238) ;; <CJK>
     (?$AH0(B . ?\x529D) ;; <CJK>
     (?$AH1(B . ?\x7F3A) ;; <CJK>
     (?$AH2(B . ?\x7094) ;; <CJK>
     (?$AH3(B . ?\x7638) ;; <CJK>
     (?$AH4(B . ?\x5374) ;; <CJK>
     (?$AH5(B . ?\x9E4A) ;; <CJK>
     (?$AH6(B . ?\x69B7) ;; <CJK>
     (?$AH7(B . ?\x786E) ;; <CJK>
     (?$AH8(B . ?\x96C0) ;; <CJK>
     (?$AH9(B . ?\x88D9) ;; <CJK>
     (?$AH:(B . ?\x7FA4) ;; <CJK>
     (?$AH;(B . ?\x7136) ;; <CJK>
     (?$AH<(B . ?\x71C3) ;; <CJK>
     (?$AH=(B . ?\x5189) ;; <CJK>
     (?$AH>(B . ?\x67D3) ;; <CJK>
     (?$AH?(B . ?\x74E4) ;; <CJK>
     (?$AH@(B . ?\x58E4) ;; <CJK>
     (?$AHA(B . ?\x6518) ;; <CJK>
     (?$AHB(B . ?\x56B7) ;; <CJK>
     (?$AHC(B . ?\x8BA9) ;; <CJK>
     (?$AHD(B . ?\x9976) ;; <CJK>
     (?$AHE(B . ?\x6270) ;; <CJK>
     (?$AHF(B . ?\x7ED5) ;; <CJK>
     (?$AHG(B . ?\x60F9) ;; <CJK>
     (?$AHH(B . ?\x70ED) ;; <CJK>
     (?$AHI(B . ?\x58EC) ;; <CJK>
     (?$AHJ(B . ?\x4EC1) ;; <CJK>
     (?$AHK(B . ?\x4EBA) ;; <CJK>
     (?$AHL(B . ?\x5FCD) ;; <CJK>
     (?$AHM(B . ?\x97E7) ;; <CJK>
     (?$AHN(B . ?\x4EFB) ;; <CJK>
     (?$AHO(B . ?\x8BA4) ;; <CJK>
     (?$AHP(B . ?\x5203) ;; <CJK>
     (?$AHQ(B . ?\x598A) ;; <CJK>
     (?$AHR(B . ?\x7EAB) ;; <CJK>
     (?$AHS(B . ?\x6254) ;; <CJK>
     (?$AHT(B . ?\x4ECD) ;; <CJK>
     (?$AHU(B . ?\x65E5) ;; <CJK>
     (?$AHV(B . ?\x620E) ;; <CJK>
     (?$AHW(B . ?\x8338) ;; <CJK>
     (?$AHX(B . ?\x84C9) ;; <CJK>
     (?$AHY(B . ?\x8363) ;; <CJK>
     (?$AHZ(B . ?\x878D) ;; <CJK>
     (?$AH[(B . ?\x7194) ;; <CJK>
     (?$AH\(B . ?\x6EB6) ;; <CJK>
     (?$AH](B . ?\x5BB9) ;; <CJK>
     (?$AH^(B . ?\x7ED2) ;; <CJK>
     (?$AH_(B . ?\x5197) ;; <CJK>
     (?$AH`(B . ?\x63C9) ;; <CJK>
     (?$AHa(B . ?\x67D4) ;; <CJK>
     (?$AHb(B . ?\x8089) ;; <CJK>
     (?$AHc(B . ?\x8339) ;; <CJK>
     (?$AHd(B . ?\x8815) ;; <CJK>
     (?$AHe(B . ?\x5112) ;; <CJK>
     (?$AHf(B . ?\x5B7A) ;; <CJK>
     (?$AHg(B . ?\x5982) ;; <CJK>
     (?$AHh(B . ?\x8FB1) ;; <CJK>
     (?$AHi(B . ?\x4E73) ;; <CJK>
     (?$AHj(B . ?\x6C5D) ;; <CJK>
     (?$AHk(B . ?\x5165) ;; <CJK>
     (?$AHl(B . ?\x8925) ;; <CJK>
     (?$AHm(B . ?\x8F6F) ;; <CJK>
     (?$AHn(B . ?\x962E) ;; <CJK>
     (?$AHo(B . ?\x854A) ;; <CJK>
     (?$AHp(B . ?\x745E) ;; <CJK>
     (?$AHq(B . ?\x9510) ;; <CJK>
     (?$AHr(B . ?\x95F0) ;; <CJK>
     (?$AHs(B . ?\x6DA6) ;; <CJK>
     (?$AHt(B . ?\x82E5) ;; <CJK>
     (?$AHu(B . ?\x5F31) ;; <CJK>
     (?$AHv(B . ?\x6492) ;; <CJK>
     (?$AHw(B . ?\x6D12) ;; <CJK>
     (?$AHx(B . ?\x8428) ;; <CJK>
     (?$AHy(B . ?\x816E) ;; <CJK>
     (?$AHz(B . ?\x9CC3) ;; <CJK>
     (?$AH{(B . ?\x585E) ;; <CJK>
     (?$AH|(B . ?\x8D5B) ;; <CJK>
     (?$AH}(B . ?\x4E09) ;; <CJK>
     (?$AH~(B . ?\x53C1) ;; <CJK>
     (?$AI!(B . ?\x4F1E) ;; <CJK>
     (?$AI"(B . ?\x6563) ;; <CJK>
     (?$AI#(B . ?\x6851) ;; <CJK>
     (?$AI$(B . ?\x55D3) ;; <CJK>
     (?$AI%(B . ?\x4E27) ;; <CJK>
     (?$AI&(B . ?\x6414) ;; <CJK>
     (?$AI'(B . ?\x9A9A) ;; <CJK>
     (?$AI((B . ?\x626B) ;; <CJK>
     (?$AI)(B . ?\x5AC2) ;; <CJK>
     (?$AI*(B . ?\x745F) ;; <CJK>
     (?$AI+(B . ?\x8272) ;; <CJK>
     (?$AI,(B . ?\x6DA9) ;; <CJK>
     (?$AI-(B . ?\x68EE) ;; <CJK>
     (?$AI.(B . ?\x50E7) ;; <CJK>
     (?$AI/(B . ?\x838E) ;; <CJK>
     (?$AI0(B . ?\x7802) ;; <CJK>
     (?$AI1(B . ?\x6740) ;; <CJK>
     (?$AI2(B . ?\x5239) ;; <CJK>
     (?$AI3(B . ?\x6C99) ;; <CJK>
     (?$AI4(B . ?\x7EB1) ;; <CJK>
     (?$AI5(B . ?\x50BB) ;; <CJK>
     (?$AI6(B . ?\x5565) ;; <CJK>
     (?$AI7(B . ?\x715E) ;; <CJK>
     (?$AI8(B . ?\x7B5B) ;; <CJK>
     (?$AI9(B . ?\x6652) ;; <CJK>
     (?$AI:(B . ?\x73CA) ;; <CJK>
     (?$AI;(B . ?\x82EB) ;; <CJK>
     (?$AI<(B . ?\x6749) ;; <CJK>
     (?$AI=(B . ?\x5C71) ;; <CJK>
     (?$AI>(B . ?\x5220) ;; <CJK>
     (?$AI?(B . ?\x717D) ;; <CJK>
     (?$AI@(B . ?\x886B) ;; <CJK>
     (?$AIA(B . ?\x95EA) ;; <CJK>
     (?$AIB(B . ?\x9655) ;; <CJK>
     (?$AIC(B . ?\x64C5) ;; <CJK>
     (?$AID(B . ?\x8D61) ;; <CJK>
     (?$AIE(B . ?\x81B3) ;; <CJK>
     (?$AIF(B . ?\x5584) ;; <CJK>
     (?$AIG(B . ?\x6C55) ;; <CJK>
     (?$AIH(B . ?\x6247) ;; <CJK>
     (?$AII(B . ?\x7F2E) ;; <CJK>
     (?$AIJ(B . ?\x5892) ;; <CJK>
     (?$AIK(B . ?\x4F24) ;; <CJK>
     (?$AIL(B . ?\x5546) ;; <CJK>
     (?$AIM(B . ?\x8D4F) ;; <CJK>
     (?$AIN(B . ?\x664C) ;; <CJK>
     (?$AIO(B . ?\x4E0A) ;; <CJK>
     (?$AIP(B . ?\x5C1A) ;; <CJK>
     (?$AIQ(B . ?\x88F3) ;; <CJK>
     (?$AIR(B . ?\x68A2) ;; <CJK>
     (?$AIS(B . ?\x634E) ;; <CJK>
     (?$AIT(B . ?\x7A0D) ;; <CJK>
     (?$AIU(B . ?\x70E7) ;; <CJK>
     (?$AIV(B . ?\x828D) ;; <CJK>
     (?$AIW(B . ?\x52FA) ;; <CJK>
     (?$AIX(B . ?\x97F6) ;; <CJK>
     (?$AIY(B . ?\x5C11) ;; <CJK>
     (?$AIZ(B . ?\x54E8) ;; <CJK>
     (?$AI[(B . ?\x90B5) ;; <CJK>
     (?$AI\(B . ?\x7ECD) ;; <CJK>
     (?$AI](B . ?\x5962) ;; <CJK>
     (?$AI^(B . ?\x8D4A) ;; <CJK>
     (?$AI_(B . ?\x86C7) ;; <CJK>
     (?$AI`(B . ?\x820C) ;; <CJK>
     (?$AIa(B . ?\x820D) ;; <CJK>
     (?$AIb(B . ?\x8D66) ;; <CJK>
     (?$AIc(B . ?\x6444) ;; <CJK>
     (?$AId(B . ?\x5C04) ;; <CJK>
     (?$AIe(B . ?\x6151) ;; <CJK>
     (?$AIf(B . ?\x6D89) ;; <CJK>
     (?$AIg(B . ?\x793E) ;; <CJK>
     (?$AIh(B . ?\x8BBE) ;; <CJK>
     (?$AIi(B . ?\x7837) ;; <CJK>
     (?$AIj(B . ?\x7533) ;; <CJK>
     (?$AIk(B . ?\x547B) ;; <CJK>
     (?$AIl(B . ?\x4F38) ;; <CJK>
     (?$AIm(B . ?\x8EAB) ;; <CJK>
     (?$AIn(B . ?\x6DF1) ;; <CJK>
     (?$AIo(B . ?\x5A20) ;; <CJK>
     (?$AIp(B . ?\x7EC5) ;; <CJK>
     (?$AIq(B . ?\x795E) ;; <CJK>
     (?$AIr(B . ?\x6C88) ;; <CJK>
     (?$AIs(B . ?\x5BA1) ;; <CJK>
     (?$AIt(B . ?\x5A76) ;; <CJK>
     (?$AIu(B . ?\x751A) ;; <CJK>
     (?$AIv(B . ?\x80BE) ;; <CJK>
     (?$AIw(B . ?\x614E) ;; <CJK>
     (?$AIx(B . ?\x6E17) ;; <CJK>
     (?$AIy(B . ?\x58F0) ;; <CJK>
     (?$AIz(B . ?\x751F) ;; <CJK>
     (?$AI{(B . ?\x7525) ;; <CJK>
     (?$AI|(B . ?\x7272) ;; <CJK>
     (?$AI}(B . ?\x5347) ;; <CJK>
     (?$AI~(B . ?\x7EF3) ;; <CJK>
     (?$AJ!(B . ?\x7701) ;; <CJK>
     (?$AJ"(B . ?\x76DB) ;; <CJK>
     (?$AJ#(B . ?\x5269) ;; <CJK>
     (?$AJ$(B . ?\x80DC) ;; <CJK>
     (?$AJ%(B . ?\x5723) ;; <CJK>
     (?$AJ&(B . ?\x5E08) ;; <CJK>
     (?$AJ'(B . ?\x5931) ;; <CJK>
     (?$AJ((B . ?\x72EE) ;; <CJK>
     (?$AJ)(B . ?\x65BD) ;; <CJK>
     (?$AJ*(B . ?\x6E7F) ;; <CJK>
     (?$AJ+(B . ?\x8BD7) ;; <CJK>
     (?$AJ,(B . ?\x5C38) ;; <CJK>
     (?$AJ-(B . ?\x8671) ;; <CJK>
     (?$AJ.(B . ?\x5341) ;; <CJK>
     (?$AJ/(B . ?\x77F3) ;; <CJK>
     (?$AJ0(B . ?\x62FE) ;; <CJK>
     (?$AJ1(B . ?\x65F6) ;; <CJK>
     (?$AJ2(B . ?\x4EC0) ;; <CJK>
     (?$AJ3(B . ?\x98DF) ;; <CJK>
     (?$AJ4(B . ?\x8680) ;; <CJK>
     (?$AJ5(B . ?\x5B9E) ;; <CJK>
     (?$AJ6(B . ?\x8BC6) ;; <CJK>
     (?$AJ7(B . ?\x53F2) ;; <CJK>
     (?$AJ8(B . ?\x77E2) ;; <CJK>
     (?$AJ9(B . ?\x4F7F) ;; <CJK>
     (?$AJ:(B . ?\x5C4E) ;; <CJK>
     (?$AJ;(B . ?\x9A76) ;; <CJK>
     (?$AJ<(B . ?\x59CB) ;; <CJK>
     (?$AJ=(B . ?\x5F0F) ;; <CJK>
     (?$AJ>(B . ?\x793A) ;; <CJK>
     (?$AJ?(B . ?\x58EB) ;; <CJK>
     (?$AJ@(B . ?\x4E16) ;; <CJK>
     (?$AJA(B . ?\x67FF) ;; <CJK>
     (?$AJB(B . ?\x4E8B) ;; <CJK>
     (?$AJC(B . ?\x62ED) ;; <CJK>
     (?$AJD(B . ?\x8A93) ;; <CJK>
     (?$AJE(B . ?\x901D) ;; <CJK>
     (?$AJF(B . ?\x52BF) ;; <CJK>
     (?$AJG(B . ?\x662F) ;; <CJK>
     (?$AJH(B . ?\x55DC) ;; <CJK>
     (?$AJI(B . ?\x566C) ;; <CJK>
     (?$AJJ(B . ?\x9002) ;; <CJK>
     (?$AJK(B . ?\x4ED5) ;; <CJK>
     (?$AJL(B . ?\x4F8D) ;; <CJK>
     (?$AJM(B . ?\x91CA) ;; <CJK>
     (?$AJN(B . ?\x9970) ;; <CJK>
     (?$AJO(B . ?\x6C0F) ;; <CJK>
     (?$AJP(B . ?\x5E02) ;; <CJK>
     (?$AJQ(B . ?\x6043) ;; <CJK>
     (?$AJR(B . ?\x5BA4) ;; <CJK>
     (?$AJS(B . ?\x89C6) ;; <CJK>
     (?$AJT(B . ?\x8BD5) ;; <CJK>
     (?$AJU(B . ?\x6536) ;; <CJK>
     (?$AJV(B . ?\x624B) ;; <CJK>
     (?$AJW(B . ?\x9996) ;; <CJK>
     (?$AJX(B . ?\x5B88) ;; <CJK>
     (?$AJY(B . ?\x5BFF) ;; <CJK>
     (?$AJZ(B . ?\x6388) ;; <CJK>
     (?$AJ[(B . ?\x552E) ;; <CJK>
     (?$AJ\(B . ?\x53D7) ;; <CJK>
     (?$AJ](B . ?\x7626) ;; <CJK>
     (?$AJ^(B . ?\x517D) ;; <CJK>
     (?$AJ_(B . ?\x852C) ;; <CJK>
     (?$AJ`(B . ?\x67A2) ;; <CJK>
     (?$AJa(B . ?\x68B3) ;; <CJK>
     (?$AJb(B . ?\x6B8A) ;; <CJK>
     (?$AJc(B . ?\x6292) ;; <CJK>
     (?$AJd(B . ?\x8F93) ;; <CJK>
     (?$AJe(B . ?\x53D4) ;; <CJK>
     (?$AJf(B . ?\x8212) ;; <CJK>
     (?$AJg(B . ?\x6DD1) ;; <CJK>
     (?$AJh(B . ?\x758F) ;; <CJK>
     (?$AJi(B . ?\x4E66) ;; <CJK>
     (?$AJj(B . ?\x8D4E) ;; <CJK>
     (?$AJk(B . ?\x5B70) ;; <CJK>
     (?$AJl(B . ?\x719F) ;; <CJK>
     (?$AJm(B . ?\x85AF) ;; <CJK>
     (?$AJn(B . ?\x6691) ;; <CJK>
     (?$AJo(B . ?\x66D9) ;; <CJK>
     (?$AJp(B . ?\x7F72) ;; <CJK>
     (?$AJq(B . ?\x8700) ;; <CJK>
     (?$AJr(B . ?\x9ECD) ;; <CJK>
     (?$AJs(B . ?\x9F20) ;; <CJK>
     (?$AJt(B . ?\x5C5E) ;; <CJK>
     (?$AJu(B . ?\x672F) ;; <CJK>
     (?$AJv(B . ?\x8FF0) ;; <CJK>
     (?$AJw(B . ?\x6811) ;; <CJK>
     (?$AJx(B . ?\x675F) ;; <CJK>
     (?$AJy(B . ?\x620D) ;; <CJK>
     (?$AJz(B . ?\x7AD6) ;; <CJK>
     (?$AJ{(B . ?\x5885) ;; <CJK>
     (?$AJ|(B . ?\x5EB6) ;; <CJK>
     (?$AJ}(B . ?\x6570) ;; <CJK>
     (?$AJ~(B . ?\x6F31) ;; <CJK>
     (?$AK!(B . ?\x6055) ;; <CJK>
     (?$AK"(B . ?\x5237) ;; <CJK>
     (?$AK#(B . ?\x800D) ;; <CJK>
     (?$AK$(B . ?\x6454) ;; <CJK>
     (?$AK%(B . ?\x8870) ;; <CJK>
     (?$AK&(B . ?\x7529) ;; <CJK>
     (?$AK'(B . ?\x5E05) ;; <CJK>
     (?$AK((B . ?\x6813) ;; <CJK>
     (?$AK)(B . ?\x62F4) ;; <CJK>
     (?$AK*(B . ?\x971C) ;; <CJK>
     (?$AK+(B . ?\x53CC) ;; <CJK>
     (?$AK,(B . ?\x723D) ;; <CJK>
     (?$AK-(B . ?\x8C01) ;; <CJK>
     (?$AK.(B . ?\x6C34) ;; <CJK>
     (?$AK/(B . ?\x7761) ;; <CJK>
     (?$AK0(B . ?\x7A0E) ;; <CJK>
     (?$AK1(B . ?\x542E) ;; <CJK>
     (?$AK2(B . ?\x77AC) ;; <CJK>
     (?$AK3(B . ?\x987A) ;; <CJK>
     (?$AK4(B . ?\x821C) ;; <CJK>
     (?$AK5(B . ?\x8BF4) ;; <CJK>
     (?$AK6(B . ?\x7855) ;; <CJK>
     (?$AK7(B . ?\x6714) ;; <CJK>
     (?$AK8(B . ?\x70C1) ;; <CJK>
     (?$AK9(B . ?\x65AF) ;; <CJK>
     (?$AK:(B . ?\x6495) ;; <CJK>
     (?$AK;(B . ?\x5636) ;; <CJK>
     (?$AK<(B . ?\x601D) ;; <CJK>
     (?$AK=(B . ?\x79C1) ;; <CJK>
     (?$AK>(B . ?\x53F8) ;; <CJK>
     (?$AK?(B . ?\x4E1D) ;; <CJK>
     (?$AK@(B . ?\x6B7B) ;; <CJK>
     (?$AKA(B . ?\x8086) ;; <CJK>
     (?$AKB(B . ?\x5BFA) ;; <CJK>
     (?$AKC(B . ?\x55E3) ;; <CJK>
     (?$AKD(B . ?\x56DB) ;; <CJK>
     (?$AKE(B . ?\x4F3A) ;; <CJK>
     (?$AKF(B . ?\x4F3C) ;; <CJK>
     (?$AKG(B . ?\x9972) ;; <CJK>
     (?$AKH(B . ?\x5DF3) ;; <CJK>
     (?$AKI(B . ?\x677E) ;; <CJK>
     (?$AKJ(B . ?\x8038) ;; <CJK>
     (?$AKK(B . ?\x6002) ;; <CJK>
     (?$AKL(B . ?\x9882) ;; <CJK>
     (?$AKM(B . ?\x9001) ;; <CJK>
     (?$AKN(B . ?\x5B8B) ;; <CJK>
     (?$AKO(B . ?\x8BBC) ;; <CJK>
     (?$AKP(B . ?\x8BF5) ;; <CJK>
     (?$AKQ(B . ?\x641C) ;; <CJK>
     (?$AKR(B . ?\x8258) ;; <CJK>
     (?$AKS(B . ?\x64DE) ;; <CJK>
     (?$AKT(B . ?\x55FD) ;; <CJK>
     (?$AKU(B . ?\x82CF) ;; <CJK>
     (?$AKV(B . ?\x9165) ;; <CJK>
     (?$AKW(B . ?\x4FD7) ;; <CJK>
     (?$AKX(B . ?\x7D20) ;; <CJK>
     (?$AKY(B . ?\x901F) ;; <CJK>
     (?$AKZ(B . ?\x7C9F) ;; <CJK>
     (?$AK[(B . ?\x50F3) ;; <CJK>
     (?$AK\(B . ?\x5851) ;; <CJK>
     (?$AK](B . ?\x6EAF) ;; <CJK>
     (?$AK^(B . ?\x5BBF) ;; <CJK>
     (?$AK_(B . ?\x8BC9) ;; <CJK>
     (?$AK`(B . ?\x8083) ;; <CJK>
     (?$AKa(B . ?\x9178) ;; <CJK>
     (?$AKb(B . ?\x849C) ;; <CJK>
     (?$AKc(B . ?\x7B97) ;; <CJK>
     (?$AKd(B . ?\x867D) ;; <CJK>
     (?$AKe(B . ?\x968B) ;; <CJK>
     (?$AKf(B . ?\x968F) ;; <CJK>
     (?$AKg(B . ?\x7EE5) ;; <CJK>
     (?$AKh(B . ?\x9AD3) ;; <CJK>
     (?$AKi(B . ?\x788E) ;; <CJK>
     (?$AKj(B . ?\x5C81) ;; <CJK>
     (?$AKk(B . ?\x7A57) ;; <CJK>
     (?$AKl(B . ?\x9042) ;; <CJK>
     (?$AKm(B . ?\x96A7) ;; <CJK>
     (?$AKn(B . ?\x795F) ;; <CJK>
     (?$AKo(B . ?\x5B59) ;; <CJK>
     (?$AKp(B . ?\x635F) ;; <CJK>
     (?$AKq(B . ?\x7B0B) ;; <CJK>
     (?$AKr(B . ?\x84D1) ;; <CJK>
     (?$AKs(B . ?\x68AD) ;; <CJK>
     (?$AKt(B . ?\x5506) ;; <CJK>
     (?$AKu(B . ?\x7F29) ;; <CJK>
     (?$AKv(B . ?\x7410) ;; <CJK>
     (?$AKw(B . ?\x7D22) ;; <CJK>
     (?$AKx(B . ?\x9501) ;; <CJK>
     (?$AKy(B . ?\x6240) ;; <CJK>
     (?$AKz(B . ?\x584C) ;; <CJK>
     (?$AK{(B . ?\x4ED6) ;; <CJK>
     (?$AK|(B . ?\x5B83) ;; <CJK>
     (?$AK}(B . ?\x5979) ;; <CJK>
     (?$AK~(B . ?\x5854) ;; <CJK>
     (?$AL!(B . ?\x736D) ;; <CJK>
     (?$AL"(B . ?\x631E) ;; <CJK>
     (?$AL#(B . ?\x8E4B) ;; <CJK>
     (?$AL$(B . ?\x8E0F) ;; <CJK>
     (?$AL%(B . ?\x80CE) ;; <CJK>
     (?$AL&(B . ?\x82D4) ;; <CJK>
     (?$AL'(B . ?\x62AC) ;; <CJK>
     (?$AL((B . ?\x53F0) ;; <CJK>
     (?$AL)(B . ?\x6CF0) ;; <CJK>
     (?$AL*(B . ?\x915E) ;; <CJK>
     (?$AL+(B . ?\x592A) ;; <CJK>
     (?$AL,(B . ?\x6001) ;; <CJK>
     (?$AL-(B . ?\x6C70) ;; <CJK>
     (?$AL.(B . ?\x574D) ;; <CJK>
     (?$AL/(B . ?\x644A) ;; <CJK>
     (?$AL0(B . ?\x8D2A) ;; <CJK>
     (?$AL1(B . ?\x762B) ;; <CJK>
     (?$AL2(B . ?\x6EE9) ;; <CJK>
     (?$AL3(B . ?\x575B) ;; <CJK>
     (?$AL4(B . ?\x6A80) ;; <CJK>
     (?$AL5(B . ?\x75F0) ;; <CJK>
     (?$AL6(B . ?\x6F6D) ;; <CJK>
     (?$AL7(B . ?\x8C2D) ;; <CJK>
     (?$AL8(B . ?\x8C08) ;; <CJK>
     (?$AL9(B . ?\x5766) ;; <CJK>
     (?$AL:(B . ?\x6BEF) ;; <CJK>
     (?$AL;(B . ?\x8892) ;; <CJK>
     (?$AL<(B . ?\x78B3) ;; <CJK>
     (?$AL=(B . ?\x63A2) ;; <CJK>
     (?$AL>(B . ?\x53F9) ;; <CJK>
     (?$AL?(B . ?\x70AD) ;; <CJK>
     (?$AL@(B . ?\x6C64) ;; <CJK>
     (?$ALA(B . ?\x5858) ;; <CJK>
     (?$ALB(B . ?\x642A) ;; <CJK>
     (?$ALC(B . ?\x5802) ;; <CJK>
     (?$ALD(B . ?\x68E0) ;; <CJK>
     (?$ALE(B . ?\x819B) ;; <CJK>
     (?$ALF(B . ?\x5510) ;; <CJK>
     (?$ALG(B . ?\x7CD6) ;; <CJK>
     (?$ALH(B . ?\x5018) ;; <CJK>
     (?$ALI(B . ?\x8EBA) ;; <CJK>
     (?$ALJ(B . ?\x6DCC) ;; <CJK>
     (?$ALK(B . ?\x8D9F) ;; <CJK>
     (?$ALL(B . ?\x70EB) ;; <CJK>
     (?$ALM(B . ?\x638F) ;; <CJK>
     (?$ALN(B . ?\x6D9B) ;; <CJK>
     (?$ALO(B . ?\x6ED4) ;; <CJK>
     (?$ALP(B . ?\x7EE6) ;; <CJK>
     (?$ALQ(B . ?\x8404) ;; <CJK>
     (?$ALR(B . ?\x6843) ;; <CJK>
     (?$ALS(B . ?\x9003) ;; <CJK>
     (?$ALT(B . ?\x6DD8) ;; <CJK>
     (?$ALU(B . ?\x9676) ;; <CJK>
     (?$ALV(B . ?\x8BA8) ;; <CJK>
     (?$ALW(B . ?\x5957) ;; <CJK>
     (?$ALX(B . ?\x7279) ;; <CJK>
     (?$ALY(B . ?\x85E4) ;; <CJK>
     (?$ALZ(B . ?\x817E) ;; <CJK>
     (?$AL[(B . ?\x75BC) ;; <CJK>
     (?$AL\(B . ?\x8A8A) ;; <CJK>
     (?$AL](B . ?\x68AF) ;; <CJK>
     (?$AL^(B . ?\x5254) ;; <CJK>
     (?$AL_(B . ?\x8E22) ;; <CJK>
     (?$AL`(B . ?\x9511) ;; <CJK>
     (?$ALa(B . ?\x63D0) ;; <CJK>
     (?$ALb(B . ?\x9898) ;; <CJK>
     (?$ALc(B . ?\x8E44) ;; <CJK>
     (?$ALd(B . ?\x557C) ;; <CJK>
     (?$ALe(B . ?\x4F53) ;; <CJK>
     (?$ALf(B . ?\x66FF) ;; <CJK>
     (?$ALg(B . ?\x568F) ;; <CJK>
     (?$ALh(B . ?\x60D5) ;; <CJK>
     (?$ALi(B . ?\x6D95) ;; <CJK>
     (?$ALj(B . ?\x5243) ;; <CJK>
     (?$ALk(B . ?\x5C49) ;; <CJK>
     (?$ALl(B . ?\x5929) ;; <CJK>
     (?$ALm(B . ?\x6DFB) ;; <CJK>
     (?$ALn(B . ?\x586B) ;; <CJK>
     (?$ALo(B . ?\x7530) ;; <CJK>
     (?$ALp(B . ?\x751C) ;; <CJK>
     (?$ALq(B . ?\x606C) ;; <CJK>
     (?$ALr(B . ?\x8214) ;; <CJK>
     (?$ALs(B . ?\x8146) ;; <CJK>
     (?$ALt(B . ?\x6311) ;; <CJK>
     (?$ALu(B . ?\x6761) ;; <CJK>
     (?$ALv(B . ?\x8FE2) ;; <CJK>
     (?$ALw(B . ?\x773A) ;; <CJK>
     (?$ALx(B . ?\x8DF3) ;; <CJK>
     (?$ALy(B . ?\x8D34) ;; <CJK>
     (?$ALz(B . ?\x94C1) ;; <CJK>
     (?$AL{(B . ?\x5E16) ;; <CJK>
     (?$AL|(B . ?\x5385) ;; <CJK>
     (?$AL}(B . ?\x542C) ;; <CJK>
     (?$AL~(B . ?\x70C3) ;; <CJK>
     (?$AM!(B . ?\x6C40) ;; <CJK>
     (?$AM"(B . ?\x5EF7) ;; <CJK>
     (?$AM#(B . ?\x505C) ;; <CJK>
     (?$AM$(B . ?\x4EAD) ;; <CJK>
     (?$AM%(B . ?\x5EAD) ;; <CJK>
     (?$AM&(B . ?\x633A) ;; <CJK>
     (?$AM'(B . ?\x8247) ;; <CJK>
     (?$AM((B . ?\x901A) ;; <CJK>
     (?$AM)(B . ?\x6850) ;; <CJK>
     (?$AM*(B . ?\x916E) ;; <CJK>
     (?$AM+(B . ?\x77B3) ;; <CJK>
     (?$AM,(B . ?\x540C) ;; <CJK>
     (?$AM-(B . ?\x94DC) ;; <CJK>
     (?$AM.(B . ?\x5F64) ;; <CJK>
     (?$AM/(B . ?\x7AE5) ;; <CJK>
     (?$AM0(B . ?\x6876) ;; <CJK>
     (?$AM1(B . ?\x6345) ;; <CJK>
     (?$AM2(B . ?\x7B52) ;; <CJK>
     (?$AM3(B . ?\x7EDF) ;; <CJK>
     (?$AM4(B . ?\x75DB) ;; <CJK>
     (?$AM5(B . ?\x5077) ;; <CJK>
     (?$AM6(B . ?\x6295) ;; <CJK>
     (?$AM7(B . ?\x5934) ;; <CJK>
     (?$AM8(B . ?\x900F) ;; <CJK>
     (?$AM9(B . ?\x51F8) ;; <CJK>
     (?$AM:(B . ?\x79C3) ;; <CJK>
     (?$AM;(B . ?\x7A81) ;; <CJK>
     (?$AM<(B . ?\x56FE) ;; <CJK>
     (?$AM=(B . ?\x5F92) ;; <CJK>
     (?$AM>(B . ?\x9014) ;; <CJK>
     (?$AM?(B . ?\x6D82) ;; <CJK>
     (?$AM@(B . ?\x5C60) ;; <CJK>
     (?$AMA(B . ?\x571F) ;; <CJK>
     (?$AMB(B . ?\x5410) ;; <CJK>
     (?$AMC(B . ?\x5154) ;; <CJK>
     (?$AMD(B . ?\x6E4D) ;; <CJK>
     (?$AME(B . ?\x56E2) ;; <CJK>
     (?$AMF(B . ?\x63A8) ;; <CJK>
     (?$AMG(B . ?\x9893) ;; <CJK>
     (?$AMH(B . ?\x817F) ;; <CJK>
     (?$AMI(B . ?\x8715) ;; <CJK>
     (?$AMJ(B . ?\x892A) ;; <CJK>
     (?$AMK(B . ?\x9000) ;; <CJK>
     (?$AML(B . ?\x541E) ;; <CJK>
     (?$AMM(B . ?\x5C6F) ;; <CJK>
     (?$AMN(B . ?\x81C0) ;; <CJK>
     (?$AMO(B . ?\x62D6) ;; <CJK>
     (?$AMP(B . ?\x6258) ;; <CJK>
     (?$AMQ(B . ?\x8131) ;; <CJK>
     (?$AMR(B . ?\x9E35) ;; <CJK>
     (?$AMS(B . ?\x9640) ;; <CJK>
     (?$AMT(B . ?\x9A6E) ;; <CJK>
     (?$AMU(B . ?\x9A7C) ;; <CJK>
     (?$AMV(B . ?\x692D) ;; <CJK>
     (?$AMW(B . ?\x59A5) ;; <CJK>
     (?$AMX(B . ?\x62D3) ;; <CJK>
     (?$AMY(B . ?\x553E) ;; <CJK>
     (?$AMZ(B . ?\x6316) ;; <CJK>
     (?$AM[(B . ?\x54C7) ;; <CJK>
     (?$AM\(B . ?\x86D9) ;; <CJK>
     (?$AM](B . ?\x6D3C) ;; <CJK>
     (?$AM^(B . ?\x5A03) ;; <CJK>
     (?$AM_(B . ?\x74E6) ;; <CJK>
     (?$AM`(B . ?\x889C) ;; <CJK>
     (?$AMa(B . ?\x6B6A) ;; <CJK>
     (?$AMb(B . ?\x5916) ;; <CJK>
     (?$AMc(B . ?\x8C4C) ;; <CJK>
     (?$AMd(B . ?\x5F2F) ;; <CJK>
     (?$AMe(B . ?\x6E7E) ;; <CJK>
     (?$AMf(B . ?\x73A9) ;; <CJK>
     (?$AMg(B . ?\x987D) ;; <CJK>
     (?$AMh(B . ?\x4E38) ;; <CJK>
     (?$AMi(B . ?\x70F7) ;; <CJK>
     (?$AMj(B . ?\x5B8C) ;; <CJK>
     (?$AMk(B . ?\x7897) ;; <CJK>
     (?$AMl(B . ?\x633D) ;; <CJK>
     (?$AMm(B . ?\x665A) ;; <CJK>
     (?$AMn(B . ?\x7696) ;; <CJK>
     (?$AMo(B . ?\x60CB) ;; <CJK>
     (?$AMp(B . ?\x5B9B) ;; <CJK>
     (?$AMq(B . ?\x5A49) ;; <CJK>
     (?$AMr(B . ?\x4E07) ;; <CJK>
     (?$AMs(B . ?\x8155) ;; <CJK>
     (?$AMt(B . ?\x6C6A) ;; <CJK>
     (?$AMu(B . ?\x738B) ;; <CJK>
     (?$AMv(B . ?\x4EA1) ;; <CJK>
     (?$AMw(B . ?\x6789) ;; <CJK>
     (?$AMx(B . ?\x7F51) ;; <CJK>
     (?$AMy(B . ?\x5F80) ;; <CJK>
     (?$AMz(B . ?\x65FA) ;; <CJK>
     (?$AM{(B . ?\x671B) ;; <CJK>
     (?$AM|(B . ?\x5FD8) ;; <CJK>
     (?$AM}(B . ?\x5984) ;; <CJK>
     (?$AM~(B . ?\x5A01) ;; <CJK>
     (?$AN!(B . ?\x5DCD) ;; <CJK>
     (?$AN"(B . ?\x5FAE) ;; <CJK>
     (?$AN#(B . ?\x5371) ;; <CJK>
     (?$AN$(B . ?\x97E6) ;; <CJK>
     (?$AN%(B . ?\x8FDD) ;; <CJK>
     (?$AN&(B . ?\x6845) ;; <CJK>
     (?$AN'(B . ?\x56F4) ;; <CJK>
     (?$AN((B . ?\x552F) ;; <CJK>
     (?$AN)(B . ?\x60DF) ;; <CJK>
     (?$AN*(B . ?\x4E3A) ;; <CJK>
     (?$AN+(B . ?\x6F4D) ;; <CJK>
     (?$AN,(B . ?\x7EF4) ;; <CJK>
     (?$AN-(B . ?\x82C7) ;; <CJK>
     (?$AN.(B . ?\x840E) ;; <CJK>
     (?$AN/(B . ?\x59D4) ;; <CJK>
     (?$AN0(B . ?\x4F1F) ;; <CJK>
     (?$AN1(B . ?\x4F2A) ;; <CJK>
     (?$AN2(B . ?\x5C3E) ;; <CJK>
     (?$AN3(B . ?\x7EAC) ;; <CJK>
     (?$AN4(B . ?\x672A) ;; <CJK>
     (?$AN5(B . ?\x851A) ;; <CJK>
     (?$AN6(B . ?\x5473) ;; <CJK>
     (?$AN7(B . ?\x754F) ;; <CJK>
     (?$AN8(B . ?\x80C3) ;; <CJK>
     (?$AN9(B . ?\x5582) ;; <CJK>
     (?$AN:(B . ?\x9B4F) ;; <CJK>
     (?$AN;(B . ?\x4F4D) ;; <CJK>
     (?$AN<(B . ?\x6E2D) ;; <CJK>
     (?$AN=(B . ?\x8C13) ;; <CJK>
     (?$AN>(B . ?\x5C09) ;; <CJK>
     (?$AN?(B . ?\x6170) ;; <CJK>
     (?$AN@(B . ?\x536B) ;; <CJK>
     (?$ANA(B . ?\x761F) ;; <CJK>
     (?$ANB(B . ?\x6E29) ;; <CJK>
     (?$ANC(B . ?\x868A) ;; <CJK>
     (?$AND(B . ?\x6587) ;; <CJK>
     (?$ANE(B . ?\x95FB) ;; <CJK>
     (?$ANF(B . ?\x7EB9) ;; <CJK>
     (?$ANG(B . ?\x543B) ;; <CJK>
     (?$ANH(B . ?\x7A33) ;; <CJK>
     (?$ANI(B . ?\x7D0A) ;; <CJK>
     (?$ANJ(B . ?\x95EE) ;; <CJK>
     (?$ANK(B . ?\x55E1) ;; <CJK>
     (?$ANL(B . ?\x7FC1) ;; <CJK>
     (?$ANM(B . ?\x74EE) ;; <CJK>
     (?$ANN(B . ?\x631D) ;; <CJK>
     (?$ANO(B . ?\x8717) ;; <CJK>
     (?$ANP(B . ?\x6DA1) ;; <CJK>
     (?$ANQ(B . ?\x7A9D) ;; <CJK>
     (?$ANR(B . ?\x6211) ;; <CJK>
     (?$ANS(B . ?\x65A1) ;; <CJK>
     (?$ANT(B . ?\x5367) ;; <CJK>
     (?$ANU(B . ?\x63E1) ;; <CJK>
     (?$ANV(B . ?\x6C83) ;; <CJK>
     (?$ANW(B . ?\x5DEB) ;; <CJK>
     (?$ANX(B . ?\x545C) ;; <CJK>
     (?$ANY(B . ?\x94A8) ;; <CJK>
     (?$ANZ(B . ?\x4E4C) ;; <CJK>
     (?$AN[(B . ?\x6C61) ;; <CJK>
     (?$AN\(B . ?\x8BEC) ;; <CJK>
     (?$AN](B . ?\x5C4B) ;; <CJK>
     (?$AN^(B . ?\x65E0) ;; <CJK>
     (?$AN_(B . ?\x829C) ;; <CJK>
     (?$AN`(B . ?\x68A7) ;; <CJK>
     (?$ANa(B . ?\x543E) ;; <CJK>
     (?$ANb(B . ?\x5434) ;; <CJK>
     (?$ANc(B . ?\x6BCB) ;; <CJK>
     (?$ANd(B . ?\x6B66) ;; <CJK>
     (?$ANe(B . ?\x4E94) ;; <CJK>
     (?$ANf(B . ?\x6342) ;; <CJK>
     (?$ANg(B . ?\x5348) ;; <CJK>
     (?$ANh(B . ?\x821E) ;; <CJK>
     (?$ANi(B . ?\x4F0D) ;; <CJK>
     (?$ANj(B . ?\x4FAE) ;; <CJK>
     (?$ANk(B . ?\x575E) ;; <CJK>
     (?$ANl(B . ?\x620A) ;; <CJK>
     (?$ANm(B . ?\x96FE) ;; <CJK>
     (?$ANn(B . ?\x6664) ;; <CJK>
     (?$ANo(B . ?\x7269) ;; <CJK>
     (?$ANp(B . ?\x52FF) ;; <CJK>
     (?$ANq(B . ?\x52A1) ;; <CJK>
     (?$ANr(B . ?\x609F) ;; <CJK>
     (?$ANs(B . ?\x8BEF) ;; <CJK>
     (?$ANt(B . ?\x6614) ;; <CJK>
     (?$ANu(B . ?\x7199) ;; <CJK>
     (?$ANv(B . ?\x6790) ;; <CJK>
     (?$ANw(B . ?\x897F) ;; <CJK>
     (?$ANx(B . ?\x7852) ;; <CJK>
     (?$ANy(B . ?\x77FD) ;; <CJK>
     (?$ANz(B . ?\x6670) ;; <CJK>
     (?$AN{(B . ?\x563B) ;; <CJK>
     (?$AN|(B . ?\x5438) ;; <CJK>
     (?$AN}(B . ?\x9521) ;; <CJK>
     (?$AN~(B . ?\x727A) ;; <CJK>
     (?$AO!(B . ?\x7A00) ;; <CJK>
     (?$AO"(B . ?\x606F) ;; <CJK>
     (?$AO#(B . ?\x5E0C) ;; <CJK>
     (?$AO$(B . ?\x6089) ;; <CJK>
     (?$AO%(B . ?\x819D) ;; <CJK>
     (?$AO&(B . ?\x5915) ;; <CJK>
     (?$AO'(B . ?\x60DC) ;; <CJK>
     (?$AO((B . ?\x7184) ;; <CJK>
     (?$AO)(B . ?\x70EF) ;; <CJK>
     (?$AO*(B . ?\x6EAA) ;; <CJK>
     (?$AO+(B . ?\x6C50) ;; <CJK>
     (?$AO,(B . ?\x7280) ;; <CJK>
     (?$AO-(B . ?\x6A84) ;; <CJK>
     (?$AO.(B . ?\x88AD) ;; <CJK>
     (?$AO/(B . ?\x5E2D) ;; <CJK>
     (?$AO0(B . ?\x4E60) ;; <CJK>
     (?$AO1(B . ?\x5AB3) ;; <CJK>
     (?$AO2(B . ?\x559C) ;; <CJK>
     (?$AO3(B . ?\x94E3) ;; <CJK>
     (?$AO4(B . ?\x6D17) ;; <CJK>
     (?$AO5(B . ?\x7CFB) ;; <CJK>
     (?$AO6(B . ?\x9699) ;; <CJK>
     (?$AO7(B . ?\x620F) ;; <CJK>
     (?$AO8(B . ?\x7EC6) ;; <CJK>
     (?$AO9(B . ?\x778E) ;; <CJK>
     (?$AO:(B . ?\x867E) ;; <CJK>
     (?$AO;(B . ?\x5323) ;; <CJK>
     (?$AO<(B . ?\x971E) ;; <CJK>
     (?$AO=(B . ?\x8F96) ;; <CJK>
     (?$AO>(B . ?\x6687) ;; <CJK>
     (?$AO?(B . ?\x5CE1) ;; <CJK>
     (?$AO@(B . ?\x4FA0) ;; <CJK>
     (?$AOA(B . ?\x72ED) ;; <CJK>
     (?$AOB(B . ?\x4E0B) ;; <CJK>
     (?$AOC(B . ?\x53A6) ;; <CJK>
     (?$AOD(B . ?\x590F) ;; <CJK>
     (?$AOE(B . ?\x5413) ;; <CJK>
     (?$AOF(B . ?\x6380) ;; <CJK>
     (?$AOG(B . ?\x9528) ;; <CJK>
     (?$AOH(B . ?\x5148) ;; <CJK>
     (?$AOI(B . ?\x4ED9) ;; <CJK>
     (?$AOJ(B . ?\x9C9C) ;; <CJK>
     (?$AOK(B . ?\x7EA4) ;; <CJK>
     (?$AOL(B . ?\x54B8) ;; <CJK>
     (?$AOM(B . ?\x8D24) ;; <CJK>
     (?$AON(B . ?\x8854) ;; <CJK>
     (?$AOO(B . ?\x8237) ;; <CJK>
     (?$AOP(B . ?\x95F2) ;; <CJK>
     (?$AOQ(B . ?\x6D8E) ;; <CJK>
     (?$AOR(B . ?\x5F26) ;; <CJK>
     (?$AOS(B . ?\x5ACC) ;; <CJK>
     (?$AOT(B . ?\x663E) ;; <CJK>
     (?$AOU(B . ?\x9669) ;; <CJK>
     (?$AOV(B . ?\x73B0) ;; <CJK>
     (?$AOW(B . ?\x732E) ;; <CJK>
     (?$AOX(B . ?\x53BF) ;; <CJK>
     (?$AOY(B . ?\x817A) ;; <CJK>
     (?$AOZ(B . ?\x9985) ;; <CJK>
     (?$AO[(B . ?\x7FA1) ;; <CJK>
     (?$AO\(B . ?\x5BAA) ;; <CJK>
     (?$AO](B . ?\x9677) ;; <CJK>
     (?$AO^(B . ?\x9650) ;; <CJK>
     (?$AO_(B . ?\x7EBF) ;; <CJK>
     (?$AO`(B . ?\x76F8) ;; <CJK>
     (?$AOa(B . ?\x53A2) ;; <CJK>
     (?$AOb(B . ?\x9576) ;; <CJK>
     (?$AOc(B . ?\x9999) ;; <CJK>
     (?$AOd(B . ?\x7BB1) ;; <CJK>
     (?$AOe(B . ?\x8944) ;; <CJK>
     (?$AOf(B . ?\x6E58) ;; <CJK>
     (?$AOg(B . ?\x4E61) ;; <CJK>
     (?$AOh(B . ?\x7FD4) ;; <CJK>
     (?$AOi(B . ?\x7965) ;; <CJK>
     (?$AOj(B . ?\x8BE6) ;; <CJK>
     (?$AOk(B . ?\x60F3) ;; <CJK>
     (?$AOl(B . ?\x54CD) ;; <CJK>
     (?$AOm(B . ?\x4EAB) ;; <CJK>
     (?$AOn(B . ?\x9879) ;; <CJK>
     (?$AOo(B . ?\x5DF7) ;; <CJK>
     (?$AOp(B . ?\x6A61) ;; <CJK>
     (?$AOq(B . ?\x50CF) ;; <CJK>
     (?$AOr(B . ?\x5411) ;; <CJK>
     (?$AOs(B . ?\x8C61) ;; <CJK>
     (?$AOt(B . ?\x8427) ;; <CJK>
     (?$AOu(B . ?\x785D) ;; <CJK>
     (?$AOv(B . ?\x9704) ;; <CJK>
     (?$AOw(B . ?\x524A) ;; <CJK>
     (?$AOx(B . ?\x54EE) ;; <CJK>
     (?$AOy(B . ?\x56A3) ;; <CJK>
     (?$AOz(B . ?\x9500) ;; <CJK>
     (?$AO{(B . ?\x6D88) ;; <CJK>
     (?$AO|(B . ?\x5BB5) ;; <CJK>
     (?$AO}(B . ?\x6DC6) ;; <CJK>
     (?$AO~(B . ?\x6653) ;; <CJK>
     (?$AP!(B . ?\x5C0F) ;; <CJK>
     (?$AP"(B . ?\x5B5D) ;; <CJK>
     (?$AP#(B . ?\x6821) ;; <CJK>
     (?$AP$(B . ?\x8096) ;; <CJK>
     (?$AP%(B . ?\x5578) ;; <CJK>
     (?$AP&(B . ?\x7B11) ;; <CJK>
     (?$AP'(B . ?\x6548) ;; <CJK>
     (?$AP((B . ?\x6954) ;; <CJK>
     (?$AP)(B . ?\x4E9B) ;; <CJK>
     (?$AP*(B . ?\x6B47) ;; <CJK>
     (?$AP+(B . ?\x874E) ;; <CJK>
     (?$AP,(B . ?\x978B) ;; <CJK>
     (?$AP-(B . ?\x534F) ;; <CJK>
     (?$AP.(B . ?\x631F) ;; <CJK>
     (?$AP/(B . ?\x643A) ;; <CJK>
     (?$AP0(B . ?\x90AA) ;; <CJK>
     (?$AP1(B . ?\x659C) ;; <CJK>
     (?$AP2(B . ?\x80C1) ;; <CJK>
     (?$AP3(B . ?\x8C10) ;; <CJK>
     (?$AP4(B . ?\x5199) ;; <CJK>
     (?$AP5(B . ?\x68B0) ;; <CJK>
     (?$AP6(B . ?\x5378) ;; <CJK>
     (?$AP7(B . ?\x87F9) ;; <CJK>
     (?$AP8(B . ?\x61C8) ;; <CJK>
     (?$AP9(B . ?\x6CC4) ;; <CJK>
     (?$AP:(B . ?\x6CFB) ;; <CJK>
     (?$AP;(B . ?\x8C22) ;; <CJK>
     (?$AP<(B . ?\x5C51) ;; <CJK>
     (?$AP=(B . ?\x85AA) ;; <CJK>
     (?$AP>(B . ?\x82AF) ;; <CJK>
     (?$AP?(B . ?\x950C) ;; <CJK>
     (?$AP@(B . ?\x6B23) ;; <CJK>
     (?$APA(B . ?\x8F9B) ;; <CJK>
     (?$APB(B . ?\x65B0) ;; <CJK>
     (?$APC(B . ?\x5FFB) ;; <CJK>
     (?$APD(B . ?\x5FC3) ;; <CJK>
     (?$APE(B . ?\x4FE1) ;; <CJK>
     (?$APF(B . ?\x8845) ;; <CJK>
     (?$APG(B . ?\x661F) ;; <CJK>
     (?$APH(B . ?\x8165) ;; <CJK>
     (?$API(B . ?\x7329) ;; <CJK>
     (?$APJ(B . ?\x60FA) ;; <CJK>
     (?$APK(B . ?\x5174) ;; <CJK>
     (?$APL(B . ?\x5211) ;; <CJK>
     (?$APM(B . ?\x578B) ;; <CJK>
     (?$APN(B . ?\x5F62) ;; <CJK>
     (?$APO(B . ?\x90A2) ;; <CJK>
     (?$APP(B . ?\x884C) ;; <CJK>
     (?$APQ(B . ?\x9192) ;; <CJK>
     (?$APR(B . ?\x5E78) ;; <CJK>
     (?$APS(B . ?\x674F) ;; <CJK>
     (?$APT(B . ?\x6027) ;; <CJK>
     (?$APU(B . ?\x59D3) ;; <CJK>
     (?$APV(B . ?\x5144) ;; <CJK>
     (?$APW(B . ?\x51F6) ;; <CJK>
     (?$APX(B . ?\x80F8) ;; <CJK>
     (?$APY(B . ?\x5308) ;; <CJK>
     (?$APZ(B . ?\x6C79) ;; <CJK>
     (?$AP[(B . ?\x96C4) ;; <CJK>
     (?$AP\(B . ?\x718A) ;; <CJK>
     (?$AP](B . ?\x4F11) ;; <CJK>
     (?$AP^(B . ?\x4FEE) ;; <CJK>
     (?$AP_(B . ?\x7F9E) ;; <CJK>
     (?$AP`(B . ?\x673D) ;; <CJK>
     (?$APa(B . ?\x55C5) ;; <CJK>
     (?$APb(B . ?\x9508) ;; <CJK>
     (?$APc(B . ?\x79C0) ;; <CJK>
     (?$APd(B . ?\x8896) ;; <CJK>
     (?$APe(B . ?\x7EE3) ;; <CJK>
     (?$APf(B . ?\x589F) ;; <CJK>
     (?$APg(B . ?\x620C) ;; <CJK>
     (?$APh(B . ?\x9700) ;; <CJK>
     (?$APi(B . ?\x865A) ;; <CJK>
     (?$APj(B . ?\x5618) ;; <CJK>
     (?$APk(B . ?\x987B) ;; <CJK>
     (?$APl(B . ?\x5F90) ;; <CJK>
     (?$APm(B . ?\x8BB8) ;; <CJK>
     (?$APn(B . ?\x84C4) ;; <CJK>
     (?$APo(B . ?\x9157) ;; <CJK>
     (?$APp(B . ?\x53D9) ;; <CJK>
     (?$APq(B . ?\x65ED) ;; <CJK>
     (?$APr(B . ?\x5E8F) ;; <CJK>
     (?$APs(B . ?\x755C) ;; <CJK>
     (?$APt(B . ?\x6064) ;; <CJK>
     (?$APu(B . ?\x7D6E) ;; <CJK>
     (?$APv(B . ?\x5A7F) ;; <CJK>
     (?$APw(B . ?\x7EEA) ;; <CJK>
     (?$APx(B . ?\x7EED) ;; <CJK>
     (?$APy(B . ?\x8F69) ;; <CJK>
     (?$APz(B . ?\x55A7) ;; <CJK>
     (?$AP{(B . ?\x5BA3) ;; <CJK>
     (?$AP|(B . ?\x60AC) ;; <CJK>
     (?$AP}(B . ?\x65CB) ;; <CJK>
     (?$AP~(B . ?\x7384) ;; <CJK>
     (?$AQ!(B . ?\x9009) ;; <CJK>
     (?$AQ"(B . ?\x7663) ;; <CJK>
     (?$AQ#(B . ?\x7729) ;; <CJK>
     (?$AQ$(B . ?\x7EDA) ;; <CJK>
     (?$AQ%(B . ?\x9774) ;; <CJK>
     (?$AQ&(B . ?\x859B) ;; <CJK>
     (?$AQ'(B . ?\x5B66) ;; <CJK>
     (?$AQ((B . ?\x7A74) ;; <CJK>
     (?$AQ)(B . ?\x96EA) ;; <CJK>
     (?$AQ*(B . ?\x8840) ;; <CJK>
     (?$AQ+(B . ?\x52CB) ;; <CJK>
     (?$AQ,(B . ?\x718F) ;; <CJK>
     (?$AQ-(B . ?\x5FAA) ;; <CJK>
     (?$AQ.(B . ?\x65EC) ;; <CJK>
     (?$AQ/(B . ?\x8BE2) ;; <CJK>
     (?$AQ0(B . ?\x5BFB) ;; <CJK>
     (?$AQ1(B . ?\x9A6F) ;; <CJK>
     (?$AQ2(B . ?\x5DE1) ;; <CJK>
     (?$AQ3(B . ?\x6B89) ;; <CJK>
     (?$AQ4(B . ?\x6C5B) ;; <CJK>
     (?$AQ5(B . ?\x8BAD) ;; <CJK>
     (?$AQ6(B . ?\x8BAF) ;; <CJK>
     (?$AQ7(B . ?\x900A) ;; <CJK>
     (?$AQ8(B . ?\x8FC5) ;; <CJK>
     (?$AQ9(B . ?\x538B) ;; <CJK>
     (?$AQ:(B . ?\x62BC) ;; <CJK>
     (?$AQ;(B . ?\x9E26) ;; <CJK>
     (?$AQ<(B . ?\x9E2D) ;; <CJK>
     (?$AQ=(B . ?\x5440) ;; <CJK>
     (?$AQ>(B . ?\x4E2B) ;; <CJK>
     (?$AQ?(B . ?\x82BD) ;; <CJK>
     (?$AQ@(B . ?\x7259) ;; <CJK>
     (?$AQA(B . ?\x869C) ;; <CJK>
     (?$AQB(B . ?\x5D16) ;; <CJK>
     (?$AQC(B . ?\x8859) ;; <CJK>
     (?$AQD(B . ?\x6DAF) ;; <CJK>
     (?$AQE(B . ?\x96C5) ;; <CJK>
     (?$AQF(B . ?\x54D1) ;; <CJK>
     (?$AQG(B . ?\x4E9A) ;; <CJK>
     (?$AQH(B . ?\x8BB6) ;; <CJK>
     (?$AQI(B . ?\x7109) ;; <CJK>
     (?$AQJ(B . ?\x54BD) ;; <CJK>
     (?$AQK(B . ?\x9609) ;; <CJK>
     (?$AQL(B . ?\x70DF) ;; <CJK>
     (?$AQM(B . ?\x6DF9) ;; <CJK>
     (?$AQN(B . ?\x76D0) ;; <CJK>
     (?$AQO(B . ?\x4E25) ;; <CJK>
     (?$AQP(B . ?\x7814) ;; <CJK>
     (?$AQQ(B . ?\x8712) ;; <CJK>
     (?$AQR(B . ?\x5CA9) ;; <CJK>
     (?$AQS(B . ?\x5EF6) ;; <CJK>
     (?$AQT(B . ?\x8A00) ;; <CJK>
     (?$AQU(B . ?\x989C) ;; <CJK>
     (?$AQV(B . ?\x960E) ;; <CJK>
     (?$AQW(B . ?\x708E) ;; <CJK>
     (?$AQX(B . ?\x6CBF) ;; <CJK>
     (?$AQY(B . ?\x5944) ;; <CJK>
     (?$AQZ(B . ?\x63A9) ;; <CJK>
     (?$AQ[(B . ?\x773C) ;; <CJK>
     (?$AQ\(B . ?\x884D) ;; <CJK>
     (?$AQ](B . ?\x6F14) ;; <CJK>
     (?$AQ^(B . ?\x8273) ;; <CJK>
     (?$AQ_(B . ?\x5830) ;; <CJK>
     (?$AQ`(B . ?\x71D5) ;; <CJK>
     (?$AQa(B . ?\x538C) ;; <CJK>
     (?$AQb(B . ?\x781A) ;; <CJK>
     (?$AQc(B . ?\x96C1) ;; <CJK>
     (?$AQd(B . ?\x5501) ;; <CJK>
     (?$AQe(B . ?\x5F66) ;; <CJK>
     (?$AQf(B . ?\x7130) ;; <CJK>
     (?$AQg(B . ?\x5BB4) ;; <CJK>
     (?$AQh(B . ?\x8C1A) ;; <CJK>
     (?$AQi(B . ?\x9A8C) ;; <CJK>
     (?$AQj(B . ?\x6B83) ;; <CJK>
     (?$AQk(B . ?\x592E) ;; <CJK>
     (?$AQl(B . ?\x9E2F) ;; <CJK>
     (?$AQm(B . ?\x79E7) ;; <CJK>
     (?$AQn(B . ?\x6768) ;; <CJK>
     (?$AQo(B . ?\x626C) ;; <CJK>
     (?$AQp(B . ?\x4F6F) ;; <CJK>
     (?$AQq(B . ?\x75A1) ;; <CJK>
     (?$AQr(B . ?\x7F8A) ;; <CJK>
     (?$AQs(B . ?\x6D0B) ;; <CJK>
     (?$AQt(B . ?\x9633) ;; <CJK>
     (?$AQu(B . ?\x6C27) ;; <CJK>
     (?$AQv(B . ?\x4EF0) ;; <CJK>
     (?$AQw(B . ?\x75D2) ;; <CJK>
     (?$AQx(B . ?\x517B) ;; <CJK>
     (?$AQy(B . ?\x6837) ;; <CJK>
     (?$AQz(B . ?\x6F3E) ;; <CJK>
     (?$AQ{(B . ?\x9080) ;; <CJK>
     (?$AQ|(B . ?\x8170) ;; <CJK>
     (?$AQ}(B . ?\x5996) ;; <CJK>
     (?$AQ~(B . ?\x7476) ;; <CJK>
     (?$AR!(B . ?\x6447) ;; <CJK>
     (?$AR"(B . ?\x5C27) ;; <CJK>
     (?$AR#(B . ?\x9065) ;; <CJK>
     (?$AR$(B . ?\x7A91) ;; <CJK>
     (?$AR%(B . ?\x8C23) ;; <CJK>
     (?$AR&(B . ?\x59DA) ;; <CJK>
     (?$AR'(B . ?\x54AC) ;; <CJK>
     (?$AR((B . ?\x8200) ;; <CJK>
     (?$AR)(B . ?\x836F) ;; <CJK>
     (?$AR*(B . ?\x8981) ;; <CJK>
     (?$AR+(B . ?\x8000) ;; <CJK>
     (?$AR,(B . ?\x6930) ;; <CJK>
     (?$AR-(B . ?\x564E) ;; <CJK>
     (?$AR.(B . ?\x8036) ;; <CJK>
     (?$AR/(B . ?\x7237) ;; <CJK>
     (?$AR0(B . ?\x91CE) ;; <CJK>
     (?$AR1(B . ?\x51B6) ;; <CJK>
     (?$AR2(B . ?\x4E5F) ;; <CJK>
     (?$AR3(B . ?\x9875) ;; <CJK>
     (?$AR4(B . ?\x6396) ;; <CJK>
     (?$AR5(B . ?\x4E1A) ;; <CJK>
     (?$AR6(B . ?\x53F6) ;; <CJK>
     (?$AR7(B . ?\x66F3) ;; <CJK>
     (?$AR8(B . ?\x814B) ;; <CJK>
     (?$AR9(B . ?\x591C) ;; <CJK>
     (?$AR:(B . ?\x6DB2) ;; <CJK>
     (?$AR;(B . ?\x4E00) ;; <CJK>
     (?$AR<(B . ?\x58F9) ;; <CJK>
     (?$AR=(B . ?\x533B) ;; <CJK>
     (?$AR>(B . ?\x63D6) ;; <CJK>
     (?$AR?(B . ?\x94F1) ;; <CJK>
     (?$AR@(B . ?\x4F9D) ;; <CJK>
     (?$ARA(B . ?\x4F0A) ;; <CJK>
     (?$ARB(B . ?\x8863) ;; <CJK>
     (?$ARC(B . ?\x9890) ;; <CJK>
     (?$ARD(B . ?\x5937) ;; <CJK>
     (?$ARE(B . ?\x9057) ;; <CJK>
     (?$ARF(B . ?\x79FB) ;; <CJK>
     (?$ARG(B . ?\x4EEA) ;; <CJK>
     (?$ARH(B . ?\x80F0) ;; <CJK>
     (?$ARI(B . ?\x7591) ;; <CJK>
     (?$ARJ(B . ?\x6C82) ;; <CJK>
     (?$ARK(B . ?\x5B9C) ;; <CJK>
     (?$ARL(B . ?\x59E8) ;; <CJK>
     (?$ARM(B . ?\x5F5D) ;; <CJK>
     (?$ARN(B . ?\x6905) ;; <CJK>
     (?$ARO(B . ?\x8681) ;; <CJK>
     (?$ARP(B . ?\x501A) ;; <CJK>
     (?$ARQ(B . ?\x5DF2) ;; <CJK>
     (?$ARR(B . ?\x4E59) ;; <CJK>
     (?$ARS(B . ?\x77E3) ;; <CJK>
     (?$ART(B . ?\x4EE5) ;; <CJK>
     (?$ARU(B . ?\x827A) ;; <CJK>
     (?$ARV(B . ?\x6291) ;; <CJK>
     (?$ARW(B . ?\x6613) ;; <CJK>
     (?$ARX(B . ?\x9091) ;; <CJK>
     (?$ARY(B . ?\x5C79) ;; <CJK>
     (?$ARZ(B . ?\x4EBF) ;; <CJK>
     (?$AR[(B . ?\x5F79) ;; <CJK>
     (?$AR\(B . ?\x81C6) ;; <CJK>
     (?$AR](B . ?\x9038) ;; <CJK>
     (?$AR^(B . ?\x8084) ;; <CJK>
     (?$AR_(B . ?\x75AB) ;; <CJK>
     (?$AR`(B . ?\x4EA6) ;; <CJK>
     (?$ARa(B . ?\x88D4) ;; <CJK>
     (?$ARb(B . ?\x610F) ;; <CJK>
     (?$ARc(B . ?\x6BC5) ;; <CJK>
     (?$ARd(B . ?\x5FC6) ;; <CJK>
     (?$ARe(B . ?\x4E49) ;; <CJK>
     (?$ARf(B . ?\x76CA) ;; <CJK>
     (?$ARg(B . ?\x6EA2) ;; <CJK>
     (?$ARh(B . ?\x8BE3) ;; <CJK>
     (?$ARi(B . ?\x8BAE) ;; <CJK>
     (?$ARj(B . ?\x8C0A) ;; <CJK>
     (?$ARk(B . ?\x8BD1) ;; <CJK>
     (?$ARl(B . ?\x5F02) ;; <CJK>
     (?$ARm(B . ?\x7FFC) ;; <CJK>
     (?$ARn(B . ?\x7FCC) ;; <CJK>
     (?$ARo(B . ?\x7ECE) ;; <CJK>
     (?$ARp(B . ?\x8335) ;; <CJK>
     (?$ARq(B . ?\x836B) ;; <CJK>
     (?$ARr(B . ?\x56E0) ;; <CJK>
     (?$ARs(B . ?\x6BB7) ;; <CJK>
     (?$ARt(B . ?\x97F3) ;; <CJK>
     (?$ARu(B . ?\x9634) ;; <CJK>
     (?$ARv(B . ?\x59FB) ;; <CJK>
     (?$ARw(B . ?\x541F) ;; <CJK>
     (?$ARx(B . ?\x94F6) ;; <CJK>
     (?$ARy(B . ?\x6DEB) ;; <CJK>
     (?$ARz(B . ?\x5BC5) ;; <CJK>
     (?$AR{(B . ?\x996E) ;; <CJK>
     (?$AR|(B . ?\x5C39) ;; <CJK>
     (?$AR}(B . ?\x5F15) ;; <CJK>
     (?$AR~(B . ?\x9690) ;; <CJK>
     (?$AS!(B . ?\x5370) ;; <CJK>
     (?$AS"(B . ?\x82F1) ;; <CJK>
     (?$AS#(B . ?\x6A31) ;; <CJK>
     (?$AS$(B . ?\x5A74) ;; <CJK>
     (?$AS%(B . ?\x9E70) ;; <CJK>
     (?$AS&(B . ?\x5E94) ;; <CJK>
     (?$AS'(B . ?\x7F28) ;; <CJK>
     (?$AS((B . ?\x83B9) ;; <CJK>
     (?$AS)(B . ?\x8424) ;; <CJK>
     (?$AS*(B . ?\x8425) ;; <CJK>
     (?$AS+(B . ?\x8367) ;; <CJK>
     (?$AS,(B . ?\x8747) ;; <CJK>
     (?$AS-(B . ?\x8FCE) ;; <CJK>
     (?$AS.(B . ?\x8D62) ;; <CJK>
     (?$AS/(B . ?\x76C8) ;; <CJK>
     (?$AS0(B . ?\x5F71) ;; <CJK>
     (?$AS1(B . ?\x9896) ;; <CJK>
     (?$AS2(B . ?\x786C) ;; <CJK>
     (?$AS3(B . ?\x6620) ;; <CJK>
     (?$AS4(B . ?\x54DF) ;; <CJK>
     (?$AS5(B . ?\x62E5) ;; <CJK>
     (?$AS6(B . ?\x4F63) ;; <CJK>
     (?$AS7(B . ?\x81C3) ;; <CJK>
     (?$AS8(B . ?\x75C8) ;; <CJK>
     (?$AS9(B . ?\x5EB8) ;; <CJK>
     (?$AS:(B . ?\x96CD) ;; <CJK>
     (?$AS;(B . ?\x8E0A) ;; <CJK>
     (?$AS<(B . ?\x86F9) ;; <CJK>
     (?$AS=(B . ?\x548F) ;; <CJK>
     (?$AS>(B . ?\x6CF3) ;; <CJK>
     (?$AS?(B . ?\x6D8C) ;; <CJK>
     (?$AS@(B . ?\x6C38) ;; <CJK>
     (?$ASA(B . ?\x607F) ;; <CJK>
     (?$ASB(B . ?\x52C7) ;; <CJK>
     (?$ASC(B . ?\x7528) ;; <CJK>
     (?$ASD(B . ?\x5E7D) ;; <CJK>
     (?$ASE(B . ?\x4F18) ;; <CJK>
     (?$ASF(B . ?\x60A0) ;; <CJK>
     (?$ASG(B . ?\x5FE7) ;; <CJK>
     (?$ASH(B . ?\x5C24) ;; <CJK>
     (?$ASI(B . ?\x7531) ;; <CJK>
     (?$ASJ(B . ?\x90AE) ;; <CJK>
     (?$ASK(B . ?\x94C0) ;; <CJK>
     (?$ASL(B . ?\x72B9) ;; <CJK>
     (?$ASM(B . ?\x6CB9) ;; <CJK>
     (?$ASN(B . ?\x6E38) ;; <CJK>
     (?$ASO(B . ?\x9149) ;; <CJK>
     (?$ASP(B . ?\x6709) ;; <CJK>
     (?$ASQ(B . ?\x53CB) ;; <CJK>
     (?$ASR(B . ?\x53F3) ;; <CJK>
     (?$ASS(B . ?\x4F51) ;; <CJK>
     (?$AST(B . ?\x91C9) ;; <CJK>
     (?$ASU(B . ?\x8BF1) ;; <CJK>
     (?$ASV(B . ?\x53C8) ;; <CJK>
     (?$ASW(B . ?\x5E7C) ;; <CJK>
     (?$ASX(B . ?\x8FC2) ;; <CJK>
     (?$ASY(B . ?\x6DE4) ;; <CJK>
     (?$ASZ(B . ?\x4E8E) ;; <CJK>
     (?$AS[(B . ?\x76C2) ;; <CJK>
     (?$AS\(B . ?\x6986) ;; <CJK>
     (?$AS](B . ?\x865E) ;; <CJK>
     (?$AS^(B . ?\x611A) ;; <CJK>
     (?$AS_(B . ?\x8206) ;; <CJK>
     (?$AS`(B . ?\x4F59) ;; <CJK>
     (?$ASa(B . ?\x4FDE) ;; <CJK>
     (?$ASb(B . ?\x903E) ;; <CJK>
     (?$ASc(B . ?\x9C7C) ;; <CJK>
     (?$ASd(B . ?\x6109) ;; <CJK>
     (?$ASe(B . ?\x6E1D) ;; <CJK>
     (?$ASf(B . ?\x6E14) ;; <CJK>
     (?$ASg(B . ?\x9685) ;; <CJK>
     (?$ASh(B . ?\x4E88) ;; <CJK>
     (?$ASi(B . ?\x5A31) ;; <CJK>
     (?$ASj(B . ?\x96E8) ;; <CJK>
     (?$ASk(B . ?\x4E0E) ;; <CJK>
     (?$ASl(B . ?\x5C7F) ;; <CJK>
     (?$ASm(B . ?\x79B9) ;; <CJK>
     (?$ASn(B . ?\x5B87) ;; <CJK>
     (?$ASo(B . ?\x8BED) ;; <CJK>
     (?$ASp(B . ?\x7FBD) ;; <CJK>
     (?$ASq(B . ?\x7389) ;; <CJK>
     (?$ASr(B . ?\x57DF) ;; <CJK>
     (?$ASs(B . ?\x828B) ;; <CJK>
     (?$ASt(B . ?\x90C1) ;; <CJK>
     (?$ASu(B . ?\x5401) ;; <CJK>
     (?$ASv(B . ?\x9047) ;; <CJK>
     (?$ASw(B . ?\x55BB) ;; <CJK>
     (?$ASx(B . ?\x5CEA) ;; <CJK>
     (?$ASy(B . ?\x5FA1) ;; <CJK>
     (?$ASz(B . ?\x6108) ;; <CJK>
     (?$AS{(B . ?\x6B32) ;; <CJK>
     (?$AS|(B . ?\x72F1) ;; <CJK>
     (?$AS}(B . ?\x80B2) ;; <CJK>
     (?$AS~(B . ?\x8A89) ;; <CJK>
     (?$AT!(B . ?\x6D74) ;; <CJK>
     (?$AT"(B . ?\x5BD3) ;; <CJK>
     (?$AT#(B . ?\x88D5) ;; <CJK>
     (?$AT$(B . ?\x9884) ;; <CJK>
     (?$AT%(B . ?\x8C6B) ;; <CJK>
     (?$AT&(B . ?\x9A6D) ;; <CJK>
     (?$AT'(B . ?\x9E33) ;; <CJK>
     (?$AT((B . ?\x6E0A) ;; <CJK>
     (?$AT)(B . ?\x51A4) ;; <CJK>
     (?$AT*(B . ?\x5143) ;; <CJK>
     (?$AT+(B . ?\x57A3) ;; <CJK>
     (?$AT,(B . ?\x8881) ;; <CJK>
     (?$AT-(B . ?\x539F) ;; <CJK>
     (?$AT.(B . ?\x63F4) ;; <CJK>
     (?$AT/(B . ?\x8F95) ;; <CJK>
     (?$AT0(B . ?\x56ED) ;; <CJK>
     (?$AT1(B . ?\x5458) ;; <CJK>
     (?$AT2(B . ?\x5706) ;; <CJK>
     (?$AT3(B . ?\x733F) ;; <CJK>
     (?$AT4(B . ?\x6E90) ;; <CJK>
     (?$AT5(B . ?\x7F18) ;; <CJK>
     (?$AT6(B . ?\x8FDC) ;; <CJK>
     (?$AT7(B . ?\x82D1) ;; <CJK>
     (?$AT8(B . ?\x613F) ;; <CJK>
     (?$AT9(B . ?\x6028) ;; <CJK>
     (?$AT:(B . ?\x9662) ;; <CJK>
     (?$AT;(B . ?\x66F0) ;; <CJK>
     (?$AT<(B . ?\x7EA6) ;; <CJK>
     (?$AT=(B . ?\x8D8A) ;; <CJK>
     (?$AT>(B . ?\x8DC3) ;; <CJK>
     (?$AT?(B . ?\x94A5) ;; <CJK>
     (?$AT@(B . ?\x5CB3) ;; <CJK>
     (?$ATA(B . ?\x7CA4) ;; <CJK>
     (?$ATB(B . ?\x6708) ;; <CJK>
     (?$ATC(B . ?\x60A6) ;; <CJK>
     (?$ATD(B . ?\x9605) ;; <CJK>
     (?$ATE(B . ?\x8018) ;; <CJK>
     (?$ATF(B . ?\x4E91) ;; <CJK>
     (?$ATG(B . ?\x90E7) ;; <CJK>
     (?$ATH(B . ?\x5300) ;; <CJK>
     (?$ATI(B . ?\x9668) ;; <CJK>
     (?$ATJ(B . ?\x5141) ;; <CJK>
     (?$ATK(B . ?\x8FD0) ;; <CJK>
     (?$ATL(B . ?\x8574) ;; <CJK>
     (?$ATM(B . ?\x915D) ;; <CJK>
     (?$ATN(B . ?\x6655) ;; <CJK>
     (?$ATO(B . ?\x97F5) ;; <CJK>
     (?$ATP(B . ?\x5B55) ;; <CJK>
     (?$ATQ(B . ?\x531D) ;; <CJK>
     (?$ATR(B . ?\x7838) ;; <CJK>
     (?$ATS(B . ?\x6742) ;; <CJK>
     (?$ATT(B . ?\x683D) ;; <CJK>
     (?$ATU(B . ?\x54C9) ;; <CJK>
     (?$ATV(B . ?\x707E) ;; <CJK>
     (?$ATW(B . ?\x5BB0) ;; <CJK>
     (?$ATX(B . ?\x8F7D) ;; <CJK>
     (?$ATY(B . ?\x518D) ;; <CJK>
     (?$ATZ(B . ?\x5728) ;; <CJK>
     (?$AT[(B . ?\x54B1) ;; <CJK>
     (?$AT\(B . ?\x6512) ;; <CJK>
     (?$AT](B . ?\x6682) ;; <CJK>
     (?$AT^(B . ?\x8D5E) ;; <CJK>
     (?$AT_(B . ?\x8D43) ;; <CJK>
     (?$AT`(B . ?\x810F) ;; <CJK>
     (?$ATa(B . ?\x846C) ;; <CJK>
     (?$ATb(B . ?\x906D) ;; <CJK>
     (?$ATc(B . ?\x7CDF) ;; <CJK>
     (?$ATd(B . ?\x51FF) ;; <CJK>
     (?$ATe(B . ?\x85FB) ;; <CJK>
     (?$ATf(B . ?\x67A3) ;; <CJK>
     (?$ATg(B . ?\x65E9) ;; <CJK>
     (?$ATh(B . ?\x6FA1) ;; <CJK>
     (?$ATi(B . ?\x86A4) ;; <CJK>
     (?$ATj(B . ?\x8E81) ;; <CJK>
     (?$ATk(B . ?\x566A) ;; <CJK>
     (?$ATl(B . ?\x9020) ;; <CJK>
     (?$ATm(B . ?\x7682) ;; <CJK>
     (?$ATn(B . ?\x7076) ;; <CJK>
     (?$ATo(B . ?\x71E5) ;; <CJK>
     (?$ATp(B . ?\x8D23) ;; <CJK>
     (?$ATq(B . ?\x62E9) ;; <CJK>
     (?$ATr(B . ?\x5219) ;; <CJK>
     (?$ATs(B . ?\x6CFD) ;; <CJK>
     (?$ATt(B . ?\x8D3C) ;; <CJK>
     (?$ATu(B . ?\x600E) ;; <CJK>
     (?$ATv(B . ?\x589E) ;; <CJK>
     (?$ATw(B . ?\x618E) ;; <CJK>
     (?$ATx(B . ?\x66FE) ;; <CJK>
     (?$ATy(B . ?\x8D60) ;; <CJK>
     (?$ATz(B . ?\x624E) ;; <CJK>
     (?$AT{(B . ?\x55B3) ;; <CJK>
     (?$AT|(B . ?\x6E23) ;; <CJK>
     (?$AT}(B . ?\x672D) ;; <CJK>
     (?$AT~(B . ?\x8F67) ;; <CJK>
     (?$AU!(B . ?\x94E1) ;; <CJK>
     (?$AU"(B . ?\x95F8) ;; <CJK>
     (?$AU#(B . ?\x7728) ;; <CJK>
     (?$AU$(B . ?\x6805) ;; <CJK>
     (?$AU%(B . ?\x69A8) ;; <CJK>
     (?$AU&(B . ?\x548B) ;; <CJK>
     (?$AU'(B . ?\x4E4D) ;; <CJK>
     (?$AU((B . ?\x70B8) ;; <CJK>
     (?$AU)(B . ?\x8BC8) ;; <CJK>
     (?$AU*(B . ?\x6458) ;; <CJK>
     (?$AU+(B . ?\x658B) ;; <CJK>
     (?$AU,(B . ?\x5B85) ;; <CJK>
     (?$AU-(B . ?\x7A84) ;; <CJK>
     (?$AU.(B . ?\x503A) ;; <CJK>
     (?$AU/(B . ?\x5BE8) ;; <CJK>
     (?$AU0(B . ?\x77BB) ;; <CJK>
     (?$AU1(B . ?\x6BE1) ;; <CJK>
     (?$AU2(B . ?\x8A79) ;; <CJK>
     (?$AU3(B . ?\x7C98) ;; <CJK>
     (?$AU4(B . ?\x6CBE) ;; <CJK>
     (?$AU5(B . ?\x76CF) ;; <CJK>
     (?$AU6(B . ?\x65A9) ;; <CJK>
     (?$AU7(B . ?\x8F97) ;; <CJK>
     (?$AU8(B . ?\x5D2D) ;; <CJK>
     (?$AU9(B . ?\x5C55) ;; <CJK>
     (?$AU:(B . ?\x8638) ;; <CJK>
     (?$AU;(B . ?\x6808) ;; <CJK>
     (?$AU<(B . ?\x5360) ;; <CJK>
     (?$AU=(B . ?\x6218) ;; <CJK>
     (?$AU>(B . ?\x7AD9) ;; <CJK>
     (?$AU?(B . ?\x6E5B) ;; <CJK>
     (?$AU@(B . ?\x7EFD) ;; <CJK>
     (?$AUA(B . ?\x6A1F) ;; <CJK>
     (?$AUB(B . ?\x7AE0) ;; <CJK>
     (?$AUC(B . ?\x5F70) ;; <CJK>
     (?$AUD(B . ?\x6F33) ;; <CJK>
     (?$AUE(B . ?\x5F20) ;; <CJK>
     (?$AUF(B . ?\x638C) ;; <CJK>
     (?$AUG(B . ?\x6DA8) ;; <CJK>
     (?$AUH(B . ?\x6756) ;; <CJK>
     (?$AUI(B . ?\x4E08) ;; <CJK>
     (?$AUJ(B . ?\x5E10) ;; <CJK>
     (?$AUK(B . ?\x8D26) ;; <CJK>
     (?$AUL(B . ?\x4ED7) ;; <CJK>
     (?$AUM(B . ?\x80C0) ;; <CJK>
     (?$AUN(B . ?\x7634) ;; <CJK>
     (?$AUO(B . ?\x969C) ;; <CJK>
     (?$AUP(B . ?\x62DB) ;; <CJK>
     (?$AUQ(B . ?\x662D) ;; <CJK>
     (?$AUR(B . ?\x627E) ;; <CJK>
     (?$AUS(B . ?\x6CBC) ;; <CJK>
     (?$AUT(B . ?\x8D75) ;; <CJK>
     (?$AUU(B . ?\x7167) ;; <CJK>
     (?$AUV(B . ?\x7F69) ;; <CJK>
     (?$AUW(B . ?\x5146) ;; <CJK>
     (?$AUX(B . ?\x8087) ;; <CJK>
     (?$AUY(B . ?\x53EC) ;; <CJK>
     (?$AUZ(B . ?\x906E) ;; <CJK>
     (?$AU[(B . ?\x6298) ;; <CJK>
     (?$AU\(B . ?\x54F2) ;; <CJK>
     (?$AU](B . ?\x86F0) ;; <CJK>
     (?$AU^(B . ?\x8F99) ;; <CJK>
     (?$AU_(B . ?\x8005) ;; <CJK>
     (?$AU`(B . ?\x9517) ;; <CJK>
     (?$AUa(B . ?\x8517) ;; <CJK>
     (?$AUb(B . ?\x8FD9) ;; <CJK>
     (?$AUc(B . ?\x6D59) ;; <CJK>
     (?$AUd(B . ?\x73CD) ;; <CJK>
     (?$AUe(B . ?\x659F) ;; <CJK>
     (?$AUf(B . ?\x771F) ;; <CJK>
     (?$AUg(B . ?\x7504) ;; <CJK>
     (?$AUh(B . ?\x7827) ;; <CJK>
     (?$AUi(B . ?\x81FB) ;; <CJK>
     (?$AUj(B . ?\x8D1E) ;; <CJK>
     (?$AUk(B . ?\x9488) ;; <CJK>
     (?$AUl(B . ?\x4FA6) ;; <CJK>
     (?$AUm(B . ?\x6795) ;; <CJK>
     (?$AUn(B . ?\x75B9) ;; <CJK>
     (?$AUo(B . ?\x8BCA) ;; <CJK>
     (?$AUp(B . ?\x9707) ;; <CJK>
     (?$AUq(B . ?\x632F) ;; <CJK>
     (?$AUr(B . ?\x9547) ;; <CJK>
     (?$AUs(B . ?\x9635) ;; <CJK>
     (?$AUt(B . ?\x84B8) ;; <CJK>
     (?$AUu(B . ?\x6323) ;; <CJK>
     (?$AUv(B . ?\x7741) ;; <CJK>
     (?$AUw(B . ?\x5F81) ;; <CJK>
     (?$AUx(B . ?\x72F0) ;; <CJK>
     (?$AUy(B . ?\x4E89) ;; <CJK>
     (?$AUz(B . ?\x6014) ;; <CJK>
     (?$AU{(B . ?\x6574) ;; <CJK>
     (?$AU|(B . ?\x62EF) ;; <CJK>
     (?$AU}(B . ?\x6B63) ;; <CJK>
     (?$AU~(B . ?\x653F) ;; <CJK>
     (?$AV!(B . ?\x5E27) ;; <CJK>
     (?$AV"(B . ?\x75C7) ;; <CJK>
     (?$AV#(B . ?\x90D1) ;; <CJK>
     (?$AV$(B . ?\x8BC1) ;; <CJK>
     (?$AV%(B . ?\x829D) ;; <CJK>
     (?$AV&(B . ?\x679D) ;; <CJK>
     (?$AV'(B . ?\x652F) ;; <CJK>
     (?$AV((B . ?\x5431) ;; <CJK>
     (?$AV)(B . ?\x8718) ;; <CJK>
     (?$AV*(B . ?\x77E5) ;; <CJK>
     (?$AV+(B . ?\x80A2) ;; <CJK>
     (?$AV,(B . ?\x8102) ;; <CJK>
     (?$AV-(B . ?\x6C41) ;; <CJK>
     (?$AV.(B . ?\x4E4B) ;; <CJK>
     (?$AV/(B . ?\x7EC7) ;; <CJK>
     (?$AV0(B . ?\x804C) ;; <CJK>
     (?$AV1(B . ?\x76F4) ;; <CJK>
     (?$AV2(B . ?\x690D) ;; <CJK>
     (?$AV3(B . ?\x6B96) ;; <CJK>
     (?$AV4(B . ?\x6267) ;; <CJK>
     (?$AV5(B . ?\x503C) ;; <CJK>
     (?$AV6(B . ?\x4F84) ;; <CJK>
     (?$AV7(B . ?\x5740) ;; <CJK>
     (?$AV8(B . ?\x6307) ;; <CJK>
     (?$AV9(B . ?\x6B62) ;; <CJK>
     (?$AV:(B . ?\x8DBE) ;; <CJK>
     (?$AV;(B . ?\x53EA) ;; <CJK>
     (?$AV<(B . ?\x65E8) ;; <CJK>
     (?$AV=(B . ?\x7EB8) ;; <CJK>
     (?$AV>(B . ?\x5FD7) ;; <CJK>
     (?$AV?(B . ?\x631A) ;; <CJK>
     (?$AV@(B . ?\x63B7) ;; <CJK>
     (?$AVA(B . ?\x81F3) ;; <CJK>
     (?$AVB(B . ?\x81F4) ;; <CJK>
     (?$AVC(B . ?\x7F6E) ;; <CJK>
     (?$AVD(B . ?\x5E1C) ;; <CJK>
     (?$AVE(B . ?\x5CD9) ;; <CJK>
     (?$AVF(B . ?\x5236) ;; <CJK>
     (?$AVG(B . ?\x667A) ;; <CJK>
     (?$AVH(B . ?\x79E9) ;; <CJK>
     (?$AVI(B . ?\x7A1A) ;; <CJK>
     (?$AVJ(B . ?\x8D28) ;; <CJK>
     (?$AVK(B . ?\x7099) ;; <CJK>
     (?$AVL(B . ?\x75D4) ;; <CJK>
     (?$AVM(B . ?\x6EDE) ;; <CJK>
     (?$AVN(B . ?\x6CBB) ;; <CJK>
     (?$AVO(B . ?\x7A92) ;; <CJK>
     (?$AVP(B . ?\x4E2D) ;; <CJK>
     (?$AVQ(B . ?\x76C5) ;; <CJK>
     (?$AVR(B . ?\x5FE0) ;; <CJK>
     (?$AVS(B . ?\x949F) ;; <CJK>
     (?$AVT(B . ?\x8877) ;; <CJK>
     (?$AVU(B . ?\x7EC8) ;; <CJK>
     (?$AVV(B . ?\x79CD) ;; <CJK>
     (?$AVW(B . ?\x80BF) ;; <CJK>
     (?$AVX(B . ?\x91CD) ;; <CJK>
     (?$AVY(B . ?\x4EF2) ;; <CJK>
     (?$AVZ(B . ?\x4F17) ;; <CJK>
     (?$AV[(B . ?\x821F) ;; <CJK>
     (?$AV\(B . ?\x5468) ;; <CJK>
     (?$AV](B . ?\x5DDE) ;; <CJK>
     (?$AV^(B . ?\x6D32) ;; <CJK>
     (?$AV_(B . ?\x8BCC) ;; <CJK>
     (?$AV`(B . ?\x7CA5) ;; <CJK>
     (?$AVa(B . ?\x8F74) ;; <CJK>
     (?$AVb(B . ?\x8098) ;; <CJK>
     (?$AVc(B . ?\x5E1A) ;; <CJK>
     (?$AVd(B . ?\x5492) ;; <CJK>
     (?$AVe(B . ?\x76B1) ;; <CJK>
     (?$AVf(B . ?\x5B99) ;; <CJK>
     (?$AVg(B . ?\x663C) ;; <CJK>
     (?$AVh(B . ?\x9AA4) ;; <CJK>
     (?$AVi(B . ?\x73E0) ;; <CJK>
     (?$AVj(B . ?\x682A) ;; <CJK>
     (?$AVk(B . ?\x86DB) ;; <CJK>
     (?$AVl(B . ?\x6731) ;; <CJK>
     (?$AVm(B . ?\x732A) ;; <CJK>
     (?$AVn(B . ?\x8BF8) ;; <CJK>
     (?$AVo(B . ?\x8BDB) ;; <CJK>
     (?$AVp(B . ?\x9010) ;; <CJK>
     (?$AVq(B . ?\x7AF9) ;; <CJK>
     (?$AVr(B . ?\x70DB) ;; <CJK>
     (?$AVs(B . ?\x716E) ;; <CJK>
     (?$AVt(B . ?\x62C4) ;; <CJK>
     (?$AVu(B . ?\x77A9) ;; <CJK>
     (?$AVv(B . ?\x5631) ;; <CJK>
     (?$AVw(B . ?\x4E3B) ;; <CJK>
     (?$AVx(B . ?\x8457) ;; <CJK>
     (?$AVy(B . ?\x67F1) ;; <CJK>
     (?$AVz(B . ?\x52A9) ;; <CJK>
     (?$AV{(B . ?\x86C0) ;; <CJK>
     (?$AV|(B . ?\x8D2E) ;; <CJK>
     (?$AV}(B . ?\x94F8) ;; <CJK>
     (?$AV~(B . ?\x7B51) ;; <CJK>
     (?$AW!(B . ?\x4F4F) ;; <CJK>
     (?$AW"(B . ?\x6CE8) ;; <CJK>
     (?$AW#(B . ?\x795D) ;; <CJK>
     (?$AW$(B . ?\x9A7B) ;; <CJK>
     (?$AW%(B . ?\x6293) ;; <CJK>
     (?$AW&(B . ?\x722A) ;; <CJK>
     (?$AW'(B . ?\x62FD) ;; <CJK>
     (?$AW((B . ?\x4E13) ;; <CJK>
     (?$AW)(B . ?\x7816) ;; <CJK>
     (?$AW*(B . ?\x8F6C) ;; <CJK>
     (?$AW+(B . ?\x64B0) ;; <CJK>
     (?$AW,(B . ?\x8D5A) ;; <CJK>
     (?$AW-(B . ?\x7BC6) ;; <CJK>
     (?$AW.(B . ?\x6869) ;; <CJK>
     (?$AW/(B . ?\x5E84) ;; <CJK>
     (?$AW0(B . ?\x88C5) ;; <CJK>
     (?$AW1(B . ?\x5986) ;; <CJK>
     (?$AW2(B . ?\x649E) ;; <CJK>
     (?$AW3(B . ?\x58EE) ;; <CJK>
     (?$AW4(B . ?\x72B6) ;; <CJK>
     (?$AW5(B . ?\x690E) ;; <CJK>
     (?$AW6(B . ?\x9525) ;; <CJK>
     (?$AW7(B . ?\x8FFD) ;; <CJK>
     (?$AW8(B . ?\x8D58) ;; <CJK>
     (?$AW9(B . ?\x5760) ;; <CJK>
     (?$AW:(B . ?\x7F00) ;; <CJK>
     (?$AW;(B . ?\x8C06) ;; <CJK>
     (?$AW<(B . ?\x51C6) ;; <CJK>
     (?$AW=(B . ?\x6349) ;; <CJK>
     (?$AW>(B . ?\x62D9) ;; <CJK>
     (?$AW?(B . ?\x5353) ;; <CJK>
     (?$AW@(B . ?\x684C) ;; <CJK>
     (?$AWA(B . ?\x7422) ;; <CJK>
     (?$AWB(B . ?\x8301) ;; <CJK>
     (?$AWC(B . ?\x914C) ;; <CJK>
     (?$AWD(B . ?\x5544) ;; <CJK>
     (?$AWE(B . ?\x7740) ;; <CJK>
     (?$AWF(B . ?\x707C) ;; <CJK>
     (?$AWG(B . ?\x6D4A) ;; <CJK>
     (?$AWH(B . ?\x5179) ;; <CJK>
     (?$AWI(B . ?\x54A8) ;; <CJK>
     (?$AWJ(B . ?\x8D44) ;; <CJK>
     (?$AWK(B . ?\x59FF) ;; <CJK>
     (?$AWL(B . ?\x6ECB) ;; <CJK>
     (?$AWM(B . ?\x6DC4) ;; <CJK>
     (?$AWN(B . ?\x5B5C) ;; <CJK>
     (?$AWO(B . ?\x7D2B) ;; <CJK>
     (?$AWP(B . ?\x4ED4) ;; <CJK>
     (?$AWQ(B . ?\x7C7D) ;; <CJK>
     (?$AWR(B . ?\x6ED3) ;; <CJK>
     (?$AWS(B . ?\x5B50) ;; <CJK>
     (?$AWT(B . ?\x81EA) ;; <CJK>
     (?$AWU(B . ?\x6E0D) ;; <CJK>
     (?$AWV(B . ?\x5B57) ;; <CJK>
     (?$AWW(B . ?\x9B03) ;; <CJK>
     (?$AWX(B . ?\x68D5) ;; <CJK>
     (?$AWY(B . ?\x8E2A) ;; <CJK>
     (?$AWZ(B . ?\x5B97) ;; <CJK>
     (?$AW[(B . ?\x7EFC) ;; <CJK>
     (?$AW\(B . ?\x603B) ;; <CJK>
     (?$AW](B . ?\x7EB5) ;; <CJK>
     (?$AW^(B . ?\x90B9) ;; <CJK>
     (?$AW_(B . ?\x8D70) ;; <CJK>
     (?$AW`(B . ?\x594F) ;; <CJK>
     (?$AWa(B . ?\x63CD) ;; <CJK>
     (?$AWb(B . ?\x79DF) ;; <CJK>
     (?$AWc(B . ?\x8DB3) ;; <CJK>
     (?$AWd(B . ?\x5352) ;; <CJK>
     (?$AWe(B . ?\x65CF) ;; <CJK>
     (?$AWf(B . ?\x7956) ;; <CJK>
     (?$AWg(B . ?\x8BC5) ;; <CJK>
     (?$AWh(B . ?\x963B) ;; <CJK>
     (?$AWi(B . ?\x7EC4) ;; <CJK>
     (?$AWj(B . ?\x94BB) ;; <CJK>
     (?$AWk(B . ?\x7E82) ;; <CJK>
     (?$AWl(B . ?\x5634) ;; <CJK>
     (?$AWm(B . ?\x9189) ;; <CJK>
     (?$AWn(B . ?\x6700) ;; <CJK>
     (?$AWo(B . ?\x7F6A) ;; <CJK>
     (?$AWp(B . ?\x5C0A) ;; <CJK>
     (?$AWq(B . ?\x9075) ;; <CJK>
     (?$AWr(B . ?\x6628) ;; <CJK>
     (?$AWs(B . ?\x5DE6) ;; <CJK>
     (?$AWt(B . ?\x4F50) ;; <CJK>
     (?$AWu(B . ?\x67DE) ;; <CJK>
     (?$AWv(B . ?\x505A) ;; <CJK>
     (?$AWw(B . ?\x4F5C) ;; <CJK>
     (?$AWx(B . ?\x5750) ;; <CJK>
     (?$AWy(B . ?\x5EA7) ;; <CJK>
     (?$AX!(B . ?\x4E8D) ;; <CJK>
     (?$AX"(B . ?\x4E0C) ;; <CJK>
     (?$AX#(B . ?\x5140) ;; <CJK>
     (?$AX$(B . ?\x4E10) ;; <CJK>
     (?$AX%(B . ?\x5EFF) ;; <CJK>
     (?$AX&(B . ?\x5345) ;; <CJK>
     (?$AX'(B . ?\x4E15) ;; <CJK>
     (?$AX((B . ?\x4E98) ;; <CJK>
     (?$AX)(B . ?\x4E1E) ;; <CJK>
     (?$AX*(B . ?\x9B32) ;; <CJK>
     (?$AX+(B . ?\x5B6C) ;; <CJK>
     (?$AX,(B . ?\x5669) ;; <CJK>
     (?$AX-(B . ?\x4E28) ;; <CJK>
     (?$AX.(B . ?\x79BA) ;; <CJK>
     (?$AX/(B . ?\x4E3F) ;; <CJK>
     (?$AX0(B . ?\x5315) ;; <CJK>
     (?$AX1(B . ?\x4E47) ;; <CJK>
     (?$AX2(B . ?\x592D) ;; <CJK>
     (?$AX3(B . ?\x723B) ;; <CJK>
     (?$AX4(B . ?\x536E) ;; <CJK>
     (?$AX5(B . ?\x6C10) ;; <CJK>
     (?$AX6(B . ?\x56DF) ;; <CJK>
     (?$AX7(B . ?\x80E4) ;; <CJK>
     (?$AX8(B . ?\x9997) ;; <CJK>
     (?$AX9(B . ?\x6BD3) ;; <CJK>
     (?$AX:(B . ?\x777E) ;; <CJK>
     (?$AX;(B . ?\x9F17) ;; <CJK>
     (?$AX<(B . ?\x4E36) ;; <CJK>
     (?$AX=(B . ?\x4E9F) ;; <CJK>
     (?$AX>(B . ?\x9F10) ;; <CJK>
     (?$AX?(B . ?\x4E5C) ;; <CJK>
     (?$AX@(B . ?\x4E69) ;; <CJK>
     (?$AXA(B . ?\x4E93) ;; <CJK>
     (?$AXB(B . ?\x8288) ;; <CJK>
     (?$AXC(B . ?\x5B5B) ;; <CJK>
     (?$AXD(B . ?\x556C) ;; <CJK>
     (?$AXE(B . ?\x560F) ;; <CJK>
     (?$AXF(B . ?\x4EC4) ;; <CJK>
     (?$AXG(B . ?\x538D) ;; <CJK>
     (?$AXH(B . ?\x539D) ;; <CJK>
     (?$AXI(B . ?\x53A3) ;; <CJK>
     (?$AXJ(B . ?\x53A5) ;; <CJK>
     (?$AXK(B . ?\x53AE) ;; <CJK>
     (?$AXL(B . ?\x9765) ;; <CJK>
     (?$AXM(B . ?\x8D5D) ;; <CJK>
     (?$AXN(B . ?\x531A) ;; <CJK>
     (?$AXO(B . ?\x53F5) ;; <CJK>
     (?$AXP(B . ?\x5326) ;; <CJK>
     (?$AXQ(B . ?\x532E) ;; <CJK>
     (?$AXR(B . ?\x533E) ;; <CJK>
     (?$AXS(B . ?\x8D5C) ;; <CJK>
     (?$AXT(B . ?\x5366) ;; <CJK>
     (?$AXU(B . ?\x5363) ;; <CJK>
     (?$AXV(B . ?\x5202) ;; <CJK>
     (?$AXW(B . ?\x5208) ;; <CJK>
     (?$AXX(B . ?\x520E) ;; <CJK>
     (?$AXY(B . ?\x522D) ;; <CJK>
     (?$AXZ(B . ?\x5233) ;; <CJK>
     (?$AX[(B . ?\x523F) ;; <CJK>
     (?$AX\(B . ?\x5240) ;; <CJK>
     (?$AX](B . ?\x524C) ;; <CJK>
     (?$AX^(B . ?\x525E) ;; <CJK>
     (?$AX_(B . ?\x5261) ;; <CJK>
     (?$AX`(B . ?\x525C) ;; <CJK>
     (?$AXa(B . ?\x84AF) ;; <CJK>
     (?$AXb(B . ?\x527D) ;; <CJK>
     (?$AXc(B . ?\x5282) ;; <CJK>
     (?$AXd(B . ?\x5281) ;; <CJK>
     (?$AXe(B . ?\x5290) ;; <CJK>
     (?$AXf(B . ?\x5293) ;; <CJK>
     (?$AXg(B . ?\x5182) ;; <CJK>
     (?$AXh(B . ?\x7F54) ;; <CJK>
     (?$AXi(B . ?\x4EBB) ;; <CJK>
     (?$AXj(B . ?\x4EC3) ;; <CJK>
     (?$AXk(B . ?\x4EC9) ;; <CJK>
     (?$AXl(B . ?\x4EC2) ;; <CJK>
     (?$AXm(B . ?\x4EE8) ;; <CJK>
     (?$AXn(B . ?\x4EE1) ;; <CJK>
     (?$AXo(B . ?\x4EEB) ;; <CJK>
     (?$AXp(B . ?\x4EDE) ;; <CJK>
     (?$AXq(B . ?\x4F1B) ;; <CJK>
     (?$AXr(B . ?\x4EF3) ;; <CJK>
     (?$AXs(B . ?\x4F22) ;; <CJK>
     (?$AXt(B . ?\x4F64) ;; <CJK>
     (?$AXu(B . ?\x4EF5) ;; <CJK>
     (?$AXv(B . ?\x4F25) ;; <CJK>
     (?$AXw(B . ?\x4F27) ;; <CJK>
     (?$AXx(B . ?\x4F09) ;; <CJK>
     (?$AXy(B . ?\x4F2B) ;; <CJK>
     (?$AXz(B . ?\x4F5E) ;; <CJK>
     (?$AX{(B . ?\x4F67) ;; <CJK>
     (?$AX|(B . ?\x6538) ;; <CJK>
     (?$AX}(B . ?\x4F5A) ;; <CJK>
     (?$AX~(B . ?\x4F5D) ;; <CJK>
     (?$AY!(B . ?\x4F5F) ;; <CJK>
     (?$AY"(B . ?\x4F57) ;; <CJK>
     (?$AY#(B . ?\x4F32) ;; <CJK>
     (?$AY$(B . ?\x4F3D) ;; <CJK>
     (?$AY%(B . ?\x4F76) ;; <CJK>
     (?$AY&(B . ?\x4F74) ;; <CJK>
     (?$AY'(B . ?\x4F91) ;; <CJK>
     (?$AY((B . ?\x4F89) ;; <CJK>
     (?$AY)(B . ?\x4F83) ;; <CJK>
     (?$AY*(B . ?\x4F8F) ;; <CJK>
     (?$AY+(B . ?\x4F7E) ;; <CJK>
     (?$AY,(B . ?\x4F7B) ;; <CJK>
     (?$AY-(B . ?\x4FAA) ;; <CJK>
     (?$AY.(B . ?\x4F7C) ;; <CJK>
     (?$AY/(B . ?\x4FAC) ;; <CJK>
     (?$AY0(B . ?\x4F94) ;; <CJK>
     (?$AY1(B . ?\x4FE6) ;; <CJK>
     (?$AY2(B . ?\x4FE8) ;; <CJK>
     (?$AY3(B . ?\x4FEA) ;; <CJK>
     (?$AY4(B . ?\x4FC5) ;; <CJK>
     (?$AY5(B . ?\x4FDA) ;; <CJK>
     (?$AY6(B . ?\x4FE3) ;; <CJK>
     (?$AY7(B . ?\x4FDC) ;; <CJK>
     (?$AY8(B . ?\x4FD1) ;; <CJK>
     (?$AY9(B . ?\x4FDF) ;; <CJK>
     (?$AY:(B . ?\x4FF8) ;; <CJK>
     (?$AY;(B . ?\x5029) ;; <CJK>
     (?$AY<(B . ?\x504C) ;; <CJK>
     (?$AY=(B . ?\x4FF3) ;; <CJK>
     (?$AY>(B . ?\x502C) ;; <CJK>
     (?$AY?(B . ?\x500F) ;; <CJK>
     (?$AY@(B . ?\x502E) ;; <CJK>
     (?$AYA(B . ?\x502D) ;; <CJK>
     (?$AYB(B . ?\x4FFE) ;; <CJK>
     (?$AYC(B . ?\x501C) ;; <CJK>
     (?$AYD(B . ?\x500C) ;; <CJK>
     (?$AYE(B . ?\x5025) ;; <CJK>
     (?$AYF(B . ?\x5028) ;; <CJK>
     (?$AYG(B . ?\x507E) ;; <CJK>
     (?$AYH(B . ?\x5043) ;; <CJK>
     (?$AYI(B . ?\x5055) ;; <CJK>
     (?$AYJ(B . ?\x5048) ;; <CJK>
     (?$AYK(B . ?\x504E) ;; <CJK>
     (?$AYL(B . ?\x506C) ;; <CJK>
     (?$AYM(B . ?\x507B) ;; <CJK>
     (?$AYN(B . ?\x50A5) ;; <CJK>
     (?$AYO(B . ?\x50A7) ;; <CJK>
     (?$AYP(B . ?\x50A9) ;; <CJK>
     (?$AYQ(B . ?\x50BA) ;; <CJK>
     (?$AYR(B . ?\x50D6) ;; <CJK>
     (?$AYS(B . ?\x5106) ;; <CJK>
     (?$AYT(B . ?\x50ED) ;; <CJK>
     (?$AYU(B . ?\x50EC) ;; <CJK>
     (?$AYV(B . ?\x50E6) ;; <CJK>
     (?$AYW(B . ?\x50EE) ;; <CJK>
     (?$AYX(B . ?\x5107) ;; <CJK>
     (?$AYY(B . ?\x510B) ;; <CJK>
     (?$AYZ(B . ?\x4EDD) ;; <CJK>
     (?$AY[(B . ?\x6C3D) ;; <CJK>
     (?$AY\(B . ?\x4F58) ;; <CJK>
     (?$AY](B . ?\x4F65) ;; <CJK>
     (?$AY^(B . ?\x4FCE) ;; <CJK>
     (?$AY_(B . ?\x9FA0) ;; <CJK>
     (?$AY`(B . ?\x6C46) ;; <CJK>
     (?$AYa(B . ?\x7C74) ;; <CJK>
     (?$AYb(B . ?\x516E) ;; <CJK>
     (?$AYc(B . ?\x5DFD) ;; <CJK>
     (?$AYd(B . ?\x9EC9) ;; <CJK>
     (?$AYe(B . ?\x9998) ;; <CJK>
     (?$AYf(B . ?\x5181) ;; <CJK>
     (?$AYg(B . ?\x5914) ;; <CJK>
     (?$AYh(B . ?\x52F9) ;; <CJK>
     (?$AYi(B . ?\x530D) ;; <CJK>
     (?$AYj(B . ?\x8A07) ;; <CJK>
     (?$AYk(B . ?\x5310) ;; <CJK>
     (?$AYl(B . ?\x51EB) ;; <CJK>
     (?$AYm(B . ?\x5919) ;; <CJK>
     (?$AYn(B . ?\x5155) ;; <CJK>
     (?$AYo(B . ?\x4EA0) ;; <CJK>
     (?$AYp(B . ?\x5156) ;; <CJK>
     (?$AYq(B . ?\x4EB3) ;; <CJK>
     (?$AYr(B . ?\x886E) ;; <CJK>
     (?$AYs(B . ?\x88A4) ;; <CJK>
     (?$AYt(B . ?\x4EB5) ;; <CJK>
     (?$AYu(B . ?\x8114) ;; <CJK>
     (?$AYv(B . ?\x88D2) ;; <CJK>
     (?$AYw(B . ?\x7980) ;; <CJK>
     (?$AYx(B . ?\x5B34) ;; <CJK>
     (?$AYy(B . ?\x8803) ;; <CJK>
     (?$AYz(B . ?\x7FB8) ;; <CJK>
     (?$AY{(B . ?\x51AB) ;; <CJK>
     (?$AY|(B . ?\x51B1) ;; <CJK>
     (?$AY}(B . ?\x51BD) ;; <CJK>
     (?$AY~(B . ?\x51BC) ;; <CJK>
     (?$AZ!(B . ?\x51C7) ;; <CJK>
     (?$AZ"(B . ?\x5196) ;; <CJK>
     (?$AZ#(B . ?\x51A2) ;; <CJK>
     (?$AZ$(B . ?\x51A5) ;; <CJK>
     (?$AZ%(B . ?\x8BA0) ;; <CJK>
     (?$AZ&(B . ?\x8BA6) ;; <CJK>
     (?$AZ'(B . ?\x8BA7) ;; <CJK>
     (?$AZ((B . ?\x8BAA) ;; <CJK>
     (?$AZ)(B . ?\x8BB4) ;; <CJK>
     (?$AZ*(B . ?\x8BB5) ;; <CJK>
     (?$AZ+(B . ?\x8BB7) ;; <CJK>
     (?$AZ,(B . ?\x8BC2) ;; <CJK>
     (?$AZ-(B . ?\x8BC3) ;; <CJK>
     (?$AZ.(B . ?\x8BCB) ;; <CJK>
     (?$AZ/(B . ?\x8BCF) ;; <CJK>
     (?$AZ0(B . ?\x8BCE) ;; <CJK>
     (?$AZ1(B . ?\x8BD2) ;; <CJK>
     (?$AZ2(B . ?\x8BD3) ;; <CJK>
     (?$AZ3(B . ?\x8BD4) ;; <CJK>
     (?$AZ4(B . ?\x8BD6) ;; <CJK>
     (?$AZ5(B . ?\x8BD8) ;; <CJK>
     (?$AZ6(B . ?\x8BD9) ;; <CJK>
     (?$AZ7(B . ?\x8BDC) ;; <CJK>
     (?$AZ8(B . ?\x8BDF) ;; <CJK>
     (?$AZ9(B . ?\x8BE0) ;; <CJK>
     (?$AZ:(B . ?\x8BE4) ;; <CJK>
     (?$AZ;(B . ?\x8BE8) ;; <CJK>
     (?$AZ<(B . ?\x8BE9) ;; <CJK>
     (?$AZ=(B . ?\x8BEE) ;; <CJK>
     (?$AZ>(B . ?\x8BF0) ;; <CJK>
     (?$AZ?(B . ?\x8BF3) ;; <CJK>
     (?$AZ@(B . ?\x8BF6) ;; <CJK>
     (?$AZA(B . ?\x8BF9) ;; <CJK>
     (?$AZB(B . ?\x8BFC) ;; <CJK>
     (?$AZC(B . ?\x8BFF) ;; <CJK>
     (?$AZD(B . ?\x8C00) ;; <CJK>
     (?$AZE(B . ?\x8C02) ;; <CJK>
     (?$AZF(B . ?\x8C04) ;; <CJK>
     (?$AZG(B . ?\x8C07) ;; <CJK>
     (?$AZH(B . ?\x8C0C) ;; <CJK>
     (?$AZI(B . ?\x8C0F) ;; <CJK>
     (?$AZJ(B . ?\x8C11) ;; <CJK>
     (?$AZK(B . ?\x8C12) ;; <CJK>
     (?$AZL(B . ?\x8C14) ;; <CJK>
     (?$AZM(B . ?\x8C15) ;; <CJK>
     (?$AZN(B . ?\x8C16) ;; <CJK>
     (?$AZO(B . ?\x8C19) ;; <CJK>
     (?$AZP(B . ?\x8C1B) ;; <CJK>
     (?$AZQ(B . ?\x8C18) ;; <CJK>
     (?$AZR(B . ?\x8C1D) ;; <CJK>
     (?$AZS(B . ?\x8C1F) ;; <CJK>
     (?$AZT(B . ?\x8C20) ;; <CJK>
     (?$AZU(B . ?\x8C21) ;; <CJK>
     (?$AZV(B . ?\x8C25) ;; <CJK>
     (?$AZW(B . ?\x8C27) ;; <CJK>
     (?$AZX(B . ?\x8C2A) ;; <CJK>
     (?$AZY(B . ?\x8C2B) ;; <CJK>
     (?$AZZ(B . ?\x8C2E) ;; <CJK>
     (?$AZ[(B . ?\x8C2F) ;; <CJK>
     (?$AZ\(B . ?\x8C32) ;; <CJK>
     (?$AZ](B . ?\x8C33) ;; <CJK>
     (?$AZ^(B . ?\x8C35) ;; <CJK>
     (?$AZ_(B . ?\x8C36) ;; <CJK>
     (?$AZ`(B . ?\x5369) ;; <CJK>
     (?$AZa(B . ?\x537A) ;; <CJK>
     (?$AZb(B . ?\x961D) ;; <CJK>
     (?$AZc(B . ?\x9622) ;; <CJK>
     (?$AZd(B . ?\x9621) ;; <CJK>
     (?$AZe(B . ?\x9631) ;; <CJK>
     (?$AZf(B . ?\x962A) ;; <CJK>
     (?$AZg(B . ?\x963D) ;; <CJK>
     (?$AZh(B . ?\x963C) ;; <CJK>
     (?$AZi(B . ?\x9642) ;; <CJK>
     (?$AZj(B . ?\x9649) ;; <CJK>
     (?$AZk(B . ?\x9654) ;; <CJK>
     (?$AZl(B . ?\x965F) ;; <CJK>
     (?$AZm(B . ?\x9667) ;; <CJK>
     (?$AZn(B . ?\x966C) ;; <CJK>
     (?$AZo(B . ?\x9672) ;; <CJK>
     (?$AZp(B . ?\x9674) ;; <CJK>
     (?$AZq(B . ?\x9688) ;; <CJK>
     (?$AZr(B . ?\x968D) ;; <CJK>
     (?$AZs(B . ?\x9697) ;; <CJK>
     (?$AZt(B . ?\x96B0) ;; <CJK>
     (?$AZu(B . ?\x9097) ;; <CJK>
     (?$AZv(B . ?\x909B) ;; <CJK>
     (?$AZw(B . ?\x909D) ;; <CJK>
     (?$AZx(B . ?\x9099) ;; <CJK>
     (?$AZy(B . ?\x90AC) ;; <CJK>
     (?$AZz(B . ?\x90A1) ;; <CJK>
     (?$AZ{(B . ?\x90B4) ;; <CJK>
     (?$AZ|(B . ?\x90B3) ;; <CJK>
     (?$AZ}(B . ?\x90B6) ;; <CJK>
     (?$AZ~(B . ?\x90BA) ;; <CJK>
     (?$A[!(B . ?\x90B8) ;; <CJK>
     (?$A["(B . ?\x90B0) ;; <CJK>
     (?$A[#(B . ?\x90CF) ;; <CJK>
     (?$A[$(B . ?\x90C5) ;; <CJK>
     (?$A[%(B . ?\x90BE) ;; <CJK>
     (?$A[&(B . ?\x90D0) ;; <CJK>
     (?$A['(B . ?\x90C4) ;; <CJK>
     (?$A[((B . ?\x90C7) ;; <CJK>
     (?$A[)(B . ?\x90D3) ;; <CJK>
     (?$A[*(B . ?\x90E6) ;; <CJK>
     (?$A[+(B . ?\x90E2) ;; <CJK>
     (?$A[,(B . ?\x90DC) ;; <CJK>
     (?$A[-(B . ?\x90D7) ;; <CJK>
     (?$A[.(B . ?\x90DB) ;; <CJK>
     (?$A[/(B . ?\x90EB) ;; <CJK>
     (?$A[0(B . ?\x90EF) ;; <CJK>
     (?$A[1(B . ?\x90FE) ;; <CJK>
     (?$A[2(B . ?\x9104) ;; <CJK>
     (?$A[3(B . ?\x9122) ;; <CJK>
     (?$A[4(B . ?\x911E) ;; <CJK>
     (?$A[5(B . ?\x9123) ;; <CJK>
     (?$A[6(B . ?\x9131) ;; <CJK>
     (?$A[7(B . ?\x912F) ;; <CJK>
     (?$A[8(B . ?\x9139) ;; <CJK>
     (?$A[9(B . ?\x9143) ;; <CJK>
     (?$A[:(B . ?\x9146) ;; <CJK>
     (?$A[;(B . ?\x520D) ;; <CJK>
     (?$A[<(B . ?\x5942) ;; <CJK>
     (?$A[=(B . ?\x52A2) ;; <CJK>
     (?$A[>(B . ?\x52AC) ;; <CJK>
     (?$A[?(B . ?\x52AD) ;; <CJK>
     (?$A[@(B . ?\x52BE) ;; <CJK>
     (?$A[A(B . ?\x54FF) ;; <CJK>
     (?$A[B(B . ?\x52D0) ;; <CJK>
     (?$A[C(B . ?\x52D6) ;; <CJK>
     (?$A[D(B . ?\x52F0) ;; <CJK>
     (?$A[E(B . ?\x53DF) ;; <CJK>
     (?$A[F(B . ?\x71EE) ;; <CJK>
     (?$A[G(B . ?\x77CD) ;; <CJK>
     (?$A[H(B . ?\x5EF4) ;; <CJK>
     (?$A[I(B . ?\x51F5) ;; <CJK>
     (?$A[J(B . ?\x51FC) ;; <CJK>
     (?$A[K(B . ?\x9B2F) ;; <CJK>
     (?$A[L(B . ?\x53B6) ;; <CJK>
     (?$A[M(B . ?\x5F01) ;; <CJK>
     (?$A[N(B . ?\x755A) ;; <CJK>
     (?$A[O(B . ?\x5DEF) ;; <CJK>
     (?$A[P(B . ?\x574C) ;; <CJK>
     (?$A[Q(B . ?\x57A9) ;; <CJK>
     (?$A[R(B . ?\x57A1) ;; <CJK>
     (?$A[S(B . ?\x587E) ;; <CJK>
     (?$A[T(B . ?\x58BC) ;; <CJK>
     (?$A[U(B . ?\x58C5) ;; <CJK>
     (?$A[V(B . ?\x58D1) ;; <CJK>
     (?$A[W(B . ?\x5729) ;; <CJK>
     (?$A[X(B . ?\x572C) ;; <CJK>
     (?$A[Y(B . ?\x572A) ;; <CJK>
     (?$A[Z(B . ?\x5733) ;; <CJK>
     (?$A[[(B . ?\x5739) ;; <CJK>
     (?$A[\(B . ?\x572E) ;; <CJK>
     (?$A[](B . ?\x572F) ;; <CJK>
     (?$A[^(B . ?\x575C) ;; <CJK>
     (?$A[_(B . ?\x573B) ;; <CJK>
     (?$A[`(B . ?\x5742) ;; <CJK>
     (?$A[a(B . ?\x5769) ;; <CJK>
     (?$A[b(B . ?\x5785) ;; <CJK>
     (?$A[c(B . ?\x576B) ;; <CJK>
     (?$A[d(B . ?\x5786) ;; <CJK>
     (?$A[e(B . ?\x577C) ;; <CJK>
     (?$A[f(B . ?\x577B) ;; <CJK>
     (?$A[g(B . ?\x5768) ;; <CJK>
     (?$A[h(B . ?\x576D) ;; <CJK>
     (?$A[i(B . ?\x5776) ;; <CJK>
     (?$A[j(B . ?\x5773) ;; <CJK>
     (?$A[k(B . ?\x57AD) ;; <CJK>
     (?$A[l(B . ?\x57A4) ;; <CJK>
     (?$A[m(B . ?\x578C) ;; <CJK>
     (?$A[n(B . ?\x57B2) ;; <CJK>
     (?$A[o(B . ?\x57CF) ;; <CJK>
     (?$A[p(B . ?\x57A7) ;; <CJK>
     (?$A[q(B . ?\x57B4) ;; <CJK>
     (?$A[r(B . ?\x5793) ;; <CJK>
     (?$A[s(B . ?\x57A0) ;; <CJK>
     (?$A[t(B . ?\x57D5) ;; <CJK>
     (?$A[u(B . ?\x57D8) ;; <CJK>
     (?$A[v(B . ?\x57DA) ;; <CJK>
     (?$A[w(B . ?\x57D9) ;; <CJK>
     (?$A[x(B . ?\x57D2) ;; <CJK>
     (?$A[y(B . ?\x57B8) ;; <CJK>
     (?$A[z(B . ?\x57F4) ;; <CJK>
     (?$A[{(B . ?\x57EF) ;; <CJK>
     (?$A[|(B . ?\x57F8) ;; <CJK>
     (?$A[}(B . ?\x57E4) ;; <CJK>
     (?$A[~(B . ?\x57DD) ;; <CJK>
     (?$A\!(B . ?\x580B) ;; <CJK>
     (?$A\"(B . ?\x580D) ;; <CJK>
     (?$A\#(B . ?\x57FD) ;; <CJK>
     (?$A\$(B . ?\x57ED) ;; <CJK>
     (?$A\%(B . ?\x5800) ;; <CJK>
     (?$A\&(B . ?\x581E) ;; <CJK>
     (?$A\'(B . ?\x5819) ;; <CJK>
     (?$A\((B . ?\x5844) ;; <CJK>
     (?$A\)(B . ?\x5820) ;; <CJK>
     (?$A\*(B . ?\x5865) ;; <CJK>
     (?$A\+(B . ?\x586C) ;; <CJK>
     (?$A\,(B . ?\x5881) ;; <CJK>
     (?$A\-(B . ?\x5889) ;; <CJK>
     (?$A\.(B . ?\x589A) ;; <CJK>
     (?$A\/(B . ?\x5880) ;; <CJK>
     (?$A\0(B . ?\x99A8) ;; <CJK>
     (?$A\1(B . ?\x9F19) ;; <CJK>
     (?$A\2(B . ?\x61FF) ;; <CJK>
     (?$A\3(B . ?\x8279) ;; <CJK>
     (?$A\4(B . ?\x827D) ;; <CJK>
     (?$A\5(B . ?\x827F) ;; <CJK>
     (?$A\6(B . ?\x828F) ;; <CJK>
     (?$A\7(B . ?\x828A) ;; <CJK>
     (?$A\8(B . ?\x82A8) ;; <CJK>
     (?$A\9(B . ?\x8284) ;; <CJK>
     (?$A\:(B . ?\x828E) ;; <CJK>
     (?$A\;(B . ?\x8291) ;; <CJK>
     (?$A\<(B . ?\x8297) ;; <CJK>
     (?$A\=(B . ?\x8299) ;; <CJK>
     (?$A\>(B . ?\x82AB) ;; <CJK>
     (?$A\?(B . ?\x82B8) ;; <CJK>
     (?$A\@(B . ?\x82BE) ;; <CJK>
     (?$A\A(B . ?\x82B0) ;; <CJK>
     (?$A\B(B . ?\x82C8) ;; <CJK>
     (?$A\C(B . ?\x82CA) ;; <CJK>
     (?$A\D(B . ?\x82E3) ;; <CJK>
     (?$A\E(B . ?\x8298) ;; <CJK>
     (?$A\F(B . ?\x82B7) ;; <CJK>
     (?$A\G(B . ?\x82AE) ;; <CJK>
     (?$A\H(B . ?\x82CB) ;; <CJK>
     (?$A\I(B . ?\x82CC) ;; <CJK>
     (?$A\J(B . ?\x82C1) ;; <CJK>
     (?$A\K(B . ?\x82A9) ;; <CJK>
     (?$A\L(B . ?\x82B4) ;; <CJK>
     (?$A\M(B . ?\x82A1) ;; <CJK>
     (?$A\N(B . ?\x82AA) ;; <CJK>
     (?$A\O(B . ?\x829F) ;; <CJK>
     (?$A\P(B . ?\x82C4) ;; <CJK>
     (?$A\Q(B . ?\x82CE) ;; <CJK>
     (?$A\R(B . ?\x82A4) ;; <CJK>
     (?$A\S(B . ?\x82E1) ;; <CJK>
     (?$A\T(B . ?\x8309) ;; <CJK>
     (?$A\U(B . ?\x82F7) ;; <CJK>
     (?$A\V(B . ?\x82E4) ;; <CJK>
     (?$A\W(B . ?\x830F) ;; <CJK>
     (?$A\X(B . ?\x8307) ;; <CJK>
     (?$A\Y(B . ?\x82DC) ;; <CJK>
     (?$A\Z(B . ?\x82F4) ;; <CJK>
     (?$A\[(B . ?\x82D2) ;; <CJK>
     (?$A\\(B . ?\x82D8) ;; <CJK>
     (?$A\](B . ?\x830C) ;; <CJK>
     (?$A\^(B . ?\x82FB) ;; <CJK>
     (?$A\_(B . ?\x82D3) ;; <CJK>
     (?$A\`(B . ?\x8311) ;; <CJK>
     (?$A\a(B . ?\x831A) ;; <CJK>
     (?$A\b(B . ?\x8306) ;; <CJK>
     (?$A\c(B . ?\x8314) ;; <CJK>
     (?$A\d(B . ?\x8315) ;; <CJK>
     (?$A\e(B . ?\x82E0) ;; <CJK>
     (?$A\f(B . ?\x82D5) ;; <CJK>
     (?$A\g(B . ?\x831C) ;; <CJK>
     (?$A\h(B . ?\x8351) ;; <CJK>
     (?$A\i(B . ?\x835B) ;; <CJK>
     (?$A\j(B . ?\x835C) ;; <CJK>
     (?$A\k(B . ?\x8308) ;; <CJK>
     (?$A\l(B . ?\x8392) ;; <CJK>
     (?$A\m(B . ?\x833C) ;; <CJK>
     (?$A\n(B . ?\x8334) ;; <CJK>
     (?$A\o(B . ?\x8331) ;; <CJK>
     (?$A\p(B . ?\x839B) ;; <CJK>
     (?$A\q(B . ?\x835E) ;; <CJK>
     (?$A\r(B . ?\x832F) ;; <CJK>
     (?$A\s(B . ?\x834F) ;; <CJK>
     (?$A\t(B . ?\x8347) ;; <CJK>
     (?$A\u(B . ?\x8343) ;; <CJK>
     (?$A\v(B . ?\x835F) ;; <CJK>
     (?$A\w(B . ?\x8340) ;; <CJK>
     (?$A\x(B . ?\x8317) ;; <CJK>
     (?$A\y(B . ?\x8360) ;; <CJK>
     (?$A\z(B . ?\x832D) ;; <CJK>
     (?$A\{(B . ?\x833A) ;; <CJK>
     (?$A\|(B . ?\x8333) ;; <CJK>
     (?$A\}(B . ?\x8366) ;; <CJK>
     (?$A\~(B . ?\x8365) ;; <CJK>
     (?$A]!(B . ?\x8368) ;; <CJK>
     (?$A]"(B . ?\x831B) ;; <CJK>
     (?$A]#(B . ?\x8369) ;; <CJK>
     (?$A]$(B . ?\x836C) ;; <CJK>
     (?$A]%(B . ?\x836A) ;; <CJK>
     (?$A]&(B . ?\x836D) ;; <CJK>
     (?$A]'(B . ?\x836E) ;; <CJK>
     (?$A]((B . ?\x83B0) ;; <CJK>
     (?$A])(B . ?\x8378) ;; <CJK>
     (?$A]*(B . ?\x83B3) ;; <CJK>
     (?$A]+(B . ?\x83B4) ;; <CJK>
     (?$A],(B . ?\x83A0) ;; <CJK>
     (?$A]-(B . ?\x83AA) ;; <CJK>
     (?$A].(B . ?\x8393) ;; <CJK>
     (?$A]/(B . ?\x839C) ;; <CJK>
     (?$A]0(B . ?\x8385) ;; <CJK>
     (?$A]1(B . ?\x837C) ;; <CJK>
     (?$A]2(B . ?\x83B6) ;; <CJK>
     (?$A]3(B . ?\x83A9) ;; <CJK>
     (?$A]4(B . ?\x837D) ;; <CJK>
     (?$A]5(B . ?\x83B8) ;; <CJK>
     (?$A]6(B . ?\x837B) ;; <CJK>
     (?$A]7(B . ?\x8398) ;; <CJK>
     (?$A]8(B . ?\x839E) ;; <CJK>
     (?$A]9(B . ?\x83A8) ;; <CJK>
     (?$A]:(B . ?\x83BA) ;; <CJK>
     (?$A];(B . ?\x83BC) ;; <CJK>
     (?$A]<(B . ?\x83C1) ;; <CJK>
     (?$A]=(B . ?\x8401) ;; <CJK>
     (?$A]>(B . ?\x83E5) ;; <CJK>
     (?$A]?(B . ?\x83D8) ;; <CJK>
     (?$A]@(B . ?\x5807) ;; <CJK>
     (?$A]A(B . ?\x8418) ;; <CJK>
     (?$A]B(B . ?\x840B) ;; <CJK>
     (?$A]C(B . ?\x83DD) ;; <CJK>
     (?$A]D(B . ?\x83FD) ;; <CJK>
     (?$A]E(B . ?\x83D6) ;; <CJK>
     (?$A]F(B . ?\x841C) ;; <CJK>
     (?$A]G(B . ?\x8438) ;; <CJK>
     (?$A]H(B . ?\x8411) ;; <CJK>
     (?$A]I(B . ?\x8406) ;; <CJK>
     (?$A]J(B . ?\x83D4) ;; <CJK>
     (?$A]K(B . ?\x83DF) ;; <CJK>
     (?$A]L(B . ?\x840F) ;; <CJK>
     (?$A]M(B . ?\x8403) ;; <CJK>
     (?$A]N(B . ?\x83F8) ;; <CJK>
     (?$A]O(B . ?\x83F9) ;; <CJK>
     (?$A]P(B . ?\x83EA) ;; <CJK>
     (?$A]Q(B . ?\x83C5) ;; <CJK>
     (?$A]R(B . ?\x83C0) ;; <CJK>
     (?$A]S(B . ?\x8426) ;; <CJK>
     (?$A]T(B . ?\x83F0) ;; <CJK>
     (?$A]U(B . ?\x83E1) ;; <CJK>
     (?$A]V(B . ?\x845C) ;; <CJK>
     (?$A]W(B . ?\x8451) ;; <CJK>
     (?$A]X(B . ?\x845A) ;; <CJK>
     (?$A]Y(B . ?\x8459) ;; <CJK>
     (?$A]Z(B . ?\x8473) ;; <CJK>
     (?$A][(B . ?\x8487) ;; <CJK>
     (?$A]\(B . ?\x8488) ;; <CJK>
     (?$A]](B . ?\x847A) ;; <CJK>
     (?$A]^(B . ?\x8489) ;; <CJK>
     (?$A]_(B . ?\x8478) ;; <CJK>
     (?$A]`(B . ?\x843C) ;; <CJK>
     (?$A]a(B . ?\x8446) ;; <CJK>
     (?$A]b(B . ?\x8469) ;; <CJK>
     (?$A]c(B . ?\x8476) ;; <CJK>
     (?$A]d(B . ?\x848C) ;; <CJK>
     (?$A]e(B . ?\x848E) ;; <CJK>
     (?$A]f(B . ?\x8431) ;; <CJK>
     (?$A]g(B . ?\x846D) ;; <CJK>
     (?$A]h(B . ?\x84C1) ;; <CJK>
     (?$A]i(B . ?\x84CD) ;; <CJK>
     (?$A]j(B . ?\x84D0) ;; <CJK>
     (?$A]k(B . ?\x84E6) ;; <CJK>
     (?$A]l(B . ?\x84BD) ;; <CJK>
     (?$A]m(B . ?\x84D3) ;; <CJK>
     (?$A]n(B . ?\x84CA) ;; <CJK>
     (?$A]o(B . ?\x84BF) ;; <CJK>
     (?$A]p(B . ?\x84BA) ;; <CJK>
     (?$A]q(B . ?\x84E0) ;; <CJK>
     (?$A]r(B . ?\x84A1) ;; <CJK>
     (?$A]s(B . ?\x84B9) ;; <CJK>
     (?$A]t(B . ?\x84B4) ;; <CJK>
     (?$A]u(B . ?\x8497) ;; <CJK>
     (?$A]v(B . ?\x84E5) ;; <CJK>
     (?$A]w(B . ?\x84E3) ;; <CJK>
     (?$A]x(B . ?\x850C) ;; <CJK>
     (?$A]y(B . ?\x750D) ;; <CJK>
     (?$A]z(B . ?\x8538) ;; <CJK>
     (?$A]{(B . ?\x84F0) ;; <CJK>
     (?$A]|(B . ?\x8539) ;; <CJK>
     (?$A]}(B . ?\x851F) ;; <CJK>
     (?$A]~(B . ?\x853A) ;; <CJK>
     (?$A^!(B . ?\x8556) ;; <CJK>
     (?$A^"(B . ?\x853B) ;; <CJK>
     (?$A^#(B . ?\x84FF) ;; <CJK>
     (?$A^$(B . ?\x84FC) ;; <CJK>
     (?$A^%(B . ?\x8559) ;; <CJK>
     (?$A^&(B . ?\x8548) ;; <CJK>
     (?$A^'(B . ?\x8568) ;; <CJK>
     (?$A^((B . ?\x8564) ;; <CJK>
     (?$A^)(B . ?\x855E) ;; <CJK>
     (?$A^*(B . ?\x857A) ;; <CJK>
     (?$A^+(B . ?\x77A2) ;; <CJK>
     (?$A^,(B . ?\x8543) ;; <CJK>
     (?$A^-(B . ?\x8572) ;; <CJK>
     (?$A^.(B . ?\x857B) ;; <CJK>
     (?$A^/(B . ?\x85A4) ;; <CJK>
     (?$A^0(B . ?\x85A8) ;; <CJK>
     (?$A^1(B . ?\x8587) ;; <CJK>
     (?$A^2(B . ?\x858F) ;; <CJK>
     (?$A^3(B . ?\x8579) ;; <CJK>
     (?$A^4(B . ?\x85AE) ;; <CJK>
     (?$A^5(B . ?\x859C) ;; <CJK>
     (?$A^6(B . ?\x8585) ;; <CJK>
     (?$A^7(B . ?\x85B9) ;; <CJK>
     (?$A^8(B . ?\x85B7) ;; <CJK>
     (?$A^9(B . ?\x85B0) ;; <CJK>
     (?$A^:(B . ?\x85D3) ;; <CJK>
     (?$A^;(B . ?\x85C1) ;; <CJK>
     (?$A^<(B . ?\x85DC) ;; <CJK>
     (?$A^=(B . ?\x85FF) ;; <CJK>
     (?$A^>(B . ?\x8627) ;; <CJK>
     (?$A^?(B . ?\x8605) ;; <CJK>
     (?$A^@(B . ?\x8629) ;; <CJK>
     (?$A^A(B . ?\x8616) ;; <CJK>
     (?$A^B(B . ?\x863C) ;; <CJK>
     (?$A^C(B . ?\x5EFE) ;; <CJK>
     (?$A^D(B . ?\x5F08) ;; <CJK>
     (?$A^E(B . ?\x593C) ;; <CJK>
     (?$A^F(B . ?\x5941) ;; <CJK>
     (?$A^G(B . ?\x8037) ;; <CJK>
     (?$A^H(B . ?\x5955) ;; <CJK>
     (?$A^I(B . ?\x595A) ;; <CJK>
     (?$A^J(B . ?\x5958) ;; <CJK>
     (?$A^K(B . ?\x530F) ;; <CJK>
     (?$A^L(B . ?\x5C22) ;; <CJK>
     (?$A^M(B . ?\x5C25) ;; <CJK>
     (?$A^N(B . ?\x5C2C) ;; <CJK>
     (?$A^O(B . ?\x5C34) ;; <CJK>
     (?$A^P(B . ?\x624C) ;; <CJK>
     (?$A^Q(B . ?\x626A) ;; <CJK>
     (?$A^R(B . ?\x629F) ;; <CJK>
     (?$A^S(B . ?\x62BB) ;; <CJK>
     (?$A^T(B . ?\x62CA) ;; <CJK>
     (?$A^U(B . ?\x62DA) ;; <CJK>
     (?$A^V(B . ?\x62D7) ;; <CJK>
     (?$A^W(B . ?\x62EE) ;; <CJK>
     (?$A^X(B . ?\x6322) ;; <CJK>
     (?$A^Y(B . ?\x62F6) ;; <CJK>
     (?$A^Z(B . ?\x6339) ;; <CJK>
     (?$A^[(B . ?\x634B) ;; <CJK>
     (?$A^\(B . ?\x6343) ;; <CJK>
     (?$A^](B . ?\x63AD) ;; <CJK>
     (?$A^^(B . ?\x63F6) ;; <CJK>
     (?$A^_(B . ?\x6371) ;; <CJK>
     (?$A^`(B . ?\x637A) ;; <CJK>
     (?$A^a(B . ?\x638E) ;; <CJK>
     (?$A^b(B . ?\x63B4) ;; <CJK>
     (?$A^c(B . ?\x636D) ;; <CJK>
     (?$A^d(B . ?\x63AC) ;; <CJK>
     (?$A^e(B . ?\x638A) ;; <CJK>
     (?$A^f(B . ?\x6369) ;; <CJK>
     (?$A^g(B . ?\x63AE) ;; <CJK>
     (?$A^h(B . ?\x63BC) ;; <CJK>
     (?$A^i(B . ?\x63F2) ;; <CJK>
     (?$A^j(B . ?\x63F8) ;; <CJK>
     (?$A^k(B . ?\x63E0) ;; <CJK>
     (?$A^l(B . ?\x63FF) ;; <CJK>
     (?$A^m(B . ?\x63C4) ;; <CJK>
     (?$A^n(B . ?\x63DE) ;; <CJK>
     (?$A^o(B . ?\x63CE) ;; <CJK>
     (?$A^p(B . ?\x6452) ;; <CJK>
     (?$A^q(B . ?\x63C6) ;; <CJK>
     (?$A^r(B . ?\x63BE) ;; <CJK>
     (?$A^s(B . ?\x6445) ;; <CJK>
     (?$A^t(B . ?\x6441) ;; <CJK>
     (?$A^u(B . ?\x640B) ;; <CJK>
     (?$A^v(B . ?\x641B) ;; <CJK>
     (?$A^w(B . ?\x6420) ;; <CJK>
     (?$A^x(B . ?\x640C) ;; <CJK>
     (?$A^y(B . ?\x6426) ;; <CJK>
     (?$A^z(B . ?\x6421) ;; <CJK>
     (?$A^{(B . ?\x645E) ;; <CJK>
     (?$A^|(B . ?\x6484) ;; <CJK>
     (?$A^}(B . ?\x646D) ;; <CJK>
     (?$A^~(B . ?\x6496) ;; <CJK>
     (?$A_!(B . ?\x647A) ;; <CJK>
     (?$A_"(B . ?\x64B7) ;; <CJK>
     (?$A_#(B . ?\x64B8) ;; <CJK>
     (?$A_$(B . ?\x6499) ;; <CJK>
     (?$A_%(B . ?\x64BA) ;; <CJK>
     (?$A_&(B . ?\x64C0) ;; <CJK>
     (?$A_'(B . ?\x64D0) ;; <CJK>
     (?$A_((B . ?\x64D7) ;; <CJK>
     (?$A_)(B . ?\x64E4) ;; <CJK>
     (?$A_*(B . ?\x64E2) ;; <CJK>
     (?$A_+(B . ?\x6509) ;; <CJK>
     (?$A_,(B . ?\x6525) ;; <CJK>
     (?$A_-(B . ?\x652E) ;; <CJK>
     (?$A_.(B . ?\x5F0B) ;; <CJK>
     (?$A_/(B . ?\x5FD2) ;; <CJK>
     (?$A_0(B . ?\x7519) ;; <CJK>
     (?$A_1(B . ?\x5F11) ;; <CJK>
     (?$A_2(B . ?\x535F) ;; <CJK>
     (?$A_3(B . ?\x53F1) ;; <CJK>
     (?$A_4(B . ?\x53FD) ;; <CJK>
     (?$A_5(B . ?\x53E9) ;; <CJK>
     (?$A_6(B . ?\x53E8) ;; <CJK>
     (?$A_7(B . ?\x53FB) ;; <CJK>
     (?$A_8(B . ?\x5412) ;; <CJK>
     (?$A_9(B . ?\x5416) ;; <CJK>
     (?$A_:(B . ?\x5406) ;; <CJK>
     (?$A_;(B . ?\x544B) ;; <CJK>
     (?$A_<(B . ?\x5452) ;; <CJK>
     (?$A_=(B . ?\x5453) ;; <CJK>
     (?$A_>(B . ?\x5454) ;; <CJK>
     (?$A_?(B . ?\x5456) ;; <CJK>
     (?$A_@(B . ?\x5443) ;; <CJK>
     (?$A_A(B . ?\x5421) ;; <CJK>
     (?$A_B(B . ?\x5457) ;; <CJK>
     (?$A_C(B . ?\x5459) ;; <CJK>
     (?$A_D(B . ?\x5423) ;; <CJK>
     (?$A_E(B . ?\x5432) ;; <CJK>
     (?$A_F(B . ?\x5482) ;; <CJK>
     (?$A_G(B . ?\x5494) ;; <CJK>
     (?$A_H(B . ?\x5477) ;; <CJK>
     (?$A_I(B . ?\x5471) ;; <CJK>
     (?$A_J(B . ?\x5464) ;; <CJK>
     (?$A_K(B . ?\x549A) ;; <CJK>
     (?$A_L(B . ?\x549B) ;; <CJK>
     (?$A_M(B . ?\x5484) ;; <CJK>
     (?$A_N(B . ?\x5476) ;; <CJK>
     (?$A_O(B . ?\x5466) ;; <CJK>
     (?$A_P(B . ?\x549D) ;; <CJK>
     (?$A_Q(B . ?\x54D0) ;; <CJK>
     (?$A_R(B . ?\x54AD) ;; <CJK>
     (?$A_S(B . ?\x54C2) ;; <CJK>
     (?$A_T(B . ?\x54B4) ;; <CJK>
     (?$A_U(B . ?\x54D2) ;; <CJK>
     (?$A_V(B . ?\x54A7) ;; <CJK>
     (?$A_W(B . ?\x54A6) ;; <CJK>
     (?$A_X(B . ?\x54D3) ;; <CJK>
     (?$A_Y(B . ?\x54D4) ;; <CJK>
     (?$A_Z(B . ?\x5472) ;; <CJK>
     (?$A_[(B . ?\x54A3) ;; <CJK>
     (?$A_\(B . ?\x54D5) ;; <CJK>
     (?$A_](B . ?\x54BB) ;; <CJK>
     (?$A_^(B . ?\x54BF) ;; <CJK>
     (?$A__(B . ?\x54CC) ;; <CJK>
     (?$A_`(B . ?\x54D9) ;; <CJK>
     (?$A_a(B . ?\x54DA) ;; <CJK>
     (?$A_b(B . ?\x54DC) ;; <CJK>
     (?$A_c(B . ?\x54A9) ;; <CJK>
     (?$A_d(B . ?\x54AA) ;; <CJK>
     (?$A_e(B . ?\x54A4) ;; <CJK>
     (?$A_f(B . ?\x54DD) ;; <CJK>
     (?$A_g(B . ?\x54CF) ;; <CJK>
     (?$A_h(B . ?\x54DE) ;; <CJK>
     (?$A_i(B . ?\x551B) ;; <CJK>
     (?$A_j(B . ?\x54E7) ;; <CJK>
     (?$A_k(B . ?\x5520) ;; <CJK>
     (?$A_l(B . ?\x54FD) ;; <CJK>
     (?$A_m(B . ?\x5514) ;; <CJK>
     (?$A_n(B . ?\x54F3) ;; <CJK>
     (?$A_o(B . ?\x5522) ;; <CJK>
     (?$A_p(B . ?\x5523) ;; <CJK>
     (?$A_q(B . ?\x550F) ;; <CJK>
     (?$A_r(B . ?\x5511) ;; <CJK>
     (?$A_s(B . ?\x5527) ;; <CJK>
     (?$A_t(B . ?\x552A) ;; <CJK>
     (?$A_u(B . ?\x5567) ;; <CJK>
     (?$A_v(B . ?\x558F) ;; <CJK>
     (?$A_w(B . ?\x55B5) ;; <CJK>
     (?$A_x(B . ?\x5549) ;; <CJK>
     (?$A_y(B . ?\x556D) ;; <CJK>
     (?$A_z(B . ?\x5541) ;; <CJK>
     (?$A_{(B . ?\x5555) ;; <CJK>
     (?$A_|(B . ?\x553F) ;; <CJK>
     (?$A_}(B . ?\x5550) ;; <CJK>
     (?$A_~(B . ?\x553C) ;; <CJK>
     (?$A`!(B . ?\x5537) ;; <CJK>
     (?$A`"(B . ?\x5556) ;; <CJK>
     (?$A`#(B . ?\x5575) ;; <CJK>
     (?$A`$(B . ?\x5576) ;; <CJK>
     (?$A`%(B . ?\x5577) ;; <CJK>
     (?$A`&(B . ?\x5533) ;; <CJK>
     (?$A`'(B . ?\x5530) ;; <CJK>
     (?$A`((B . ?\x555C) ;; <CJK>
     (?$A`)(B . ?\x558B) ;; <CJK>
     (?$A`*(B . ?\x55D2) ;; <CJK>
     (?$A`+(B . ?\x5583) ;; <CJK>
     (?$A`,(B . ?\x55B1) ;; <CJK>
     (?$A`-(B . ?\x55B9) ;; <CJK>
     (?$A`.(B . ?\x5588) ;; <CJK>
     (?$A`/(B . ?\x5581) ;; <CJK>
     (?$A`0(B . ?\x559F) ;; <CJK>
     (?$A`1(B . ?\x557E) ;; <CJK>
     (?$A`2(B . ?\x55D6) ;; <CJK>
     (?$A`3(B . ?\x5591) ;; <CJK>
     (?$A`4(B . ?\x557B) ;; <CJK>
     (?$A`5(B . ?\x55DF) ;; <CJK>
     (?$A`6(B . ?\x55BD) ;; <CJK>
     (?$A`7(B . ?\x55BE) ;; <CJK>
     (?$A`8(B . ?\x5594) ;; <CJK>
     (?$A`9(B . ?\x5599) ;; <CJK>
     (?$A`:(B . ?\x55EA) ;; <CJK>
     (?$A`;(B . ?\x55F7) ;; <CJK>
     (?$A`<(B . ?\x55C9) ;; <CJK>
     (?$A`=(B . ?\x561F) ;; <CJK>
     (?$A`>(B . ?\x55D1) ;; <CJK>
     (?$A`?(B . ?\x55EB) ;; <CJK>
     (?$A`@(B . ?\x55EC) ;; <CJK>
     (?$A`A(B . ?\x55D4) ;; <CJK>
     (?$A`B(B . ?\x55E6) ;; <CJK>
     (?$A`C(B . ?\x55DD) ;; <CJK>
     (?$A`D(B . ?\x55C4) ;; <CJK>
     (?$A`E(B . ?\x55EF) ;; <CJK>
     (?$A`F(B . ?\x55E5) ;; <CJK>
     (?$A`G(B . ?\x55F2) ;; <CJK>
     (?$A`H(B . ?\x55F3) ;; <CJK>
     (?$A`I(B . ?\x55CC) ;; <CJK>
     (?$A`J(B . ?\x55CD) ;; <CJK>
     (?$A`K(B . ?\x55E8) ;; <CJK>
     (?$A`L(B . ?\x55F5) ;; <CJK>
     (?$A`M(B . ?\x55E4) ;; <CJK>
     (?$A`N(B . ?\x8F94) ;; <CJK>
     (?$A`O(B . ?\x561E) ;; <CJK>
     (?$A`P(B . ?\x5608) ;; <CJK>
     (?$A`Q(B . ?\x560C) ;; <CJK>
     (?$A`R(B . ?\x5601) ;; <CJK>
     (?$A`S(B . ?\x5624) ;; <CJK>
     (?$A`T(B . ?\x5623) ;; <CJK>
     (?$A`U(B . ?\x55FE) ;; <CJK>
     (?$A`V(B . ?\x5600) ;; <CJK>
     (?$A`W(B . ?\x5627) ;; <CJK>
     (?$A`X(B . ?\x562D) ;; <CJK>
     (?$A`Y(B . ?\x5658) ;; <CJK>
     (?$A`Z(B . ?\x5639) ;; <CJK>
     (?$A`[(B . ?\x5657) ;; <CJK>
     (?$A`\(B . ?\x562C) ;; <CJK>
     (?$A`](B . ?\x564D) ;; <CJK>
     (?$A`^(B . ?\x5662) ;; <CJK>
     (?$A`_(B . ?\x5659) ;; <CJK>
     (?$A``(B . ?\x565C) ;; <CJK>
     (?$A`a(B . ?\x564C) ;; <CJK>
     (?$A`b(B . ?\x5654) ;; <CJK>
     (?$A`c(B . ?\x5686) ;; <CJK>
     (?$A`d(B . ?\x5664) ;; <CJK>
     (?$A`e(B . ?\x5671) ;; <CJK>
     (?$A`f(B . ?\x566B) ;; <CJK>
     (?$A`g(B . ?\x567B) ;; <CJK>
     (?$A`h(B . ?\x567C) ;; <CJK>
     (?$A`i(B . ?\x5685) ;; <CJK>
     (?$A`j(B . ?\x5693) ;; <CJK>
     (?$A`k(B . ?\x56AF) ;; <CJK>
     (?$A`l(B . ?\x56D4) ;; <CJK>
     (?$A`m(B . ?\x56D7) ;; <CJK>
     (?$A`n(B . ?\x56DD) ;; <CJK>
     (?$A`o(B . ?\x56E1) ;; <CJK>
     (?$A`p(B . ?\x56F5) ;; <CJK>
     (?$A`q(B . ?\x56EB) ;; <CJK>
     (?$A`r(B . ?\x56F9) ;; <CJK>
     (?$A`s(B . ?\x56FF) ;; <CJK>
     (?$A`t(B . ?\x5704) ;; <CJK>
     (?$A`u(B . ?\x570A) ;; <CJK>
     (?$A`v(B . ?\x5709) ;; <CJK>
     (?$A`w(B . ?\x571C) ;; <CJK>
     (?$A`x(B . ?\x5E0F) ;; <CJK>
     (?$A`y(B . ?\x5E19) ;; <CJK>
     (?$A`z(B . ?\x5E14) ;; <CJK>
     (?$A`{(B . ?\x5E11) ;; <CJK>
     (?$A`|(B . ?\x5E31) ;; <CJK>
     (?$A`}(B . ?\x5E3B) ;; <CJK>
     (?$A`~(B . ?\x5E3C) ;; <CJK>
     (?$Aa!(B . ?\x5E37) ;; <CJK>
     (?$Aa"(B . ?\x5E44) ;; <CJK>
     (?$Aa#(B . ?\x5E54) ;; <CJK>
     (?$Aa$(B . ?\x5E5B) ;; <CJK>
     (?$Aa%(B . ?\x5E5E) ;; <CJK>
     (?$Aa&(B . ?\x5E61) ;; <CJK>
     (?$Aa'(B . ?\x5C8C) ;; <CJK>
     (?$Aa((B . ?\x5C7A) ;; <CJK>
     (?$Aa)(B . ?\x5C8D) ;; <CJK>
     (?$Aa*(B . ?\x5C90) ;; <CJK>
     (?$Aa+(B . ?\x5C96) ;; <CJK>
     (?$Aa,(B . ?\x5C88) ;; <CJK>
     (?$Aa-(B . ?\x5C98) ;; <CJK>
     (?$Aa.(B . ?\x5C99) ;; <CJK>
     (?$Aa/(B . ?\x5C91) ;; <CJK>
     (?$Aa0(B . ?\x5C9A) ;; <CJK>
     (?$Aa1(B . ?\x5C9C) ;; <CJK>
     (?$Aa2(B . ?\x5CB5) ;; <CJK>
     (?$Aa3(B . ?\x5CA2) ;; <CJK>
     (?$Aa4(B . ?\x5CBD) ;; <CJK>
     (?$Aa5(B . ?\x5CAC) ;; <CJK>
     (?$Aa6(B . ?\x5CAB) ;; <CJK>
     (?$Aa7(B . ?\x5CB1) ;; <CJK>
     (?$Aa8(B . ?\x5CA3) ;; <CJK>
     (?$Aa9(B . ?\x5CC1) ;; <CJK>
     (?$Aa:(B . ?\x5CB7) ;; <CJK>
     (?$Aa;(B . ?\x5CC4) ;; <CJK>
     (?$Aa<(B . ?\x5CD2) ;; <CJK>
     (?$Aa=(B . ?\x5CE4) ;; <CJK>
     (?$Aa>(B . ?\x5CCB) ;; <CJK>
     (?$Aa?(B . ?\x5CE5) ;; <CJK>
     (?$Aa@(B . ?\x5D02) ;; <CJK>
     (?$AaA(B . ?\x5D03) ;; <CJK>
     (?$AaB(B . ?\x5D27) ;; <CJK>
     (?$AaC(B . ?\x5D26) ;; <CJK>
     (?$AaD(B . ?\x5D2E) ;; <CJK>
     (?$AaE(B . ?\x5D24) ;; <CJK>
     (?$AaF(B . ?\x5D1E) ;; <CJK>
     (?$AaG(B . ?\x5D06) ;; <CJK>
     (?$AaH(B . ?\x5D1B) ;; <CJK>
     (?$AaI(B . ?\x5D58) ;; <CJK>
     (?$AaJ(B . ?\x5D3E) ;; <CJK>
     (?$AaK(B . ?\x5D34) ;; <CJK>
     (?$AaL(B . ?\x5D3D) ;; <CJK>
     (?$AaM(B . ?\x5D6C) ;; <CJK>
     (?$AaN(B . ?\x5D5B) ;; <CJK>
     (?$AaO(B . ?\x5D6F) ;; <CJK>
     (?$AaP(B . ?\x5D5D) ;; <CJK>
     (?$AaQ(B . ?\x5D6B) ;; <CJK>
     (?$AaR(B . ?\x5D4B) ;; <CJK>
     (?$AaS(B . ?\x5D4A) ;; <CJK>
     (?$AaT(B . ?\x5D69) ;; <CJK>
     (?$AaU(B . ?\x5D74) ;; <CJK>
     (?$AaV(B . ?\x5D82) ;; <CJK>
     (?$AaW(B . ?\x5D99) ;; <CJK>
     (?$AaX(B . ?\x5D9D) ;; <CJK>
     (?$AaY(B . ?\x8C73) ;; <CJK>
     (?$AaZ(B . ?\x5DB7) ;; <CJK>
     (?$Aa[(B . ?\x5DC5) ;; <CJK>
     (?$Aa\(B . ?\x5F73) ;; <CJK>
     (?$Aa](B . ?\x5F77) ;; <CJK>
     (?$Aa^(B . ?\x5F82) ;; <CJK>
     (?$Aa_(B . ?\x5F87) ;; <CJK>
     (?$Aa`(B . ?\x5F89) ;; <CJK>
     (?$Aaa(B . ?\x5F8C) ;; <CJK>
     (?$Aab(B . ?\x5F95) ;; <CJK>
     (?$Aac(B . ?\x5F99) ;; <CJK>
     (?$Aad(B . ?\x5F9C) ;; <CJK>
     (?$Aae(B . ?\x5FA8) ;; <CJK>
     (?$Aaf(B . ?\x5FAD) ;; <CJK>
     (?$Aag(B . ?\x5FB5) ;; <CJK>
     (?$Aah(B . ?\x5FBC) ;; <CJK>
     (?$Aai(B . ?\x8862) ;; <CJK>
     (?$Aaj(B . ?\x5F61) ;; <CJK>
     (?$Aak(B . ?\x72AD) ;; <CJK>
     (?$Aal(B . ?\x72B0) ;; <CJK>
     (?$Aam(B . ?\x72B4) ;; <CJK>
     (?$Aan(B . ?\x72B7) ;; <CJK>
     (?$Aao(B . ?\x72B8) ;; <CJK>
     (?$Aap(B . ?\x72C3) ;; <CJK>
     (?$Aaq(B . ?\x72C1) ;; <CJK>
     (?$Aar(B . ?\x72CE) ;; <CJK>
     (?$Aas(B . ?\x72CD) ;; <CJK>
     (?$Aat(B . ?\x72D2) ;; <CJK>
     (?$Aau(B . ?\x72E8) ;; <CJK>
     (?$Aav(B . ?\x72EF) ;; <CJK>
     (?$Aaw(B . ?\x72E9) ;; <CJK>
     (?$Aax(B . ?\x72F2) ;; <CJK>
     (?$Aay(B . ?\x72F4) ;; <CJK>
     (?$Aaz(B . ?\x72F7) ;; <CJK>
     (?$Aa{(B . ?\x7301) ;; <CJK>
     (?$Aa|(B . ?\x72F3) ;; <CJK>
     (?$Aa}(B . ?\x7303) ;; <CJK>
     (?$Aa~(B . ?\x72FA) ;; <CJK>
     (?$Ab!(B . ?\x72FB) ;; <CJK>
     (?$Ab"(B . ?\x7317) ;; <CJK>
     (?$Ab#(B . ?\x7313) ;; <CJK>
     (?$Ab$(B . ?\x7321) ;; <CJK>
     (?$Ab%(B . ?\x730A) ;; <CJK>
     (?$Ab&(B . ?\x731E) ;; <CJK>
     (?$Ab'(B . ?\x731D) ;; <CJK>
     (?$Ab((B . ?\x7315) ;; <CJK>
     (?$Ab)(B . ?\x7322) ;; <CJK>
     (?$Ab*(B . ?\x7339) ;; <CJK>
     (?$Ab+(B . ?\x7325) ;; <CJK>
     (?$Ab,(B . ?\x732C) ;; <CJK>
     (?$Ab-(B . ?\x7338) ;; <CJK>
     (?$Ab.(B . ?\x7331) ;; <CJK>
     (?$Ab/(B . ?\x7350) ;; <CJK>
     (?$Ab0(B . ?\x734D) ;; <CJK>
     (?$Ab1(B . ?\x7357) ;; <CJK>
     (?$Ab2(B . ?\x7360) ;; <CJK>
     (?$Ab3(B . ?\x736C) ;; <CJK>
     (?$Ab4(B . ?\x736F) ;; <CJK>
     (?$Ab5(B . ?\x737E) ;; <CJK>
     (?$Ab6(B . ?\x821B) ;; <CJK>
     (?$Ab7(B . ?\x5925) ;; <CJK>
     (?$Ab8(B . ?\x98E7) ;; <CJK>
     (?$Ab9(B . ?\x5924) ;; <CJK>
     (?$Ab:(B . ?\x5902) ;; <CJK>
     (?$Ab;(B . ?\x9963) ;; <CJK>
     (?$Ab<(B . ?\x9967) ;; <CJK>
     (?$Ab=(B . ?\x9968) ;; <CJK>
     (?$Ab>(B . ?\x9969) ;; <CJK>
     (?$Ab?(B . ?\x996A) ;; <CJK>
     (?$Ab@(B . ?\x996B) ;; <CJK>
     (?$AbA(B . ?\x996C) ;; <CJK>
     (?$AbB(B . ?\x9974) ;; <CJK>
     (?$AbC(B . ?\x9977) ;; <CJK>
     (?$AbD(B . ?\x997D) ;; <CJK>
     (?$AbE(B . ?\x9980) ;; <CJK>
     (?$AbF(B . ?\x9984) ;; <CJK>
     (?$AbG(B . ?\x9987) ;; <CJK>
     (?$AbH(B . ?\x998A) ;; <CJK>
     (?$AbI(B . ?\x998D) ;; <CJK>
     (?$AbJ(B . ?\x9990) ;; <CJK>
     (?$AbK(B . ?\x9991) ;; <CJK>
     (?$AbL(B . ?\x9993) ;; <CJK>
     (?$AbM(B . ?\x9994) ;; <CJK>
     (?$AbN(B . ?\x9995) ;; <CJK>
     (?$AbO(B . ?\x5E80) ;; <CJK>
     (?$AbP(B . ?\x5E91) ;; <CJK>
     (?$AbQ(B . ?\x5E8B) ;; <CJK>
     (?$AbR(B . ?\x5E96) ;; <CJK>
     (?$AbS(B . ?\x5EA5) ;; <CJK>
     (?$AbT(B . ?\x5EA0) ;; <CJK>
     (?$AbU(B . ?\x5EB9) ;; <CJK>
     (?$AbV(B . ?\x5EB5) ;; <CJK>
     (?$AbW(B . ?\x5EBE) ;; <CJK>
     (?$AbX(B . ?\x5EB3) ;; <CJK>
     (?$AbY(B . ?\x8D53) ;; <CJK>
     (?$AbZ(B . ?\x5ED2) ;; <CJK>
     (?$Ab[(B . ?\x5ED1) ;; <CJK>
     (?$Ab\(B . ?\x5EDB) ;; <CJK>
     (?$Ab](B . ?\x5EE8) ;; <CJK>
     (?$Ab^(B . ?\x5EEA) ;; <CJK>
     (?$Ab_(B . ?\x81BA) ;; <CJK>
     (?$Ab`(B . ?\x5FC4) ;; <CJK>
     (?$Aba(B . ?\x5FC9) ;; <CJK>
     (?$Abb(B . ?\x5FD6) ;; <CJK>
     (?$Abc(B . ?\x5FCF) ;; <CJK>
     (?$Abd(B . ?\x6003) ;; <CJK>
     (?$Abe(B . ?\x5FEE) ;; <CJK>
     (?$Abf(B . ?\x6004) ;; <CJK>
     (?$Abg(B . ?\x5FE1) ;; <CJK>
     (?$Abh(B . ?\x5FE4) ;; <CJK>
     (?$Abi(B . ?\x5FFE) ;; <CJK>
     (?$Abj(B . ?\x6005) ;; <CJK>
     (?$Abk(B . ?\x6006) ;; <CJK>
     (?$Abl(B . ?\x5FEA) ;; <CJK>
     (?$Abm(B . ?\x5FED) ;; <CJK>
     (?$Abn(B . ?\x5FF8) ;; <CJK>
     (?$Abo(B . ?\x6019) ;; <CJK>
     (?$Abp(B . ?\x6035) ;; <CJK>
     (?$Abq(B . ?\x6026) ;; <CJK>
     (?$Abr(B . ?\x601B) ;; <CJK>
     (?$Abs(B . ?\x600F) ;; <CJK>
     (?$Abt(B . ?\x600D) ;; <CJK>
     (?$Abu(B . ?\x6029) ;; <CJK>
     (?$Abv(B . ?\x602B) ;; <CJK>
     (?$Abw(B . ?\x600A) ;; <CJK>
     (?$Abx(B . ?\x603F) ;; <CJK>
     (?$Aby(B . ?\x6021) ;; <CJK>
     (?$Abz(B . ?\x6078) ;; <CJK>
     (?$Ab{(B . ?\x6079) ;; <CJK>
     (?$Ab|(B . ?\x607B) ;; <CJK>
     (?$Ab}(B . ?\x607A) ;; <CJK>
     (?$Ab~(B . ?\x6042) ;; <CJK>
     (?$Ac!(B . ?\x606A) ;; <CJK>
     (?$Ac"(B . ?\x607D) ;; <CJK>
     (?$Ac#(B . ?\x6096) ;; <CJK>
     (?$Ac$(B . ?\x609A) ;; <CJK>
     (?$Ac%(B . ?\x60AD) ;; <CJK>
     (?$Ac&(B . ?\x609D) ;; <CJK>
     (?$Ac'(B . ?\x6083) ;; <CJK>
     (?$Ac((B . ?\x6092) ;; <CJK>
     (?$Ac)(B . ?\x608C) ;; <CJK>
     (?$Ac*(B . ?\x609B) ;; <CJK>
     (?$Ac+(B . ?\x60EC) ;; <CJK>
     (?$Ac,(B . ?\x60BB) ;; <CJK>
     (?$Ac-(B . ?\x60B1) ;; <CJK>
     (?$Ac.(B . ?\x60DD) ;; <CJK>
     (?$Ac/(B . ?\x60D8) ;; <CJK>
     (?$Ac0(B . ?\x60C6) ;; <CJK>
     (?$Ac1(B . ?\x60DA) ;; <CJK>
     (?$Ac2(B . ?\x60B4) ;; <CJK>
     (?$Ac3(B . ?\x6120) ;; <CJK>
     (?$Ac4(B . ?\x6126) ;; <CJK>
     (?$Ac5(B . ?\x6115) ;; <CJK>
     (?$Ac6(B . ?\x6123) ;; <CJK>
     (?$Ac7(B . ?\x60F4) ;; <CJK>
     (?$Ac8(B . ?\x6100) ;; <CJK>
     (?$Ac9(B . ?\x610E) ;; <CJK>
     (?$Ac:(B . ?\x612B) ;; <CJK>
     (?$Ac;(B . ?\x614A) ;; <CJK>
     (?$Ac<(B . ?\x6175) ;; <CJK>
     (?$Ac=(B . ?\x61AC) ;; <CJK>
     (?$Ac>(B . ?\x6194) ;; <CJK>
     (?$Ac?(B . ?\x61A7) ;; <CJK>
     (?$Ac@(B . ?\x61B7) ;; <CJK>
     (?$AcA(B . ?\x61D4) ;; <CJK>
     (?$AcB(B . ?\x61F5) ;; <CJK>
     (?$AcC(B . ?\x5FDD) ;; <CJK>
     (?$AcD(B . ?\x96B3) ;; <CJK>
     (?$AcE(B . ?\x95E9) ;; <CJK>
     (?$AcF(B . ?\x95EB) ;; <CJK>
     (?$AcG(B . ?\x95F1) ;; <CJK>
     (?$AcH(B . ?\x95F3) ;; <CJK>
     (?$AcI(B . ?\x95F5) ;; <CJK>
     (?$AcJ(B . ?\x95F6) ;; <CJK>
     (?$AcK(B . ?\x95FC) ;; <CJK>
     (?$AcL(B . ?\x95FE) ;; <CJK>
     (?$AcM(B . ?\x9603) ;; <CJK>
     (?$AcN(B . ?\x9604) ;; <CJK>
     (?$AcO(B . ?\x9606) ;; <CJK>
     (?$AcP(B . ?\x9608) ;; <CJK>
     (?$AcQ(B . ?\x960A) ;; <CJK>
     (?$AcR(B . ?\x960B) ;; <CJK>
     (?$AcS(B . ?\x960C) ;; <CJK>
     (?$AcT(B . ?\x960D) ;; <CJK>
     (?$AcU(B . ?\x960F) ;; <CJK>
     (?$AcV(B . ?\x9612) ;; <CJK>
     (?$AcW(B . ?\x9615) ;; <CJK>
     (?$AcX(B . ?\x9616) ;; <CJK>
     (?$AcY(B . ?\x9617) ;; <CJK>
     (?$AcZ(B . ?\x9619) ;; <CJK>
     (?$Ac[(B . ?\x961A) ;; <CJK>
     (?$Ac\(B . ?\x4E2C) ;; <CJK>
     (?$Ac](B . ?\x723F) ;; <CJK>
     (?$Ac^(B . ?\x6215) ;; <CJK>
     (?$Ac_(B . ?\x6C35) ;; <CJK>
     (?$Ac`(B . ?\x6C54) ;; <CJK>
     (?$Aca(B . ?\x6C5C) ;; <CJK>
     (?$Acb(B . ?\x6C4A) ;; <CJK>
     (?$Acc(B . ?\x6CA3) ;; <CJK>
     (?$Acd(B . ?\x6C85) ;; <CJK>
     (?$Ace(B . ?\x6C90) ;; <CJK>
     (?$Acf(B . ?\x6C94) ;; <CJK>
     (?$Acg(B . ?\x6C8C) ;; <CJK>
     (?$Ach(B . ?\x6C68) ;; <CJK>
     (?$Aci(B . ?\x6C69) ;; <CJK>
     (?$Acj(B . ?\x6C74) ;; <CJK>
     (?$Ack(B . ?\x6C76) ;; <CJK>
     (?$Acl(B . ?\x6C86) ;; <CJK>
     (?$Acm(B . ?\x6CA9) ;; <CJK>
     (?$Acn(B . ?\x6CD0) ;; <CJK>
     (?$Aco(B . ?\x6CD4) ;; <CJK>
     (?$Acp(B . ?\x6CAD) ;; <CJK>
     (?$Acq(B . ?\x6CF7) ;; <CJK>
     (?$Acr(B . ?\x6CF8) ;; <CJK>
     (?$Acs(B . ?\x6CF1) ;; <CJK>
     (?$Act(B . ?\x6CD7) ;; <CJK>
     (?$Acu(B . ?\x6CB2) ;; <CJK>
     (?$Acv(B . ?\x6CE0) ;; <CJK>
     (?$Acw(B . ?\x6CD6) ;; <CJK>
     (?$Acx(B . ?\x6CFA) ;; <CJK>
     (?$Acy(B . ?\x6CEB) ;; <CJK>
     (?$Acz(B . ?\x6CEE) ;; <CJK>
     (?$Ac{(B . ?\x6CB1) ;; <CJK>
     (?$Ac|(B . ?\x6CD3) ;; <CJK>
     (?$Ac}(B . ?\x6CEF) ;; <CJK>
     (?$Ac~(B . ?\x6CFE) ;; <CJK>
     (?$Ad!(B . ?\x6D39) ;; <CJK>
     (?$Ad"(B . ?\x6D27) ;; <CJK>
     (?$Ad#(B . ?\x6D0C) ;; <CJK>
     (?$Ad$(B . ?\x6D43) ;; <CJK>
     (?$Ad%(B . ?\x6D48) ;; <CJK>
     (?$Ad&(B . ?\x6D07) ;; <CJK>
     (?$Ad'(B . ?\x6D04) ;; <CJK>
     (?$Ad((B . ?\x6D19) ;; <CJK>
     (?$Ad)(B . ?\x6D0E) ;; <CJK>
     (?$Ad*(B . ?\x6D2B) ;; <CJK>
     (?$Ad+(B . ?\x6D4D) ;; <CJK>
     (?$Ad,(B . ?\x6D2E) ;; <CJK>
     (?$Ad-(B . ?\x6D35) ;; <CJK>
     (?$Ad.(B . ?\x6D1A) ;; <CJK>
     (?$Ad/(B . ?\x6D4F) ;; <CJK>
     (?$Ad0(B . ?\x6D52) ;; <CJK>
     (?$Ad1(B . ?\x6D54) ;; <CJK>
     (?$Ad2(B . ?\x6D33) ;; <CJK>
     (?$Ad3(B . ?\x6D91) ;; <CJK>
     (?$Ad4(B . ?\x6D6F) ;; <CJK>
     (?$Ad5(B . ?\x6D9E) ;; <CJK>
     (?$Ad6(B . ?\x6DA0) ;; <CJK>
     (?$Ad7(B . ?\x6D5E) ;; <CJK>
     (?$Ad8(B . ?\x6D93) ;; <CJK>
     (?$Ad9(B . ?\x6D94) ;; <CJK>
     (?$Ad:(B . ?\x6D5C) ;; <CJK>
     (?$Ad;(B . ?\x6D60) ;; <CJK>
     (?$Ad<(B . ?\x6D7C) ;; <CJK>
     (?$Ad=(B . ?\x6D63) ;; <CJK>
     (?$Ad>(B . ?\x6E1A) ;; <CJK>
     (?$Ad?(B . ?\x6DC7) ;; <CJK>
     (?$Ad@(B . ?\x6DC5) ;; <CJK>
     (?$AdA(B . ?\x6DDE) ;; <CJK>
     (?$AdB(B . ?\x6E0E) ;; <CJK>
     (?$AdC(B . ?\x6DBF) ;; <CJK>
     (?$AdD(B . ?\x6DE0) ;; <CJK>
     (?$AdE(B . ?\x6E11) ;; <CJK>
     (?$AdF(B . ?\x6DE6) ;; <CJK>
     (?$AdG(B . ?\x6DDD) ;; <CJK>
     (?$AdH(B . ?\x6DD9) ;; <CJK>
     (?$AdI(B . ?\x6E16) ;; <CJK>
     (?$AdJ(B . ?\x6DAB) ;; <CJK>
     (?$AdK(B . ?\x6E0C) ;; <CJK>
     (?$AdL(B . ?\x6DAE) ;; <CJK>
     (?$AdM(B . ?\x6E2B) ;; <CJK>
     (?$AdN(B . ?\x6E6E) ;; <CJK>
     (?$AdO(B . ?\x6E4E) ;; <CJK>
     (?$AdP(B . ?\x6E6B) ;; <CJK>
     (?$AdQ(B . ?\x6EB2) ;; <CJK>
     (?$AdR(B . ?\x6E5F) ;; <CJK>
     (?$AdS(B . ?\x6E86) ;; <CJK>
     (?$AdT(B . ?\x6E53) ;; <CJK>
     (?$AdU(B . ?\x6E54) ;; <CJK>
     (?$AdV(B . ?\x6E32) ;; <CJK>
     (?$AdW(B . ?\x6E25) ;; <CJK>
     (?$AdX(B . ?\x6E44) ;; <CJK>
     (?$AdY(B . ?\x6EDF) ;; <CJK>
     (?$AdZ(B . ?\x6EB1) ;; <CJK>
     (?$Ad[(B . ?\x6E98) ;; <CJK>
     (?$Ad\(B . ?\x6EE0) ;; <CJK>
     (?$Ad](B . ?\x6F2D) ;; <CJK>
     (?$Ad^(B . ?\x6EE2) ;; <CJK>
     (?$Ad_(B . ?\x6EA5) ;; <CJK>
     (?$Ad`(B . ?\x6EA7) ;; <CJK>
     (?$Ada(B . ?\x6EBD) ;; <CJK>
     (?$Adb(B . ?\x6EBB) ;; <CJK>
     (?$Adc(B . ?\x6EB7) ;; <CJK>
     (?$Add(B . ?\x6ED7) ;; <CJK>
     (?$Ade(B . ?\x6EB4) ;; <CJK>
     (?$Adf(B . ?\x6ECF) ;; <CJK>
     (?$Adg(B . ?\x6E8F) ;; <CJK>
     (?$Adh(B . ?\x6EC2) ;; <CJK>
     (?$Adi(B . ?\x6E9F) ;; <CJK>
     (?$Adj(B . ?\x6F62) ;; <CJK>
     (?$Adk(B . ?\x6F46) ;; <CJK>
     (?$Adl(B . ?\x6F47) ;; <CJK>
     (?$Adm(B . ?\x6F24) ;; <CJK>
     (?$Adn(B . ?\x6F15) ;; <CJK>
     (?$Ado(B . ?\x6EF9) ;; <CJK>
     (?$Adp(B . ?\x6F2F) ;; <CJK>
     (?$Adq(B . ?\x6F36) ;; <CJK>
     (?$Adr(B . ?\x6F4B) ;; <CJK>
     (?$Ads(B . ?\x6F74) ;; <CJK>
     (?$Adt(B . ?\x6F2A) ;; <CJK>
     (?$Adu(B . ?\x6F09) ;; <CJK>
     (?$Adv(B . ?\x6F29) ;; <CJK>
     (?$Adw(B . ?\x6F89) ;; <CJK>
     (?$Adx(B . ?\x6F8D) ;; <CJK>
     (?$Ady(B . ?\x6F8C) ;; <CJK>
     (?$Adz(B . ?\x6F78) ;; <CJK>
     (?$Ad{(B . ?\x6F72) ;; <CJK>
     (?$Ad|(B . ?\x6F7C) ;; <CJK>
     (?$Ad}(B . ?\x6F7A) ;; <CJK>
     (?$Ad~(B . ?\x6FD1) ;; <CJK>
     (?$Ae!(B . ?\x6FC9) ;; <CJK>
     (?$Ae"(B . ?\x6FA7) ;; <CJK>
     (?$Ae#(B . ?\x6FB9) ;; <CJK>
     (?$Ae$(B . ?\x6FB6) ;; <CJK>
     (?$Ae%(B . ?\x6FC2) ;; <CJK>
     (?$Ae&(B . ?\x6FE1) ;; <CJK>
     (?$Ae'(B . ?\x6FEE) ;; <CJK>
     (?$Ae((B . ?\x6FDE) ;; <CJK>
     (?$Ae)(B . ?\x6FE0) ;; <CJK>
     (?$Ae*(B . ?\x6FEF) ;; <CJK>
     (?$Ae+(B . ?\x701A) ;; <CJK>
     (?$Ae,(B . ?\x7023) ;; <CJK>
     (?$Ae-(B . ?\x701B) ;; <CJK>
     (?$Ae.(B . ?\x7039) ;; <CJK>
     (?$Ae/(B . ?\x7035) ;; <CJK>
     (?$Ae0(B . ?\x704F) ;; <CJK>
     (?$Ae1(B . ?\x705E) ;; <CJK>
     (?$Ae2(B . ?\x5B80) ;; <CJK>
     (?$Ae3(B . ?\x5B84) ;; <CJK>
     (?$Ae4(B . ?\x5B95) ;; <CJK>
     (?$Ae5(B . ?\x5B93) ;; <CJK>
     (?$Ae6(B . ?\x5BA5) ;; <CJK>
     (?$Ae7(B . ?\x5BB8) ;; <CJK>
     (?$Ae8(B . ?\x752F) ;; <CJK>
     (?$Ae9(B . ?\x9A9E) ;; <CJK>
     (?$Ae:(B . ?\x6434) ;; <CJK>
     (?$Ae;(B . ?\x5BE4) ;; <CJK>
     (?$Ae<(B . ?\x5BEE) ;; <CJK>
     (?$Ae=(B . ?\x8930) ;; <CJK>
     (?$Ae>(B . ?\x5BF0) ;; <CJK>
     (?$Ae?(B . ?\x8E47) ;; <CJK>
     (?$Ae@(B . ?\x8B07) ;; <CJK>
     (?$AeA(B . ?\x8FB6) ;; <CJK>
     (?$AeB(B . ?\x8FD3) ;; <CJK>
     (?$AeC(B . ?\x8FD5) ;; <CJK>
     (?$AeD(B . ?\x8FE5) ;; <CJK>
     (?$AeE(B . ?\x8FEE) ;; <CJK>
     (?$AeF(B . ?\x8FE4) ;; <CJK>
     (?$AeG(B . ?\x8FE9) ;; <CJK>
     (?$AeH(B . ?\x8FE6) ;; <CJK>
     (?$AeI(B . ?\x8FF3) ;; <CJK>
     (?$AeJ(B . ?\x8FE8) ;; <CJK>
     (?$AeK(B . ?\x9005) ;; <CJK>
     (?$AeL(B . ?\x9004) ;; <CJK>
     (?$AeM(B . ?\x900B) ;; <CJK>
     (?$AeN(B . ?\x9026) ;; <CJK>
     (?$AeO(B . ?\x9011) ;; <CJK>
     (?$AeP(B . ?\x900D) ;; <CJK>
     (?$AeQ(B . ?\x9016) ;; <CJK>
     (?$AeR(B . ?\x9021) ;; <CJK>
     (?$AeS(B . ?\x9035) ;; <CJK>
     (?$AeT(B . ?\x9036) ;; <CJK>
     (?$AeU(B . ?\x902D) ;; <CJK>
     (?$AeV(B . ?\x902F) ;; <CJK>
     (?$AeW(B . ?\x9044) ;; <CJK>
     (?$AeX(B . ?\x9051) ;; <CJK>
     (?$AeY(B . ?\x9052) ;; <CJK>
     (?$AeZ(B . ?\x9050) ;; <CJK>
     (?$Ae[(B . ?\x9068) ;; <CJK>
     (?$Ae\(B . ?\x9058) ;; <CJK>
     (?$Ae](B . ?\x9062) ;; <CJK>
     (?$Ae^(B . ?\x905B) ;; <CJK>
     (?$Ae_(B . ?\x66B9) ;; <CJK>
     (?$Ae`(B . ?\x9074) ;; <CJK>
     (?$Aea(B . ?\x907D) ;; <CJK>
     (?$Aeb(B . ?\x9082) ;; <CJK>
     (?$Aec(B . ?\x9088) ;; <CJK>
     (?$Aed(B . ?\x9083) ;; <CJK>
     (?$Aee(B . ?\x908B) ;; <CJK>
     (?$Aef(B . ?\x5F50) ;; <CJK>
     (?$Aeg(B . ?\x5F57) ;; <CJK>
     (?$Aeh(B . ?\x5F56) ;; <CJK>
     (?$Aei(B . ?\x5F58) ;; <CJK>
     (?$Aej(B . ?\x5C3B) ;; <CJK>
     (?$Aek(B . ?\x54AB) ;; <CJK>
     (?$Ael(B . ?\x5C50) ;; <CJK>
     (?$Aem(B . ?\x5C59) ;; <CJK>
     (?$Aen(B . ?\x5B71) ;; <CJK>
     (?$Aeo(B . ?\x5C63) ;; <CJK>
     (?$Aep(B . ?\x5C66) ;; <CJK>
     (?$Aeq(B . ?\x7FBC) ;; <CJK>
     (?$Aer(B . ?\x5F2A) ;; <CJK>
     (?$Aes(B . ?\x5F29) ;; <CJK>
     (?$Aet(B . ?\x5F2D) ;; <CJK>
     (?$Aeu(B . ?\x8274) ;; <CJK>
     (?$Aev(B . ?\x5F3C) ;; <CJK>
     (?$Aew(B . ?\x9B3B) ;; <CJK>
     (?$Aex(B . ?\x5C6E) ;; <CJK>
     (?$Aey(B . ?\x5981) ;; <CJK>
     (?$Aez(B . ?\x5983) ;; <CJK>
     (?$Ae{(B . ?\x598D) ;; <CJK>
     (?$Ae|(B . ?\x59A9) ;; <CJK>
     (?$Ae}(B . ?\x59AA) ;; <CJK>
     (?$Ae~(B . ?\x59A3) ;; <CJK>
     (?$Af!(B . ?\x5997) ;; <CJK>
     (?$Af"(B . ?\x59CA) ;; <CJK>
     (?$Af#(B . ?\x59AB) ;; <CJK>
     (?$Af$(B . ?\x599E) ;; <CJK>
     (?$Af%(B . ?\x59A4) ;; <CJK>
     (?$Af&(B . ?\x59D2) ;; <CJK>
     (?$Af'(B . ?\x59B2) ;; <CJK>
     (?$Af((B . ?\x59AF) ;; <CJK>
     (?$Af)(B . ?\x59D7) ;; <CJK>
     (?$Af*(B . ?\x59BE) ;; <CJK>
     (?$Af+(B . ?\x5A05) ;; <CJK>
     (?$Af,(B . ?\x5A06) ;; <CJK>
     (?$Af-(B . ?\x59DD) ;; <CJK>
     (?$Af.(B . ?\x5A08) ;; <CJK>
     (?$Af/(B . ?\x59E3) ;; <CJK>
     (?$Af0(B . ?\x59D8) ;; <CJK>
     (?$Af1(B . ?\x59F9) ;; <CJK>
     (?$Af2(B . ?\x5A0C) ;; <CJK>
     (?$Af3(B . ?\x5A09) ;; <CJK>
     (?$Af4(B . ?\x5A32) ;; <CJK>
     (?$Af5(B . ?\x5A34) ;; <CJK>
     (?$Af6(B . ?\x5A11) ;; <CJK>
     (?$Af7(B . ?\x5A23) ;; <CJK>
     (?$Af8(B . ?\x5A13) ;; <CJK>
     (?$Af9(B . ?\x5A40) ;; <CJK>
     (?$Af:(B . ?\x5A67) ;; <CJK>
     (?$Af;(B . ?\x5A4A) ;; <CJK>
     (?$Af<(B . ?\x5A55) ;; <CJK>
     (?$Af=(B . ?\x5A3C) ;; <CJK>
     (?$Af>(B . ?\x5A62) ;; <CJK>
     (?$Af?(B . ?\x5A75) ;; <CJK>
     (?$Af@(B . ?\x80EC) ;; <CJK>
     (?$AfA(B . ?\x5AAA) ;; <CJK>
     (?$AfB(B . ?\x5A9B) ;; <CJK>
     (?$AfC(B . ?\x5A77) ;; <CJK>
     (?$AfD(B . ?\x5A7A) ;; <CJK>
     (?$AfE(B . ?\x5ABE) ;; <CJK>
     (?$AfF(B . ?\x5AEB) ;; <CJK>
     (?$AfG(B . ?\x5AB2) ;; <CJK>
     (?$AfH(B . ?\x5AD2) ;; <CJK>
     (?$AfI(B . ?\x5AD4) ;; <CJK>
     (?$AfJ(B . ?\x5AB8) ;; <CJK>
     (?$AfK(B . ?\x5AE0) ;; <CJK>
     (?$AfL(B . ?\x5AE3) ;; <CJK>
     (?$AfM(B . ?\x5AF1) ;; <CJK>
     (?$AfN(B . ?\x5AD6) ;; <CJK>
     (?$AfO(B . ?\x5AE6) ;; <CJK>
     (?$AfP(B . ?\x5AD8) ;; <CJK>
     (?$AfQ(B . ?\x5ADC) ;; <CJK>
     (?$AfR(B . ?\x5B09) ;; <CJK>
     (?$AfS(B . ?\x5B17) ;; <CJK>
     (?$AfT(B . ?\x5B16) ;; <CJK>
     (?$AfU(B . ?\x5B32) ;; <CJK>
     (?$AfV(B . ?\x5B37) ;; <CJK>
     (?$AfW(B . ?\x5B40) ;; <CJK>
     (?$AfX(B . ?\x5C15) ;; <CJK>
     (?$AfY(B . ?\x5C1C) ;; <CJK>
     (?$AfZ(B . ?\x5B5A) ;; <CJK>
     (?$Af[(B . ?\x5B65) ;; <CJK>
     (?$Af\(B . ?\x5B73) ;; <CJK>
     (?$Af](B . ?\x5B51) ;; <CJK>
     (?$Af^(B . ?\x5B53) ;; <CJK>
     (?$Af_(B . ?\x5B62) ;; <CJK>
     (?$Af`(B . ?\x9A75) ;; <CJK>
     (?$Afa(B . ?\x9A77) ;; <CJK>
     (?$Afb(B . ?\x9A78) ;; <CJK>
     (?$Afc(B . ?\x9A7A) ;; <CJK>
     (?$Afd(B . ?\x9A7F) ;; <CJK>
     (?$Afe(B . ?\x9A7D) ;; <CJK>
     (?$Aff(B . ?\x9A80) ;; <CJK>
     (?$Afg(B . ?\x9A81) ;; <CJK>
     (?$Afh(B . ?\x9A85) ;; <CJK>
     (?$Afi(B . ?\x9A88) ;; <CJK>
     (?$Afj(B . ?\x9A8A) ;; <CJK>
     (?$Afk(B . ?\x9A90) ;; <CJK>
     (?$Afl(B . ?\x9A92) ;; <CJK>
     (?$Afm(B . ?\x9A93) ;; <CJK>
     (?$Afn(B . ?\x9A96) ;; <CJK>
     (?$Afo(B . ?\x9A98) ;; <CJK>
     (?$Afp(B . ?\x9A9B) ;; <CJK>
     (?$Afq(B . ?\x9A9C) ;; <CJK>
     (?$Afr(B . ?\x9A9D) ;; <CJK>
     (?$Afs(B . ?\x9A9F) ;; <CJK>
     (?$Aft(B . ?\x9AA0) ;; <CJK>
     (?$Afu(B . ?\x9AA2) ;; <CJK>
     (?$Afv(B . ?\x9AA3) ;; <CJK>
     (?$Afw(B . ?\x9AA5) ;; <CJK>
     (?$Afx(B . ?\x9AA7) ;; <CJK>
     (?$Afy(B . ?\x7E9F) ;; <CJK>
     (?$Afz(B . ?\x7EA1) ;; <CJK>
     (?$Af{(B . ?\x7EA3) ;; <CJK>
     (?$Af|(B . ?\x7EA5) ;; <CJK>
     (?$Af}(B . ?\x7EA8) ;; <CJK>
     (?$Af~(B . ?\x7EA9) ;; <CJK>
     (?$Ag!(B . ?\x7EAD) ;; <CJK>
     (?$Ag"(B . ?\x7EB0) ;; <CJK>
     (?$Ag#(B . ?\x7EBE) ;; <CJK>
     (?$Ag$(B . ?\x7EC0) ;; <CJK>
     (?$Ag%(B . ?\x7EC1) ;; <CJK>
     (?$Ag&(B . ?\x7EC2) ;; <CJK>
     (?$Ag'(B . ?\x7EC9) ;; <CJK>
     (?$Ag((B . ?\x7ECB) ;; <CJK>
     (?$Ag)(B . ?\x7ECC) ;; <CJK>
     (?$Ag*(B . ?\x7ED0) ;; <CJK>
     (?$Ag+(B . ?\x7ED4) ;; <CJK>
     (?$Ag,(B . ?\x7ED7) ;; <CJK>
     (?$Ag-(B . ?\x7EDB) ;; <CJK>
     (?$Ag.(B . ?\x7EE0) ;; <CJK>
     (?$Ag/(B . ?\x7EE1) ;; <CJK>
     (?$Ag0(B . ?\x7EE8) ;; <CJK>
     (?$Ag1(B . ?\x7EEB) ;; <CJK>
     (?$Ag2(B . ?\x7EEE) ;; <CJK>
     (?$Ag3(B . ?\x7EEF) ;; <CJK>
     (?$Ag4(B . ?\x7EF1) ;; <CJK>
     (?$Ag5(B . ?\x7EF2) ;; <CJK>
     (?$Ag6(B . ?\x7F0D) ;; <CJK>
     (?$Ag7(B . ?\x7EF6) ;; <CJK>
     (?$Ag8(B . ?\x7EFA) ;; <CJK>
     (?$Ag9(B . ?\x7EFB) ;; <CJK>
     (?$Ag:(B . ?\x7EFE) ;; <CJK>
     (?$Ag;(B . ?\x7F01) ;; <CJK>
     (?$Ag<(B . ?\x7F02) ;; <CJK>
     (?$Ag=(B . ?\x7F03) ;; <CJK>
     (?$Ag>(B . ?\x7F07) ;; <CJK>
     (?$Ag?(B . ?\x7F08) ;; <CJK>
     (?$Ag@(B . ?\x7F0B) ;; <CJK>
     (?$AgA(B . ?\x7F0C) ;; <CJK>
     (?$AgB(B . ?\x7F0F) ;; <CJK>
     (?$AgC(B . ?\x7F11) ;; <CJK>
     (?$AgD(B . ?\x7F12) ;; <CJK>
     (?$AgE(B . ?\x7F17) ;; <CJK>
     (?$AgF(B . ?\x7F19) ;; <CJK>
     (?$AgG(B . ?\x7F1C) ;; <CJK>
     (?$AgH(B . ?\x7F1B) ;; <CJK>
     (?$AgI(B . ?\x7F1F) ;; <CJK>
     (?$AgJ(B . ?\x7F21) ;; <CJK>
     (?$AgK(B . ?\x7F22) ;; <CJK>
     (?$AgL(B . ?\x7F23) ;; <CJK>
     (?$AgM(B . ?\x7F24) ;; <CJK>
     (?$AgN(B . ?\x7F25) ;; <CJK>
     (?$AgO(B . ?\x7F26) ;; <CJK>
     (?$AgP(B . ?\x7F27) ;; <CJK>
     (?$AgQ(B . ?\x7F2A) ;; <CJK>
     (?$AgR(B . ?\x7F2B) ;; <CJK>
     (?$AgS(B . ?\x7F2C) ;; <CJK>
     (?$AgT(B . ?\x7F2D) ;; <CJK>
     (?$AgU(B . ?\x7F2F) ;; <CJK>
     (?$AgV(B . ?\x7F30) ;; <CJK>
     (?$AgW(B . ?\x7F31) ;; <CJK>
     (?$AgX(B . ?\x7F32) ;; <CJK>
     (?$AgY(B . ?\x7F33) ;; <CJK>
     (?$AgZ(B . ?\x7F35) ;; <CJK>
     (?$Ag[(B . ?\x5E7A) ;; <CJK>
     (?$Ag\(B . ?\x757F) ;; <CJK>
     (?$Ag](B . ?\x5DDB) ;; <CJK>
     (?$Ag^(B . ?\x753E) ;; <CJK>
     (?$Ag_(B . ?\x9095) ;; <CJK>
     (?$Ag`(B . ?\x738E) ;; <CJK>
     (?$Aga(B . ?\x7391) ;; <CJK>
     (?$Agb(B . ?\x73AE) ;; <CJK>
     (?$Agc(B . ?\x73A2) ;; <CJK>
     (?$Agd(B . ?\x739F) ;; <CJK>
     (?$Age(B . ?\x73CF) ;; <CJK>
     (?$Agf(B . ?\x73C2) ;; <CJK>
     (?$Agg(B . ?\x73D1) ;; <CJK>
     (?$Agh(B . ?\x73B7) ;; <CJK>
     (?$Agi(B . ?\x73B3) ;; <CJK>
     (?$Agj(B . ?\x73C0) ;; <CJK>
     (?$Agk(B . ?\x73C9) ;; <CJK>
     (?$Agl(B . ?\x73C8) ;; <CJK>
     (?$Agm(B . ?\x73E5) ;; <CJK>
     (?$Agn(B . ?\x73D9) ;; <CJK>
     (?$Ago(B . ?\x987C) ;; <CJK>
     (?$Agp(B . ?\x740A) ;; <CJK>
     (?$Agq(B . ?\x73E9) ;; <CJK>
     (?$Agr(B . ?\x73E7) ;; <CJK>
     (?$Ags(B . ?\x73DE) ;; <CJK>
     (?$Agt(B . ?\x73BA) ;; <CJK>
     (?$Agu(B . ?\x73F2) ;; <CJK>
     (?$Agv(B . ?\x740F) ;; <CJK>
     (?$Agw(B . ?\x742A) ;; <CJK>
     (?$Agx(B . ?\x745B) ;; <CJK>
     (?$Agy(B . ?\x7426) ;; <CJK>
     (?$Agz(B . ?\x7425) ;; <CJK>
     (?$Ag{(B . ?\x7428) ;; <CJK>
     (?$Ag|(B . ?\x7430) ;; <CJK>
     (?$Ag}(B . ?\x742E) ;; <CJK>
     (?$Ag~(B . ?\x742C) ;; <CJK>
     (?$Ah!(B . ?\x741B) ;; <CJK>
     (?$Ah"(B . ?\x741A) ;; <CJK>
     (?$Ah#(B . ?\x7441) ;; <CJK>
     (?$Ah$(B . ?\x745C) ;; <CJK>
     (?$Ah%(B . ?\x7457) ;; <CJK>
     (?$Ah&(B . ?\x7455) ;; <CJK>
     (?$Ah'(B . ?\x7459) ;; <CJK>
     (?$Ah((B . ?\x7477) ;; <CJK>
     (?$Ah)(B . ?\x746D) ;; <CJK>
     (?$Ah*(B . ?\x747E) ;; <CJK>
     (?$Ah+(B . ?\x749C) ;; <CJK>
     (?$Ah,(B . ?\x748E) ;; <CJK>
     (?$Ah-(B . ?\x7480) ;; <CJK>
     (?$Ah.(B . ?\x7481) ;; <CJK>
     (?$Ah/(B . ?\x7487) ;; <CJK>
     (?$Ah0(B . ?\x748B) ;; <CJK>
     (?$Ah1(B . ?\x749E) ;; <CJK>
     (?$Ah2(B . ?\x74A8) ;; <CJK>
     (?$Ah3(B . ?\x74A9) ;; <CJK>
     (?$Ah4(B . ?\x7490) ;; <CJK>
     (?$Ah5(B . ?\x74A7) ;; <CJK>
     (?$Ah6(B . ?\x74D2) ;; <CJK>
     (?$Ah7(B . ?\x74BA) ;; <CJK>
     (?$Ah8(B . ?\x97EA) ;; <CJK>
     (?$Ah9(B . ?\x97EB) ;; <CJK>
     (?$Ah:(B . ?\x97EC) ;; <CJK>
     (?$Ah;(B . ?\x674C) ;; <CJK>
     (?$Ah<(B . ?\x6753) ;; <CJK>
     (?$Ah=(B . ?\x675E) ;; <CJK>
     (?$Ah>(B . ?\x6748) ;; <CJK>
     (?$Ah?(B . ?\x6769) ;; <CJK>
     (?$Ah@(B . ?\x67A5) ;; <CJK>
     (?$AhA(B . ?\x6787) ;; <CJK>
     (?$AhB(B . ?\x676A) ;; <CJK>
     (?$AhC(B . ?\x6773) ;; <CJK>
     (?$AhD(B . ?\x6798) ;; <CJK>
     (?$AhE(B . ?\x67A7) ;; <CJK>
     (?$AhF(B . ?\x6775) ;; <CJK>
     (?$AhG(B . ?\x67A8) ;; <CJK>
     (?$AhH(B . ?\x679E) ;; <CJK>
     (?$AhI(B . ?\x67AD) ;; <CJK>
     (?$AhJ(B . ?\x678B) ;; <CJK>
     (?$AhK(B . ?\x6777) ;; <CJK>
     (?$AhL(B . ?\x677C) ;; <CJK>
     (?$AhM(B . ?\x67F0) ;; <CJK>
     (?$AhN(B . ?\x6809) ;; <CJK>
     (?$AhO(B . ?\x67D8) ;; <CJK>
     (?$AhP(B . ?\x680A) ;; <CJK>
     (?$AhQ(B . ?\x67E9) ;; <CJK>
     (?$AhR(B . ?\x67B0) ;; <CJK>
     (?$AhS(B . ?\x680C) ;; <CJK>
     (?$AhT(B . ?\x67D9) ;; <CJK>
     (?$AhU(B . ?\x67B5) ;; <CJK>
     (?$AhV(B . ?\x67DA) ;; <CJK>
     (?$AhW(B . ?\x67B3) ;; <CJK>
     (?$AhX(B . ?\x67DD) ;; <CJK>
     (?$AhY(B . ?\x6800) ;; <CJK>
     (?$AhZ(B . ?\x67C3) ;; <CJK>
     (?$Ah[(B . ?\x67B8) ;; <CJK>
     (?$Ah\(B . ?\x67E2) ;; <CJK>
     (?$Ah](B . ?\x680E) ;; <CJK>
     (?$Ah^(B . ?\x67C1) ;; <CJK>
     (?$Ah_(B . ?\x67FD) ;; <CJK>
     (?$Ah`(B . ?\x6832) ;; <CJK>
     (?$Aha(B . ?\x6833) ;; <CJK>
     (?$Ahb(B . ?\x6860) ;; <CJK>
     (?$Ahc(B . ?\x6861) ;; <CJK>
     (?$Ahd(B . ?\x684E) ;; <CJK>
     (?$Ahe(B . ?\x6862) ;; <CJK>
     (?$Ahf(B . ?\x6844) ;; <CJK>
     (?$Ahg(B . ?\x6864) ;; <CJK>
     (?$Ahh(B . ?\x6883) ;; <CJK>
     (?$Ahi(B . ?\x681D) ;; <CJK>
     (?$Ahj(B . ?\x6855) ;; <CJK>
     (?$Ahk(B . ?\x6866) ;; <CJK>
     (?$Ahl(B . ?\x6841) ;; <CJK>
     (?$Ahm(B . ?\x6867) ;; <CJK>
     (?$Ahn(B . ?\x6840) ;; <CJK>
     (?$Aho(B . ?\x683E) ;; <CJK>
     (?$Ahp(B . ?\x684A) ;; <CJK>
     (?$Ahq(B . ?\x6849) ;; <CJK>
     (?$Ahr(B . ?\x6829) ;; <CJK>
     (?$Ahs(B . ?\x68B5) ;; <CJK>
     (?$Aht(B . ?\x688F) ;; <CJK>
     (?$Ahu(B . ?\x6874) ;; <CJK>
     (?$Ahv(B . ?\x6877) ;; <CJK>
     (?$Ahw(B . ?\x6893) ;; <CJK>
     (?$Ahx(B . ?\x686B) ;; <CJK>
     (?$Ahy(B . ?\x68C2) ;; <CJK>
     (?$Ahz(B . ?\x696E) ;; <CJK>
     (?$Ah{(B . ?\x68FC) ;; <CJK>
     (?$Ah|(B . ?\x691F) ;; <CJK>
     (?$Ah}(B . ?\x6920) ;; <CJK>
     (?$Ah~(B . ?\x68F9) ;; <CJK>
     (?$Ai!(B . ?\x6924) ;; <CJK>
     (?$Ai"(B . ?\x68F0) ;; <CJK>
     (?$Ai#(B . ?\x690B) ;; <CJK>
     (?$Ai$(B . ?\x6901) ;; <CJK>
     (?$Ai%(B . ?\x6957) ;; <CJK>
     (?$Ai&(B . ?\x68E3) ;; <CJK>
     (?$Ai'(B . ?\x6910) ;; <CJK>
     (?$Ai((B . ?\x6971) ;; <CJK>
     (?$Ai)(B . ?\x6939) ;; <CJK>
     (?$Ai*(B . ?\x6960) ;; <CJK>
     (?$Ai+(B . ?\x6942) ;; <CJK>
     (?$Ai,(B . ?\x695D) ;; <CJK>
     (?$Ai-(B . ?\x6984) ;; <CJK>
     (?$Ai.(B . ?\x696B) ;; <CJK>
     (?$Ai/(B . ?\x6980) ;; <CJK>
     (?$Ai0(B . ?\x6998) ;; <CJK>
     (?$Ai1(B . ?\x6978) ;; <CJK>
     (?$Ai2(B . ?\x6934) ;; <CJK>
     (?$Ai3(B . ?\x69CC) ;; <CJK>
     (?$Ai4(B . ?\x6987) ;; <CJK>
     (?$Ai5(B . ?\x6988) ;; <CJK>
     (?$Ai6(B . ?\x69CE) ;; <CJK>
     (?$Ai7(B . ?\x6989) ;; <CJK>
     (?$Ai8(B . ?\x6966) ;; <CJK>
     (?$Ai9(B . ?\x6963) ;; <CJK>
     (?$Ai:(B . ?\x6979) ;; <CJK>
     (?$Ai;(B . ?\x699B) ;; <CJK>
     (?$Ai<(B . ?\x69A7) ;; <CJK>
     (?$Ai=(B . ?\x69BB) ;; <CJK>
     (?$Ai>(B . ?\x69AB) ;; <CJK>
     (?$Ai?(B . ?\x69AD) ;; <CJK>
     (?$Ai@(B . ?\x69D4) ;; <CJK>
     (?$AiA(B . ?\x69B1) ;; <CJK>
     (?$AiB(B . ?\x69C1) ;; <CJK>
     (?$AiC(B . ?\x69CA) ;; <CJK>
     (?$AiD(B . ?\x69DF) ;; <CJK>
     (?$AiE(B . ?\x6995) ;; <CJK>
     (?$AiF(B . ?\x69E0) ;; <CJK>
     (?$AiG(B . ?\x698D) ;; <CJK>
     (?$AiH(B . ?\x69FF) ;; <CJK>
     (?$AiI(B . ?\x6A2F) ;; <CJK>
     (?$AiJ(B . ?\x69ED) ;; <CJK>
     (?$AiK(B . ?\x6A17) ;; <CJK>
     (?$AiL(B . ?\x6A18) ;; <CJK>
     (?$AiM(B . ?\x6A65) ;; <CJK>
     (?$AiN(B . ?\x69F2) ;; <CJK>
     (?$AiO(B . ?\x6A44) ;; <CJK>
     (?$AiP(B . ?\x6A3E) ;; <CJK>
     (?$AiQ(B . ?\x6AA0) ;; <CJK>
     (?$AiR(B . ?\x6A50) ;; <CJK>
     (?$AiS(B . ?\x6A5B) ;; <CJK>
     (?$AiT(B . ?\x6A35) ;; <CJK>
     (?$AiU(B . ?\x6A8E) ;; <CJK>
     (?$AiV(B . ?\x6A79) ;; <CJK>
     (?$AiW(B . ?\x6A3D) ;; <CJK>
     (?$AiX(B . ?\x6A28) ;; <CJK>
     (?$AiY(B . ?\x6A58) ;; <CJK>
     (?$AiZ(B . ?\x6A7C) ;; <CJK>
     (?$Ai[(B . ?\x6A91) ;; <CJK>
     (?$Ai\(B . ?\x6A90) ;; <CJK>
     (?$Ai](B . ?\x6AA9) ;; <CJK>
     (?$Ai^(B . ?\x6A97) ;; <CJK>
     (?$Ai_(B . ?\x6AAB) ;; <CJK>
     (?$Ai`(B . ?\x7337) ;; <CJK>
     (?$Aia(B . ?\x7352) ;; <CJK>
     (?$Aib(B . ?\x6B81) ;; <CJK>
     (?$Aic(B . ?\x6B82) ;; <CJK>
     (?$Aid(B . ?\x6B87) ;; <CJK>
     (?$Aie(B . ?\x6B84) ;; <CJK>
     (?$Aif(B . ?\x6B92) ;; <CJK>
     (?$Aig(B . ?\x6B93) ;; <CJK>
     (?$Aih(B . ?\x6B8D) ;; <CJK>
     (?$Aii(B . ?\x6B9A) ;; <CJK>
     (?$Aij(B . ?\x6B9B) ;; <CJK>
     (?$Aik(B . ?\x6BA1) ;; <CJK>
     (?$Ail(B . ?\x6BAA) ;; <CJK>
     (?$Aim(B . ?\x8F6B) ;; <CJK>
     (?$Ain(B . ?\x8F6D) ;; <CJK>
     (?$Aio(B . ?\x8F71) ;; <CJK>
     (?$Aip(B . ?\x8F72) ;; <CJK>
     (?$Aiq(B . ?\x8F73) ;; <CJK>
     (?$Air(B . ?\x8F75) ;; <CJK>
     (?$Ais(B . ?\x8F76) ;; <CJK>
     (?$Ait(B . ?\x8F78) ;; <CJK>
     (?$Aiu(B . ?\x8F77) ;; <CJK>
     (?$Aiv(B . ?\x8F79) ;; <CJK>
     (?$Aiw(B . ?\x8F7A) ;; <CJK>
     (?$Aix(B . ?\x8F7C) ;; <CJK>
     (?$Aiy(B . ?\x8F7E) ;; <CJK>
     (?$Aiz(B . ?\x8F81) ;; <CJK>
     (?$Ai{(B . ?\x8F82) ;; <CJK>
     (?$Ai|(B . ?\x8F84) ;; <CJK>
     (?$Ai}(B . ?\x8F87) ;; <CJK>
     (?$Ai~(B . ?\x8F8B) ;; <CJK>
     (?$Aj!(B . ?\x8F8D) ;; <CJK>
     (?$Aj"(B . ?\x8F8E) ;; <CJK>
     (?$Aj#(B . ?\x8F8F) ;; <CJK>
     (?$Aj$(B . ?\x8F98) ;; <CJK>
     (?$Aj%(B . ?\x8F9A) ;; <CJK>
     (?$Aj&(B . ?\x8ECE) ;; <CJK>
     (?$Aj'(B . ?\x620B) ;; <CJK>
     (?$Aj((B . ?\x6217) ;; <CJK>
     (?$Aj)(B . ?\x621B) ;; <CJK>
     (?$Aj*(B . ?\x621F) ;; <CJK>
     (?$Aj+(B . ?\x6222) ;; <CJK>
     (?$Aj,(B . ?\x6221) ;; <CJK>
     (?$Aj-(B . ?\x6225) ;; <CJK>
     (?$Aj.(B . ?\x6224) ;; <CJK>
     (?$Aj/(B . ?\x622C) ;; <CJK>
     (?$Aj0(B . ?\x81E7) ;; <CJK>
     (?$Aj1(B . ?\x74EF) ;; <CJK>
     (?$Aj2(B . ?\x74F4) ;; <CJK>
     (?$Aj3(B . ?\x74FF) ;; <CJK>
     (?$Aj4(B . ?\x750F) ;; <CJK>
     (?$Aj5(B . ?\x7511) ;; <CJK>
     (?$Aj6(B . ?\x7513) ;; <CJK>
     (?$Aj7(B . ?\x6534) ;; <CJK>
     (?$Aj8(B . ?\x65EE) ;; <CJK>
     (?$Aj9(B . ?\x65EF) ;; <CJK>
     (?$Aj:(B . ?\x65F0) ;; <CJK>
     (?$Aj;(B . ?\x660A) ;; <CJK>
     (?$Aj<(B . ?\x6619) ;; <CJK>
     (?$Aj=(B . ?\x6772) ;; <CJK>
     (?$Aj>(B . ?\x6603) ;; <CJK>
     (?$Aj?(B . ?\x6615) ;; <CJK>
     (?$Aj@(B . ?\x6600) ;; <CJK>
     (?$AjA(B . ?\x7085) ;; <CJK>
     (?$AjB(B . ?\x66F7) ;; <CJK>
     (?$AjC(B . ?\x661D) ;; <CJK>
     (?$AjD(B . ?\x6634) ;; <CJK>
     (?$AjE(B . ?\x6631) ;; <CJK>
     (?$AjF(B . ?\x6636) ;; <CJK>
     (?$AjG(B . ?\x6635) ;; <CJK>
     (?$AjH(B . ?\x8006) ;; <CJK>
     (?$AjI(B . ?\x665F) ;; <CJK>
     (?$AjJ(B . ?\x6654) ;; <CJK>
     (?$AjK(B . ?\x6641) ;; <CJK>
     (?$AjL(B . ?\x664F) ;; <CJK>
     (?$AjM(B . ?\x6656) ;; <CJK>
     (?$AjN(B . ?\x6661) ;; <CJK>
     (?$AjO(B . ?\x6657) ;; <CJK>
     (?$AjP(B . ?\x6677) ;; <CJK>
     (?$AjQ(B . ?\x6684) ;; <CJK>
     (?$AjR(B . ?\x668C) ;; <CJK>
     (?$AjS(B . ?\x66A7) ;; <CJK>
     (?$AjT(B . ?\x669D) ;; <CJK>
     (?$AjU(B . ?\x66BE) ;; <CJK>
     (?$AjV(B . ?\x66DB) ;; <CJK>
     (?$AjW(B . ?\x66DC) ;; <CJK>
     (?$AjX(B . ?\x66E6) ;; <CJK>
     (?$AjY(B . ?\x66E9) ;; <CJK>
     (?$AjZ(B . ?\x8D32) ;; <CJK>
     (?$Aj[(B . ?\x8D33) ;; <CJK>
     (?$Aj\(B . ?\x8D36) ;; <CJK>
     (?$Aj](B . ?\x8D3B) ;; <CJK>
     (?$Aj^(B . ?\x8D3D) ;; <CJK>
     (?$Aj_(B . ?\x8D40) ;; <CJK>
     (?$Aj`(B . ?\x8D45) ;; <CJK>
     (?$Aja(B . ?\x8D46) ;; <CJK>
     (?$Ajb(B . ?\x8D48) ;; <CJK>
     (?$Ajc(B . ?\x8D49) ;; <CJK>
     (?$Ajd(B . ?\x8D47) ;; <CJK>
     (?$Aje(B . ?\x8D4D) ;; <CJK>
     (?$Ajf(B . ?\x8D55) ;; <CJK>
     (?$Ajg(B . ?\x8D59) ;; <CJK>
     (?$Ajh(B . ?\x89C7) ;; <CJK>
     (?$Aji(B . ?\x89CA) ;; <CJK>
     (?$Ajj(B . ?\x89CB) ;; <CJK>
     (?$Ajk(B . ?\x89CC) ;; <CJK>
     (?$Ajl(B . ?\x89CE) ;; <CJK>
     (?$Ajm(B . ?\x89CF) ;; <CJK>
     (?$Ajn(B . ?\x89D0) ;; <CJK>
     (?$Ajo(B . ?\x89D1) ;; <CJK>
     (?$Ajp(B . ?\x726E) ;; <CJK>
     (?$Ajq(B . ?\x729F) ;; <CJK>
     (?$Ajr(B . ?\x725D) ;; <CJK>
     (?$Ajs(B . ?\x7266) ;; <CJK>
     (?$Ajt(B . ?\x726F) ;; <CJK>
     (?$Aju(B . ?\x727E) ;; <CJK>
     (?$Ajv(B . ?\x727F) ;; <CJK>
     (?$Ajw(B . ?\x7284) ;; <CJK>
     (?$Ajx(B . ?\x728B) ;; <CJK>
     (?$Ajy(B . ?\x728D) ;; <CJK>
     (?$Ajz(B . ?\x728F) ;; <CJK>
     (?$Aj{(B . ?\x7292) ;; <CJK>
     (?$Aj|(B . ?\x6308) ;; <CJK>
     (?$Aj}(B . ?\x6332) ;; <CJK>
     (?$Aj~(B . ?\x63B0) ;; <CJK>
     (?$Ak!(B . ?\x643F) ;; <CJK>
     (?$Ak"(B . ?\x64D8) ;; <CJK>
     (?$Ak#(B . ?\x8004) ;; <CJK>
     (?$Ak$(B . ?\x6BEA) ;; <CJK>
     (?$Ak%(B . ?\x6BF3) ;; <CJK>
     (?$Ak&(B . ?\x6BFD) ;; <CJK>
     (?$Ak'(B . ?\x6BF5) ;; <CJK>
     (?$Ak((B . ?\x6BF9) ;; <CJK>
     (?$Ak)(B . ?\x6C05) ;; <CJK>
     (?$Ak*(B . ?\x6C07) ;; <CJK>
     (?$Ak+(B . ?\x6C06) ;; <CJK>
     (?$Ak,(B . ?\x6C0D) ;; <CJK>
     (?$Ak-(B . ?\x6C15) ;; <CJK>
     (?$Ak.(B . ?\x6C18) ;; <CJK>
     (?$Ak/(B . ?\x6C19) ;; <CJK>
     (?$Ak0(B . ?\x6C1A) ;; <CJK>
     (?$Ak1(B . ?\x6C21) ;; <CJK>
     (?$Ak2(B . ?\x6C29) ;; <CJK>
     (?$Ak3(B . ?\x6C24) ;; <CJK>
     (?$Ak4(B . ?\x6C2A) ;; <CJK>
     (?$Ak5(B . ?\x6C32) ;; <CJK>
     (?$Ak6(B . ?\x6535) ;; <CJK>
     (?$Ak7(B . ?\x6555) ;; <CJK>
     (?$Ak8(B . ?\x656B) ;; <CJK>
     (?$Ak9(B . ?\x724D) ;; <CJK>
     (?$Ak:(B . ?\x7252) ;; <CJK>
     (?$Ak;(B . ?\x7256) ;; <CJK>
     (?$Ak<(B . ?\x7230) ;; <CJK>
     (?$Ak=(B . ?\x8662) ;; <CJK>
     (?$Ak>(B . ?\x5216) ;; <CJK>
     (?$Ak?(B . ?\x809F) ;; <CJK>
     (?$Ak@(B . ?\x809C) ;; <CJK>
     (?$AkA(B . ?\x8093) ;; <CJK>
     (?$AkB(B . ?\x80BC) ;; <CJK>
     (?$AkC(B . ?\x670A) ;; <CJK>
     (?$AkD(B . ?\x80BD) ;; <CJK>
     (?$AkE(B . ?\x80B1) ;; <CJK>
     (?$AkF(B . ?\x80AB) ;; <CJK>
     (?$AkG(B . ?\x80AD) ;; <CJK>
     (?$AkH(B . ?\x80B4) ;; <CJK>
     (?$AkI(B . ?\x80B7) ;; <CJK>
     (?$AkJ(B . ?\x80E7) ;; <CJK>
     (?$AkK(B . ?\x80E8) ;; <CJK>
     (?$AkL(B . ?\x80E9) ;; <CJK>
     (?$AkM(B . ?\x80EA) ;; <CJK>
     (?$AkN(B . ?\x80DB) ;; <CJK>
     (?$AkO(B . ?\x80C2) ;; <CJK>
     (?$AkP(B . ?\x80C4) ;; <CJK>
     (?$AkQ(B . ?\x80D9) ;; <CJK>
     (?$AkR(B . ?\x80CD) ;; <CJK>
     (?$AkS(B . ?\x80D7) ;; <CJK>
     (?$AkT(B . ?\x6710) ;; <CJK>
     (?$AkU(B . ?\x80DD) ;; <CJK>
     (?$AkV(B . ?\x80EB) ;; <CJK>
     (?$AkW(B . ?\x80F1) ;; <CJK>
     (?$AkX(B . ?\x80F4) ;; <CJK>
     (?$AkY(B . ?\x80ED) ;; <CJK>
     (?$AkZ(B . ?\x810D) ;; <CJK>
     (?$Ak[(B . ?\x810E) ;; <CJK>
     (?$Ak\(B . ?\x80F2) ;; <CJK>
     (?$Ak](B . ?\x80FC) ;; <CJK>
     (?$Ak^(B . ?\x6715) ;; <CJK>
     (?$Ak_(B . ?\x8112) ;; <CJK>
     (?$Ak`(B . ?\x8C5A) ;; <CJK>
     (?$Aka(B . ?\x8136) ;; <CJK>
     (?$Akb(B . ?\x811E) ;; <CJK>
     (?$Akc(B . ?\x812C) ;; <CJK>
     (?$Akd(B . ?\x8118) ;; <CJK>
     (?$Ake(B . ?\x8132) ;; <CJK>
     (?$Akf(B . ?\x8148) ;; <CJK>
     (?$Akg(B . ?\x814C) ;; <CJK>
     (?$Akh(B . ?\x8153) ;; <CJK>
     (?$Aki(B . ?\x8174) ;; <CJK>
     (?$Akj(B . ?\x8159) ;; <CJK>
     (?$Akk(B . ?\x815A) ;; <CJK>
     (?$Akl(B . ?\x8171) ;; <CJK>
     (?$Akm(B . ?\x8160) ;; <CJK>
     (?$Akn(B . ?\x8169) ;; <CJK>
     (?$Ako(B . ?\x817C) ;; <CJK>
     (?$Akp(B . ?\x817D) ;; <CJK>
     (?$Akq(B . ?\x816D) ;; <CJK>
     (?$Akr(B . ?\x8167) ;; <CJK>
     (?$Aks(B . ?\x584D) ;; <CJK>
     (?$Akt(B . ?\x5AB5) ;; <CJK>
     (?$Aku(B . ?\x8188) ;; <CJK>
     (?$Akv(B . ?\x8182) ;; <CJK>
     (?$Akw(B . ?\x8191) ;; <CJK>
     (?$Akx(B . ?\x6ED5) ;; <CJK>
     (?$Aky(B . ?\x81A3) ;; <CJK>
     (?$Akz(B . ?\x81AA) ;; <CJK>
     (?$Ak{(B . ?\x81CC) ;; <CJK>
     (?$Ak|(B . ?\x6726) ;; <CJK>
     (?$Ak}(B . ?\x81CA) ;; <CJK>
     (?$Ak~(B . ?\x81BB) ;; <CJK>
     (?$Al!(B . ?\x81C1) ;; <CJK>
     (?$Al"(B . ?\x81A6) ;; <CJK>
     (?$Al#(B . ?\x6B24) ;; <CJK>
     (?$Al$(B . ?\x6B37) ;; <CJK>
     (?$Al%(B . ?\x6B39) ;; <CJK>
     (?$Al&(B . ?\x6B43) ;; <CJK>
     (?$Al'(B . ?\x6B46) ;; <CJK>
     (?$Al((B . ?\x6B59) ;; <CJK>
     (?$Al)(B . ?\x98D1) ;; <CJK>
     (?$Al*(B . ?\x98D2) ;; <CJK>
     (?$Al+(B . ?\x98D3) ;; <CJK>
     (?$Al,(B . ?\x98D5) ;; <CJK>
     (?$Al-(B . ?\x98D9) ;; <CJK>
     (?$Al.(B . ?\x98DA) ;; <CJK>
     (?$Al/(B . ?\x6BB3) ;; <CJK>
     (?$Al0(B . ?\x5F40) ;; <CJK>
     (?$Al1(B . ?\x6BC2) ;; <CJK>
     (?$Al2(B . ?\x89F3) ;; <CJK>
     (?$Al3(B . ?\x6590) ;; <CJK>
     (?$Al4(B . ?\x9F51) ;; <CJK>
     (?$Al5(B . ?\x6593) ;; <CJK>
     (?$Al6(B . ?\x65BC) ;; <CJK>
     (?$Al7(B . ?\x65C6) ;; <CJK>
     (?$Al8(B . ?\x65C4) ;; <CJK>
     (?$Al9(B . ?\x65C3) ;; <CJK>
     (?$Al:(B . ?\x65CC) ;; <CJK>
     (?$Al;(B . ?\x65CE) ;; <CJK>
     (?$Al<(B . ?\x65D2) ;; <CJK>
     (?$Al=(B . ?\x65D6) ;; <CJK>
     (?$Al>(B . ?\x7080) ;; <CJK>
     (?$Al?(B . ?\x709C) ;; <CJK>
     (?$Al@(B . ?\x7096) ;; <CJK>
     (?$AlA(B . ?\x709D) ;; <CJK>
     (?$AlB(B . ?\x70BB) ;; <CJK>
     (?$AlC(B . ?\x70C0) ;; <CJK>
     (?$AlD(B . ?\x70B7) ;; <CJK>
     (?$AlE(B . ?\x70AB) ;; <CJK>
     (?$AlF(B . ?\x70B1) ;; <CJK>
     (?$AlG(B . ?\x70E8) ;; <CJK>
     (?$AlH(B . ?\x70CA) ;; <CJK>
     (?$AlI(B . ?\x7110) ;; <CJK>
     (?$AlJ(B . ?\x7113) ;; <CJK>
     (?$AlK(B . ?\x7116) ;; <CJK>
     (?$AlL(B . ?\x712F) ;; <CJK>
     (?$AlM(B . ?\x7131) ;; <CJK>
     (?$AlN(B . ?\x7173) ;; <CJK>
     (?$AlO(B . ?\x715C) ;; <CJK>
     (?$AlP(B . ?\x7168) ;; <CJK>
     (?$AlQ(B . ?\x7145) ;; <CJK>
     (?$AlR(B . ?\x7172) ;; <CJK>
     (?$AlS(B . ?\x714A) ;; <CJK>
     (?$AlT(B . ?\x7178) ;; <CJK>
     (?$AlU(B . ?\x717A) ;; <CJK>
     (?$AlV(B . ?\x7198) ;; <CJK>
     (?$AlW(B . ?\x71B3) ;; <CJK>
     (?$AlX(B . ?\x71B5) ;; <CJK>
     (?$AlY(B . ?\x71A8) ;; <CJK>
     (?$AlZ(B . ?\x71A0) ;; <CJK>
     (?$Al[(B . ?\x71E0) ;; <CJK>
     (?$Al\(B . ?\x71D4) ;; <CJK>
     (?$Al](B . ?\x71E7) ;; <CJK>
     (?$Al^(B . ?\x71F9) ;; <CJK>
     (?$Al_(B . ?\x721D) ;; <CJK>
     (?$Al`(B . ?\x7228) ;; <CJK>
     (?$Ala(B . ?\x706C) ;; <CJK>
     (?$Alb(B . ?\x7118) ;; <CJK>
     (?$Alc(B . ?\x7166) ;; <CJK>
     (?$Ald(B . ?\x71B9) ;; <CJK>
     (?$Ale(B . ?\x623E) ;; <CJK>
     (?$Alf(B . ?\x623D) ;; <CJK>
     (?$Alg(B . ?\x6243) ;; <CJK>
     (?$Alh(B . ?\x6248) ;; <CJK>
     (?$Ali(B . ?\x6249) ;; <CJK>
     (?$Alj(B . ?\x793B) ;; <CJK>
     (?$Alk(B . ?\x7940) ;; <CJK>
     (?$All(B . ?\x7946) ;; <CJK>
     (?$Alm(B . ?\x7949) ;; <CJK>
     (?$Aln(B . ?\x795B) ;; <CJK>
     (?$Alo(B . ?\x795C) ;; <CJK>
     (?$Alp(B . ?\x7953) ;; <CJK>
     (?$Alq(B . ?\x795A) ;; <CJK>
     (?$Alr(B . ?\x7962) ;; <CJK>
     (?$Als(B . ?\x7957) ;; <CJK>
     (?$Alt(B . ?\x7960) ;; <CJK>
     (?$Alu(B . ?\x796F) ;; <CJK>
     (?$Alv(B . ?\x7967) ;; <CJK>
     (?$Alw(B . ?\x797A) ;; <CJK>
     (?$Alx(B . ?\x7985) ;; <CJK>
     (?$Aly(B . ?\x798A) ;; <CJK>
     (?$Alz(B . ?\x799A) ;; <CJK>
     (?$Al{(B . ?\x79A7) ;; <CJK>
     (?$Al|(B . ?\x79B3) ;; <CJK>
     (?$Al}(B . ?\x5FD1) ;; <CJK>
     (?$Al~(B . ?\x5FD0) ;; <CJK>
     (?$Am!(B . ?\x603C) ;; <CJK>
     (?$Am"(B . ?\x605D) ;; <CJK>
     (?$Am#(B . ?\x605A) ;; <CJK>
     (?$Am$(B . ?\x6067) ;; <CJK>
     (?$Am%(B . ?\x6041) ;; <CJK>
     (?$Am&(B . ?\x6059) ;; <CJK>
     (?$Am'(B . ?\x6063) ;; <CJK>
     (?$Am((B . ?\x60AB) ;; <CJK>
     (?$Am)(B . ?\x6106) ;; <CJK>
     (?$Am*(B . ?\x610D) ;; <CJK>
     (?$Am+(B . ?\x615D) ;; <CJK>
     (?$Am,(B . ?\x61A9) ;; <CJK>
     (?$Am-(B . ?\x619D) ;; <CJK>
     (?$Am.(B . ?\x61CB) ;; <CJK>
     (?$Am/(B . ?\x61D1) ;; <CJK>
     (?$Am0(B . ?\x6206) ;; <CJK>
     (?$Am1(B . ?\x8080) ;; <CJK>
     (?$Am2(B . ?\x807F) ;; <CJK>
     (?$Am3(B . ?\x6C93) ;; <CJK>
     (?$Am4(B . ?\x6CF6) ;; <CJK>
     (?$Am5(B . ?\x6DFC) ;; <CJK>
     (?$Am6(B . ?\x77F6) ;; <CJK>
     (?$Am7(B . ?\x77F8) ;; <CJK>
     (?$Am8(B . ?\x7800) ;; <CJK>
     (?$Am9(B . ?\x7809) ;; <CJK>
     (?$Am:(B . ?\x7817) ;; <CJK>
     (?$Am;(B . ?\x7818) ;; <CJK>
     (?$Am<(B . ?\x7811) ;; <CJK>
     (?$Am=(B . ?\x65AB) ;; <CJK>
     (?$Am>(B . ?\x782D) ;; <CJK>
     (?$Am?(B . ?\x781C) ;; <CJK>
     (?$Am@(B . ?\x781D) ;; <CJK>
     (?$AmA(B . ?\x7839) ;; <CJK>
     (?$AmB(B . ?\x783A) ;; <CJK>
     (?$AmC(B . ?\x783B) ;; <CJK>
     (?$AmD(B . ?\x781F) ;; <CJK>
     (?$AmE(B . ?\x783C) ;; <CJK>
     (?$AmF(B . ?\x7825) ;; <CJK>
     (?$AmG(B . ?\x782C) ;; <CJK>
     (?$AmH(B . ?\x7823) ;; <CJK>
     (?$AmI(B . ?\x7829) ;; <CJK>
     (?$AmJ(B . ?\x784E) ;; <CJK>
     (?$AmK(B . ?\x786D) ;; <CJK>
     (?$AmL(B . ?\x7856) ;; <CJK>
     (?$AmM(B . ?\x7857) ;; <CJK>
     (?$AmN(B . ?\x7826) ;; <CJK>
     (?$AmO(B . ?\x7850) ;; <CJK>
     (?$AmP(B . ?\x7847) ;; <CJK>
     (?$AmQ(B . ?\x784C) ;; <CJK>
     (?$AmR(B . ?\x786A) ;; <CJK>
     (?$AmS(B . ?\x789B) ;; <CJK>
     (?$AmT(B . ?\x7893) ;; <CJK>
     (?$AmU(B . ?\x789A) ;; <CJK>
     (?$AmV(B . ?\x7887) ;; <CJK>
     (?$AmW(B . ?\x789C) ;; <CJK>
     (?$AmX(B . ?\x78A1) ;; <CJK>
     (?$AmY(B . ?\x78A3) ;; <CJK>
     (?$AmZ(B . ?\x78B2) ;; <CJK>
     (?$Am[(B . ?\x78B9) ;; <CJK>
     (?$Am\(B . ?\x78A5) ;; <CJK>
     (?$Am](B . ?\x78D4) ;; <CJK>
     (?$Am^(B . ?\x78D9) ;; <CJK>
     (?$Am_(B . ?\x78C9) ;; <CJK>
     (?$Am`(B . ?\x78EC) ;; <CJK>
     (?$Ama(B . ?\x78F2) ;; <CJK>
     (?$Amb(B . ?\x7905) ;; <CJK>
     (?$Amc(B . ?\x78F4) ;; <CJK>
     (?$Amd(B . ?\x7913) ;; <CJK>
     (?$Ame(B . ?\x7924) ;; <CJK>
     (?$Amf(B . ?\x791E) ;; <CJK>
     (?$Amg(B . ?\x7934) ;; <CJK>
     (?$Amh(B . ?\x9F9B) ;; <CJK>
     (?$Ami(B . ?\x9EF9) ;; <CJK>
     (?$Amj(B . ?\x9EFB) ;; <CJK>
     (?$Amk(B . ?\x9EFC) ;; <CJK>
     (?$Aml(B . ?\x76F1) ;; <CJK>
     (?$Amm(B . ?\x7704) ;; <CJK>
     (?$Amn(B . ?\x770D) ;; <CJK>
     (?$Amo(B . ?\x76F9) ;; <CJK>
     (?$Amp(B . ?\x7707) ;; <CJK>
     (?$Amq(B . ?\x7708) ;; <CJK>
     (?$Amr(B . ?\x771A) ;; <CJK>
     (?$Ams(B . ?\x7722) ;; <CJK>
     (?$Amt(B . ?\x7719) ;; <CJK>
     (?$Amu(B . ?\x772D) ;; <CJK>
     (?$Amv(B . ?\x7726) ;; <CJK>
     (?$Amw(B . ?\x7735) ;; <CJK>
     (?$Amx(B . ?\x7738) ;; <CJK>
     (?$Amy(B . ?\x7750) ;; <CJK>
     (?$Amz(B . ?\x7751) ;; <CJK>
     (?$Am{(B . ?\x7747) ;; <CJK>
     (?$Am|(B . ?\x7743) ;; <CJK>
     (?$Am}(B . ?\x775A) ;; <CJK>
     (?$Am~(B . ?\x7768) ;; <CJK>
     (?$An!(B . ?\x7762) ;; <CJK>
     (?$An"(B . ?\x7765) ;; <CJK>
     (?$An#(B . ?\x777F) ;; <CJK>
     (?$An$(B . ?\x778D) ;; <CJK>
     (?$An%(B . ?\x777D) ;; <CJK>
     (?$An&(B . ?\x7780) ;; <CJK>
     (?$An'(B . ?\x778C) ;; <CJK>
     (?$An((B . ?\x7791) ;; <CJK>
     (?$An)(B . ?\x779F) ;; <CJK>
     (?$An*(B . ?\x77A0) ;; <CJK>
     (?$An+(B . ?\x77B0) ;; <CJK>
     (?$An,(B . ?\x77B5) ;; <CJK>
     (?$An-(B . ?\x77BD) ;; <CJK>
     (?$An.(B . ?\x753A) ;; <CJK>
     (?$An/(B . ?\x7540) ;; <CJK>
     (?$An0(B . ?\x754E) ;; <CJK>
     (?$An1(B . ?\x754B) ;; <CJK>
     (?$An2(B . ?\x7548) ;; <CJK>
     (?$An3(B . ?\x755B) ;; <CJK>
     (?$An4(B . ?\x7572) ;; <CJK>
     (?$An5(B . ?\x7579) ;; <CJK>
     (?$An6(B . ?\x7583) ;; <CJK>
     (?$An7(B . ?\x7F58) ;; <CJK>
     (?$An8(B . ?\x7F61) ;; <CJK>
     (?$An9(B . ?\x7F5F) ;; <CJK>
     (?$An:(B . ?\x8A48) ;; <CJK>
     (?$An;(B . ?\x7F68) ;; <CJK>
     (?$An<(B . ?\x7F74) ;; <CJK>
     (?$An=(B . ?\x7F71) ;; <CJK>
     (?$An>(B . ?\x7F79) ;; <CJK>
     (?$An?(B . ?\x7F81) ;; <CJK>
     (?$An@(B . ?\x7F7E) ;; <CJK>
     (?$AnA(B . ?\x76CD) ;; <CJK>
     (?$AnB(B . ?\x76E5) ;; <CJK>
     (?$AnC(B . ?\x8832) ;; <CJK>
     (?$AnD(B . ?\x9485) ;; <CJK>
     (?$AnE(B . ?\x9486) ;; <CJK>
     (?$AnF(B . ?\x9487) ;; <CJK>
     (?$AnG(B . ?\x948B) ;; <CJK>
     (?$AnH(B . ?\x948A) ;; <CJK>
     (?$AnI(B . ?\x948C) ;; <CJK>
     (?$AnJ(B . ?\x948D) ;; <CJK>
     (?$AnK(B . ?\x948F) ;; <CJK>
     (?$AnL(B . ?\x9490) ;; <CJK>
     (?$AnM(B . ?\x9494) ;; <CJK>
     (?$AnN(B . ?\x9497) ;; <CJK>
     (?$AnO(B . ?\x9495) ;; <CJK>
     (?$AnP(B . ?\x949A) ;; <CJK>
     (?$AnQ(B . ?\x949B) ;; <CJK>
     (?$AnR(B . ?\x949C) ;; <CJK>
     (?$AnS(B . ?\x94A3) ;; <CJK>
     (?$AnT(B . ?\x94A4) ;; <CJK>
     (?$AnU(B . ?\x94AB) ;; <CJK>
     (?$AnV(B . ?\x94AA) ;; <CJK>
     (?$AnW(B . ?\x94AD) ;; <CJK>
     (?$AnX(B . ?\x94AC) ;; <CJK>
     (?$AnY(B . ?\x94AF) ;; <CJK>
     (?$AnZ(B . ?\x94B0) ;; <CJK>
     (?$An[(B . ?\x94B2) ;; <CJK>
     (?$An\(B . ?\x94B4) ;; <CJK>
     (?$An](B . ?\x94B6) ;; <CJK>
     (?$An^(B . ?\x94B7) ;; <CJK>
     (?$An_(B . ?\x94B8) ;; <CJK>
     (?$An`(B . ?\x94B9) ;; <CJK>
     (?$Ana(B . ?\x94BA) ;; <CJK>
     (?$Anb(B . ?\x94BC) ;; <CJK>
     (?$Anc(B . ?\x94BD) ;; <CJK>
     (?$And(B . ?\x94BF) ;; <CJK>
     (?$Ane(B . ?\x94C4) ;; <CJK>
     (?$Anf(B . ?\x94C8) ;; <CJK>
     (?$Ang(B . ?\x94C9) ;; <CJK>
     (?$Anh(B . ?\x94CA) ;; <CJK>
     (?$Ani(B . ?\x94CB) ;; <CJK>
     (?$Anj(B . ?\x94CC) ;; <CJK>
     (?$Ank(B . ?\x94CD) ;; <CJK>
     (?$Anl(B . ?\x94CE) ;; <CJK>
     (?$Anm(B . ?\x94D0) ;; <CJK>
     (?$Ann(B . ?\x94D1) ;; <CJK>
     (?$Ano(B . ?\x94D2) ;; <CJK>
     (?$Anp(B . ?\x94D5) ;; <CJK>
     (?$Anq(B . ?\x94D6) ;; <CJK>
     (?$Anr(B . ?\x94D7) ;; <CJK>
     (?$Ans(B . ?\x94D9) ;; <CJK>
     (?$Ant(B . ?\x94D8) ;; <CJK>
     (?$Anu(B . ?\x94DB) ;; <CJK>
     (?$Anv(B . ?\x94DE) ;; <CJK>
     (?$Anw(B . ?\x94DF) ;; <CJK>
     (?$Anx(B . ?\x94E0) ;; <CJK>
     (?$Any(B . ?\x94E2) ;; <CJK>
     (?$Anz(B . ?\x94E4) ;; <CJK>
     (?$An{(B . ?\x94E5) ;; <CJK>
     (?$An|(B . ?\x94E7) ;; <CJK>
     (?$An}(B . ?\x94E8) ;; <CJK>
     (?$An~(B . ?\x94EA) ;; <CJK>
     (?$Ao!(B . ?\x94E9) ;; <CJK>
     (?$Ao"(B . ?\x94EB) ;; <CJK>
     (?$Ao#(B . ?\x94EE) ;; <CJK>
     (?$Ao$(B . ?\x94EF) ;; <CJK>
     (?$Ao%(B . ?\x94F3) ;; <CJK>
     (?$Ao&(B . ?\x94F4) ;; <CJK>
     (?$Ao'(B . ?\x94F5) ;; <CJK>
     (?$Ao((B . ?\x94F7) ;; <CJK>
     (?$Ao)(B . ?\x94F9) ;; <CJK>
     (?$Ao*(B . ?\x94FC) ;; <CJK>
     (?$Ao+(B . ?\x94FD) ;; <CJK>
     (?$Ao,(B . ?\x94FF) ;; <CJK>
     (?$Ao-(B . ?\x9503) ;; <CJK>
     (?$Ao.(B . ?\x9502) ;; <CJK>
     (?$Ao/(B . ?\x9506) ;; <CJK>
     (?$Ao0(B . ?\x9507) ;; <CJK>
     (?$Ao1(B . ?\x9509) ;; <CJK>
     (?$Ao2(B . ?\x950A) ;; <CJK>
     (?$Ao3(B . ?\x950D) ;; <CJK>
     (?$Ao4(B . ?\x950E) ;; <CJK>
     (?$Ao5(B . ?\x950F) ;; <CJK>
     (?$Ao6(B . ?\x9512) ;; <CJK>
     (?$Ao7(B . ?\x9513) ;; <CJK>
     (?$Ao8(B . ?\x9514) ;; <CJK>
     (?$Ao9(B . ?\x9515) ;; <CJK>
     (?$Ao:(B . ?\x9516) ;; <CJK>
     (?$Ao;(B . ?\x9518) ;; <CJK>
     (?$Ao<(B . ?\x951B) ;; <CJK>
     (?$Ao=(B . ?\x951D) ;; <CJK>
     (?$Ao>(B . ?\x951E) ;; <CJK>
     (?$Ao?(B . ?\x951F) ;; <CJK>
     (?$Ao@(B . ?\x9522) ;; <CJK>
     (?$AoA(B . ?\x952A) ;; <CJK>
     (?$AoB(B . ?\x952B) ;; <CJK>
     (?$AoC(B . ?\x9529) ;; <CJK>
     (?$AoD(B . ?\x952C) ;; <CJK>
     (?$AoE(B . ?\x9531) ;; <CJK>
     (?$AoF(B . ?\x9532) ;; <CJK>
     (?$AoG(B . ?\x9534) ;; <CJK>
     (?$AoH(B . ?\x9536) ;; <CJK>
     (?$AoI(B . ?\x9537) ;; <CJK>
     (?$AoJ(B . ?\x9538) ;; <CJK>
     (?$AoK(B . ?\x953C) ;; <CJK>
     (?$AoL(B . ?\x953E) ;; <CJK>
     (?$AoM(B . ?\x953F) ;; <CJK>
     (?$AoN(B . ?\x9542) ;; <CJK>
     (?$AoO(B . ?\x9535) ;; <CJK>
     (?$AoP(B . ?\x9544) ;; <CJK>
     (?$AoQ(B . ?\x9545) ;; <CJK>
     (?$AoR(B . ?\x9546) ;; <CJK>
     (?$AoS(B . ?\x9549) ;; <CJK>
     (?$AoT(B . ?\x954C) ;; <CJK>
     (?$AoU(B . ?\x954E) ;; <CJK>
     (?$AoV(B . ?\x954F) ;; <CJK>
     (?$AoW(B . ?\x9552) ;; <CJK>
     (?$AoX(B . ?\x9553) ;; <CJK>
     (?$AoY(B . ?\x9554) ;; <CJK>
     (?$AoZ(B . ?\x9556) ;; <CJK>
     (?$Ao[(B . ?\x9557) ;; <CJK>
     (?$Ao\(B . ?\x9558) ;; <CJK>
     (?$Ao](B . ?\x9559) ;; <CJK>
     (?$Ao^(B . ?\x955B) ;; <CJK>
     (?$Ao_(B . ?\x955E) ;; <CJK>
     (?$Ao`(B . ?\x955F) ;; <CJK>
     (?$Aoa(B . ?\x955D) ;; <CJK>
     (?$Aob(B . ?\x9561) ;; <CJK>
     (?$Aoc(B . ?\x9562) ;; <CJK>
     (?$Aod(B . ?\x9564) ;; <CJK>
     (?$Aoe(B . ?\x9565) ;; <CJK>
     (?$Aof(B . ?\x9566) ;; <CJK>
     (?$Aog(B . ?\x9567) ;; <CJK>
     (?$Aoh(B . ?\x9568) ;; <CJK>
     (?$Aoi(B . ?\x9569) ;; <CJK>
     (?$Aoj(B . ?\x956A) ;; <CJK>
     (?$Aok(B . ?\x956B) ;; <CJK>
     (?$Aol(B . ?\x956C) ;; <CJK>
     (?$Aom(B . ?\x956F) ;; <CJK>
     (?$Aon(B . ?\x9571) ;; <CJK>
     (?$Aoo(B . ?\x9572) ;; <CJK>
     (?$Aop(B . ?\x9573) ;; <CJK>
     (?$Aoq(B . ?\x953A) ;; <CJK>
     (?$Aor(B . ?\x77E7) ;; <CJK>
     (?$Aos(B . ?\x77EC) ;; <CJK>
     (?$Aot(B . ?\x96C9) ;; <CJK>
     (?$Aou(B . ?\x79D5) ;; <CJK>
     (?$Aov(B . ?\x79ED) ;; <CJK>
     (?$Aow(B . ?\x79E3) ;; <CJK>
     (?$Aox(B . ?\x79EB) ;; <CJK>
     (?$Aoy(B . ?\x7A06) ;; <CJK>
     (?$Aoz(B . ?\x5D47) ;; <CJK>
     (?$Ao{(B . ?\x7A03) ;; <CJK>
     (?$Ao|(B . ?\x7A02) ;; <CJK>
     (?$Ao}(B . ?\x7A1E) ;; <CJK>
     (?$Ao~(B . ?\x7A14) ;; <CJK>
     (?$Ap!(B . ?\x7A39) ;; <CJK>
     (?$Ap"(B . ?\x7A37) ;; <CJK>
     (?$Ap#(B . ?\x7A51) ;; <CJK>
     (?$Ap$(B . ?\x9ECF) ;; <CJK>
     (?$Ap%(B . ?\x99A5) ;; <CJK>
     (?$Ap&(B . ?\x7A70) ;; <CJK>
     (?$Ap'(B . ?\x7688) ;; <CJK>
     (?$Ap((B . ?\x768E) ;; <CJK>
     (?$Ap)(B . ?\x7693) ;; <CJK>
     (?$Ap*(B . ?\x7699) ;; <CJK>
     (?$Ap+(B . ?\x76A4) ;; <CJK>
     (?$Ap,(B . ?\x74DE) ;; <CJK>
     (?$Ap-(B . ?\x74E0) ;; <CJK>
     (?$Ap.(B . ?\x752C) ;; <CJK>
     (?$Ap/(B . ?\x9E20) ;; <CJK>
     (?$Ap0(B . ?\x9E22) ;; <CJK>
     (?$Ap1(B . ?\x9E28) ;; <CJK>
     (?$Ap2(B . ?\x9E29) ;; <CJK>
     (?$Ap3(B . ?\x9E2A) ;; <CJK>
     (?$Ap4(B . ?\x9E2B) ;; <CJK>
     (?$Ap5(B . ?\x9E2C) ;; <CJK>
     (?$Ap6(B . ?\x9E32) ;; <CJK>
     (?$Ap7(B . ?\x9E31) ;; <CJK>
     (?$Ap8(B . ?\x9E36) ;; <CJK>
     (?$Ap9(B . ?\x9E38) ;; <CJK>
     (?$Ap:(B . ?\x9E37) ;; <CJK>
     (?$Ap;(B . ?\x9E39) ;; <CJK>
     (?$Ap<(B . ?\x9E3A) ;; <CJK>
     (?$Ap=(B . ?\x9E3E) ;; <CJK>
     (?$Ap>(B . ?\x9E41) ;; <CJK>
     (?$Ap?(B . ?\x9E42) ;; <CJK>
     (?$Ap@(B . ?\x9E44) ;; <CJK>
     (?$ApA(B . ?\x9E46) ;; <CJK>
     (?$ApB(B . ?\x9E47) ;; <CJK>
     (?$ApC(B . ?\x9E48) ;; <CJK>
     (?$ApD(B . ?\x9E49) ;; <CJK>
     (?$ApE(B . ?\x9E4B) ;; <CJK>
     (?$ApF(B . ?\x9E4C) ;; <CJK>
     (?$ApG(B . ?\x9E4E) ;; <CJK>
     (?$ApH(B . ?\x9E51) ;; <CJK>
     (?$ApI(B . ?\x9E55) ;; <CJK>
     (?$ApJ(B . ?\x9E57) ;; <CJK>
     (?$ApK(B . ?\x9E5A) ;; <CJK>
     (?$ApL(B . ?\x9E5B) ;; <CJK>
     (?$ApM(B . ?\x9E5C) ;; <CJK>
     (?$ApN(B . ?\x9E5E) ;; <CJK>
     (?$ApO(B . ?\x9E63) ;; <CJK>
     (?$ApP(B . ?\x9E66) ;; <CJK>
     (?$ApQ(B . ?\x9E67) ;; <CJK>
     (?$ApR(B . ?\x9E68) ;; <CJK>
     (?$ApS(B . ?\x9E69) ;; <CJK>
     (?$ApT(B . ?\x9E6A) ;; <CJK>
     (?$ApU(B . ?\x9E6B) ;; <CJK>
     (?$ApV(B . ?\x9E6C) ;; <CJK>
     (?$ApW(B . ?\x9E71) ;; <CJK>
     (?$ApX(B . ?\x9E6D) ;; <CJK>
     (?$ApY(B . ?\x9E73) ;; <CJK>
     (?$ApZ(B . ?\x7592) ;; <CJK>
     (?$Ap[(B . ?\x7594) ;; <CJK>
     (?$Ap\(B . ?\x7596) ;; <CJK>
     (?$Ap](B . ?\x75A0) ;; <CJK>
     (?$Ap^(B . ?\x759D) ;; <CJK>
     (?$Ap_(B . ?\x75AC) ;; <CJK>
     (?$Ap`(B . ?\x75A3) ;; <CJK>
     (?$Apa(B . ?\x75B3) ;; <CJK>
     (?$Apb(B . ?\x75B4) ;; <CJK>
     (?$Apc(B . ?\x75B8) ;; <CJK>
     (?$Apd(B . ?\x75C4) ;; <CJK>
     (?$Ape(B . ?\x75B1) ;; <CJK>
     (?$Apf(B . ?\x75B0) ;; <CJK>
     (?$Apg(B . ?\x75C3) ;; <CJK>
     (?$Aph(B . ?\x75C2) ;; <CJK>
     (?$Api(B . ?\x75D6) ;; <CJK>
     (?$Apj(B . ?\x75CD) ;; <CJK>
     (?$Apk(B . ?\x75E3) ;; <CJK>
     (?$Apl(B . ?\x75E8) ;; <CJK>
     (?$Apm(B . ?\x75E6) ;; <CJK>
     (?$Apn(B . ?\x75E4) ;; <CJK>
     (?$Apo(B . ?\x75EB) ;; <CJK>
     (?$App(B . ?\x75E7) ;; <CJK>
     (?$Apq(B . ?\x7603) ;; <CJK>
     (?$Apr(B . ?\x75F1) ;; <CJK>
     (?$Aps(B . ?\x75FC) ;; <CJK>
     (?$Apt(B . ?\x75FF) ;; <CJK>
     (?$Apu(B . ?\x7610) ;; <CJK>
     (?$Apv(B . ?\x7600) ;; <CJK>
     (?$Apw(B . ?\x7605) ;; <CJK>
     (?$Apx(B . ?\x760C) ;; <CJK>
     (?$Apy(B . ?\x7617) ;; <CJK>
     (?$Apz(B . ?\x760A) ;; <CJK>
     (?$Ap{(B . ?\x7625) ;; <CJK>
     (?$Ap|(B . ?\x7618) ;; <CJK>
     (?$Ap}(B . ?\x7615) ;; <CJK>
     (?$Ap~(B . ?\x7619) ;; <CJK>
     (?$Aq!(B . ?\x761B) ;; <CJK>
     (?$Aq"(B . ?\x763C) ;; <CJK>
     (?$Aq#(B . ?\x7622) ;; <CJK>
     (?$Aq$(B . ?\x7620) ;; <CJK>
     (?$Aq%(B . ?\x7640) ;; <CJK>
     (?$Aq&(B . ?\x762D) ;; <CJK>
     (?$Aq'(B . ?\x7630) ;; <CJK>
     (?$Aq((B . ?\x763F) ;; <CJK>
     (?$Aq)(B . ?\x7635) ;; <CJK>
     (?$Aq*(B . ?\x7643) ;; <CJK>
     (?$Aq+(B . ?\x763E) ;; <CJK>
     (?$Aq,(B . ?\x7633) ;; <CJK>
     (?$Aq-(B . ?\x764D) ;; <CJK>
     (?$Aq.(B . ?\x765E) ;; <CJK>
     (?$Aq/(B . ?\x7654) ;; <CJK>
     (?$Aq0(B . ?\x765C) ;; <CJK>
     (?$Aq1(B . ?\x7656) ;; <CJK>
     (?$Aq2(B . ?\x766B) ;; <CJK>
     (?$Aq3(B . ?\x766F) ;; <CJK>
     (?$Aq4(B . ?\x7FCA) ;; <CJK>
     (?$Aq5(B . ?\x7AE6) ;; <CJK>
     (?$Aq6(B . ?\x7A78) ;; <CJK>
     (?$Aq7(B . ?\x7A79) ;; <CJK>
     (?$Aq8(B . ?\x7A80) ;; <CJK>
     (?$Aq9(B . ?\x7A86) ;; <CJK>
     (?$Aq:(B . ?\x7A88) ;; <CJK>
     (?$Aq;(B . ?\x7A95) ;; <CJK>
     (?$Aq<(B . ?\x7AA6) ;; <CJK>
     (?$Aq=(B . ?\x7AA0) ;; <CJK>
     (?$Aq>(B . ?\x7AAC) ;; <CJK>
     (?$Aq?(B . ?\x7AA8) ;; <CJK>
     (?$Aq@(B . ?\x7AAD) ;; <CJK>
     (?$AqA(B . ?\x7AB3) ;; <CJK>
     (?$AqB(B . ?\x8864) ;; <CJK>
     (?$AqC(B . ?\x8869) ;; <CJK>
     (?$AqD(B . ?\x8872) ;; <CJK>
     (?$AqE(B . ?\x887D) ;; <CJK>
     (?$AqF(B . ?\x887F) ;; <CJK>
     (?$AqG(B . ?\x8882) ;; <CJK>
     (?$AqH(B . ?\x88A2) ;; <CJK>
     (?$AqI(B . ?\x88C6) ;; <CJK>
     (?$AqJ(B . ?\x88B7) ;; <CJK>
     (?$AqK(B . ?\x88BC) ;; <CJK>
     (?$AqL(B . ?\x88C9) ;; <CJK>
     (?$AqM(B . ?\x88E2) ;; <CJK>
     (?$AqN(B . ?\x88CE) ;; <CJK>
     (?$AqO(B . ?\x88E3) ;; <CJK>
     (?$AqP(B . ?\x88E5) ;; <CJK>
     (?$AqQ(B . ?\x88F1) ;; <CJK>
     (?$AqR(B . ?\x891A) ;; <CJK>
     (?$AqS(B . ?\x88FC) ;; <CJK>
     (?$AqT(B . ?\x88E8) ;; <CJK>
     (?$AqU(B . ?\x88FE) ;; <CJK>
     (?$AqV(B . ?\x88F0) ;; <CJK>
     (?$AqW(B . ?\x8921) ;; <CJK>
     (?$AqX(B . ?\x8919) ;; <CJK>
     (?$AqY(B . ?\x8913) ;; <CJK>
     (?$AqZ(B . ?\x891B) ;; <CJK>
     (?$Aq[(B . ?\x890A) ;; <CJK>
     (?$Aq\(B . ?\x8934) ;; <CJK>
     (?$Aq](B . ?\x892B) ;; <CJK>
     (?$Aq^(B . ?\x8936) ;; <CJK>
     (?$Aq_(B . ?\x8941) ;; <CJK>
     (?$Aq`(B . ?\x8966) ;; <CJK>
     (?$Aqa(B . ?\x897B) ;; <CJK>
     (?$Aqb(B . ?\x758B) ;; <CJK>
     (?$Aqc(B . ?\x80E5) ;; <CJK>
     (?$Aqd(B . ?\x76B2) ;; <CJK>
     (?$Aqe(B . ?\x76B4) ;; <CJK>
     (?$Aqf(B . ?\x77DC) ;; <CJK>
     (?$Aqg(B . ?\x8012) ;; <CJK>
     (?$Aqh(B . ?\x8014) ;; <CJK>
     (?$Aqi(B . ?\x8016) ;; <CJK>
     (?$Aqj(B . ?\x801C) ;; <CJK>
     (?$Aqk(B . ?\x8020) ;; <CJK>
     (?$Aql(B . ?\x8022) ;; <CJK>
     (?$Aqm(B . ?\x8025) ;; <CJK>
     (?$Aqn(B . ?\x8026) ;; <CJK>
     (?$Aqo(B . ?\x8027) ;; <CJK>
     (?$Aqp(B . ?\x8029) ;; <CJK>
     (?$Aqq(B . ?\x8028) ;; <CJK>
     (?$Aqr(B . ?\x8031) ;; <CJK>
     (?$Aqs(B . ?\x800B) ;; <CJK>
     (?$Aqt(B . ?\x8035) ;; <CJK>
     (?$Aqu(B . ?\x8043) ;; <CJK>
     (?$Aqv(B . ?\x8046) ;; <CJK>
     (?$Aqw(B . ?\x804D) ;; <CJK>
     (?$Aqx(B . ?\x8052) ;; <CJK>
     (?$Aqy(B . ?\x8069) ;; <CJK>
     (?$Aqz(B . ?\x8071) ;; <CJK>
     (?$Aq{(B . ?\x8983) ;; <CJK>
     (?$Aq|(B . ?\x9878) ;; <CJK>
     (?$Aq}(B . ?\x9880) ;; <CJK>
     (?$Aq~(B . ?\x9883) ;; <CJK>
     (?$Ar!(B . ?\x9889) ;; <CJK>
     (?$Ar"(B . ?\x988C) ;; <CJK>
     (?$Ar#(B . ?\x988D) ;; <CJK>
     (?$Ar$(B . ?\x988F) ;; <CJK>
     (?$Ar%(B . ?\x9894) ;; <CJK>
     (?$Ar&(B . ?\x989A) ;; <CJK>
     (?$Ar'(B . ?\x989B) ;; <CJK>
     (?$Ar((B . ?\x989E) ;; <CJK>
     (?$Ar)(B . ?\x989F) ;; <CJK>
     (?$Ar*(B . ?\x98A1) ;; <CJK>
     (?$Ar+(B . ?\x98A2) ;; <CJK>
     (?$Ar,(B . ?\x98A5) ;; <CJK>
     (?$Ar-(B . ?\x98A6) ;; <CJK>
     (?$Ar.(B . ?\x864D) ;; <CJK>
     (?$Ar/(B . ?\x8654) ;; <CJK>
     (?$Ar0(B . ?\x866C) ;; <CJK>
     (?$Ar1(B . ?\x866E) ;; <CJK>
     (?$Ar2(B . ?\x867F) ;; <CJK>
     (?$Ar3(B . ?\x867A) ;; <CJK>
     (?$Ar4(B . ?\x867C) ;; <CJK>
     (?$Ar5(B . ?\x867B) ;; <CJK>
     (?$Ar6(B . ?\x86A8) ;; <CJK>
     (?$Ar7(B . ?\x868D) ;; <CJK>
     (?$Ar8(B . ?\x868B) ;; <CJK>
     (?$Ar9(B . ?\x86AC) ;; <CJK>
     (?$Ar:(B . ?\x869D) ;; <CJK>
     (?$Ar;(B . ?\x86A7) ;; <CJK>
     (?$Ar<(B . ?\x86A3) ;; <CJK>
     (?$Ar=(B . ?\x86AA) ;; <CJK>
     (?$Ar>(B . ?\x8693) ;; <CJK>
     (?$Ar?(B . ?\x86A9) ;; <CJK>
     (?$Ar@(B . ?\x86B6) ;; <CJK>
     (?$ArA(B . ?\x86C4) ;; <CJK>
     (?$ArB(B . ?\x86B5) ;; <CJK>
     (?$ArC(B . ?\x86CE) ;; <CJK>
     (?$ArD(B . ?\x86B0) ;; <CJK>
     (?$ArE(B . ?\x86BA) ;; <CJK>
     (?$ArF(B . ?\x86B1) ;; <CJK>
     (?$ArG(B . ?\x86AF) ;; <CJK>
     (?$ArH(B . ?\x86C9) ;; <CJK>
     (?$ArI(B . ?\x86CF) ;; <CJK>
     (?$ArJ(B . ?\x86B4) ;; <CJK>
     (?$ArK(B . ?\x86E9) ;; <CJK>
     (?$ArL(B . ?\x86F1) ;; <CJK>
     (?$ArM(B . ?\x86F2) ;; <CJK>
     (?$ArN(B . ?\x86ED) ;; <CJK>
     (?$ArO(B . ?\x86F3) ;; <CJK>
     (?$ArP(B . ?\x86D0) ;; <CJK>
     (?$ArQ(B . ?\x8713) ;; <CJK>
     (?$ArR(B . ?\x86DE) ;; <CJK>
     (?$ArS(B . ?\x86F4) ;; <CJK>
     (?$ArT(B . ?\x86DF) ;; <CJK>
     (?$ArU(B . ?\x86D8) ;; <CJK>
     (?$ArV(B . ?\x86D1) ;; <CJK>
     (?$ArW(B . ?\x8703) ;; <CJK>
     (?$ArX(B . ?\x8707) ;; <CJK>
     (?$ArY(B . ?\x86F8) ;; <CJK>
     (?$ArZ(B . ?\x8708) ;; <CJK>
     (?$Ar[(B . ?\x870A) ;; <CJK>
     (?$Ar\(B . ?\x870D) ;; <CJK>
     (?$Ar](B . ?\x8709) ;; <CJK>
     (?$Ar^(B . ?\x8723) ;; <CJK>
     (?$Ar_(B . ?\x873B) ;; <CJK>
     (?$Ar`(B . ?\x871E) ;; <CJK>
     (?$Ara(B . ?\x8725) ;; <CJK>
     (?$Arb(B . ?\x872E) ;; <CJK>
     (?$Arc(B . ?\x871A) ;; <CJK>
     (?$Ard(B . ?\x873E) ;; <CJK>
     (?$Are(B . ?\x8748) ;; <CJK>
     (?$Arf(B . ?\x8734) ;; <CJK>
     (?$Arg(B . ?\x8731) ;; <CJK>
     (?$Arh(B . ?\x8729) ;; <CJK>
     (?$Ari(B . ?\x8737) ;; <CJK>
     (?$Arj(B . ?\x873F) ;; <CJK>
     (?$Ark(B . ?\x8782) ;; <CJK>
     (?$Arl(B . ?\x8722) ;; <CJK>
     (?$Arm(B . ?\x877D) ;; <CJK>
     (?$Arn(B . ?\x877E) ;; <CJK>
     (?$Aro(B . ?\x877B) ;; <CJK>
     (?$Arp(B . ?\x8760) ;; <CJK>
     (?$Arq(B . ?\x8770) ;; <CJK>
     (?$Arr(B . ?\x874C) ;; <CJK>
     (?$Ars(B . ?\x876E) ;; <CJK>
     (?$Art(B . ?\x878B) ;; <CJK>
     (?$Aru(B . ?\x8753) ;; <CJK>
     (?$Arv(B . ?\x8763) ;; <CJK>
     (?$Arw(B . ?\x877C) ;; <CJK>
     (?$Arx(B . ?\x8764) ;; <CJK>
     (?$Ary(B . ?\x8759) ;; <CJK>
     (?$Arz(B . ?\x8765) ;; <CJK>
     (?$Ar{(B . ?\x8793) ;; <CJK>
     (?$Ar|(B . ?\x87AF) ;; <CJK>
     (?$Ar}(B . ?\x87A8) ;; <CJK>
     (?$Ar~(B . ?\x87D2) ;; <CJK>
     (?$As!(B . ?\x87C6) ;; <CJK>
     (?$As"(B . ?\x8788) ;; <CJK>
     (?$As#(B . ?\x8785) ;; <CJK>
     (?$As$(B . ?\x87AD) ;; <CJK>
     (?$As%(B . ?\x8797) ;; <CJK>
     (?$As&(B . ?\x8783) ;; <CJK>
     (?$As'(B . ?\x87AB) ;; <CJK>
     (?$As((B . ?\x87E5) ;; <CJK>
     (?$As)(B . ?\x87AC) ;; <CJK>
     (?$As*(B . ?\x87B5) ;; <CJK>
     (?$As+(B . ?\x87B3) ;; <CJK>
     (?$As,(B . ?\x87CB) ;; <CJK>
     (?$As-(B . ?\x87D3) ;; <CJK>
     (?$As.(B . ?\x87BD) ;; <CJK>
     (?$As/(B . ?\x87D1) ;; <CJK>
     (?$As0(B . ?\x87C0) ;; <CJK>
     (?$As1(B . ?\x87CA) ;; <CJK>
     (?$As2(B . ?\x87DB) ;; <CJK>
     (?$As3(B . ?\x87EA) ;; <CJK>
     (?$As4(B . ?\x87E0) ;; <CJK>
     (?$As5(B . ?\x87EE) ;; <CJK>
     (?$As6(B . ?\x8816) ;; <CJK>
     (?$As7(B . ?\x8813) ;; <CJK>
     (?$As8(B . ?\x87FE) ;; <CJK>
     (?$As9(B . ?\x880A) ;; <CJK>
     (?$As:(B . ?\x881B) ;; <CJK>
     (?$As;(B . ?\x8821) ;; <CJK>
     (?$As<(B . ?\x8839) ;; <CJK>
     (?$As=(B . ?\x883C) ;; <CJK>
     (?$As>(B . ?\x7F36) ;; <CJK>
     (?$As?(B . ?\x7F42) ;; <CJK>
     (?$As@(B . ?\x7F44) ;; <CJK>
     (?$AsA(B . ?\x7F45) ;; <CJK>
     (?$AsB(B . ?\x8210) ;; <CJK>
     (?$AsC(B . ?\x7AFA) ;; <CJK>
     (?$AsD(B . ?\x7AFD) ;; <CJK>
     (?$AsE(B . ?\x7B08) ;; <CJK>
     (?$AsF(B . ?\x7B03) ;; <CJK>
     (?$AsG(B . ?\x7B04) ;; <CJK>
     (?$AsH(B . ?\x7B15) ;; <CJK>
     (?$AsI(B . ?\x7B0A) ;; <CJK>
     (?$AsJ(B . ?\x7B2B) ;; <CJK>
     (?$AsK(B . ?\x7B0F) ;; <CJK>
     (?$AsL(B . ?\x7B47) ;; <CJK>
     (?$AsM(B . ?\x7B38) ;; <CJK>
     (?$AsN(B . ?\x7B2A) ;; <CJK>
     (?$AsO(B . ?\x7B19) ;; <CJK>
     (?$AsP(B . ?\x7B2E) ;; <CJK>
     (?$AsQ(B . ?\x7B31) ;; <CJK>
     (?$AsR(B . ?\x7B20) ;; <CJK>
     (?$AsS(B . ?\x7B25) ;; <CJK>
     (?$AsT(B . ?\x7B24) ;; <CJK>
     (?$AsU(B . ?\x7B33) ;; <CJK>
     (?$AsV(B . ?\x7B3E) ;; <CJK>
     (?$AsW(B . ?\x7B1E) ;; <CJK>
     (?$AsX(B . ?\x7B58) ;; <CJK>
     (?$AsY(B . ?\x7B5A) ;; <CJK>
     (?$AsZ(B . ?\x7B45) ;; <CJK>
     (?$As[(B . ?\x7B75) ;; <CJK>
     (?$As\(B . ?\x7B4C) ;; <CJK>
     (?$As](B . ?\x7B5D) ;; <CJK>
     (?$As^(B . ?\x7B60) ;; <CJK>
     (?$As_(B . ?\x7B6E) ;; <CJK>
     (?$As`(B . ?\x7B7B) ;; <CJK>
     (?$Asa(B . ?\x7B62) ;; <CJK>
     (?$Asb(B . ?\x7B72) ;; <CJK>
     (?$Asc(B . ?\x7B71) ;; <CJK>
     (?$Asd(B . ?\x7B90) ;; <CJK>
     (?$Ase(B . ?\x7BA6) ;; <CJK>
     (?$Asf(B . ?\x7BA7) ;; <CJK>
     (?$Asg(B . ?\x7BB8) ;; <CJK>
     (?$Ash(B . ?\x7BAC) ;; <CJK>
     (?$Asi(B . ?\x7B9D) ;; <CJK>
     (?$Asj(B . ?\x7BA8) ;; <CJK>
     (?$Ask(B . ?\x7B85) ;; <CJK>
     (?$Asl(B . ?\x7BAA) ;; <CJK>
     (?$Asm(B . ?\x7B9C) ;; <CJK>
     (?$Asn(B . ?\x7BA2) ;; <CJK>
     (?$Aso(B . ?\x7BAB) ;; <CJK>
     (?$Asp(B . ?\x7BB4) ;; <CJK>
     (?$Asq(B . ?\x7BD1) ;; <CJK>
     (?$Asr(B . ?\x7BC1) ;; <CJK>
     (?$Ass(B . ?\x7BCC) ;; <CJK>
     (?$Ast(B . ?\x7BDD) ;; <CJK>
     (?$Asu(B . ?\x7BDA) ;; <CJK>
     (?$Asv(B . ?\x7BE5) ;; <CJK>
     (?$Asw(B . ?\x7BE6) ;; <CJK>
     (?$Asx(B . ?\x7BEA) ;; <CJK>
     (?$Asy(B . ?\x7C0C) ;; <CJK>
     (?$Asz(B . ?\x7BFE) ;; <CJK>
     (?$As{(B . ?\x7BFC) ;; <CJK>
     (?$As|(B . ?\x7C0F) ;; <CJK>
     (?$As}(B . ?\x7C16) ;; <CJK>
     (?$As~(B . ?\x7C0B) ;; <CJK>
     (?$At!(B . ?\x7C1F) ;; <CJK>
     (?$At"(B . ?\x7C2A) ;; <CJK>
     (?$At#(B . ?\x7C26) ;; <CJK>
     (?$At$(B . ?\x7C38) ;; <CJK>
     (?$At%(B . ?\x7C41) ;; <CJK>
     (?$At&(B . ?\x7C40) ;; <CJK>
     (?$At'(B . ?\x81FE) ;; <CJK>
     (?$At((B . ?\x8201) ;; <CJK>
     (?$At)(B . ?\x8202) ;; <CJK>
     (?$At*(B . ?\x8204) ;; <CJK>
     (?$At+(B . ?\x81EC) ;; <CJK>
     (?$At,(B . ?\x8844) ;; <CJK>
     (?$At-(B . ?\x8221) ;; <CJK>
     (?$At.(B . ?\x8222) ;; <CJK>
     (?$At/(B . ?\x8223) ;; <CJK>
     (?$At0(B . ?\x822D) ;; <CJK>
     (?$At1(B . ?\x822F) ;; <CJK>
     (?$At2(B . ?\x8228) ;; <CJK>
     (?$At3(B . ?\x822B) ;; <CJK>
     (?$At4(B . ?\x8238) ;; <CJK>
     (?$At5(B . ?\x823B) ;; <CJK>
     (?$At6(B . ?\x8233) ;; <CJK>
     (?$At7(B . ?\x8234) ;; <CJK>
     (?$At8(B . ?\x823E) ;; <CJK>
     (?$At9(B . ?\x8244) ;; <CJK>
     (?$At:(B . ?\x8249) ;; <CJK>
     (?$At;(B . ?\x824B) ;; <CJK>
     (?$At<(B . ?\x824F) ;; <CJK>
     (?$At=(B . ?\x825A) ;; <CJK>
     (?$At>(B . ?\x825F) ;; <CJK>
     (?$At?(B . ?\x8268) ;; <CJK>
     (?$At@(B . ?\x887E) ;; <CJK>
     (?$AtA(B . ?\x8885) ;; <CJK>
     (?$AtB(B . ?\x8888) ;; <CJK>
     (?$AtC(B . ?\x88D8) ;; <CJK>
     (?$AtD(B . ?\x88DF) ;; <CJK>
     (?$AtE(B . ?\x895E) ;; <CJK>
     (?$AtF(B . ?\x7F9D) ;; <CJK>
     (?$AtG(B . ?\x7F9F) ;; <CJK>
     (?$AtH(B . ?\x7FA7) ;; <CJK>
     (?$AtI(B . ?\x7FAF) ;; <CJK>
     (?$AtJ(B . ?\x7FB0) ;; <CJK>
     (?$AtK(B . ?\x7FB2) ;; <CJK>
     (?$AtL(B . ?\x7C7C) ;; <CJK>
     (?$AtM(B . ?\x6549) ;; <CJK>
     (?$AtN(B . ?\x7C91) ;; <CJK>
     (?$AtO(B . ?\x7C9D) ;; <CJK>
     (?$AtP(B . ?\x7C9C) ;; <CJK>
     (?$AtQ(B . ?\x7C9E) ;; <CJK>
     (?$AtR(B . ?\x7CA2) ;; <CJK>
     (?$AtS(B . ?\x7CB2) ;; <CJK>
     (?$AtT(B . ?\x7CBC) ;; <CJK>
     (?$AtU(B . ?\x7CBD) ;; <CJK>
     (?$AtV(B . ?\x7CC1) ;; <CJK>
     (?$AtW(B . ?\x7CC7) ;; <CJK>
     (?$AtX(B . ?\x7CCC) ;; <CJK>
     (?$AtY(B . ?\x7CCD) ;; <CJK>
     (?$AtZ(B . ?\x7CC8) ;; <CJK>
     (?$At[(B . ?\x7CC5) ;; <CJK>
     (?$At\(B . ?\x7CD7) ;; <CJK>
     (?$At](B . ?\x7CE8) ;; <CJK>
     (?$At^(B . ?\x826E) ;; <CJK>
     (?$At_(B . ?\x66A8) ;; <CJK>
     (?$At`(B . ?\x7FBF) ;; <CJK>
     (?$Ata(B . ?\x7FCE) ;; <CJK>
     (?$Atb(B . ?\x7FD5) ;; <CJK>
     (?$Atc(B . ?\x7FE5) ;; <CJK>
     (?$Atd(B . ?\x7FE1) ;; <CJK>
     (?$Ate(B . ?\x7FE6) ;; <CJK>
     (?$Atf(B . ?\x7FE9) ;; <CJK>
     (?$Atg(B . ?\x7FEE) ;; <CJK>
     (?$Ath(B . ?\x7FF3) ;; <CJK>
     (?$Ati(B . ?\x7CF8) ;; <CJK>
     (?$Atj(B . ?\x7D77) ;; <CJK>
     (?$Atk(B . ?\x7DA6) ;; <CJK>
     (?$Atl(B . ?\x7DAE) ;; <CJK>
     (?$Atm(B . ?\x7E47) ;; <CJK>
     (?$Atn(B . ?\x7E9B) ;; <CJK>
     (?$Ato(B . ?\x9EB8) ;; <CJK>
     (?$Atp(B . ?\x9EB4) ;; <CJK>
     (?$Atq(B . ?\x8D73) ;; <CJK>
     (?$Atr(B . ?\x8D84) ;; <CJK>
     (?$Ats(B . ?\x8D94) ;; <CJK>
     (?$Att(B . ?\x8D91) ;; <CJK>
     (?$Atu(B . ?\x8DB1) ;; <CJK>
     (?$Atv(B . ?\x8D67) ;; <CJK>
     (?$Atw(B . ?\x8D6D) ;; <CJK>
     (?$Atx(B . ?\x8C47) ;; <CJK>
     (?$Aty(B . ?\x8C49) ;; <CJK>
     (?$Atz(B . ?\x914A) ;; <CJK>
     (?$At{(B . ?\x9150) ;; <CJK>
     (?$At|(B . ?\x914E) ;; <CJK>
     (?$At}(B . ?\x914F) ;; <CJK>
     (?$At~(B . ?\x9164) ;; <CJK>
     (?$Au!(B . ?\x9162) ;; <CJK>
     (?$Au"(B . ?\x9161) ;; <CJK>
     (?$Au#(B . ?\x9170) ;; <CJK>
     (?$Au$(B . ?\x9169) ;; <CJK>
     (?$Au%(B . ?\x916F) ;; <CJK>
     (?$Au&(B . ?\x917D) ;; <CJK>
     (?$Au'(B . ?\x917E) ;; <CJK>
     (?$Au((B . ?\x9172) ;; <CJK>
     (?$Au)(B . ?\x9174) ;; <CJK>
     (?$Au*(B . ?\x9179) ;; <CJK>
     (?$Au+(B . ?\x918C) ;; <CJK>
     (?$Au,(B . ?\x9185) ;; <CJK>
     (?$Au-(B . ?\x9190) ;; <CJK>
     (?$Au.(B . ?\x918D) ;; <CJK>
     (?$Au/(B . ?\x9191) ;; <CJK>
     (?$Au0(B . ?\x91A2) ;; <CJK>
     (?$Au1(B . ?\x91A3) ;; <CJK>
     (?$Au2(B . ?\x91AA) ;; <CJK>
     (?$Au3(B . ?\x91AD) ;; <CJK>
     (?$Au4(B . ?\x91AE) ;; <CJK>
     (?$Au5(B . ?\x91AF) ;; <CJK>
     (?$Au6(B . ?\x91B5) ;; <CJK>
     (?$Au7(B . ?\x91B4) ;; <CJK>
     (?$Au8(B . ?\x91BA) ;; <CJK>
     (?$Au9(B . ?\x8C55) ;; <CJK>
     (?$Au:(B . ?\x9E7E) ;; <CJK>
     (?$Au;(B . ?\x8DB8) ;; <CJK>
     (?$Au<(B . ?\x8DEB) ;; <CJK>
     (?$Au=(B . ?\x8E05) ;; <CJK>
     (?$Au>(B . ?\x8E59) ;; <CJK>
     (?$Au?(B . ?\x8E69) ;; <CJK>
     (?$Au@(B . ?\x8DB5) ;; <CJK>
     (?$AuA(B . ?\x8DBF) ;; <CJK>
     (?$AuB(B . ?\x8DBC) ;; <CJK>
     (?$AuC(B . ?\x8DBA) ;; <CJK>
     (?$AuD(B . ?\x8DC4) ;; <CJK>
     (?$AuE(B . ?\x8DD6) ;; <CJK>
     (?$AuF(B . ?\x8DD7) ;; <CJK>
     (?$AuG(B . ?\x8DDA) ;; <CJK>
     (?$AuH(B . ?\x8DDE) ;; <CJK>
     (?$AuI(B . ?\x8DCE) ;; <CJK>
     (?$AuJ(B . ?\x8DCF) ;; <CJK>
     (?$AuK(B . ?\x8DDB) ;; <CJK>
     (?$AuL(B . ?\x8DC6) ;; <CJK>
     (?$AuM(B . ?\x8DEC) ;; <CJK>
     (?$AuN(B . ?\x8DF7) ;; <CJK>
     (?$AuO(B . ?\x8DF8) ;; <CJK>
     (?$AuP(B . ?\x8DE3) ;; <CJK>
     (?$AuQ(B . ?\x8DF9) ;; <CJK>
     (?$AuR(B . ?\x8DFB) ;; <CJK>
     (?$AuS(B . ?\x8DE4) ;; <CJK>
     (?$AuT(B . ?\x8E09) ;; <CJK>
     (?$AuU(B . ?\x8DFD) ;; <CJK>
     (?$AuV(B . ?\x8E14) ;; <CJK>
     (?$AuW(B . ?\x8E1D) ;; <CJK>
     (?$AuX(B . ?\x8E1F) ;; <CJK>
     (?$AuY(B . ?\x8E2C) ;; <CJK>
     (?$AuZ(B . ?\x8E2E) ;; <CJK>
     (?$Au[(B . ?\x8E23) ;; <CJK>
     (?$Au\(B . ?\x8E2F) ;; <CJK>
     (?$Au](B . ?\x8E3A) ;; <CJK>
     (?$Au^(B . ?\x8E40) ;; <CJK>
     (?$Au_(B . ?\x8E39) ;; <CJK>
     (?$Au`(B . ?\x8E35) ;; <CJK>
     (?$Aua(B . ?\x8E3D) ;; <CJK>
     (?$Aub(B . ?\x8E31) ;; <CJK>
     (?$Auc(B . ?\x8E49) ;; <CJK>
     (?$Aud(B . ?\x8E41) ;; <CJK>
     (?$Aue(B . ?\x8E42) ;; <CJK>
     (?$Auf(B . ?\x8E51) ;; <CJK>
     (?$Aug(B . ?\x8E52) ;; <CJK>
     (?$Auh(B . ?\x8E4A) ;; <CJK>
     (?$Aui(B . ?\x8E70) ;; <CJK>
     (?$Auj(B . ?\x8E76) ;; <CJK>
     (?$Auk(B . ?\x8E7C) ;; <CJK>
     (?$Aul(B . ?\x8E6F) ;; <CJK>
     (?$Aum(B . ?\x8E74) ;; <CJK>
     (?$Aun(B . ?\x8E85) ;; <CJK>
     (?$Auo(B . ?\x8E8F) ;; <CJK>
     (?$Aup(B . ?\x8E94) ;; <CJK>
     (?$Auq(B . ?\x8E90) ;; <CJK>
     (?$Aur(B . ?\x8E9C) ;; <CJK>
     (?$Aus(B . ?\x8E9E) ;; <CJK>
     (?$Aut(B . ?\x8C78) ;; <CJK>
     (?$Auu(B . ?\x8C82) ;; <CJK>
     (?$Auv(B . ?\x8C8A) ;; <CJK>
     (?$Auw(B . ?\x8C85) ;; <CJK>
     (?$Aux(B . ?\x8C98) ;; <CJK>
     (?$Auy(B . ?\x8C94) ;; <CJK>
     (?$Auz(B . ?\x659B) ;; <CJK>
     (?$Au{(B . ?\x89D6) ;; <CJK>
     (?$Au|(B . ?\x89DE) ;; <CJK>
     (?$Au}(B . ?\x89DA) ;; <CJK>
     (?$Au~(B . ?\x89DC) ;; <CJK>
     (?$Av!(B . ?\x89E5) ;; <CJK>
     (?$Av"(B . ?\x89EB) ;; <CJK>
     (?$Av#(B . ?\x89EF) ;; <CJK>
     (?$Av$(B . ?\x8A3E) ;; <CJK>
     (?$Av%(B . ?\x8B26) ;; <CJK>
     (?$Av&(B . ?\x9753) ;; <CJK>
     (?$Av'(B . ?\x96E9) ;; <CJK>
     (?$Av((B . ?\x96F3) ;; <CJK>
     (?$Av)(B . ?\x96EF) ;; <CJK>
     (?$Av*(B . ?\x9706) ;; <CJK>
     (?$Av+(B . ?\x9701) ;; <CJK>
     (?$Av,(B . ?\x9708) ;; <CJK>
     (?$Av-(B . ?\x970F) ;; <CJK>
     (?$Av.(B . ?\x970E) ;; <CJK>
     (?$Av/(B . ?\x972A) ;; <CJK>
     (?$Av0(B . ?\x972D) ;; <CJK>
     (?$Av1(B . ?\x9730) ;; <CJK>
     (?$Av2(B . ?\x973E) ;; <CJK>
     (?$Av3(B . ?\x9F80) ;; <CJK>
     (?$Av4(B . ?\x9F83) ;; <CJK>
     (?$Av5(B . ?\x9F85) ;; <CJK>
     (?$Av6(B . ?\x9F86) ;; <CJK>
     (?$Av7(B . ?\x9F87) ;; <CJK>
     (?$Av8(B . ?\x9F88) ;; <CJK>
     (?$Av9(B . ?\x9F89) ;; <CJK>
     (?$Av:(B . ?\x9F8A) ;; <CJK>
     (?$Av;(B . ?\x9F8C) ;; <CJK>
     (?$Av<(B . ?\x9EFE) ;; <CJK>
     (?$Av=(B . ?\x9F0B) ;; <CJK>
     (?$Av>(B . ?\x9F0D) ;; <CJK>
     (?$Av?(B . ?\x96B9) ;; <CJK>
     (?$Av@(B . ?\x96BC) ;; <CJK>
     (?$AvA(B . ?\x96BD) ;; <CJK>
     (?$AvB(B . ?\x96CE) ;; <CJK>
     (?$AvC(B . ?\x96D2) ;; <CJK>
     (?$AvD(B . ?\x77BF) ;; <CJK>
     (?$AvE(B . ?\x96E0) ;; <CJK>
     (?$AvF(B . ?\x928E) ;; <CJK>
     (?$AvG(B . ?\x92AE) ;; <CJK>
     (?$AvH(B . ?\x92C8) ;; <CJK>
     (?$AvI(B . ?\x933E) ;; <CJK>
     (?$AvJ(B . ?\x936A) ;; <CJK>
     (?$AvK(B . ?\x93CA) ;; <CJK>
     (?$AvL(B . ?\x938F) ;; <CJK>
     (?$AvM(B . ?\x943E) ;; <CJK>
     (?$AvN(B . ?\x946B) ;; <CJK>
     (?$AvO(B . ?\x9C7F) ;; <CJK>
     (?$AvP(B . ?\x9C82) ;; <CJK>
     (?$AvQ(B . ?\x9C85) ;; <CJK>
     (?$AvR(B . ?\x9C86) ;; <CJK>
     (?$AvS(B . ?\x9C87) ;; <CJK>
     (?$AvT(B . ?\x9C88) ;; <CJK>
     (?$AvU(B . ?\x7A23) ;; <CJK>
     (?$AvV(B . ?\x9C8B) ;; <CJK>
     (?$AvW(B . ?\x9C8E) ;; <CJK>
     (?$AvX(B . ?\x9C90) ;; <CJK>
     (?$AvY(B . ?\x9C91) ;; <CJK>
     (?$AvZ(B . ?\x9C92) ;; <CJK>
     (?$Av[(B . ?\x9C94) ;; <CJK>
     (?$Av\(B . ?\x9C95) ;; <CJK>
     (?$Av](B . ?\x9C9A) ;; <CJK>
     (?$Av^(B . ?\x9C9B) ;; <CJK>
     (?$Av_(B . ?\x9C9E) ;; <CJK>
     (?$Av`(B . ?\x9C9F) ;; <CJK>
     (?$Ava(B . ?\x9CA0) ;; <CJK>
     (?$Avb(B . ?\x9CA1) ;; <CJK>
     (?$Avc(B . ?\x9CA2) ;; <CJK>
     (?$Avd(B . ?\x9CA3) ;; <CJK>
     (?$Ave(B . ?\x9CA5) ;; <CJK>
     (?$Avf(B . ?\x9CA6) ;; <CJK>
     (?$Avg(B . ?\x9CA7) ;; <CJK>
     (?$Avh(B . ?\x9CA8) ;; <CJK>
     (?$Avi(B . ?\x9CA9) ;; <CJK>
     (?$Avj(B . ?\x9CAB) ;; <CJK>
     (?$Avk(B . ?\x9CAD) ;; <CJK>
     (?$Avl(B . ?\x9CAE) ;; <CJK>
     (?$Avm(B . ?\x9CB0) ;; <CJK>
     (?$Avn(B . ?\x9CB1) ;; <CJK>
     (?$Avo(B . ?\x9CB2) ;; <CJK>
     (?$Avp(B . ?\x9CB3) ;; <CJK>
     (?$Avq(B . ?\x9CB4) ;; <CJK>
     (?$Avr(B . ?\x9CB5) ;; <CJK>
     (?$Avs(B . ?\x9CB6) ;; <CJK>
     (?$Avt(B . ?\x9CB7) ;; <CJK>
     (?$Avu(B . ?\x9CBA) ;; <CJK>
     (?$Avv(B . ?\x9CBB) ;; <CJK>
     (?$Avw(B . ?\x9CBC) ;; <CJK>
     (?$Avx(B . ?\x9CBD) ;; <CJK>
     (?$Avy(B . ?\x9CC4) ;; <CJK>
     (?$Avz(B . ?\x9CC5) ;; <CJK>
     (?$Av{(B . ?\x9CC6) ;; <CJK>
     (?$Av|(B . ?\x9CC7) ;; <CJK>
     (?$Av}(B . ?\x9CCA) ;; <CJK>
     (?$Av~(B . ?\x9CCB) ;; <CJK>
     (?$Aw!(B . ?\x9CCC) ;; <CJK>
     (?$Aw"(B . ?\x9CCD) ;; <CJK>
     (?$Aw#(B . ?\x9CCE) ;; <CJK>
     (?$Aw$(B . ?\x9CCF) ;; <CJK>
     (?$Aw%(B . ?\x9CD0) ;; <CJK>
     (?$Aw&(B . ?\x9CD3) ;; <CJK>
     (?$Aw'(B . ?\x9CD4) ;; <CJK>
     (?$Aw((B . ?\x9CD5) ;; <CJK>
     (?$Aw)(B . ?\x9CD7) ;; <CJK>
     (?$Aw*(B . ?\x9CD8) ;; <CJK>
     (?$Aw+(B . ?\x9CD9) ;; <CJK>
     (?$Aw,(B . ?\x9CDC) ;; <CJK>
     (?$Aw-(B . ?\x9CDD) ;; <CJK>
     (?$Aw.(B . ?\x9CDF) ;; <CJK>
     (?$Aw/(B . ?\x9CE2) ;; <CJK>
     (?$Aw0(B . ?\x977C) ;; <CJK>
     (?$Aw1(B . ?\x9785) ;; <CJK>
     (?$Aw2(B . ?\x9791) ;; <CJK>
     (?$Aw3(B . ?\x9792) ;; <CJK>
     (?$Aw4(B . ?\x9794) ;; <CJK>
     (?$Aw5(B . ?\x97AF) ;; <CJK>
     (?$Aw6(B . ?\x97AB) ;; <CJK>
     (?$Aw7(B . ?\x97A3) ;; <CJK>
     (?$Aw8(B . ?\x97B2) ;; <CJK>
     (?$Aw9(B . ?\x97B4) ;; <CJK>
     (?$Aw:(B . ?\x9AB1) ;; <CJK>
     (?$Aw;(B . ?\x9AB0) ;; <CJK>
     (?$Aw<(B . ?\x9AB7) ;; <CJK>
     (?$Aw=(B . ?\x9E58) ;; <CJK>
     (?$Aw>(B . ?\x9AB6) ;; <CJK>
     (?$Aw?(B . ?\x9ABA) ;; <CJK>
     (?$Aw@(B . ?\x9ABC) ;; <CJK>
     (?$AwA(B . ?\x9AC1) ;; <CJK>
     (?$AwB(B . ?\x9AC0) ;; <CJK>
     (?$AwC(B . ?\x9AC5) ;; <CJK>
     (?$AwD(B . ?\x9AC2) ;; <CJK>
     (?$AwE(B . ?\x9ACB) ;; <CJK>
     (?$AwF(B . ?\x9ACC) ;; <CJK>
     (?$AwG(B . ?\x9AD1) ;; <CJK>
     (?$AwH(B . ?\x9B45) ;; <CJK>
     (?$AwI(B . ?\x9B43) ;; <CJK>
     (?$AwJ(B . ?\x9B47) ;; <CJK>
     (?$AwK(B . ?\x9B49) ;; <CJK>
     (?$AwL(B . ?\x9B48) ;; <CJK>
     (?$AwM(B . ?\x9B4D) ;; <CJK>
     (?$AwN(B . ?\x9B51) ;; <CJK>
     (?$AwO(B . ?\x98E8) ;; <CJK>
     (?$AwP(B . ?\x990D) ;; <CJK>
     (?$AwQ(B . ?\x992E) ;; <CJK>
     (?$AwR(B . ?\x9955) ;; <CJK>
     (?$AwS(B . ?\x9954) ;; <CJK>
     (?$AwT(B . ?\x9ADF) ;; <CJK>
     (?$AwU(B . ?\x9AE1) ;; <CJK>
     (?$AwV(B . ?\x9AE6) ;; <CJK>
     (?$AwW(B . ?\x9AEF) ;; <CJK>
     (?$AwX(B . ?\x9AEB) ;; <CJK>
     (?$AwY(B . ?\x9AFB) ;; <CJK>
     (?$AwZ(B . ?\x9AED) ;; <CJK>
     (?$Aw[(B . ?\x9AF9) ;; <CJK>
     (?$Aw\(B . ?\x9B08) ;; <CJK>
     (?$Aw](B . ?\x9B0F) ;; <CJK>
     (?$Aw^(B . ?\x9B13) ;; <CJK>
     (?$Aw_(B . ?\x9B1F) ;; <CJK>
     (?$Aw`(B . ?\x9B23) ;; <CJK>
     (?$Awa(B . ?\x9EBD) ;; <CJK>
     (?$Awb(B . ?\x9EBE) ;; <CJK>
     (?$Awc(B . ?\x7E3B) ;; <CJK>
     (?$Awd(B . ?\x9E82) ;; <CJK>
     (?$Awe(B . ?\x9E87) ;; <CJK>
     (?$Awf(B . ?\x9E88) ;; <CJK>
     (?$Awg(B . ?\x9E8B) ;; <CJK>
     (?$Awh(B . ?\x9E92) ;; <CJK>
     (?$Awi(B . ?\x93D6) ;; <CJK>
     (?$Awj(B . ?\x9E9D) ;; <CJK>
     (?$Awk(B . ?\x9E9F) ;; <CJK>
     (?$Awl(B . ?\x9EDB) ;; <CJK>
     (?$Awm(B . ?\x9EDC) ;; <CJK>
     (?$Awn(B . ?\x9EDD) ;; <CJK>
     (?$Awo(B . ?\x9EE0) ;; <CJK>
     (?$Awp(B . ?\x9EDF) ;; <CJK>
     (?$Awq(B . ?\x9EE2) ;; <CJK>
     (?$Awr(B . ?\x9EE9) ;; <CJK>
     (?$Aws(B . ?\x9EE7) ;; <CJK>
     (?$Awt(B . ?\x9EE5) ;; <CJK>
     (?$Awu(B . ?\x9EEA) ;; <CJK>
     (?$Awv(B . ?\x9EEF) ;; <CJK>
     (?$Aww(B . ?\x9F22) ;; <CJK>
     (?$Awx(B . ?\x9F2C) ;; <CJK>
     (?$Awy(B . ?\x9F2F) ;; <CJK>
     (?$Awz(B . ?\x9F39) ;; <CJK>
     (?$Aw{(B . ?\x9F37) ;; <CJK>
     (?$Aw|(B . ?\x9F3D) ;; <CJK>
     (?$Aw}(B . ?\x9F3E) ;; <CJK>
     (?$Aw~(B . ?\x9F44) ;; <CJK>
     )))

(provide 'ugb2312)
     
     