#include "seaview.h"
#include <stdlib.h>
#include <ctype.h>

/* local prototypes */
int save_part_as_pir(int debut, int fin, char **sequence, char **seqname, 
	int *sel_seqs, int tot_seqs, char *fname, int *withU, int *empty_seq,
	int *num_longest, int protein);
int replace_align_part(SEA_VIEW *view, int debut, int fin, char *fname, int withU, int num_longest);
void align_selected_parts(SEA_VIEW *view);
int calc_gap_sites(char *old_seq, char *new_seq, int lold, int lnew, 
	gap_site *gap_sites, int maxsites);
int insert_gaps_new_align(char **seq, int site, int number, int numseqs, 
	int lseqs);
int reset_stars(SEA_VIEW *view, int debut, int lpart, char **seq, int lfrag);

/* extern proto */
extern int insert_gaps_at(SEA_VIEW *view, int seq, int site, int total);
extern int insert_gap_all_comments(int numgaps, int pos,  SEA_VIEW *view);
extern char *mktemp(char *template);

/* extern variables */
extern gap_site gap_sites[];

int save_part_as_pir(int debut, int fin, char **sequence, char **seqname, 
	int *sel_seqs, int tot_seqs, char *fname, int *withU, int *empty_seq,
	int *num_longest, int protein)
/* returns TRUE iff error */
{
FILE *out;
int num, pos, l_line, retval, maxlen, seqlen, current;
char line[90];

out = fopen(fname,"w");
if( out == NULL ) return TRUE;
retval = TRUE;
*withU = FALSE;
maxlen = 0; current = 0;
for(num = 0; num < tot_seqs; num++) {
	if( ! sel_seqs[num] ) continue;
	sprintf(line, "%d_%s", ++current, seqname[num]);
	fprintf(out, ">%.10s\n", line);
	if(ferror(out)) goto fin;
	*empty_seq = TRUE;
	l_line = 0;
	seqlen = 0;
	for ( pos = debut - 1 ; pos < fin; pos++) {
		if( sequence[num][pos] == 0 ) break;
		if( sequence[num][pos] == '-' ) continue;
		if(l_line >= 70) {
			line[l_line] = 0;
			if(!*withU) *withU = (strchr(line, 'U') != NULL);
			fprintf(out, "%s\n", line);
			seqlen += l_line;
			l_line = 0;
			}
		line[l_line++] = sequence[num][pos];
		if(protein && sequence[num][pos] == '*') line[l_line - 1] = 'X';
		*empty_seq = FALSE;
		}
	line[l_line] = 0;
	seqlen += l_line;
	if(seqlen > maxlen) {
		maxlen = seqlen; *num_longest = num;
		}
	if(!*withU) *withU = (strchr(line, 'U') != NULL);
	fprintf(out, "%s\n", line);
	if( *empty_seq ) strcpy(fname, seqname[num]);
	if(ferror(out) || *empty_seq) goto fin;
	}
retval = FALSE;
fin:
fclose(out);
return retval;		
}


void align_selected_parts(SEA_VIEW *view)
{
int debut, fin, status, withU, empty_seq, num_longest, l;
char *p;
static char base_fname[100], commande[200];
FILE *in;
static int first = TRUE;

#ifndef __VMS 
/* omit this check under VMS */
if(first) { /* check for presence of xterm + clustalw + seaview_align.csh */
	first = FALSE;
	status = check_path("xterm");
	if(status == 0) {
		status = check_path("clustalw");
		}
	if(status == 0) {
		status = check_path("seaview_align.csh");
		}
	if(status != 0) {
		fl_show_message("Alignment operation is impossible because",
		  "one of the programs xterm, clustalw, seaview_align.csh",
		  "is missing");
		fl_set_menu_item_mode(view->menu_edit, ALIGN_SEQS, FL_PUP_GRAY);
		return;
		}
	}
#endif /* __VMS */
if(view->active_region == NULL || view->active_region->list == NULL ||
	view->active_region->list->next != NULL || view->tot_sel_seqs <= 1) {
	fl_show_message("Need to have exactly one block of selected sites",
		"and some selected sequences", "");
	return;
	}
debut = view->active_region->list->debut;
fin = view->active_region->list->fin;
strcpy(base_fname, "tmp_XXXXXX");
mktemp( base_fname );
/* 
convertir en minuscules car clustalw n'accepte pas les majuscules ds filenames
*/
p = base_fname - 1; while( *(++p) != 0) *p = tolower( *p);
sprintf(commande, "%s.pir", base_fname);
status = save_part_as_pir(debut, fin, view->sequence, view->seqname, 
	view->sel_seqs, view->tot_seqs, commande, &withU, &empty_seq, 
	&num_longest, view->protein);
if(view->protein) withU = FALSE;
if(empty_seq) {
	fl_show_alert("Cannot process sequence(s)", commande,
		 "containing only gaps",  TRUE);
#ifdef __VMS
	sprintf(commande, "delete %s.pir;*", base_fname);
#else
	sprintf(commande, "rm %s.pir", base_fname);
#endif
	system(commande);
	return;
	}
if(status) {
	fl_show_alert("Cannot write sequences to filename", commande, 
		"", TRUE);
	return;
	}
/* pour memoire: clustalw retourne 1 ou -1 si erreur, autre chose = succes */

#ifdef __VMS
strcpy(commande, "@seaview:seaview_align");
#else
strcpy(commande, "xterm -T \"clustalw alignment\" -n clustalw -sb -sl 2000 "
	"-e seaview_align.csh" );
#endif
l = strlen(commande);
#ifdef OLD_CLUSTALW
sprintf(commande + l, 
	" %s /infile=%s.pir/outfile=%s.phy/output=phylip", 
	base_fname, base_fname, base_fname);
#else
sprintf(commande + l, 
	" %s -infile=%s.pir -outfile=%s.phy -output=phylip -outorder=input", 
	base_fname, base_fname, base_fname);
#endif
if(view->clustal_options != NULL &&
	  ( fl_getpup_mode(view->bouton_props->u_ldata, 56) & FL_PUP_CHECK ) ){
	int l;
	l = strlen(commande);
	sprintf(commande + l, " %s", view->clustal_options);
	}
status = system(commande);
#ifdef __VMS  /* VMS can return a bunch of different status codes, just
                 assume that it worked*/
status = 0;
#endif
if( status == 0 ) {
	sprintf(commande, "%s.status", base_fname);
	in = fopen(commande, "r");
	if(in != NULL) {
		fgets(commande, sizeof(commande), in);
		if( strcmp(commande, "success\n") != 0) status = 1;
		fclose(in);
		}
	else	status = 1;
	}
if( status != 0 )
	fl_show_message("Alignment operation ignored", "", "");
else	{
	sprintf(commande, "%s.phy", base_fname);
	status = replace_align_part(view, debut, fin, commande, withU, 
		num_longest);
	if(status) fl_show_alert("Not enough memory", "or", 
		"max sequence length reached", TRUE);
	}
#ifdef __VMS
sprintf(commande, "delete %s.*;*", base_fname);
#else
sprintf(commande, "rm %s.*", base_fname);
#endif
system(commande);
}


int calc_gap_sites(char *old_seq, char *new_seq, int lold, int lnew, 
	gap_site *gap_sites, int maxsites)
{
char *fin_old, *fin_new;
int tot_sites = 0, posnewalign = 0, posmultalign = 0;
fin_old = old_seq + lold - 1; fin_new = new_seq + lnew - 1;
while( old_seq <= fin_old || new_seq <= fin_new ) {
	if(old_seq <= fin_old && new_seq <= fin_new && 
		( ( *old_seq != '-' && *new_seq != '-') ||
		  ( *old_seq == '-' && *new_seq == '-') ) ){
		old_seq++; new_seq++;
		posnewalign++; posmultalign++;
		continue;
		}
	if(tot_sites >= maxsites) return -1;
	gap_sites[tot_sites].l[1] = 0;
	gap_sites[tot_sites].l[0] = 0;
	if(old_seq <= fin_old && *old_seq == '-') {
		gap_sites[tot_sites].pos = posnewalign;
		do	{ old_seq++; ++(gap_sites[tot_sites].l[1]); }
		while( *old_seq == '-' && old_seq < fin_old);
		posnewalign += gap_sites[tot_sites].l[1];
		}
	else 	{
		gap_sites[tot_sites].pos = posmultalign;
		do	{ new_seq++; ++(gap_sites[tot_sites].l[0]); }
		while( *new_seq == '-' && new_seq < fin_new);
		posmultalign += gap_sites[tot_sites].l[0];
		}
	tot_sites++;
	}
return tot_sites;
}


int replace_align_part(SEA_VIEW *view, int debut, int fin, char *fname, 
	int withU, int num_longest)
/* returns TRUE if error, FALSE if ok */
{
int num, lfrag, lpart, i, col, rang, retval, newlength;
char **seq, **comments, **seqname, *pheader, *err_message;
int (*calc_color_function)(int);
int totgapsites, num1, site, l_copy;
char *tmp;

view->cursor_in_comment = FALSE;
view->cursor_seq = view->first_seq;
seq = (char **)malloc( view->tot_sel_seqs * sizeof(char *) );
if(seq == NULL) return TRUE;
comments = (char **)malloc( view->tot_sel_seqs * sizeof(char *) );
if(comments == NULL) return TRUE;
seqname = (char **)malloc( view->tot_sel_seqs * sizeof(char *) );
if(seqname == NULL) return TRUE;
/* lecture de l'alignement multiple produit par clustalw */
num = read_phylip_align(fname, seq, seqname, comments, &pheader, 
	view->tot_sel_seqs, &err_message);
free(comments); 
for(i = 0; i < num; i++) free(seqname[i]);
free(seqname);
if(num != view->tot_sel_seqs) { free(seq); return TRUE; }

retval = TRUE;
if(withU) { 
/* si seq avec U au depart, les remettre car ont ete changes en T par clustalw */
	char *p, *q;
 	for(num = 0; num < view->tot_sel_seqs; num++) {
 		p = seq[num];
 		while( (q = strchr(p, 'T')) != NULL) { *q = 'U'; p = q; }
		}
	}	
lfrag = strlen(seq[0]); /* long alignement de clustalw */
lpart = fin - debut + 1; /*long region traitee de l'ancien alignement multiple*/
if(view->protein) {
	if( reset_stars(view, debut, lpart, seq, lfrag) ) return TRUE;
	}
/* num1 = rang dans align clustalw de num_longest dans align multiple */
num1 = -1;
for(i = 0; i < view->tot_seqs; i++) {
	if( !view->sel_seqs[i]) continue;
	num1++;
	if( i == num_longest) break;
	}
/* calcul des pos et longs de gaps a inserer:
gap_sites[x].pos = position a droite du gap a inserer (from 0)
gap_sites[x].l[0] = longueur a inserer dans alignement multiple
gap_sites[x].l[1] = longueur a inserer dans alignement produit par clustalw
*/
totgapsites = calc_gap_sites(view->sequence[num_longest] + debut - 1, seq[num1],
	FL_min(lpart, view->each_length[num_longest] - debut + 1),
	lfrag, gap_sites, MAX_GAP_SITES);
if(totgapsites == -1) goto fin;
/* calcul long region traitee apres ajout des gaps */
for(site=0; site<totgapsites; site++) 
	lpart += gap_sites[site].l[0];
/* l'alignement multiple serait-il trop long en fin d'operation? */
if( view->seq_length + lpart - (fin - debut + 1) > view->max_seq_length ) 
	goto fin;
/* allongement memoire pour seqs de l'alignement de clustalw */
for(num=0; num<view->tot_sel_seqs; num++) {
	tmp = (char *)malloc(lpart+1);
	if(tmp == NULL) goto fin;
	memcpy(tmp, seq[num], lfrag+1);
	free(seq[num]);
	seq[num] = tmp;
	}
/* allongement des seqs de l'alignement de clustalw */
for(site = 0; site < totgapsites; site++) {
	if(gap_sites[site].l[1] == 0) continue;
	lfrag = insert_gaps_new_align(seq, gap_sites[site].pos, 
		gap_sites[site].l[1],
		view->tot_sel_seqs, lfrag);
	}
if(view->numb_gc > 1) {
	calc_color_function = ( view->protein ? 
		get_color_for_aa : get_color_for_base );
	}
newlength = view->seq_length;
/* allongement des seqs de l'alignement multiple */
for(site = 0; site < totgapsites; site++) {
	if(gap_sites[site].l[0] == 0) continue;
	for(num = 0; num < view->tot_seqs; num++) {
		insert_gaps_at(view, num + 1, 
			debut + gap_sites[site].pos, gap_sites[site].l[0]);
		}
	newlength += gap_sites[site].l[0];
	insert_region_part(view, debut + gap_sites[site].pos, 
		gap_sites[site].l[0]);
	if(view->tot_comment_lines > 0) insert_gap_all_comments(
		gap_sites[site].l[0], debut + gap_sites[site].pos, view);
	}

/* copie des sequences de clustalw vers alignement multiple */
rang = -1;
for(num = 0; num < view->tot_seqs; num++) {
	if(  ! view->sel_seqs[num] ) continue;
	rang++;
/* on met les nouvelles seqs */ 
	l_copy = FL_min(lpart, lfrag);
	memcpy( view->sequence[num] + debut - 1, seq[rang], l_copy);
	if(debut + l_copy - 1 > view->each_length[num])
		view->each_length[num] = debut + l_copy - 1;
	newlength = FL_max(newlength, view->each_length[num]);
	if(view->each_length[num] == debut + l_copy - 1) 
		view->sequence[num][debut + l_copy - 1] = 0;
	if(view->numb_gc == 1) continue;
	for(i = 0; i < view->numb_gc; i++) {
		memset( view->col_seq[num][i] + debut - 1, ' ', l_copy);
		}
	for(i = debut - 1; i < debut + l_copy - 1; i++) {
		col = calc_color_function( view->sequence[num][i] );
		view->col_seq[num][col][i] = view->sequence[num][i];
		}
	if(view->each_length[num] == debut + l_copy - 1) {
		for(col = 0; col < view->numb_gc; col++) 
			view->col_seq[num][col][debut + l_copy - 1] = 0;
		}
	}
/* mettre a jour horsli */
update_current_seq_length(newlength, view);
view->modif_but_not_saved = TRUE;
retval = FALSE;

fin:
for(num = 0; num < view->tot_sel_seqs; num++) 
	free(seq[num]);
free(seq);
return retval;
}


int insert_gaps_new_align(char **seq, int site, int number, int numseqs, 
	int lseqs)
{
int num;
char *pos;
for(num=0; num < numseqs; num++) {
	pos = seq[num] + site;
	memmove(pos + number, pos, lseqs - site + 1);
	memset(pos, '-', number);
	}
return lseqs + number;
}


int reset_stars(SEA_VIEW *view, int debut, int lpart, char **seq, int lfrag)
{
int oldseq, newseq;
char *p, *q;

newseq = -1;
for(oldseq = 0; oldseq < view->tot_seqs; oldseq++) {
	if(!view->sel_seqs[oldseq]) continue;
	newseq++;
	p = view->sequence[oldseq] + debut - 2;
	q = seq[newseq] - 1;
	while(TRUE) {
		p++; q++;
		while (*p == '-') p++;
		while (*q == '-') q++;
		if(*p == 0 || *q == 0) break;
		if( *p == '*' && *q == 'X') *q = '*';
		if( *p != *q) return TRUE;
		}
	}
return FALSE;
}

